import React, { useState, useEffect } from 'react'
import { Image, ScrollView, View } from '@tarojs/components'
import API from '@/api'
import { DRAW_STATUS, PRIZE_TYPE, BENEFIT_TYPE, BGMUSIC_URL } from '@/const'
import DeliveryModal from '@/components/_tb_modal/DeliveryModal/DeliveryModal'
import tbccTs from 'tbcc-sdk-ts'
import { useThrottle } from '@/hooks/useThrottle'
import { checkIsMember } from 'tbcc-sdk-ts/lib/utils'
import { dateFormatter } from '@/utils/date'
import styles from './myPrize.module.less'
import { getApp } from '@tarojs/taro'
import { receiveEnamePrize, receiveObjectPrize, receiveMemberEname } from '@/utils/util'
import config from '@/config/index'

const { commonToast, getUserAddress, navigateToOutside, setClipboard } = tbccTs.tb
const { getMyPrizeList } = API
import {useAudio} from '@/hooks/useAudio'

// 我的奖品配置项
const prizeConfig = {
  bg: '//yun.duiba.com.cn/aurora/assets/e13fab3165d3a6bb4cbe8827e8f0fd41084b0091.png', // 背景图
  title: '//yun.dui88.com/duiba-components-c-myprizeprize_title.png', // 标题
  copyIcon: '//yun.dui88.com/duiba-components-c-myprizemyprize_copy_code.png', // 复制
  receiveBtn: '//yun.duiba.com.cn/bestoreBox/prize_received.png', // 已领取 权益类奖品未配置 uesUrl使用
  objectStatus: {
    1: '//yun.dui88.com/duiba-components-c-myprizeto_address.png', // 填写地址(实物奖品)
    3: '//yun.dui88.com/duiba-components-c-myprizelogistics.png', // 查看物流
    6: '//yun.dui88.com/duiba-components-c-myprizeget_again.png', // 重新领取
    5: '//yun.duiba.com.cn/spark/assets/914ba8643c8abb8d710a3126ec312aecf6c4daf0.png', // 已失效
    4: '//yun.duiba.com.cn/spark/assets/8267375232058a6d0140270b1594427fb08d6ae3.png' // 领取失败
  },
  enameStatus: {
    1: '//yun.dui88.com/duiba-components-c-myprizeget_now.png', // 立即领取(除实物奖品外)
    3: '//yun.duiba.com.cn/bestoreBox/prize_received.png', // 去使用(除实物奖品外)
    6: '//yun.dui88.com/duiba-components-c-myprizeget_again.png', // 重新领取
    5: '//yun.duiba.com.cn/spark/assets/914ba8643c8abb8d710a3126ec312aecf6c4daf0.png', // 已失效
    4: '//yun.duiba.com.cn/spark/assets/8267375232058a6d0140270b1594427fb08d6ae3.png' // 领取失败
  },
  logisticsImage: {
    shipped: '//yun.dui88.com/duiba-components-c-myprizeprize_shipped.png', // 已发货物理弹窗
    notShipped: '//yun.dui88.com/duiba-components-c-myprizenotshipped.png' // 待发货物流弹窗
  },
  btnStyle: {
    width: '150rpx'
  },
  contentTop: '140rpx',
  blankTxt: '暂无奖品',
  hasLogistic: false, // 是否展示物流信息
  isShowPirzeId: false // 是否显示奖品编号
}

function Empty(blankTxt) {
  return <View className={styles['my-prize-item__empty']}>{blankTxt}</View>
}

function MyPrizeList() {
  const app = getApp()
  const [ myPrizeList, setMyPrizeList ] = useState([])
  const [ expiredTime, setExpiredTime ] = useState('')
  const [ currentPrize, setCurrentPrize ] = useState({})
  const [ memberVisible, setMemberVisible ] = useState(false)
  const [ deliveryModalVisible, setDeliveryModalVisible ] = useState(false)

  // const {openStatus,setOpenStatus} = useAudio(BGMUSIC_URL.MUSIC,true)

  useEffect(() => {
    fetchMyPriceList()
  }, [])
  async function fetchMyPriceList() {
    const res = await getMyPrizeList()
    if (res.success && res?.data?.list?.length) {
      setMyPrizeList(res?.data?.list)
    }
    if (res?.data?.expiredTime) {
      setExpiredTime(dateFormatter(res?.data?.expiredTime, 'yyyy/MM/dd hh:mm:ss'))
    }
  }
  // 复制编码
  const handleCopyId = async(text) => {
    await setClipboard(text)
    commonToast('复制成功')
  }
  // 新领取方式
  const handleClick = useThrottle(async (item) => {
      const { activityId } = app
      const { type, drawStatus, useUrl = '', id, _id, ename = '', benefitType } = item
      // 领取前验证
      if (drawStatus === DRAW_STATUS.SUCCESS) {
        if (type === PRIZE_TYPE.OBJECT && prizeConfig.hasLogistic) {
          setCurrentPrize(item)
          setDeliveryModalVisible(true)
          return
        }
        if (type !== PRIZE_TYPE.OBJECT && useUrl) {
          navigateToOutside(useUrl)
          return
        }
      }
      if (!(drawStatus === DRAW_STATUS.RETRY || drawStatus === DRAW_STATUS.WAITAWARD)) {
        return
      }
      // 执行奖品领取
      const successMsg = '领取成功'
      if(type === PRIZE_TYPE.CREDITS || (type === PRIZE_TYPE.ENAME && benefitType === BENEFIT_TYPE.MEMBER)) {
        const isVip = await checkIsMember()
        if(!isVip) {
          commonToast('需加入会员才能领取成功哦', 2000, () => { setMemberVisible(true) })
          return;
        }
      }
      const receiveFn = {
        [PRIZE_TYPE.ENAME]: async () => {
          if(benefitType === BENEFIT_TYPE.MEMBER) {
           return await receiveMemberEname({params: { sellerId: config.sellerId, ename, id }, successMsg })
          }else {
            return await receiveEnamePrize({params: { activityId, id }, successMsg })
          }
        },
        [PRIZE_TYPE.OBJECT]: async () => {
          return await receiveObjectPrize({params: { activityId, id }, successMsg })
        },
        [PRIZE_TYPE.CREDITS]: async () => {
          return await receiveEnamePrize({params: { activityId, id }, successMsg })
        }
      }
      const result = await receiveFn[type]()
      result && fetchMyPriceList()
  },2000)
  // 入会插件
  const onClose = () => {
    setMemberVisible(false)
  }
  const onAuthSuccess = () => {
    setMemberVisible(false)
  }
  const onAuthFail = () => {
    setMemberVisible(false)
  }

  return (
    <View className={styles['page-container']}>
      <View className={styles['my-prize-container']} style={{ background: `url(${prizeConfig.bg}) no-repeat center top/cover` }}>
        <View className={styles['page-content']}>
          <View className={styles['my-prize-label']} style={{ background: `url(${prizeConfig.title}) no-repeat`, backgroundSize: '100% 100%' }} />

          <View className={styles['my-prize-content']} style={{ top: prizeConfig.contentTop }}>
            <ScrollView scrollY className={styles['my-prize-content__scroll']}>
              {myPrizeList.length > 0 &&
                <View className={styles['my-prize-list']}>
                  {myPrizeList.map((item, i) => {
                    return (
                      <View className={styles['my-prize-item']} key={'prize_'+i}>
                        <Image className={styles['my-prize-item__avatar']} src={item.image} />

                        <View className={styles['my-prize-item__content']}>
                          <View className={styles['my-prize-item__name']}>{item.name}</View>
                          {
                            prizeConfig.isShowPirzeId &&
                              <View className={styles['my-prize-item__subtitle']}>
                                <View className={styles['my-prize-item__code']}>奖品编码：{item.id || item._id}</View>
                                {/* <!-- 复制按钮 --> */}
                                <Image className={styles['my-prize-item__copy']} onTap={() => handleCopyId(item.id || item._id)} src={prizeConfig.copyIcon} />
                              </View>
                          }
                          {item.drawStatus === DRAW_STATUS.FAIL && <View className={styles['my-prize-item__tip']}>{item.remark}</View>}
                          {(item.drawStatus === DRAW_STATUS.RETRY || item.drawStatus === DRAW_STATUS.WAITAWARD) && <View className={styles['my-prize-item__tip']}>请于{expiredTime}前领取</View>}
                          {item.drawStatus === DRAW_STATUS.EXPIRED && <View className={styles['my-prize-item__tip']}>奖品已过期失效</View>}

                        </View>

                        <View className={styles['prize-item__status']} style={prizeConfig.btnStyle}>
                          {item.type === PRIZE_TYPE.OBJECT

                            ? <Image onTap={() => handleClick(item)} src={prizeConfig.objectStatus[item.drawStatus]} mode='widthFix' />

                            : <Image onTap={() => handleClick(item)} src={(item.drawStatus === 3 && !item.useUrl) ? prizeConfig.receiveBtn : prizeConfig.enameStatus[item.drawStatus]} mode='widthFix' />}

                        </View>
                      </View>
                    )
                  })}
                </View>}
              {
                myPrizeList.length === 0 && Empty(prizeConfig.blankTxt)
              }

            </ScrollView>
          </View>
        </View>
      </View>
      {deliveryModalVisible && <DeliveryModal prizeItem={currentPrize} task={prizeConfig.logisticsImage} onClose={() => setDeliveryModalVisible(false)} />}
      {memberVisible && <member-modal onClose={onClose} onAuthFail={onAuthFail} onAuthSuccess={onAuthSuccess} />}
    </View>
  )
}
export default MyPrizeList