import React, { useState, useEffect, useRef } from 'react'
import { View } from '@tarojs/components'
import GoodsTitle from '@/components/_tb_comps/GoodsTitle/GoodsTitle'
import GoodsList from '@/components/_tb_comps/GoodsList/GoodsList'
import { useRouter } from '@tarojs/taro'
import tbccTs from 'tbcc-sdk-ts'
import API from '@/api'
import { useThrottle } from '@/hooks/useThrottle'

const { commonToast } = tbccTs.tb
import styles from './collectGoods.module.less'

const collectConfig = {
  taskType: 'collectGoods',
  type: '01',
  bg: '//yun.dui88.com/taobaomini/clientCTest/goods_bg@2x.png',
  head: {
    image: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_title@2x.png',
    width: 750,// 头部banner/title 宽度
    height: 120,// 头部banner/title 高度
  },
  image: {
    banner: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_banner@2x.png',
    title: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_title@2x.png',
    collect: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_collection@2x.png',
    no_collect: '//yun.duiba.com.cn/taobaomini/clientCTest/collection_no_collect@2x.png',
    img: '//yun.duiba.com.cn/taobaomini/clientCTest/goods_img@2x.png'
  },
  color: '#181818'
}

function CollectGoodsPage() {
  const router = useRouter()
  const [goodsList, setGoodsList] = useState([])
  const { itemIds } = router?.params
  // 收藏状态
  const collectFlag = useRef(false)

  useEffect(() => {
    getGoodsList()
  }, [])

  const getGoodsList = async () => {
    const { data } = await API.getCollectGoodsList({ itemIds })
    setGoodsList(data?.list || [])
  }

  const onCompleteTask = useThrottle(async(itemId,collected) => {
    const collectFn = async () => {
      const { success } = await API.doCompleteTask({ taskType, itemId })
      if (success) {
        collectFlag.current = true
        getGoodsList()
        commonToast('收藏成功')
      }
    }
    // 今日是否已收藏过
    if(collectFlag.current) {
        commonToast('任务已完成，请明日再来')
        return;
    }
    if (collected) {
        commonToast('您已收藏过该商品了')
        return;
    }
    // 判断是否活动外已收藏商品
    const isCollected = await checkGoodsCollectedStatus(+itemId)
    if (isCollected) {
        collectFn()
        return;
    }
    const result = await collectGoods(+itemId)
    if (result) {
      collectFn()
      return;
    }
  })

  return (
    <View className={styles['page-container']}>
      <View className={styles['page-psd-container']} style={{ background: `url(${collectConfig.bg}) no-repeat`, backgroundSize: '750rpx 1624rpx' }}>
        <View className={styles['page-content']}>
          <View className={styles['page-content__title']}>
            <GoodsTitle config={collectConfig.head}/>
          </View>
          <View className={styles['page-content__list']}>
            <GoodsList goodsList={goodsList} task={collectConfig} onOpenDetail={(itemId,collected) => onCompleteTask(itemId,collected)} />
          </View>
        </View>
      </View>
    </View>
  )
}

export default CollectGoodsPage
