import React from 'react'
import { View, Image } from '@tarojs/components'
import styles from './DeliveryModal.module.less'

export default function DeliveryModal(props) {
  const { prizeItem, task, onClose = () => {} } = props
  return (
    <View className={styles['container']}>
      <View
        className={styles['content']}
        style={prizeItem.shipStatus === 3
          ? `background: url(${task.shipped}) no-repeat;background-size: 100% 100%;`
          : `background: url(${task.notShipped}) no-repeat;background-size: 100% 100%;`}
      >
        <View className={styles['container__close']} onTap={onClose} />
        <View className={styles['content-item']}>
          <View className={styles['content-left']}>
            <Image mode='scaleToFill' src={prizeItem.image} />
          </View>
          <View className={styles['content-right']}>
            <View className={styles['content-name']}>{prizeItem.name}</View>
            <View className={styles['content-copy']}>
              <View className={styles['content-copy__code']}>奖品编码：{prizeItem._id}</View>
              <View className={styles['content-copy__img']} onTap='copyPrizeId' />
            </View>
            <View className={styles['content-desc']}>{prizeItem.shipStatus === 3 ? '发货状态：已发货' : '发货状态：未发货'}</View>
            {prizeItem.shipStatus === 2 && <View className={styles['content-desc']}>温馨提示：奖品将在活动结束7天内陆续发出</View>}
            {
              prizeItem.shipStatus !== 2 &&
                <View className={styles['content-copy']}>
                  <View className={styles['content-copy__code']}>{'物流单号：' + prizeItem.shipNum}</View>
                  <View className={styles['content-copy__img']} style={`background: url(${task.copyIcon}) no-repeat;background-size: 100% 100%;`} onTap={onClose} />
                </View>
            }
          </View>
        </View>
      </View>
    </View>
  )
}