/** @format */
interface IActivityBaseInfo {
  _id?: string
  activityId?: string
  openId?: string
  rule: string
  startTime: number
  endTime: number
  title: string
  deleteStatus?: number
  openPrizeStatus?: number
  remark?: string
  createTime?: number
  updateTime?: number
  awardReceiveExpiredTime?: number
  tasks?: ITasks
}

interface IActivityPrize {
  _id?: string
  activityId?: string
  ename?: string
  prizeDataType: number
  type: number
  image: string
  name: string
  probability?: string | number
  properiodto: number
  properiodfrom: number
  lockStatus?: number
  switchStock?: number
  rank?: string | number
  useUrl?: string
  stock: number
  useStock: number
  openId?: string
  level: number // 索引排序用
  deleteStatus: number
  createTime: number
  updateTime: number
}

interface ITasks {
  follow?: ITaskConfig
  member?: ITaskConfig
  sign?: ITaskConfig
  exchangeCredits?: ITaskConfig
  browseGoods?: ITaskConfig
  orderGoods?: ITaskConfig
  collectGoods?: ITaskConfig
  jumpLink?: ITaskConfig
  invites?: ITaskConfig
}

interface ITaskConfig {
  title?: string // 任务标题
  value: number // 任奖奖励
  times?: number // 任务为每日限次次数值
  taskRateType?: number // 任务频率类型
  link?: number // 任务链接
  itemIds?: string // 任务商品
  checked?: boolean // 是否选中（B端需勾选时）
}
