import { ScrollView } from '@tarojs/components'
import React, { useState, useImperativeHandle, forwardRef } from 'react'
import { useThrottle } from '@/hooks/useThrottle'
import styles from './ContainerScroll.module.less'

const ContainerFit = forwardRef((props, ref) => {
  const { } = props
  // 滚动
  const [scrollTop,setScrollTop] = useState(0)
  // 滚动指定位置
  useImperativeHandle(ref,() => ({ scrollFixTop }))
  const scrollFixTop = (topFix) => {
    setScrollTop(topFix)
  }
  // 滑动
  const onScroll = useThrottle((e) => {
    const { scrollTop: _scrollTop } = e.detail
    setScrollTop(_scrollTop)
  })
  return (
    <ScrollView className={styles['scroll-container']} 
        scrollY scrollTop={scrollTop} 
        onScroll={(e) => onScroll(e)} 
        onScrollToUpper={() => {}}
        scrollWithAnimation
        trapScroll={false}
        >
        {props.children}
    </ScrollView>
  )
})
export default ContainerFit