import { useState, useEffect } from 'react'

/**
 *   请求
 *
 * @export
 * @param {*} api 接口请求
 * @param {*} [params={}] 请求参数
 * @param {*} [config={}] {
      method: 'GET',
      showLoading: false,
      toastError: true,
      manual: false 手动触发
    }
 * @return {*}
 */
export function useRequest(api, defaultParams = {}, config = { manual: false }) {
  const [ data, setData ] = useState({})
  const [ code, setCode ] = useState('')
  const [ success, setSuccess ] = useState(false)
  const [ message, setMessage ] = useState('')
  const [ loading, setLoading ] = useState(false)
  const [ error, setError ] = useState(null)

  const request = async(params = defaultParams) => {
    setLoading(true)
    try {
      const { data: resData, success: resSuccess, message: resMsg, code: resCode } = await api(params, config)
      setSuccess(resSuccess)
      setData(resData)
      if (!resSuccess) {
        setMessage(resMsg)
        setCode(resCode)
      }
    } catch (err) {
      console.log('useRequest catch :>> ', err)
      setError(err)
      setLoading(false)
    }
    setLoading(false)
  }

  useEffect(async => {
    console.log('config :>> ', config)
    !config.manual && request()
  }, [])

  return {
    data,
    code,
    success,
    message,
    loading,
    error,
    run: request
  }
}
