/** @format */
import { logger, recordErrorLog } from '../utils'
import { resultsModel } from '../sdk'
import { CODE_TYPES } from '../constants'
import { TaobaoTopService } from '../service'
async function initBaseInfo(context: Context, baseInfos: IControllerInfos) {
  if (!baseInfos.session) {
    // @ts-ignore
    const { session } = await new TaobaoTopService(context).getAccessTokenByOpenId()
    baseInfos.session = session
  }

  return baseInfos
}

export const services = (services: any[]) => {
  return (target: Object, name: string, descriptor: PropertyDescriptor) => {
    const method = descriptor.value

    descriptor.value = async function (...args: any[]) {
      let [context, otherArgs = {}] = args
      const servicesInstance = services.map(v => new v(context))
      const baseInfos: IControllerInfos = await initBaseInfo(context, otherArgs)
      // 默认全局try catch  如果有noCatch参数则直接执行
      if (baseInfos.noCatch) {
        delete baseInfos.noCatch
        return method.apply(target, [context, baseInfos, servicesInstance])
      }
      let ret: Result
      try {
        logger(context)
        ret = await method.apply(target, [context, baseInfos, servicesInstance])
      } catch (error) {
        console.log('error', error)
        await recordErrorLog(context, baseInfos, error.toString(), error.stack)
        ret = resultsModel.error(
          CODE_TYPES.SYSTEM_ERROR,
          `${context?.cloud?.dataspace?.context?.handler || context.handler}系统错误`
        )
      }
      return ret
    }
  }
}
