/**
 * 用户相关方法
 *
 * @format
 */
import BaseService from './base.service';
declare class UserService extends BaseService {
    userdao: IBaseDao;
    constructor(context: Context);
    /**
     * @desc 获取当前打开活动的用户详情
     * @returns 若用户不存在，返回null; 用户存在，返回用户信息(object对象)
     */
    getUserInfo(): Promise<any>;
    /**
     * @desc 根据inviteId获取用户详情
     * @desc 常用于助力分享码为用户openId, 被邀请人打开活动助力时需要获取邀请人的用户详情
     * @param {邀请人的openId} inviteId
     * @returns 若用户不存在，返回null; 用户存在，返回用户信息(object对象)
     */
    getUserInfoByOpenId(inviteId: string): Promise<any>;
    /**
     * @desc 获取是否是会员
     * @param {调用淘宝接口的session} session
     * @returns {isVip: boolean(是否是会员), url: string(入会链接) }
     */
    getShopVip(session: string, callbackUrl?: string): Promise<IVipInfo>;
    /**
     * 初始化用户数据
     *
     * @param {IVipInfo} vipInfo
     * @param {IActivityInfo} activityInfo
     * @returns
     * @memberof UserService
     */
    initUserData(vipInfo: IVipInfo, activityInfo: IActivityInfo): Promise<any>;
    updateUserData(vipInfo: IVipInfo, userInfo: IUserInfo): Promise<void>;
    /**
     * @desc 更新用户表
     * @param {用户的主键id} _id
     * @param {更新的对象} document
     * @returns 若更新成功，返回为1； 若更新失败，返回为 0 或系统直接报错
     */
    updateUser(_id: string, projection: object): Promise<any>;
    /**
     * @desc 根据用户主键id查找用户详情
     * @param {用户的主键id} _id
     * @returns 若用户不存在，返回null; 用户存在，返回用户信息(object对象)
     */
    getUserInfoById(_id: string): Promise<any>;
    /**
     *判断是否新会员
     *
     * @param {IUserInfo} userInfo
     * @param {IVipInfo} vipInfo
     * @returns {boolean}
     * @memberof UserService
     */
    checkNewVipStatus(userInfo: IUserInfo, vipInfo: IVipInfo): boolean;
}
export default UserService;
