"use strict";
/** @format */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
// 排行榜开奖记录
var sdk_1 = require("../sdk");
var db_1 = require("../db");
var constants_1 = require("../constants");
var AwardsService = /** @class */ (function () {
    function AwardsService(context) {
        this.awardsDao = new sdk_1.BaseDao(context, db_1.AWARDS_DB_NAME);
    }
    // 添加排行榜待开奖列表
    AwardsService.prototype.addWaitAwardsList = function (list) {
        return __awaiter(this, void 0, void 0, function () {
            var e_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!list.length)
                            return [2 /*return*/, true];
                        list = list.map(function (v) {
                            return __assign(__assign({}, v), { drawStatus: constants_1.DRAW_STATUS.WAITAWARD, message: '' });
                        });
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 4]);
                        return [4 /*yield*/, this.awardsDao.insertMany(list)];
                    case 2:
                        _a.sent();
                        return [2 /*return*/, true];
                    case 3:
                        e_1 = _a.sent();
                        console.log("\u6DFB\u52A0\u6392\u884C\u699C\u5F85\u5F00\u5956\u5217\u8868\u51FA\u9519\uFF1A" + e_1);
                        return [2 /*return*/, false];
                    case 4: return [2 /*return*/];
                }
            });
        });
    };
    AwardsService.prototype.setUserShipStatus = function (activityId, prizeId, shipCompany, shipNum) {
        return __awaiter(this, void 0, void 0, function () {
            var status, result;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        prizeId = prizeId ? prizeId : '/';
                        shipCompany = shipCompany ? shipCompany : '';
                        shipNum = shipNum ? shipNum : '';
                        status = constants_1.SHIP_STATUS.NO_SHIP;
                        console.log(shipCompany, shipNum, 'shipCompany,shipNum');
                        if (shipCompany && shipNum) {
                            status = constants_1.SHIP_STATUS.HAS_SHIP;
                        }
                        else {
                            status = constants_1.SHIP_STATUS.NO_SHIP;
                        }
                        if (!(status == constants_1.SHIP_STATUS.HAS_SHIP)) return [3 /*break*/, 2];
                        console.log(activityId, prizeId, constants_1.PRIZE_TYPE.OBJECT);
                        return [4 /*yield*/, this.awardsDao.update({
                                activityId: activityId,
                                _id: prizeId,
                                type: constants_1.PRIZE_TYPE.OBJECT,
                                shipStatus: constants_1.SHIP_STATUS.NO_SHIP
                            }, {
                                $set: {
                                    shipCompany: shipCompany,
                                    shipNum: shipNum,
                                    shipStatus: status
                                }
                            })];
                    case 1:
                        result = _a.sent();
                        console.log(result, 'result');
                        return [2 /*return*/, result];
                    case 2: return [2 /*return*/, 0];
                }
            });
        });
    };
    // 根据活动id查找中奖名单
    AwardsService.prototype.getAwardListByActivityId = function (_a) {
        var _b = _a.activityId, activityId = _b === void 0 ? '' : _b, _c = _a.title, title = _c === void 0 ? '' : _c, _d = _a.pageNo, pageNo = _d === void 0 ? 1 : _d, _e = _a.pageSize, pageSize = _e === void 0 ? 10 : _e, _f = _a.prizeId, prizeId = _f === void 0 ? null : _f, _g = _a.userNick, userNick = _g === void 0 ? '' : _g, _h = _a.type, type = _h === void 0 ? null : _h, _j = _a.prizeDataType, prizeDataType = _j === void 0 ? null : _j, _k = _a.shipStatus, shipStatus = _k === void 0 ? null : _k, _l = _a.startTime, startTime = _l === void 0 ? null : _l, _m = _a.endTime, endTime = _m === void 0 ? null : _m, _o = _a.isExport, isExport = _o === void 0 ? false : _o;
        return __awaiter(this, void 0, void 0, function () {
            var p, u, c, s, t, pt, arr, query, list, total;
            return __generator(this, function (_p) {
                switch (_p.label) {
                    case 0:
                        if (!activityId)
                            return [2 /*return*/, false];
                        p = prizeId ? { _id: prizeId } : null;
                        u = userNick ? { userNick: { $regex: '.*' + userNick + '.*' } } : null;
                        c = startTime > 0 && endTime > 0 ? { createTime: { $gt: startTime, $lt: endTime } } : null;
                        s = shipStatus
                            ? (shipStatus == 1
                                ? { shipStatus: { $in: [constants_1.SHIP_STATUS.NO_ADDRESS] } }
                                : (shipStatus == 2
                                    ? { shipStatus: { $in: [constants_1.SHIP_STATUS.NO_SHIP] } }
                                    : { shipStatus: constants_1.SHIP_STATUS.HAS_SHIP }))
                            : '';
                        t = type ? { type: +type } : null;
                        pt = prizeDataType ? { prizeDataType: +prizeDataType } : null;
                        arr = [];
                        if (p)
                            arr.push(p);
                        if (u)
                            arr.push(u);
                        if (c)
                            arr.push(c);
                        if (s)
                            arr.push(s);
                        if (t)
                            arr.push(t);
                        if (pt)
                            arr.push(pt);
                        arr = arr.filter(function (i) { return i; });
                        console.log('arr--111---', arr, activityId);
                        query = { activityId: activityId };
                        // @ts-ignore
                        if (arr.length > 0)
                            query.$and = arr;
                        return [4 /*yield*/, this.awardsDao.find(query, {
                                limit: pageSize,
                                skip: (pageNo - 1) * pageSize,
                                sort: {
                                    score: -1,
                                    rankTime: -1
                                }
                            })];
                    case 1:
                        list = _p.sent();
                        return [4 /*yield*/, this.awardsDao.count(query)];
                    case 2:
                        total = _p.sent();
                        return [2 /*return*/, {
                                list: list,
                                total: total,
                                message: '成功',
                                pageNo: pageNo,
                                pageSize: pageSize
                            }];
                }
            });
        });
    };
    return AwardsService;
}());
exports.default = AwardsService;
//# sourceMappingURL=awards.service.js.map