import moment from 'moment'
import schema from 'async-validator'
import { methods } from './mixins'
import { TASK_RATE_TYPE } from '../const'
import {
  descriptor,
  formatValidator
} from './validate'
import {
  getActivityDetail,
  saveActivityInfo,
} from '/api'
import {
  addFloat,setPrizeProbalityRange
} from '/utils/helper'

const THANKS_TYPE = 5

var validator = new schema(descriptor)

Component({
  mixins: [ methods ],
  data: {
    labelCol: { fixedSpan: 5 },
    id: '',
    startTime: '',
    endTime: '',
    <% for(var i = 0; i < configList.length; ++i) {%>
    <%- !taskKeys.includes(configList[i].key) && configList[i].key !== 'label' ? `${configList[i].key}: ${configList[i].defaultValue || "''"},` : ''  %><% } %>
    tasks: {
    <% for(var i = 0; i < configList.length; ++i) {%>
    <%- taskKeys.includes(configList[i].key)  && configList[i].key !== 'label' ? `${configList[i].key}:{
      value:"",
      taskRateType:"",
      times:"",
      title:"",
      link:""
    },` : ''  %><% } %>
    },
    <% for(var i = 0; i < boxDatas.length; ++i) {%>
      <%- `${boxkeyDatas[i].name}:{
          ${boxkeyDatas[i].value}
      },`
    %><% } %>
    isEnd: false,
    isStart: false,
    originalStartTime: '',
    formState: formatValidator(descriptor),
    isPostParams: true
  },
  didMount() {
    const { id } = this.$page.$router.params
    id && this.getActivityInfo(id)
  },
  methods: {
    // 获取activityId活动信息
    async getActivityInfo(activityId) {
      try {
        const { success, data, message } = await getActivityDetail({ activityId})
        if (!success) {
          this.showFailToast(message);
          return;
        }

        this.setData({
          ...data,
          timeRange: [+data.startTime, +data.endTime],
          originalStartTime: +data.startTime,
          isStart: +data.startTime < Date.now(),
          isEnd: +data.endTime < Date.now(),
          tasks: data.tasks
        })

      } catch (error) {
        console.log(error, 'err')
      }
    },
    validateForm(data, target) {
      const _this = this;
      return new Promise((resolve, reject) => {
        validator.validate(data, (errors, fields) => {
          console.log('errors', errors);
          console.log('fields', fields);
          const {
            formState
          } = _this.data;
          _this.setFormTips(formState, errors, target)
          if (errors) {
            resolve(false);
          } else {
            resolve(true);
          }

          // validation passed
        });
      })
    },
    setFormTips(formState, errors, target) {
      errors = errors || []
      let newValidator = {};
      Object.keys(formState).forEach(key => {
        let error = errors.filter(v => target ? v.field === target && v.field === key : v.field === key).length && errors.filter(v => v.field === key)[0];
        // 时间实时校验
        // if (key === 'timeRange' && formState[key].status === 'error') {
        //   return
        // }
        newValidator[key] = {
          status: error ? 'error' : 'success',
          message: error ? error.message : ''
        }
      })

      console.log('newValidator', newValidator)

      this.setData({
        formState: newValidator
      })
    },
    // 提交信息
    async onSubmit() {

      console.log(this.data, 'this.data')

      const isValidForm = await this.validateForm(this.data);
      if (!isValidForm) return;
      console.log('表演校验通过')
      
      const params = this.formatActivityParams(this.data)
      console.log('最后提交的数据', params)
      if (this.data.isPostParams) {
        this.setData({
          isPostParams: false
        })
        setTimeout(() => {
          this.setData({
            isPostParams: true
          })
        }, 2000);
        const { success, message } = await saveActivityInfo(params);
        if (success) {
          this.backList();
        } else {
          this.showFailToast(message);
        }
      }
    },
    showFailToast(text) {
      my.showToast({
        type: 'fail',
        content: text
      })
    },
    // 格式化参数
    formatActivityParams(params) {
      const {
        id = '',
        activityId = '',
        startTime,
        endTime,
        tasks,
        <% for(var i = 0; i < boxDatas.length; ++i) {%>
        <%- `${boxkeyDatas[i].name}, ` %><% } %>
        <% for(var i = 0; i < activityConfigList.length; ++i) {%>
        <%- !taskKeys.includes(activityConfigList[i].key) &&  activityConfigList[i].type !== 'Labels' ? activityConfigList[i].key + ',' : ''  %><% } %>
      } = params;
      let prizeList = []
      <% for(var i = 0; i < activityConfigList.length; ++i) {%>
      <%- (!taskKeys.includes(activityConfigList[i].key) && activityConfigList[i].sort == 'prizePool') ? `prizeList = [...prizeList,...setPrizeProbalityRange(${activityConfigList[i].key})]`:''  %><% } %>
      return {
        id,
        activityId,
        startTime: new Date(startTime).getTime(),
        endTime: new Date(endTime).getTime(),
        tasks,
        prizeList,
        <% for(var i = 0; i < boxDatas.length; ++i) {%>
        <%- `${boxkeyDatas[i].name}, ` %><% } %>
       // prizeInfoList: this.formatPrizeList(prizeInfoList),
        <% for(var i = 0; i < activityConfigList.length; ++i) {%>
        <%- (!taskKeys.includes(activityConfigList[i].key) &&  activityConfigList[i].type !== 'Labels' && activityConfigList[i].sort != 'prizePool' && activityConfigList[i].key != 'time') ? activityConfigList[i].key + ',' : ''  %><% } %>
      }
    },
    // 补足谢谢参与类型
    formatPrizeList(prizeInfoList = []) {
      let totalPercent = prizeInfoList.reduce((total, next) => {
        return total = addFloat(total, +next.probability)
      }, 0)
      // 排名类型不含谢谢参与
      if (prizeInfoList[0].rank) return prizeInfoList;
      let prizeInfoListCopy = prizeInfoList.concat().map((v, index) => ({
        ...v,
        level: index
      }));

      if (totalPercent < 100) {
        let thanksType = {
          type: THANKS_TYPE,
          name: '谢谢参与',
          probability: 100 - totalPercent
        }
        prizeInfoListCopy.push(thanksType)
      }
      return prizeInfoListCopy
    },
    backList() {
      this.$page.$router.push("/activity/list");
    }
  },
})
