import React from 'react'
import { View, Text, Image } from '@tarojs/components'
import Modal from '@/components/_base/Modal/Modal'
import API from '@/api'
import tbcc from 'tbcc-sdk-ts'
import { useThrottle } from '@/hooks/useThrottle'
import './JackpotModal.less'
import useReceive from '@/hooks/useReceive'

const { receiveEnamePrize, receiveObjectPrize } = API
const { commonToast } = tbcc.tb

const JackpotModal = (props) => {
  const { onClose, top = '50%', bg = '', width = 300, height = 300, prizesData = {}, receive = false } = props

  const [ getReceive ] = useReceive({ receiveEnamePrize, receiveObjectPrize })

  const handleClick = useThrottle(async() => {
    if (receive) {
      const prizeId = prizesData.id || prizesData._id
      const type = prizesData.type
      const result = await getReceive({ prizeId, type })
      if (result) {
        commonToast(result.message)
      }
    } else {
      onClose()
    }
  })

  return (
    <Modal onClose={onClose} top={top}>
      <View className='jackpot_content' style={{ width: `${width / 100}rem`, height: `${height / 100}rem`, backgroundImage: `url(${bg})` }}>
        <View className='title_box'>
          <Text className='title'>恭喜您</Text>
        </View>
        <Text className='notify'>抽到了以下奖品</Text>
        <View className='gift_box'>
          <View className='gift'>
            <Image src={prizesData?.image} />
          </View>
          <Text className='gift_name'>{prizesData?.name}</Text>
        </View>
        <View className='btn' onTap={handleClick}>领取奖励</View>
        <Text className='hint'>奖品可在<Text className='hint_hot'>“我的奖品”</Text>中查看</Text>
      </View>
    </Modal>
  )
}

export default JackpotModal
