import React, { useState, useEffect, useCallback, useRef } from 'react'
import { View, Text } from '@tarojs/components'
import Taro from '@tarojs/taro'

import styles from './Barrage.module.less'

const Barrage = props => {
  const {
    dataList = [
      '1撒撒打算打算打算的',
      '2撒撒打算打算打算的',
      '3撒撒打算打算打算的',
      '4撒撒打算打算打算的',
      '5撒撒打算打算打算的',
      '3撒撒打算打算打算的',
      '3撒撒打算打算打算的',
      '3撒撒打算打算打算的',
      '3撒撒打算打算打算的',
      '3撒撒打算打算打算的',
      '3撒撒打算打算打算的',
      '3撒撒打算打算打算的'
    ],
    interval = 5000,
    width = 500,
    trackCount = 1
  } = props

  const [ barrageList, setBarrageList ] = useState([])
  const [ animationData, setAnimationData ] = useState(null)
  const timer = useRef(null)
  const nowIndex = useRef(0)

  const createData = () => {
    const Tracks = Array.from({ length: trackCount }, (v, k) => (k + 1) * 40 - 40)
    // TODO   多轨道弹幕
    setBarrageList(
      dataList.map((item, index) => ({
        top: Tracks[index < Tracks.length ? index : index % trackCount],
        context: item
      }))
    )
  }

  const callback = useCallback(() => {
    timer.current = setInterval(() => {
      setAnimationData(
        Taro.createAnimation()
          .translateX(nowIndex.current === 0 ? 0 : Taro.pxTransform(-width * nowIndex.current))
          .step({
            duration: nowIndex.current === 0 ? 0 : 1000
          })
          .export()
      )
      if (nowIndex.current < barrageList.length - 1) {
        nowIndex.current = nowIndex.current + 1
      } else {
        nowIndex.current = 0
      }
    }, interval + 1000)
  }, [ barrageList, width ])

  useEffect(() => {
    callback()
    return () => clearInterval(timer.current)
  }, [ callback ])

  useEffect(() => {
    createData()
    return () => {}
  }, [ dataList ])

  return (
    <View id='barrage_wrap' style={`width:${width / 100}rem`} className={styles['barrage-wrap']}>
      <View id='barrage_container' animation={animationData} className={styles['barrage-fly']}>
        {barrageList.map((item, index) => {
          return (
            <View id={`barrage-${index}`} key={index} style={`width:${width / 100}rem`} className={styles['barrage-textFly']}>
              {/* 弹幕内容 */}
              <Text className={styles['barrage-text']}>{item.context}</Text>
            </View>
          )
        })}
      </View>
    </View>
  )
}

export default Barrage
