import React, { useEffect, useState } from 'react'
import { View } from '@tarojs/components'
import { useDidShow, useRouter, useDidHide, getApp } from '@tarojs/taro'
import API from '@/api'
import { useLogin, useLoginFromShare } from '@/hooks/useLogin'
import { useActivityInfoModel, useLoginInfoModel } from '@/store'
import { 
    commonToast, 
    getSystemInfo, 
    navigateToOutside, 
    navigateBack, 
    showSharePanel, 
    navigateTo, 
    openDetail
} from 'tbcc-sdk-ts/lib/core/tb'
import { versionCompare, getImgShareUrl } from 'tbcc-sdk-ts/lib/utils'
import styles from './game.module.less'

function GamePage(props) {
    const app = getApp()
    const { activityInfo, setActivityInfoAndStatus } = useActivityInfoModel()
    const { loginInfo } = useLoginInfoModel()
    const [canvasData,setCanvasData] = useState({})
    const [ taskModalVisible, setTaskModalVisible] = useState(false)
    const [ canvasVisible, setCanvasVisible] = useState(false)
    const [ memberVisible,setMemberVisible] = useState(false)
    const [updateFlag, setUpdateFlag] = useState(1)

    useEffect(() =>{
        // getImgShareUrl('cloud://2D60DC04FC1888AF6F865B88F0B2EBCC//share.png').then(res => {
        //     console.log(res)
        // })
    },[])
    useDidShow(() =>{})
    useDidHide(() =>{})
    //检查版本号
    const checkSystem = async () => {
        const { version } = await getSystemInfo();
        console.log('version', version);
        return versionCompare(version, '9.10.0');
    }
    // 授权后登录
    useLogin(res => {
        // 登录完成渲染cavans
        setCanvasVisible(true)
    })
    //和main通信的方法，接收main的信息
    const onMessage = (e)=> {
        // 接口名字 参数
        const { netName, parameter } = e.mpEvent.data
        console.warn('netName:'+netName,parameter)
        //定制的授权
        if (netName == "mine.authorize") {
            this.getAuth()
        }
        //获取地址
        else if (netName == "mine.getUserAddress") {
            this.getUserAddress(parameter.prizeId)
        }
        //关注店铺的操作
        else if (netName == "mine.favorShop") {
            this.doFavorShop()
        }
        //领养名字，有弹框的
        else if (netName == "mine.getAdoptName") {
            this.setData({ "adoptModalVisible": true, type: parameter.type })
        }
        //打开详情页，还有成功失败
        else if (netName == "mine.openDetail") {
            openDetail(parameter.itemId)
        }
        //前端同步接口
        else if (netName.indexOf("mine") == 0) {
            let data = { success: true, type: netName }
            switch (netName) {
                case "mine.getAppData"://获取信息
                    const { userNick, avatar, openId, newUser, remainTimes, firstLoginToday } = loginInfo
                    data = {
                        success: true,
                        type: netName,
                        data: {
                            activityId: app.activityId,//|| "5e7c40e98564b57d7fb95812",
                            nickName: userNick,
                            avatar,
                            openId,
                            inviteId: app.inviteId,//判断是否要发助力用
                            isFollow: app.isFollow,
                            needDataInCanvas: {},
                            activityInfo: activityInfo,
                            userInfo: {},
                            newUser: newUser,
                            remainTimes: remainTimes,
                            firstLoginToday: firstLoginToday
                        }
                    }
                    console.warn(data)
                break;
                case "mine.navigateToOutside"://跳转小程序外的页面
                    navigateToOutside(parameter.url)
                    console.log(parameter.url)
                break;
                case "mine.navigateTo"://跳转小程序内的页面
                    navigateTo(parameter.url)
                    console.warn('navigateTo:'+parameter.url)
                break;
                case "mine.navigateBack"://返回页面
                    navigateBack()
                break;
                case "mine.showSharePanel"://分享
                    //多一个参数
                    showSharePanel()
                break;
                case "mine.reportAnalytics":  ////淘宝自定义埋点
                    reportAnalytics(parameter.logkey);
                break;
                case "mine.openMusic":  //音频
                    playBgMusic(parameter.isOn, this.musicUrl);
                break;
                case "mine.openTask":  //打开任务
                    setTaskModalVisible(true)
                break;
                case "mine.openMember":  //打开入会
                    setMemberVisible(true)
                break;
            }
            // commonToast(JSON.stringify(data))
            setUpdateFlag(Math.floor(Math.random() * 1000))
            setCanvasData(data)
        } else {
            //获取后端接口
            const { function: fc } = app.cloud;
            //处理下带上activityId
            if (!parameter) parameter = {};
            parameter.activityId = app.activityId;
            //netName得分割下
            fc.invoke(netName.split(".")[0], parameter, netName.split(".")[1])
                .then(res => {
                // console.log("返回数据" + JSON.stringify(res));
                //发送消息
                this.postMessage(netName, res || { success: false })
                }, (err) => {
                //网络异常，返回失败
                this.postMessage(netName, { success: false })
                })
        }
    }
    // 入会插件
    const onClose = () => {
        setMemberVisible(false)
    }
    const onAuthSuccess = () => {
        setMemberVisible(false)
    }
    const onAuthFail = () => {
        setMemberVisible(false)
    }
    const onTestHandle = (e) => {
        setMemberVisible(true)
    }
    return(
        <View>
            { canvasVisible && <canvas-comp  data={canvasData} onMessage={onMessage} updateFlag={updateFlag} />}
            <View className={styles['test-box']} onClick={(e) => onTestHandle(e)}>入会按钮</View>
            {<member-modal expend={memberVisible} onClose={onClose} onAuthFail={onAuthFail} onAuthSuccess={onAuthSuccess} />}
       </View>
    )
}
export default GamePage