import React, { useState, useEffect } from "react";
import { View, Image, Text } from "@tarojs/components";
import LoadingBar,{LOAD_TYPE} from "../LoadingBar/LoadingBar";
import styles from './BrowserLoading.module.less'
import {BROWSE_COUNTDOWN_OBJ} from '@/config/browse.config'
const BrowserLoading = (props) => {
    const {loadFlag,count} = props;
  return (
    <View className={styles["browse_loading"]}>
      {loadFlag == BROWSE_COUNTDOWN_OBJ.NUMBER && (
        <>
          <View className={styles["count_img"]}>
            <View className={styles["count_time"]}>{count}s</View>
          </View>
        </>
      )}
      {loadFlag == BROWSE_COUNTDOWN_OBJ.PICTURE && <LoadingBar type={LOAD_TYPE.TASK} />}
    </View>
  );
};
export default BrowserLoading;
