/**
 * 任务类型（taskType）:collectGoods、orderGoods、browseGoods、
 */
const app = getApp();
const { tbcc } = app;
const { openDetail, collectGoods, checkGoodsCollectedStatus, commonToast } = tbcc.tb;

Component({
  mixins: [],
  data: {
  },
  props: {
    isBackFlag: 0,
    goodsList: [1,2,3],
    task: {
      itemId: '617724147979,617724563528,617300295119',
      taskType: 'browseGoods',
      type: '02',
      bannerHeight: 430,
      image: {
        bg: '//yun.dui88.com/taobaomini/clientCTest/goods_bg@2x.png',
        banner: '//yun.dui88.com/taobaomini/clientCTest/goods_banner@2x.png',
        title: '//yun.dui88.com/taobaomini/clientCTest/goods_title@2x.png',
        collect: '//yun.dui88.com/taobaomini/clientCTest/goods_collection@2x.png',
        no_collect: '//yun.dui88.com/taobaomini/clientCTest/collection_no_collect@2x.png',
        img: '//yun.dui88.com/taobaomini/clientCTest/goods_img@2x.png',
      },
      color: '#181818'
    },
    onCompleteTask: () => {},
    onOpenDetail: () => {}
  },
  didMount() {
  },
  didUpdate(prevProps,prevData) { 
  },
  didUnmount() {
  },
  methods: {
    /**
     * 跳转商品详情页
     */
    async goToGoodsDetail(e) {
      const { taskType } = this.props.task
      const { itemId } = e.target.dataset.item
      if(taskType == 'browseGoods') {
        this.props.onOpenDetail(itemId)
      }
      
      await openDetail(String(itemId))
    },
    /**
     * 收藏商品
     */
    async goToCollectGoods(e) {
      let { itemId, collected } = e.target.dataset.item
      const { taskType } = this.props.task
      if(collected) {
        commonToast('您已收藏过该商品了')
        return;
      }

      //判断是否活动外已收藏商品
      let isCollected = await checkGoodsCollectedStatus(+itemId)
      if(isCollected) {
        this.props.onCompleteTask(taskType, itemId)
        return;
      }

      let result = await collectGoods(+itemId)
      if(result) {
        this.props.onCompleteTask(taskType, itemId)
      }
    }
  },
});
