import { View } from '@tarojs/components'
import { useEffect, useState } from 'react'
import styles from './ContainerFit.module.less'
import { getSystemInfo } from 'tbcc-sdk-ts/lib/core/tb'

export default function ContainerFit(props) {
  const { bg = '', hasFitPsd = false, fullScreenFit = false, minHeight = '100vh' } = props
  const [ system, setSystem ] = useState(false)
  const [statusBarHeight, setStatusBarHeight ] = useState(24)
  useEffect(() => {
    fullScreenFit && getSystemInfo().then(res => {
      const { system, statusBarHeight } = res
      setSystem(system)
      setStatusBarHeight(statusBarHeight)
    })
  }, [])

  const FitContainerStyle = (flag) => {
    return flag ? { 
      background: `url(${bg}) no-repeat`, 
      backgroundSize: '100% 100%',
      paddingTop: (system === 'iOS' && fullScreenFit) && (statusBarHeight / 100 + 'rem'),
      minHeight: (minHeight === '100vh') ? minHeight : +minHeight / 100 + 'rem'
    } : {
      minHeight: (minHeight === '100vh') ? minHeight : +minHeight / 100 + 'rem'
    }
  }
  return (
    <View className={styles['page-container']} style={FitContainerStyle(!hasFitPsd)}>
      {hasFitPsd && <View className={styles['page-psd-container']} style={FitContainerStyle(hasFitPsd)}>
            {props.children}
      </View>}
      {!hasFitPsd && props.children}
    </View>
  )
}