import React, { useEffect, useState, useRef } from 'react'
import { View } from '@tarojs/components'
import { useDidShow, useRouter, useDidHide, getApp } from '@tarojs/taro'
import API from '@/api'
import { useLogin, useLoginFromShare } from '@/hooks/useLogin'
import { useActivityInfoModel, useLoginInfoModel } from '@/store'
import { prizeList } from '@/mock'

import styles from './preComp.module.less'

import {useAudio} from '@/hooks/useAudio'
import {CLOUD_OBJ, BGMUSIC_URL} from '@/const'

import ContainerFit from '@/components/_base/ContainerFit/ContainerFit'

import ScrollXView from '@/components/_tb_comps/ScrollXView/ScrollXView'

import SwiperView from '@/components/_tb_comps/SwiperView/SwiperView'

import RotateWheel from '@/components/_tb_comps/RotateWheel/RotateWheel'

import RankTitle from '@/components/_tb_comps/Rank/RankTitle/RankTitle'

import RankList from '@/components/_tb_comps/Rank/RankList/RankList'

export default function PreComp(props) {
    return(
        <ContainerFit hasFitPsd={true}>
            <View className={styles['scroll-view']}>
                <ScrollXView prizeList={prizeList} />
            </View>
            <View className={styles['comp-view']}>
                <RotateWheel />
            </View>
            <View className={styles['comp-view']}>
                <SwiperView swiperList={prizeList} />
            </View>
        </ContainerFit>
    )
}