import { View, Image } from '@tarojs/components'
import { memo, useContext, useMemo } from 'react'
import classnames from 'classnames'

import { ProgressContext } from '../ProgressContext'

// css
import styles from './index.module.less'

const ProgressNode = memo(props => {
  const {
    descInfo,
    iconInfo,
    isReceived = false,
    isReach,
    levelValue,
    levelPos,
    id
  } = props

  const {
    BtnTexts,
    maxLevel,
    nodeClassName,
    iconImgClassName,
    iconTxtClassName,
    iconClassName,
    descClassName,
    btnClassName,
    activeBtnClassName,
    disableBtnClassName,
    onReceviceClick
  } = useMemo(() => useContext(ProgressContext), ProgressContext)

  // 节点按钮点击
  const btnClick = () => {
    return isReach && !isReceived ? onReceviceClick(id) : null
  }

  // 判断方法
  const checkFunc = fn => {
    return typeof fn === 'function'
  }

  // 判断对象是否为空
  const checkObject = obj => {
    return obj instanceof Object && JSON.stringify(obj) !== '{}'
  }

  const getNodeStyle = classnames(styles['defualt-progress-node'], {
    [nodeClassName]: nodeClassName
  })

  const getDescStyle = classnames(styles['defualt-progress-node-desc'], {
    [descInfo?.className]: descInfo?.className,
    [descClassName]: descClassName
  })

  const getIconStyle = classnames(styles['defualt-progress-node-icon'], {
    [iconInfo?.className]: iconInfo?.className,
    [iconClassName]: iconClassName
  })

  const getIconImgStyle = classnames(
    styles['defualt-progress-node-icon-iconImg'],
    {
      [iconImgClassName]: iconImgClassName
    }
  )

  const getIconTxtStyle = classnames(styles['defualt-progress-node-icon-txt'], {
    [iconTxtClassName]: iconTxtClassName
  })

  const getBtnStyle = classnames(styles['defualt-progress-node-btn-txt'], {
    [btnClassName]: !isReach && btnClassName,
    [activeBtnClassName]: isReach && !isReceived && activeBtnClassName,
    [disableBtnClassName]: isReach && isReceived && disableBtnClassName
  })

  return (
    <View
      className={getNodeStyle}
      style={{
        left: levelPos ? levelPos : (levelValue / maxLevel) * 100 + '%'
      }}
    >
      {/* 描述 */}
      {checkObject(descInfo) && (
        <View className={getDescStyle}>{descInfo.descTxt}</View>
      )}
      {/* icon */}
      {checkObject(iconInfo) && (
        <View className={getIconStyle}>
          {iconInfo?.iconUrl && (
            <Image className={getIconImgStyle} src={iconInfo.iconUrl} />
          )}
          {iconInfo?.iconTxt && (
            <View className={getIconTxtStyle}>{iconInfo.iconTxt}</View>
          )}
        </View>
      )}
      {/* 节点按钮 */}
      {checkFunc(onReceviceClick) && (
        <View className={getBtnStyle} onTap={btnClick}>
          {isReach
            ? isReceived
              ? BtnTexts.REACH_RECEIVED
              : BtnTexts.REACH_UNRECEIVED
            : BtnTexts.UNREACH}
        </View>
      )}
    </View>
  )
})

export default ProgressNode
