'use strict';
import API from "/api";

const app = getApp();
const { tbcc } = app;
const { commonToast, navigateToOutside, getUserAddress, setClipboard } = tbcc.tb;
const { dateFormatter, throttleHandle } = tbcc.utils;
const { PRIZE_TYPE, DRAW_STATUS } = tbcc.constants;
// 我的奖品配置项
const prizeConfig = {
  bg: '//yun.duiba.com.cn/aurora/assets/e13fab3165d3a6bb4cbe8827e8f0fd41084b0091.png', //背景图
  title: '//yun.dui88.com/duiba-components-c-myprizeprize_title.png',//标题
  copyIcon: '//yun.dui88.com/duiba-components-c-myprizemyprize_copy_code.png', //复制
  receiveBtn: '//yun.duiba.com.cn/bestoreBox/prize_received.png', //已领取 权益类奖品未配置 uesUrl使用
  commonStatus: {
    6: '//yun.dui88.com/duiba-components-c-myprizeget_again.png', //重新领取
    5: '//yun.duiba.com.cn/spark/assets/914ba8643c8abb8d710a3126ec312aecf6c4daf0.png', //已失效
    4: '//yun.duiba.com.cn/spark/assets/8267375232058a6d0140270b1594427fb08d6ae3.png', //领取失败
  },
  objectStatus: {
    1: '//yun.dui88.com/duiba-components-c-myprizeto_address.png', //填写地址(实物奖品)
    3: '//yun.dui88.com/duiba-components-c-myprizelogistics.png', //查看物流
  },
  enameStatus: {
    1: '//yun.dui88.com/duiba-components-c-myprizeget_now.png', //立即领取(除实物奖品外)
    3: '//yun.duiba.com.cn/bestoreBox/prize_received.png', //去使用(除实物奖品外)  
  },
  logisticsImage: {
    shipped: '//yun.dui88.com/duiba-components-c-myprizeprize_shipped.png', // 已发货物理弹窗
    notShipped: '//yun.dui88.com/duiba-components-c-myprizenotshipped.png', // 待发货物流弹窗
  },
  btnStyle: {
    width: '150rpx'
  },
  contentTop: '210rpx',
  blankTxt: '暂无奖品',
  hasLogistic: true, // 是否展示物流信息
  isShowPirzeId: true // 是否显示奖品编号
}
Page({
  data: {
    PRIZE_TYPE,
    DRAW_STATUS,
    myPrizeList: [], //我的奖品
    endTime: null,//到期时间
    prizeConfig: prizeConfig,
    objectStatus: {
      ...prizeConfig.commonStatus,
      ...prizeConfig.objectStatus
    },
    enameStatus: {
      ...prizeConfig.commonStatus,
      ...prizeConfig.enameStatus
    },
    logisticsImage: {
      ...prizeConfig.logisticsImage,
      copyIcon: prizeConfig.copyIcon
    },
    hasLogistic: prizeConfig.hasLogistic,
    isShowPirzeId: prizeConfig.isShowPirzeId,
    isLogisticModal: false,
    currentPrize: {}
  },
  onLoad() {
    this.getMyPrize();
  },
  onShow() {
  },
  // 到期时间
  getEndTime(endTime) {
    if (!endTime) return null
    this.setData({
      endTime: dateFormatter(endTime, 'yyyy/MM/dd hh:mm:ss')
    })
    console.log(this.data.endTime)
  },

  /**
 * 获取奖品列表
 * @param {string}
 */
  async getMyPrize() {
    const { activityId } = app;
    const { success, data } = await API.getMyPrizeList({ activityId }).catch(res => {
      commonToast(res && res.message);
    }) || {};
    if (success && data) {
      const { list } = data
      this.setData({
        myPrizeList: list
      })
      const endTime = list && list[0] && list[0].expiredTime
      this.getEndTime(endTime)
    }
  },

  //领取奖品
  handleClick: throttleHandle(async function(e) {
    const { type, drawStatus, useUrl = '', id, _id } = e.target.dataset.item
    const { hasLogistic } = this.data

    if(drawStatus == 3) {
      if(type == PRIZE_TYPE.OBJECT && hasLogistic) {
        this.setData({ currentPrize: e.target.dataset.item, isLogisticModal: true })
        return;
      }
      if(type != PRIZE_TYPE.OBJECT && useUrl) {
        navigateToOutside(useUrl)
        return;
      }
    }
    if(!(drawStatus == 6 || drawStatus == 1)) {
      return;
    }

    // 领取权益
    const prizeId = id || _id
    if (type === PRIZE_TYPE.ENAME) return this.handleGetEquity(prizeId)
    // 领取实物
    if (type === PRIZE_TYPE.OBJECT) return this.handleGetEntity(prizeId)
    // 领取积分
    if (type === PRIZE_TYPE.CREDITS) return this.handleGetIntergation(prizeId)
  },2000),
  // 优惠券
  async handleGetEquity(id) {
    const { activityId } = app;
    const { success, data, message } = await API.receiveEnamePrize({ activityId, id }).catch(res => {
      this.getMyPrize()
      commonToast(res && res.message)
    }) || {};
    if (success && data) {
      commonToast('领取成功')
      this.getMyPrize()
    }
  },
  // 领取实物前询问
  async handleGetEntity(id) {
    const { activityId } = app;
    const userAddress = await getUserAddress().catch(err => {
      commonToast(err && err.errorMessage);
    });
    if (!userAddress) return
    const { name, telNumber, provinceName, cityName, cityCode, countyName, detailInfo, streetName } = userAddress || {};
    const params = {
      activityId,
      name,
      phone: telNumber,
      addressDetail: detailInfo,
      cityCode,
      city: cityName,
      province: provinceName,
      area: countyName,
      streetName,
      id
    }

    my.confirm({
      title: '提示',
      content: '确认使用该收货地址：' + name + telNumber + userAddress.duibaAddress.address,
      confirmButtonText: '确定',
      cancelButtonText: '取消',
      success: (result) => {
        console.log(result)
        const { confirm } = result;

        if (confirm) {
          this.receiveObjectPrize(params);
        }
      },
    });
  },
  // 领取实物
  async receiveObjectPrize(params) {
    const { success, data } = await API.receiveObjectPrize(params).catch(res => {
      commonToast(res && res.message)
    }) || {}
    if (success && data) {
      commonToast('领取成功')
    }
    this.getMyPrize()
  },
  // 积分
  async handleGetIntergation(id) {
    // 判断是否为会员
    const { isVip, url } = await this.getUserInfo() || {}
    if (!isVip) {
      commonToast('需加入会员才能领取成功哦', 2000,() => { navigateToOutside(url) });
      return;
    }
    const { activityId } = app;
    const { success, data } = await API.receiveEnamePrize({ activityId, id }).catch(res => {
      commonToast(res && res.message)
    }) || {};
    if (success && data) {
      commonToast('领取成功')
    }
    this.getMyPrize()
  },

  //获取用户vip信息
  async getUserInfo() {
    const { activityId } = app;
    const { success, data } = await API.getVipInfo({ activityId }).catch(res => {
      commonToast(res && res.message)
    }) || {};
    if (success && data) {
      return data
    }
  },

  // 复制编码
  async handleCopyId(e) {
    const { text } = e.target.dataset || {}
    await setClipboard({ text })
    commonToast('复制成功')
  },
  /**
  * 关闭物流弹窗
  */
  closeLogisticModal() {
    this.setData({ isLogisticModal: false })
  },
});