import cloud from '@tbmp/mp-cloud-sdk';
import tbcc from './tbcc-sdk';

cloud.init({
  env: 'test' // 云函数环境 test 测试环境 online 线上环境
});

App({
  requestType: 'yapi', // cloud: 云函数, yapi: yapi 接口, ams: ams接口，tornadoAPI: 风驰台接口
  cloudName: 'CommonToC', // 主云函数项目名
  tornadoAPI: 'https://tornado.duibadev.com.cn/tbServer/api?db=xxx&proxyIp=xxx',  // 新增：当requestType: 'tornadoAPI'时，找服务端提供地址
  cloud,
  tbcc,
  onLaunch(options) {
    this.handleQuery(options.query || {});
  },
  onShow(options) {
    // 从后台被 scheme 重新打开
  },
  /**
   * 处理链接参数
   * @param {object} query 小程序链接上的参数
   */
  handleQuery(query) {
    const { activityId } = query;
    this.activityId = activityId || '5f8550a3964f97be3647a635';
  }
});
