/** @format */
import { services, checkParams } from '../../decorator/common'
import { test1 } from '../../decorator/custom'
import customUtil from '../../utils/custom'
import { resultsModel } from '../../sdk'
import { CommonStatService } from '../../service/common'
import { CustomTestService } from '../../service/custom'

export default class Test1Controller {
  /**
   *  增加埋点记录
   */
  @checkParams(['activityId', 'type'])
  @test1(['tt'])
  @services([CommonStatService, CustomTestService])
  async testAddStat(
    context: IContext<IParams>,
    { activityInfo, userInfo }: IControllerInfos,
    [commonStatService, customTestService]: [CommonStatService, CustomTestService]
  ) {
    const commonStatAddStatResult1 = await commonStatService.addStat(context.data.type, userInfo)
    const customTestTest1Result2 = await customTestService.test1()
    return resultsModel.success({
      ...commonStatAddStatResult1,
      ...customTestTest1Result2
    })
  }
  /**
   *  统计数据
   */
  @checkParams(['activityId', 'startDay', 'endDay'])
  @services([CommonStatService])
  async testGetStats(
    context: IContext<IParams>,
    { activityInfo, userInfo }: IControllerInfos,
    [commonStatService]: [CommonStatService]
  ) {
    const commonStatGetStatsResult1 = await commonStatService.getStats(
      context.data.activityId,
      context.data.startDay,
      context.data.endDay
    )
    const commonStatBuildExcelResult2 = await commonStatService.buildExcel(
      context.data.startDay,
      context.data.endDay,
      commonStatGetStatsResult1
    )
    return resultsModel.success({
      ...commonStatBuildExcelResult2
    })
  }
}
