/** @format */

import { resultsModel } from '../../../sdk'
import { CODE_TYPES } from '../../../errorCode'

export default async function checkNewVip(context: IContext<IParams>, { vipInfo, userInfo }: IControllerInfos) {
  if (!vipInfo) {
    console.error(`使用checkNewVip registeInfos必须注册vipInfo`)
  }

  const { isVip } = vipInfo

  if (!isVip) return resultsModel.error(CODE_TYPES.ERROR_NO_VIP)

  const isNewVip = !userInfo?.member?.flag && isVip

  if (!isNewVip) return resultsModel.error(CODE_TYPES.ERROR_INVITE)
}
