import React, { useState } from 'react'
import { View } from '@tarojs/components'

import Progress from '../index'
import styles from './index.module.less'

const initLevelList = [
  {
    id: 0,
    levelValue: 0,
    isReceived: true,
    iconInfo: {
      iconUrl: '//yun.dui88.com/tebuXinYuan/main-circle-tip.png',
      iconTxt: ''
    },
    descInfo: {
      descTxt: '等级1'
    }
  },
  {
    id: 1,
    levelValue: 5,
    isReceived: false,
    iconInfo: {
      iconUrl: '//yun.dui88.com/tebuXinYuan/main-circle-tip.png',
      iconTxt: ''
    },
    descInfo: {
      descTxt: '等级2'
    }
  },
  {
    id: 2,
    levelValue: 10,
    isReceived: false,
    iconInfo: {
      iconUrl: '//yun.dui88.com/tebuXinYuan/main-circle-tip.png',
      iconTxt: ''
    },
    descInfo: {
      descTxt: '等级3'
    }
  },
  {
    id: 3,
    levelValue: 15,
    isReceived: false,
    iconInfo: {
      iconUrl: '//yun.dui88.com/tebuXinYuan/main-circle-tip.png',
      iconTxt: ''
    },
    descInfo: {
      descTxt: '等级4'
    }
  }
]

const Demo = props => {
  const [levelList, setLevelList] = useState(initLevelList)
  const [currentValue, setCurrentValue] = useState(10)

  const onReceviceClick = id => {
    console.log('点击：', id)
  }
  return (
    <View className={styles['progress']}>
      <Progress
        levelList={levelList}
        currentValue={currentValue}
        btnClassName={styles['btnClassName']}
        activeBtnClassName={styles['activeBtn']}
        disableBtnClassName={styles['disableBtn']}
        onReceviceClick={onReceviceClick}
      />
    </View>
  )
}

export default Demo
