import React, { useState, useEffect, useRef } from 'react'
import { View } from '@tarojs/components'
import ContainerFit from '@/components/_base/ContainerFit/ContainerFit'
import TitleImg from '@/components/_tb_comps/TitleImg/TitleImg'
import GoodsList from '@/components/_tb_comps/GoodsList/GoodsList'
import { useRouter, showToast } from '@tarojs/taro'
import tbccTs from 'tbcc-sdk-ts'
import API from '@/api'
import { useThrottle } from '@/hooks/useThrottle'
import styles from './cartGoods.module.less'
import { CART_CONFIG, CART_TYPE } from '@/config/cart.config'
import { TASK_RATE_TYPE } from '@/config/task.config'
import { GOOD_LIST } from '@/mock'

const { showSkuModal } = tbccTs.tb

function CartGoodsPage() {
  const router = useRouter()
  const [goodsList, setGoodsList] = useState(GOOD_LIST)
  const { item } = router?.params
  const { itemIds, todayCompleteTimes, rateType, times, completeTimes = 0 } = JSON.parse(item)
  // 加购状态
  const initCompleteTimes = rateType === TASK_RATE_TYPE.EVERYDAY? +(todayCompleteTimes || completeTimes) : +completeTimes
  const collectFlag = useRef(initCompleteTimes)
  useEffect(() => {
    getGoodsList()
  }, [])

  const getGoodsList = async () => {
    const { data } = await API.getCollectGoods({ key: CART_CONFIG.taskType, taskType: CART_CONFIG.taskType, itemIds })
    data?.list && setGoodsList(data?.list || [])
  }
  // 加入购物车 // 对应itemId为 574141925233 skuId为4018047819826 数量为4
  const onCompleteTask = useThrottle(async (itemId, collected) => {
    if (collected && CART_CONFIG.type === CART_TYPE.ONE) {
      showToast({ title: '您已加购过该商品了'})
      return;
    }
    if(rateType !== TASK_RATE_TYPE.FOREVER && collectFlag.current >= times && CART_TYPE.ONE) {
      showToast({ title: '该任务今天已完成，明天再来吧~'})
      return;
    }
    const { status, quantity } = await showSkuModal(String(itemId))
    if (status == "addCartSuccess") {
      const { success } = await API.completeTask({ key: CART_CONFIG.taskType, taskType: CART_CONFIG.taskType, itemId, count: quantity })
      if (success) {
        collectFlag.current += 1
        getGoodsList()
        // showToast({ title: '加购成功'})
      }
    }
  }, 2000);

  return (
    <ContainerFit bg={CART_CONFIG.bg} fullScreenFit>
      <View className={styles['page-content__title']}>
        <TitleImg config={CART_CONFIG.head} position={'bottom'} />
      </View>
      <View className={styles['page-content__list']}>
        <GoodsList goodsList={goodsList} task={CART_CONFIG} onCompleteTask={(itemId,collected) => onCompleteTask(itemId,collected)} />
      </View>
    </ContainerFit>
  )
}

export default CartGoodsPage
