/**
 * @description 音乐
 */
 import React, { useState, useEffect } from "react";
 import { playBgMusic1 } from "@/utils/audio";
 const app = getApp();
 /**
  * @description 一个页面不能同时create两个音频文件
  * @param {*} url cloud文件链接
  * @param {*} isBgMusic 是否自动调用(背景音乐自动调用),非背景音乐(点击音效)手动调用
  * @returns 
  */
 export const useAudio = (url, isBgMusic=false) => {
   const [musicUrl, setMusicUrl] = useState();
  //  若需要控制所有的音效状态，app上自定义一个变量
   const [openStatus,setOpenStatus] = useState(true);
   useEffect(() => {
     getMusicInfo();
   }, []);

   useEffect(()=>{
    if(isBgMusic){
        console.log('enter use audio function with bg music');
        playAudio();
    }
   },[musicUrl,openStatus])

   /**
    * @description 获取音频url链接
    */
   const getMusicInfo = async () => {
     const resultSrc = await app.cloud.file.getTempFileURL({ fileId: url });
     console.log('resultSrc--------hook',resultSrc);
     if (resultSrc[0]){
       setMusicUrl(resultSrc[0].url);
     } 
   };
   /**
    * @description 播放音效
    * @param {boolean} selfStatus 是否单独控制音效状态
    * @param {function} callbackFn 播放之后的回调
    */
   const playAudio = (callbackFn=()=>{}) => {
     console.log('musicUrl',musicUrl,'selfStatus',openStatus)
      musicUrl && playBgMusic1(openStatus, musicUrl, callbackFn,isBgMusic);
   };
   return {
     playAudio,
     openStatus,
     setOpenStatus,
     musicUrl
   };
 };
