import React, { useState } from 'react'
import { View, Image } from '@tarojs/components'
import classnames from 'classnames'
import styles from './Progress.module.less'
import { PROGRESS_LIST } from '@/mock'

const PRO_ICON = {
    icon: '//yun.duiba.com.cn/taobaomini/provideBeauty/total/progress_icon.png'
}
function Progress(props) {
    const { data = {}, width = 692, type = 1, hasIcon = false, hasTxt = true } = props
    const { allHotValue = 0, levleList = PROGRESS_LIST } = data
    const maxLevel = levleList[levleList.length -1]

    const getProItm = classnames(styles['progress-box-com'],{
        [`${styles['progress-box-com-02']}`]: allHotValue  === maxLevel
    })
    const tranHotValue = (value) => {
        const _num = parseInt(value / 10000)
        if(_num) return _num + '万'
        return value
    }
    const getTextStyle = classnames(styles['progress-box__txt'],{
        [`${styles['progress-box__txt-bottom']}`]: type === 2
    })
    const getDescStyle = (itm) => {
        return classnames(styles['progress-box__txt-item'],{
            [`${styles['progress-txt-active']}`]: itm <= allHotValue
        })
    }
    return (
        <View className={styles['progress-box']} style={{ width: width / 100 + 'rem'}}>
            <View className={getProItm} style={{width: allHotValue >= maxLevel ? '100%' : (allHotValue / maxLevel) * 100 +'%'}}></View>
            {hasIcon && <View className={styles['progress-box__icon']}>
                { levleList.map((itm,i) => {
                    return(
                        <Image className={styles['progress-box__icon-itm']} 
                        style={{left: (itm / maxLevel) * width / 100 + 'rem'}} src={PRO_ICON['icon']} />
                    )
                })}
            </View>}
            {hasTxt && <View className={getTextStyle}>
                { levleList.map((itm,i) => {
                    return(
                        <View className={getDescStyle(itm)}
                        style={{left: (itm / maxLevel) * width / 100 +  'rem'}}>{tranHotValue(itm)}</View>
                    )
                })}
            </View>}
        </View>
    )
}

export default Progress