/** @format */

import { resultsModel } from '../../../sdk'
import { CODE_TYPES } from '../../../errorCode'
import { formatVipCbUrl, getShopVip } from '../vip'

export default async function checkVip(context: IContext<IParams>, { vipInfo, activityInfo }: IControllerInfos) {
  if (!vipInfo) {
    vipInfo = await getShopVip(context, activityInfo, formatVipCbUrl(context))
  }
  if (!vipInfo?.isVip) return resultsModel.error(CODE_TYPES.ERROR_NO_VIP, '非店铺会员', vipInfo)

  return { vipInfo }
}
