import React, { useState, useMemo, useEffect, useRef, useCallback } from 'react'
import { View } from '@tarojs/components'
import Taro, { useReady } from '@tarojs/taro'
import styles from './VerticalBarrage.module.less'

const animation = Taro.createAnimation({
  transformOrigin: 'top right',
  duration: 850,
  timeFunction: 'ease-in-out',
  delay: 150
})

const VerticalBarrage = (props) => {
  const { dataList, barrageNum = 30, quantity = 2 } = props
  const [ height, setHeight ] = useState(0)
  const [ animationData, setAnimationData ] = useState(null)
  const nowIndex = useRef(0)
  const timer = useRef(null)

  useReady(() => {
    const query = Taro.createSelectorQuery()
    query.select('#barrage_0').boundingClientRect().exec((res) => {
      console.log(res)
      const h = res[0].height
      setHeight(h)
    })
  })

  const barrageList = useMemo(() => {
    if (!dataList.length) return []
    if (barrageNum && dataList.length < barrageNum) {
      let reslut = [ ...dataList ]
      while (reslut.length < barrageNum) {
        reslut = [ ...reslut, ...dataList ]
      }
      return [ ...reslut.slice(0, barrageNum), ...reslut.slice(0, quantity) ]
    } else {
      return [ ...dataList.slice(0, barrageNum), ...dataList.slice(0, quantity) ]
    }
  }, [ dataList ])

  const callback = useCallback(() => {
    timer.current = setInterval(() => {
      const data = animation.translateY(-nowIndex.current * height).step()
      setAnimationData(data.export())
      if (nowIndex.current < barrageList.length - quantity) {
        nowIndex.current = nowIndex.current + 1
      } else {
        nowIndex.current = 0
      }
    }, 1000)
  }, [ barrageList, height ])

  useEffect(() => {
    callback()
    return () => clearInterval(timer.current)
  }, [ callback ])

  // 控制淡入淡出
  const barrageStyle = (index) => {
    if (quantity === 1) {
      return `${(nowIndex.current === index && nowIndex.current !== 0) ? styles.in : ''} ${(nowIndex.current - 1 === index) ? styles.out : ''}`
    } else {
      return `${(nowIndex.current + quantity - 1 === index && nowIndex.current !== 0) ? styles.in : ''} ${nowIndex.current - 1 === index ? styles.out : ''}`
    }
  }

  return (
    <View className={styles['barrage-container']} style={{ height: height * quantity }}>
      <View
        className={styles['barrage-box']}
        animation={animationData}
        style={nowIndex.current === 0 && { transform: 'translateY(0)' }}
      >
        {
        barrageList.map((item, i) => (
          <View key={`barrage-${i}`} id={`barrage_${i}`} className={barrageStyle(i)}>
            <View className={styles.text}>{item}</View>
          </View>
        ))
      }
      </View>
    </View>
  )
}

export default VerticalBarrage
