import * as FYGE from "fyge";
var app = getApp();
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(window, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./src/Main.ts");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./module/RES.ts":
/*!***********************!*\
  !*** ./module/RES.ts ***!
  \***********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.RES = void 0;
var RES;
(function (RES) {
    var resData;
    var textureHash = {};
    var videoEntityHash = {};
    var soundHash = {};
    var groupsCompleteHash = {};
    var groupsPromiseHash = {};
    var singleResPromiseHash = {};
    function loadConfig(res) {
        resData = res;
        RES.resPath = res.path;
    }
    RES.loadConfig = loadConfig;
    function loadGroup(name) {
        if (groupsCompleteHash[name]) {
            return new Promise(function (resolve) {
                resolve();
            });
        }
        if (groupsPromiseHash[name]) {
            return groupsPromiseHash[name];
        }
        var arr = getGroupResByName(name);
        if (!arr || !arr.length) {
            groupsCompleteHash[name] = true;
            return new Promise(function (resolve) {
                resolve();
            });
        }
        var p = new Promise(function (resolve, reject) {
            loadResList(function (s) {
                delete groupsPromiseHash[name];
                if (s) {
                    groupsCompleteHash[name] = true;
                    resolve();
                }
                else {
                    reject();
                }
            }, arr);
        });
        groupsPromiseHash[name] = p;
        return p;
    }
    RES.loadGroup = loadGroup;
    function getResAsync(str, comFun, thisObj) {
        var type = str.substring(str.lastIndexOf(".") + 1, str.length);
        if (type == "png" || type == "jpg") {
            var cached_1 = textureHash[str] || FYGE.TextureCache[str];
            if (cached_1) {
                comFun && comFun.call(thisObj, cached_1, str);
                return new Promise(function (r) {
                    r(cached_1);
                });
            }
            else if (singleResPromiseHash[str]) {
                return returnSingleResPromise(str, comFun, thisObj);
            }
            else {
                var groupName = hasRes(str);
                if (groupName && type != "jpg") {
                    var group = getGroupByName(groupName);
                    if (group && group.atlas) {
                        var json = groupName + ".json";
                        if (singleResPromiseHash[json]) {
                            return singleResPromiseHash[json].then(function (r) {
                                var cached = textureHash[str] || FYGE.TextureCache[str];
                                comFun && comFun.call(thisObj, cached, str);
                                return cached;
                            }, function () {
                                comFun && comFun.call(thisObj, null, str);
                                return null;
                            });
                        }
                        else {
                            return getResAsync(json)
                                .then(function () {
                                var cached = textureHash[str] || FYGE.TextureCache[str];
                                comFun && comFun.call(thisObj, cached, str);
                                return cached;
                            }, function () {
                                comFun && comFun.call(thisObj, null, str);
                                return null;
                            });
                        }
                    }
                }
                var src = groupName ? RES.resPath + groupName + "/" + str : str;
                var p = new Promise(function (resolve, reject) {
                    FYGE.GlobalLoader.loadImage(function (s, image) {
                        delete singleResPromiseHash[str];
                        if (s) {
                            var cached_2 = FYGE.Texture.from(image);
                            textureHash[str] = cached_2;
                            FYGE.Texture.addToCache(cached_2, str);
                            comFun && comFun.call(thisObj, cached_2, str);
                            resolve(cached_2);
                        }
                        else {
                            comFun && comFun.call(thisObj, null, str);
                            reject();
                        }
                    }, src);
                });
                singleResPromiseHash[str] = p;
                return p;
            }
        }
        else if (type == "svga") {
            if (videoEntityHash[str]) {
                comFun && comFun.call(thisObj, videoEntityHash[str], str);
                return new Promise(function (r) {
                    r(videoEntityHash[str]);
                });
            }
            else if (singleResPromiseHash[str]) {
                return returnSingleResPromise(str, comFun, thisObj);
            }
            else {
                var groupName = hasRes(str);
                var src = groupName ? RES.resPath + groupName + "/" + str : str;
                var p = new Promise(function (resolve, reject) {
                    SvgaParser.loadSvga(src, function (v) {
                        delete singleResPromiseHash[str];
                        videoEntityHash[str] = v;
                        comFun && comFun.call(thisObj, v, str);
                        resolve(v);
                    }, function (err) {
                        delete singleResPromiseHash[str];
                        comFun && comFun.call(thisObj, null, str);
                        reject(err);
                    });
                });
                singleResPromiseHash[str] = p;
                return p;
            }
        }
        else if (type == "json") {
            if (singleResPromiseHash[str]) {
                return returnSingleResPromise(str, comFun, thisObj);
            }
            else {
                var groupName = hasRes(str);
                var src = groupName ? RES.resPath + groupName + "/" + str : str;
                var p = new Promise(function (resolve, reject) {
                    var jsonData = getGroupByName(groupName).atlas;
                    FYGE.GlobalLoader.loadImage(function (s, data) {
                        if (s) {
                            var t = FYGE.createTextureSheet(new FYGE.BaseTexture(data), jsonData);
                            for (var key in t)
                                textureHash[key] = t[key];
                            comFun && comFun.call(thisObj, t, str);
                            resolve(t);
                        }
                        else {
                            delete singleResPromiseHash[str];
                            comFun && comFun.call(thisObj, null, str);
                            reject();
                        }
                    }, src.replace("json", "png"));
                });
                singleResPromiseHash[str] = p;
                return p;
            }
        }
    }
    RES.getResAsync = getResAsync;
    function getResByUrl() {
    }
    RES.getResByUrl = getResByUrl;
    function getRes(str) {
        if (!str)
            return null;
        var type = str.substring(str.lastIndexOf(".") + 1, str.length);
        if (type == "png" || type == "jpg") {
            return textureHash[str] || FYGE.TextureCache[str] || null;
        }
        else if (type == "svga") {
            return videoEntityHash[str] || null;
        }
        else if (type == "mp3") {
            return soundHash[str] || null;
        }
    }
    RES.getRes = getRes;
    function loadAllGroup() {
        var groups = resData.groups;
        var p = [];
        groups.forEach(function (g) {
            p.push(loadGroup(g.name));
        });
        return Promise.all(p);
    }
    RES.loadAllGroup = loadAllGroup;
    function hasRes(str) {
        for (var i = 0; i < resData.groups.length; i++) {
            var group = resData.groups[i];
            var keys = group.keys;
            if (keys && keys.split(",").indexOf(str) > -1) {
                return group.name;
            }
            if (group.atlas && group.name + ".json" == str) {
                return group.name;
            }
        }
        return null;
    }
    function getGroupResByName(name) {
        var group = getGroupByName(name);
        if (!group)
            return null;
        if (group.atlas) {
            var arr = [name + ".json"];
            if (group.keys) {
                arr = arr.concat(group.keys.split(",").filter(function (k) {
                    return k.substr(-4) != ".png";
                }));
            }
            return arr;
        }
        else if (group.keys) {
            return group.keys.split(",");
        }
        else {
            return null;
        }
    }
    function getGroupByName(name) {
        var groups = resData.groups;
        var group;
        for (var i = 0; i < groups.length; i++) {
            if (groups[i].name === name) {
                group = groups[i];
                break;
            }
        }
        return group;
    }
    function loadResList(callback, arr) {
        var count = 0;
        var countAll = arr.length;
        if (!countAll)
            callback(true);
        var mark = true;
        for (var i = 0; i < countAll; i++) {
            var resName = arr[i];
            getResAsync(resName, function (res, str) {
                if (!res)
                    mark = false;
                if (++count == countAll)
                    callback(mark);
            }, this);
        }
    }
    function returnSingleResPromise(str, comFun, thisObj) {
        singleResPromiseHash[str].then(function (r) {
            comFun && comFun.call(thisObj, r, str);
        }, function () {
            comFun && comFun.call(thisObj, null, str);
        });
        return singleResPromiseHash[str];
    }
    var skinData;
    function loadSkinConfig(skinJson) {
        skinData = skinJson;
    }
    RES.loadSkinConfig = loadSkinConfig;
    function initSkinDisplay(con, skin, root) {
        var data = typeof (skin) == 'string' ? getSkinDataByName(skin) : skin;
        if (!data.children || !data.children.length)
            return;
        for (var i = 0; i < data.children.length; i++) {
            var child = data.children[i];
            if (child.type == "item")
                continue;
            var dis = con.addChild(getDisplayByData(child));
            if (root && child.id)
                root[child.id] = dis;
            if (child.type == "container")
                initSkinDisplay(dis, child, root);
        }
    }
    RES.initSkinDisplay = initSkinDisplay;
    function getSkinDataByName(skinName, skinNode) {
        if (skinNode === void 0) { skinNode = skinData; }
        if (!skinNode || !skinNode.children || !skinNode.children.length)
            return null;
        for (var i = 0; i < skinNode.children.length; i++) {
            var child = skinNode.children[i];
            if (child.name == skinName && (child.type == "container" || child.type == "item"))
                return child;
            var gson = getSkinDataByName(skinName, child);
            if (gson)
                return gson;
        }
        return null;
    }
    RES.getSkinDataByName = getSkinDataByName;
    function getDisplayByData(data) {
        var dis;
        switch (data.type) {
            case "container":
                dis = new FYGE.Container();
                break;
            case "button":
                dis = new FYGE.Button(getRes(data.props.tUp), data.props.tDown ? getRes(data.props.tDown) : null, data.props.tDisable ? getRes(data.props.tDisable) : null);
                break;
            case "text":
                dis = new FYGE.TextField();
                for (var key in data.props)
                    dis[key] = data.props[key];
                break;
            case "sprite":
                dis = new FYGE.Sprite(getRes(data.props.source));
                break;
            case "rect":
                dis = new FYGE.Shape();
                dis.beginFill(FYGE.string2hex(data.props.fillColor));
                dis.drawRect(0, 0, data.props.width, data.props.height);
                dis.endFill();
                break;
        }
        dis.name = data.name;
        dis.alpha = data.alpha || 1;
        dis.position.set(data.x, data.y);
        return dis;
    }
    function destroyGroup(name) {
        var group = getGroupByName(name);
        if (!group)
            return;
        var arr = [];
        if (group.keys) {
            arr = group.keys.split(",");
        }
        var removedBase = [];
        for (var i = 0; i < arr.length; i++) {
            var t = getRes(arr[i]);
            if (t) {
                if (removedBase.indexOf(t.baseTexture) == -1) {
                    t.baseTexture.destroy();
                    removedBase.push(t.baseTexture);
                }
                t.destroy();
            }
            delete textureHash[arr[i]];
        }
    }
    RES.destroyGroup = destroyGroup;
    function destroyRES() {
    }
})(RES = exports.RES || (exports.RES = {}));


/***/ }),

/***/ "./module/ctrls/index.ts":
/*!*******************************!*\
  !*** ./module/ctrls/index.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.destroyAllCtrls = exports.removeTweens = exports.clearWait = exports.wait = exports.showAlert = exports.getCurrentScene = exports.changeScene = exports.closeCurrentPanel = exports.closeAllPanels = exports.showConfirm = exports.showPanel = void 0;
var waitingCtrl_1 = __webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts");
var panelCtrl_1 = __importDefault(__webpack_require__(/*! ./panelCtrl */ "./module/ctrls/panelCtrl.ts"));
var sceneCtrl_1 = __importDefault(__webpack_require__(/*! ./sceneCtrl */ "./module/ctrls/sceneCtrl.ts"));
var toastCtrl_1 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
var toastCtrl_2 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
Object.defineProperty(exports, "showToast", { enumerable: true, get: function () { return toastCtrl_2.showToast; } });
__exportStar(__webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts"), exports);
exports.showPanel = function (panel, data) {
    return panelCtrl_1.default.instance.show(panel, data);
};
exports.showConfirm = function (panel, data) {
    var confirmPanel = panelCtrl_1.default.instance.show(panel, data);
    return confirmPanel.makePromise();
};
exports.closeAllPanels = function () {
    panelCtrl_1.default.instance.closeAll();
};
exports.closeCurrentPanel = function () {
    panelCtrl_1.default.instance.closeCurrent();
};
exports.changeScene = function (scene, data) {
    sceneCtrl_1.default.instance.change(scene, data);
};
function getCurrentScene() {
    return sceneCtrl_1.default.instance.currentScene;
}
exports.getCurrentScene = getCurrentScene;
exports.showAlert = function (title, content) {
    if (my) {
        my.alert({
            title: title || "",
            content: content || ""
        });
    }
    else {
        console.log(title, content);
    }
};
function wait(callback, time) {
    var obj = {};
    FYGE.Tween.get(obj)
        .wait(time)
        .call(callback);
    return obj;
}
exports.wait = wait;
function clearWait(obj) {
    obj && FYGE.Tween.removeTweens(obj);
}
exports.clearWait = clearWait;
function removeTweens(obj, isRecursive) {
    if (isRecursive === void 0) { isRecursive = true; }
    if (!obj)
        return;
    FYGE.Tween.removeTweens(obj);
    if (!isRecursive || !obj.children || !obj.children.length)
        return;
    obj.children.forEach(function (child) {
        removeTweens(child);
    });
}
exports.removeTweens = removeTweens;
function destroyAllCtrls() {
    toastCtrl_1.destroyToast();
    waitingCtrl_1.destroyWaiting();
    panelCtrl_1.default.instance.destroy();
    sceneCtrl_1.default.instance.destroy();
}
exports.destroyAllCtrls = destroyAllCtrls;


/***/ }),

/***/ "./module/ctrls/panelCtrl.ts":
/*!***********************************!*\
  !*** ./module/ctrls/panelCtrl.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var layers_1 = __webpack_require__(/*! ../views/layers */ "./module/views/layers.ts");
var waitingCtrl_1 = __webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts");
var toastCtrl_1 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
var PanelCtrl = (function () {
    function PanelCtrl() {
        this.stacks = [];
    }
    Object.defineProperty(PanelCtrl, "instance", {
        get: function () {
            return PanelCtrl._instance || (PanelCtrl._instance = new PanelCtrl());
        },
        enumerable: false,
        configurable: true
    });
    PanelCtrl.prototype.init = function (parent) {
        this._parent = parent;
        var bg = new FYGE.Shape();
        bg.beginFill(0);
        bg.drawRect(layers_1.layers.stageOffsetX - parent.x, layers_1.layers.stageOffsetY - parent.y, layers_1.layers.stageWidth, layers_1.layers.stageHeight);
        bg.endFill();
        bg.hitTestByPixel = false;
        bg.visible = false;
        this._parent.addChild(bg);
        this._bg = bg;
    };
    PanelCtrl.prototype.closeAll = function () {
        this.stacks.forEach(function (e) { return e.hidePanel(); });
    };
    PanelCtrl.prototype.show = function (cls, data) {
        var _this = this;
        waitingCtrl_1.showWaiting();
        var panel = new cls(data);
        this.add(panel);
        this.stacks.push(panel);
        panel.onLoaded = function () {
            waitingCtrl_1.hideWaiting();
            _this.updateView(false);
            panel.start(data);
            if (panel.visible)
                panel.showAni();
        };
        panel.onLoadError = function () {
            waitingCtrl_1.hideWaiting();
            toastCtrl_1.showToast("资源加载失败");
            panel.removeEventListener('onDestroy', _this.onPanelHide, _this);
            _this.remove(panel);
        };
        return panel;
    };
    PanelCtrl.prototype.updateView = function (showPanelAni) {
        var _this = this;
        if (showPanelAni === void 0) { showPanelAni = true; }
        if (!this.stacks.length) {
            if (this._bg.visible) {
                this.bgAni = "hide";
                FYGE.Tween.removeTweens(this._bg);
                FYGE.Tween.get(this._bg)
                    .to({ alpha: 0 }, 200, FYGE.Ease.cubicOut)
                    .call(function () {
                    _this._bg.visible = false;
                    _this._current = null;
                    _this._parent.visible = false;
                });
            }
        }
        else {
            this._parent.visible = true;
            if (this.bgAni == "hide") {
                this.bgAni = "show";
                FYGE.Tween.removeTweens(this._bg);
                this._bg.alpha = 0.7;
            }
            if (this._bg.visible === false) {
                this._bg.visible = true;
                this._bg.alpha = 0;
                FYGE.Tween.get(this._bg).to({ alpha: 0.7 }, 200, FYGE.Ease.cubicOut);
            }
        }
        for (var i = 0; i < this.stacks.length; i++) {
            if (i < this.stacks.length - 1) {
                this.stacks[i].visible = false;
            }
            else {
                this.stacks[i].visible = true;
                if (showPanelAni)
                    this.stacks[i].showAni();
                this._current = this.stacks[i];
            }
        }
    };
    PanelCtrl.prototype.add = function (panel) {
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
    };
    PanelCtrl.prototype.remove = function (panel) {
        this._parent.removeChild(panel);
        this.stacks = this.stacks.filter(function (e) { return e != panel; });
    };
    PanelCtrl.prototype.onPanelHide = function (e) {
        var panel = e.target;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        this.remove(panel);
        this.updateView();
    };
    PanelCtrl.prototype.closeCurrent = function () {
        if (this._current) {
            this._current.hidePanel();
        }
    };
    PanelCtrl.prototype.destroy = function () {
        PanelCtrl._instance = null;
        this.stacks = null;
        this._current = null;
        this._parent = null;
        FYGE.Tween.removeTweens(this._bg);
        this._bg = null;
    };
    return PanelCtrl;
}());
exports.default = PanelCtrl;


/***/ }),

/***/ "./module/ctrls/sceneCtrl.ts":
/*!***********************************!*\
  !*** ./module/ctrls/sceneCtrl.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var waitingCtrl_1 = __webpack_require__(/*! ./waitingCtrl */ "./module/ctrls/waitingCtrl.ts");
var toastCtrl_1 = __webpack_require__(/*! ./toastCtrl */ "./module/ctrls/toastCtrl.ts");
var SceneCtrl = (function () {
    function SceneCtrl() {
    }
    Object.defineProperty(SceneCtrl, "instance", {
        get: function () {
            return SceneCtrl._instance || (SceneCtrl._instance = new SceneCtrl());
        },
        enumerable: false,
        configurable: true
    });
    SceneCtrl.prototype.init = function (parent) {
        this._parent = parent;
    };
    SceneCtrl.prototype.change = function (cls, data) {
        var _this = this;
        var scene = new cls(data);
        scene.visible = false;
        waitingCtrl_1.showWaiting();
        var preScene = this._currentScene;
        scene.onLoaded = function () {
            waitingCtrl_1.hideWaiting();
            scene.showAni(function () {
                if (preScene)
                    preScene.destroy();
            });
            scene.visible = true;
            scene.start(data);
        };
        scene.onLoadError = function () {
            waitingCtrl_1.hideWaiting();
            toastCtrl_1.showToast("资源加载失败");
            _this._currentScene = preScene || null;
            _this._parent.removeChild(scene);
        };
        this._currentScene = scene;
        this._parent.addChild(scene);
    };
    Object.defineProperty(SceneCtrl.prototype, "currentScene", {
        get: function () {
            return this._currentScene;
        },
        enumerable: false,
        configurable: true
    });
    SceneCtrl.prototype.destroy = function () {
        SceneCtrl._instance = null;
        this._currentScene = null;
        this._parent = null;
    };
    return SceneCtrl;
}());
exports.default = SceneCtrl;


/***/ }),

/***/ "./module/ctrls/toastCtrl.ts":
/*!***********************************!*\
  !*** ./module/ctrls/toastCtrl.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.destroyToast = exports.showToast = void 0;
var layers_1 = __webpack_require__(/*! ../views/layers */ "./module/views/layers.ts");
var RES_1 = __webpack_require__(/*! ../RES */ "./module/RES.ts");
var inited = false;
var _toast;
var _parent;
var startY;
var endY;
var initToast = function () {
    if (!inited) {
        inited = true;
        _toast = new Toast();
        _parent = layers_1.layers.toastLayer;
        _toast.alpha = 0;
        _toast.x = layers_1.layers.stageOffsetX - _parent.x + (layers_1.layers.stageWidth - _toast.width) / 2;
        var h = _toast.height;
        var y = layers_1.layers.stageOffsetY - _parent.y;
        startY = y - h;
        endY = y + (layers_1.layers.stageHeight - h) / 2;
    }
};
exports.showToast = function (msg) {
    initToast();
    _toast.show(msg);
    _parent.addChild(_toast);
    FYGE.Tween.removeTweens(_toast);
    FYGE.Tween.get(_toast)
        .set({ y: startY, alpha: 1 })
        .to({ y: endY }, 500, FYGE.Ease.quartOut)
        .wait(800)
        .to({ alpha: 0 }, 300)
        .call(function () {
        _parent.removeChild(_toast);
    });
};
exports.destroyToast = function () {
    if (inited && _toast && !_toast.destroyed) {
        _toast.destroy();
        _toast = null;
        _parent = null;
        inited = false;
    }
};
var Toast = (function (_super) {
    __extends(Toast, _super);
    function Toast() {
        var _this = _super.call(this) || this;
        _this.PADDING = 40;
        _this.mouseChildren = false;
        _this.mouseEnable = false;
        var toastBgTexture = RES_1.RES.getRes("toastBg.png");
        _this.bg = new FYGE.Sprite(toastBgTexture);
        _this.addChild(_this.bg);
        _this.msg = new FYGE.TextField();
        _this.msg.size = 28;
        _this.msg.fillColor = "0xffffff";
        _this.msg.text = "";
        _this.msg.verticalAlign = FYGE.VERTICAL_ALIGN.MIDDLE;
        _this.msg.textHeight = toastBgTexture.height;
        _this.msg.textAlign = FYGE.TEXT_ALIGN.CENTER;
        _this.addChild(_this.msg);
        return _this;
    }
    Toast.prototype.show = function (msg) {
        this.msg.text = msg;
        this.msg.x = (this.bg.width - this.msg.textWidth) / 2;
    };
    Toast.prototype.destroy = function () {
        FYGE.Tween.removeTweens(this);
        _super.prototype.destroy.call(this);
        this.msg = null;
        this.bg = null;
    };
    return Toast;
}(FYGE.Container));


/***/ }),

/***/ "./module/ctrls/waitingCtrl.ts":
/*!*************************************!*\
  !*** ./module/ctrls/waitingCtrl.ts ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.destroyWaiting = exports.hideWaiting = exports.showWaiting = void 0;
var RES_1 = __webpack_require__(/*! ../RES */ "./module/RES.ts");
var layers_1 = __webpack_require__(/*! ../views/layers */ "./module/views/layers.ts");
var inited = false;
var _waiting;
var _parent;
var initWaiting = function () {
    if (!inited) {
        inited = true;
        var waiting = new Waiting();
        _parent = layers_1.layers.topLayer;
        _waiting = waiting;
        var offX = (layers_1.layers.stageWidth - 160) / 2;
        var offY = (layers_1.layers.stageHeight - _waiting.height) / 2;
        _waiting.x = layers_1.layers.stageOffsetX - _parent.x + offX;
        _waiting.y = layers_1.layers.stageOffsetY - _parent.y + offY;
        var bg = new FYGE.Graphics()
            .beginFill(0x000000)
            .drawRect(-offX, -offY, layers_1.layers.stageWidth, layers_1.layers.stageHeight)
            .endFill();
        bg.alpha = 0;
        _waiting.addChildAt(bg, 0);
    }
};
exports.showWaiting = function (msg) {
    initWaiting();
    _waiting.show(msg);
    _parent.addChild(_waiting);
};
exports.hideWaiting = function () {
    _parent.removeChild(_waiting);
};
exports.destroyWaiting = function () {
    if (inited && _waiting && !_waiting.destroyed) {
        _waiting.destroy();
        _waiting = null;
        _parent = null;
        inited = false;
    }
};
var Waiting = (function (_super) {
    __extends(Waiting, _super);
    function Waiting() {
        var _this = _super.call(this) || this;
        var rectBgTexture = RES_1.RES.getRes("waitingBg.png");
        var rectBg = new FYGE.Sprite(rectBgTexture);
        _this.addChild(rectBg);
        var rotTexture = RES_1.RES.getRes("waitingRot.png");
        var rot = new FYGE.Sprite(rotTexture);
        rot.x = (rectBgTexture.width - rotTexture.width) / 2;
        rot.y = 47;
        rot.anchorX = rotTexture.width / 2;
        rot.anchorY = rotTexture.height / 2;
        _this.addChild(rot);
        var count = 0;
        rot.addEventListener(FYGE.Event.ENTER_FRAME, function () {
            count++;
            if (count % 30 == 0)
                rot.rotation += 45;
        }, _this);
        _this.msg = new FYGE.TextField();
        _this.msg.y = 125;
        _this.msg.textWidth = rectBgTexture.width;
        _this.msg.textAlign = FYGE.TEXT_ALIGN.CENTER;
        _this.msg.size = 26;
        _this.msg.fillColor = "#ffffff";
        _this.addChild(_this.msg);
        return _this;
    }
    Waiting.prototype.show = function (msg) {
        if (msg === void 0) { msg = "加载中"; }
        this.msg.text = msg;
    };
    Waiting.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        this.msg = null;
    };
    return Waiting;
}(FYGE.Container));


/***/ }),

/***/ "./module/views/Module.ts":
/*!********************************!*\
  !*** ./module/views/Module.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Module = void 0;
var RES_1 = __webpack_require__(/*! ../RES */ "./module/RES.ts");
var ctrls_1 = __webpack_require__(/*! ../ctrls */ "./module/ctrls/index.ts");
var Module = (function (_super) {
    __extends(Module, _super);
    function Module(data) {
        var _this = _super.call(this) || this;
        _this.data = data;
        _this.init();
        return _this;
    }
    Module.prototype.init = function () {
        var _this = this;
        this.preLoadRes().then(function () {
            if (_this.skinName)
                RES_1.RES.initSkinDisplay(_this, _this.skinName, _this);
            _this.initUi();
            _this.onLoaded && _this.onLoaded();
        }, function () {
            _this.onLoadError && _this.onLoadError();
        });
    };
    Module.prototype.preLoadRes = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            if (_this.groupNames && _this.groupNames.length) {
                var arr = [];
                for (var i = 0; i < _this.groupNames.length; i++) {
                    arr.push(RES_1.RES.loadGroup(_this.groupNames[i]));
                }
                Promise.all(arr).then(resolve, reject);
            }
            else {
                resolve();
            }
        });
    };
    Module.prototype.initUi = function () {
    };
    Object.defineProperty(Module.prototype, "groupNames", {
        get: function () { return null; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Module.prototype, "skinName", {
        get: function () { return null; },
        enumerable: false,
        configurable: true
    });
    ;
    Module.prototype.start = function (data) {
        this.initEvents();
    };
    Module.prototype.initEvents = function () {
    };
    Module.prototype.removeEvents = function () {
    };
    Module.prototype.enableMouseEvt = function (enable) {
        this.mouseEnable = enable;
        this.mouseChildren = enable;
    };
    Module.prototype.btnDelay = function (target, delay) {
        if (delay === void 0) { delay = 2000; }
        target.mouseEnable = false;
        target.mouseChildren = false;
        setTimeout(function () {
            target.mouseEnable = true;
            target.mouseChildren = true;
        }, delay);
    };
    Module.prototype.destroy = function () {
        ctrls_1.removeTweens(this);
        this.removeEvents();
        this.dispatchEvent("onDestroy");
        _super.prototype.destroy.call(this);
    };
    return Module;
}(FYGE.Container));
exports.Module = Module;


/***/ }),

/***/ "./module/views/Panel.ts":
/*!*******************************!*\
  !*** ./module/views/Panel.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Panel = void 0;
var Module_1 = __webpack_require__(/*! ./Module */ "./module/views/Module.ts");
var Panel = (function (_super) {
    __extends(Panel, _super);
    function Panel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Panel.prototype.showAni = function () {
        var _this = this;
        if (this.isShowing)
            return;
        this.isShowing = true;
        var oriY = this.y || 0;
        this.y = -200;
        FYGE.Tween.get(this)
            .to({ y: oriY }, 500, FYGE.Ease.quartOut)
            .call(function () {
            _this.isShowing = false;
        });
    };
    Panel.prototype.initEvents = function () {
        var _this = this;
        this.closeBtns.forEach(function (btn) {
            if (btn)
                btn.addEventListener(FYGE.MouseEvent.CLICK, _this.hidePanel, _this);
        });
    };
    Panel.prototype.removeEvents = function () {
        var _this = this;
        this.closeBtns.forEach(function (btn) {
            if (btn)
                btn.removeEventListener(FYGE.MouseEvent.CLICK, _this.hidePanel, _this);
        });
    };
    Object.defineProperty(Panel.prototype, "closeBtns", {
        get: function () {
            return [this['closeBtn']];
        },
        enumerable: false,
        configurable: true
    });
    Panel.prototype.hidePanel = function () {
        this.destroy();
    };
    return Panel;
}(Module_1.Module));
exports.Panel = Panel;


/***/ }),

/***/ "./module/views/Scene.ts":
/*!*******************************!*\
  !*** ./module/views/Scene.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Scene = void 0;
var Module_1 = __webpack_require__(/*! ./Module */ "./module/views/Module.ts");
var Scene = (function (_super) {
    __extends(Scene, _super);
    function Scene() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Scene.prototype.showAni = function (callback) {
        callback();
    };
    Scene.prototype.updateScene = function () {
    };
    return Scene;
}(Module_1.Module));
exports.Scene = Scene;


/***/ }),

/***/ "./module/views/layers.ts":
/*!********************************!*\
  !*** ./module/views/layers.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.destroyLayers = exports.layers = void 0;
var panelCtrl_1 = __importDefault(__webpack_require__(/*! ../ctrls/panelCtrl */ "./module/ctrls/panelCtrl.ts"));
var sceneCtrl_1 = __importDefault(__webpack_require__(/*! ../ctrls/sceneCtrl */ "./module/ctrls/sceneCtrl.ts"));
var Layers = (function (_super) {
    __extends(Layers, _super);
    function Layers() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._adaptH = 0;
        return _this;
    }
    Object.defineProperty(Layers.prototype, "adaptH", {
        get: function () {
            return this._adaptH;
        },
        enumerable: false,
        configurable: true
    });
    Layers.prototype.init = function (stage) {
        stage.addChild(this);
        var arr = [
            "_bottomLayer",
            "_sceneLayer",
            "_popupLayer",
            "_toastLayer",
            "_topLayer",
            "_shareLayer"
        ];
        for (var i = 0; i < arr.length; i++) {
            this[arr[i]] = new FYGE.Container();
            this.addChild(this[arr[i]]);
        }
        this.shareLayer.y = -this.stageOffsetY;
        sceneCtrl_1.default.instance.init(this.sceneLayer);
        panelCtrl_1.default.instance.init(this.popupLayer);
        this._adaptH = 211 - (this.stageOffsetY / 211) * 211 + this.stageOffsetY;
    };
    Object.defineProperty(Layers.prototype, "bottomLayer", {
        get: function () { return this._bottomLayer; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "sceneLayer", {
        get: function () { return this._sceneLayer; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "popupLayer", {
        get: function () { return this._popupLayer; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "toastLayer", {
        get: function () { return this._toastLayer; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "topLayer", {
        get: function () { return this._topLayer; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "shareLayer", {
        get: function () { return this._shareLayer; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageHeight", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.height;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageWidth", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.width;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageOffsetX", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.x;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Layers.prototype, "stageOffsetY", {
        get: function () {
            if (!this.stage)
                return 0;
            return this.stage.viewRect.y;
        },
        enumerable: false,
        configurable: true
    });
    return Layers;
}(FYGE.Container));
exports.layers = new Layers();
function destroyLayers() {
    exports.layers.removeChildren();
    if (exports.layers.parent)
        exports.layers.parent.removeChild(exports.layers);
}
exports.destroyLayers = destroyLayers;


/***/ }),

/***/ "./node_modules/matter-js/build/matter.js":
/*!************************************************!*\
  !*** ./node_modules/matter-js/build/matter.js ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global, module) {var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

/*!
 * matter-js 0.17.1 by @liabru
 * http://brm.io/matter-js/
 * License MIT
 * 
 * The MIT License (MIT)
 * 
 * Copyright (c) Liam Brummitt and contributors.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
(function webpackUniversalModuleDefinition(root, factory) {
  if (( false ? undefined : _typeof(exports)) === 'object' && ( false ? undefined : _typeof(module)) === 'object') module.exports = factory();else if (true) !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));else {}
})(this, function () {
  return (
    /******/
    function (modules) {
      // webpackBootstrap

      /******/
      // The module cache

      /******/
      var installedModules = {};
      /******/

      /******/
      // The require function

      /******/

      function __webpack_require__(moduleId) {
        /******/

        /******/
        // Check if module is in cache

        /******/
        if (installedModules[moduleId]) {
          /******/
          return installedModules[moduleId].exports;
          /******/
        }
        /******/
        // Create a new module (and put it into the cache)

        /******/


        var module = installedModules[moduleId] = {
          /******/
          i: moduleId,

          /******/
          l: false,

          /******/
          exports: {}
          /******/

        };
        /******/

        /******/
        // Execute the module function

        /******/

        modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
        /******/

        /******/
        // Flag the module as loaded

        /******/

        module.l = true;
        /******/

        /******/
        // Return the exports of the module

        /******/

        return module.exports;
        /******/
      }
      /******/

      /******/

      /******/
      // expose the modules object (__webpack_modules__)

      /******/


      __webpack_require__.m = modules;
      /******/

      /******/
      // expose the module cache

      /******/

      __webpack_require__.c = installedModules;
      /******/

      /******/
      // define getter function for harmony exports

      /******/

      __webpack_require__.d = function (exports, name, getter) {
        /******/
        if (!__webpack_require__.o(exports, name)) {
          /******/
          Object.defineProperty(exports, name, {
            enumerable: true,
            get: getter
          });
          /******/
        }
        /******/

      };
      /******/

      /******/
      // define __esModule on exports

      /******/


      __webpack_require__.r = function (exports) {
        /******/
        if (typeof Symbol !== 'undefined' && Symbol.toStringTag) {
          /******/
          Object.defineProperty(exports, Symbol.toStringTag, {
            value: 'Module'
          });
          /******/
        }
        /******/


        Object.defineProperty(exports, '__esModule', {
          value: true
        });
        /******/
      };
      /******/

      /******/
      // create a fake namespace object

      /******/
      // mode & 1: value is a module id, require it

      /******/
      // mode & 2: merge all properties of value into the ns

      /******/
      // mode & 4: return value when already ns object

      /******/
      // mode & 8|1: behave like require

      /******/


      __webpack_require__.t = function (value, mode) {
        /******/
        if (mode & 1) value = __webpack_require__(value);
        /******/

        if (mode & 8) return value;
        /******/

        if (mode & 4 && _typeof(value) === 'object' && value && value.__esModule) return value;
        /******/

        var ns = Object.create(null);
        /******/

        __webpack_require__.r(ns);
        /******/


        Object.defineProperty(ns, 'default', {
          enumerable: true,
          value: value
        });
        /******/

        if (mode & 2 && typeof value != 'string') for (var key in value) {
          __webpack_require__.d(ns, key, function (key) {
            return value[key];
          }.bind(null, key));
        }
        /******/

        return ns;
        /******/
      };
      /******/

      /******/
      // getDefaultExport function for compatibility with non-harmony modules

      /******/


      __webpack_require__.n = function (module) {
        /******/
        var getter = module && module.__esModule ?
        /******/
        function getDefault() {
          return module['default'];
        } :
        /******/
        function getModuleExports() {
          return module;
        };
        /******/

        __webpack_require__.d(getter, 'a', getter);
        /******/


        return getter;
        /******/
      };
      /******/

      /******/
      // Object.prototype.hasOwnProperty.call

      /******/


      __webpack_require__.o = function (object, property) {
        return Object.prototype.hasOwnProperty.call(object, property);
      };
      /******/

      /******/
      // __webpack_public_path__

      /******/


      __webpack_require__.p = "";
      /******/

      /******/

      /******/
      // Load entry module and return exports

      /******/

      return __webpack_require__(__webpack_require__.s = 22);
      /******/
    }(
    /************************************************************************/

    /******/
    [
    /* 0 */

    /***/
    function (module, exports) {
      /**
      * The `Matter.Common` module contains utility functions that are common to all modules.
      *
      * @class Common
      */
      var Common = {};
      module.exports = Common;

      (function () {
        Common._nextId = 0;
        Common._seed = 0;
        Common._nowStartTime = +new Date();
        Common._warnedOnce = {};
        Common._decomp = null;
        /**
         * Extends the object in the first argument using the object in the second argument.
         * @method extend
         * @param {} obj
         * @param {boolean} deep
         * @return {} obj extended
         */

        Common.extend = function (obj, deep) {
          var argsStart, args, deepClone;

          if (typeof deep === 'boolean') {
            argsStart = 2;
            deepClone = deep;
          } else {
            argsStart = 1;
            deepClone = true;
          }

          for (var i = argsStart; i < arguments.length; i++) {
            var source = arguments[i];

            if (source) {
              for (var prop in source) {
                if (deepClone && source[prop] && source[prop].constructor === Object) {
                  if (!obj[prop] || obj[prop].constructor === Object) {
                    obj[prop] = obj[prop] || {};
                    Common.extend(obj[prop], deepClone, source[prop]);
                  } else {
                    obj[prop] = source[prop];
                  }
                } else {
                  obj[prop] = source[prop];
                }
              }
            }
          }

          return obj;
        };
        /**
         * Creates a new clone of the object, if deep is true references will also be cloned.
         * @method clone
         * @param {} obj
         * @param {bool} deep
         * @return {} obj cloned
         */


        Common.clone = function (obj, deep) {
          return Common.extend({}, deep, obj);
        };
        /**
         * Returns the list of keys for the given object.
         * @method keys
         * @param {} obj
         * @return {string[]} keys
         */


        Common.keys = function (obj) {
          if (Object.keys) return Object.keys(obj); // avoid hasOwnProperty for performance

          var keys = [];

          for (var key in obj) {
            keys.push(key);
          }

          return keys;
        };
        /**
         * Returns the list of values for the given object.
         * @method values
         * @param {} obj
         * @return {array} Array of the objects property values
         */


        Common.values = function (obj) {
          var values = [];

          if (Object.keys) {
            var keys = Object.keys(obj);

            for (var i = 0; i < keys.length; i++) {
              values.push(obj[keys[i]]);
            }

            return values;
          } // avoid hasOwnProperty for performance


          for (var key in obj) {
            values.push(obj[key]);
          }

          return values;
        };
        /**
         * Gets a value from `base` relative to the `path` string.
         * @method get
         * @param {} obj The base object
         * @param {string} path The path relative to `base`, e.g. 'Foo.Bar.baz'
         * @param {number} [begin] Path slice begin
         * @param {number} [end] Path slice end
         * @return {} The object at the given path
         */


        Common.get = function (obj, path, begin, end) {
          path = path.split('.').slice(begin, end);

          for (var i = 0; i < path.length; i += 1) {
            obj = obj[path[i]];
          }

          return obj;
        };
        /**
         * Sets a value on `base` relative to the given `path` string.
         * @method set
         * @param {} obj The base object
         * @param {string} path The path relative to `base`, e.g. 'Foo.Bar.baz'
         * @param {} val The value to set
         * @param {number} [begin] Path slice begin
         * @param {number} [end] Path slice end
         * @return {} Pass through `val` for chaining
         */


        Common.set = function (obj, path, val, begin, end) {
          var parts = path.split('.').slice(begin, end);
          Common.get(obj, path, 0, -1)[parts[parts.length - 1]] = val;
          return val;
        };
        /**
         * Shuffles the given array in-place.
         * The function uses a seeded random generator.
         * @method shuffle
         * @param {array} array
         * @return {array} array shuffled randomly
         */


        Common.shuffle = function (array) {
          for (var i = array.length - 1; i > 0; i--) {
            var j = Math.floor(Common.random() * (i + 1));
            var temp = array[i];
            array[i] = array[j];
            array[j] = temp;
          }

          return array;
        };
        /**
         * Randomly chooses a value from a list with equal probability.
         * The function uses a seeded random generator.
         * @method choose
         * @param {array} choices
         * @return {object} A random choice object from the array
         */


        Common.choose = function (choices) {
          return choices[Math.floor(Common.random() * choices.length)];
        };
        /**
         * Returns true if the object is a HTMLElement, otherwise false.
         * @method isElement
         * @param {object} obj
         * @return {boolean} True if the object is a HTMLElement, otherwise false
         */


        Common.isElement = function (obj) {
          if (typeof HTMLElement !== 'undefined') {
            return obj instanceof HTMLElement;
          }

          return !!(obj && obj.nodeType && obj.nodeName);
        };
        /**
         * Returns true if the object is an array.
         * @method isArray
         * @param {object} obj
         * @return {boolean} True if the object is an array, otherwise false
         */


        Common.isArray = function (obj) {
          return Object.prototype.toString.call(obj) === '[object Array]';
        };
        /**
         * Returns true if the object is a function.
         * @method isFunction
         * @param {object} obj
         * @return {boolean} True if the object is a function, otherwise false
         */


        Common.isFunction = function (obj) {
          return typeof obj === "function";
        };
        /**
         * Returns true if the object is a plain object.
         * @method isPlainObject
         * @param {object} obj
         * @return {boolean} True if the object is a plain object, otherwise false
         */


        Common.isPlainObject = function (obj) {
          return _typeof(obj) === 'object' && obj.constructor === Object;
        };
        /**
         * Returns true if the object is a string.
         * @method isString
         * @param {object} obj
         * @return {boolean} True if the object is a string, otherwise false
         */


        Common.isString = function (obj) {
          return toString.call(obj) === '[object String]';
        };
        /**
         * Returns the given value clamped between a minimum and maximum value.
         * @method clamp
         * @param {number} value
         * @param {number} min
         * @param {number} max
         * @return {number} The value clamped between min and max inclusive
         */


        Common.clamp = function (value, min, max) {
          if (value < min) return min;
          if (value > max) return max;
          return value;
        };
        /**
         * Returns the sign of the given value.
         * @method sign
         * @param {number} value
         * @return {number} -1 if negative, +1 if 0 or positive
         */


        Common.sign = function (value) {
          return value < 0 ? -1 : 1;
        };
        /**
         * Returns the current timestamp since the time origin (e.g. from page load).
         * The result is in milliseconds and will use high-resolution timing if available.
         * @method now
         * @return {number} the current timestamp in milliseconds
         */


        Common.now = function () {
          if (typeof window !== 'undefined' && window.performance) {
            if (window.performance.now) {
              return window.performance.now();
            } else if (window.performance.webkitNow) {
              return window.performance.webkitNow();
            }
          }

          if (Date.now) {
            return Date.now();
          }

          return new Date() - Common._nowStartTime;
        };
        /**
         * Returns a random value between a minimum and a maximum value inclusive.
         * The function uses a seeded random generator.
         * @method random
         * @param {number} min
         * @param {number} max
         * @return {number} A random number between min and max inclusive
         */


        Common.random = function (min, max) {
          min = typeof min !== "undefined" ? min : 0;
          max = typeof max !== "undefined" ? max : 1;
          return min + _seededRandom() * (max - min);
        };

        var _seededRandom = function _seededRandom() {
          // https://en.wikipedia.org/wiki/Linear_congruential_generator
          Common._seed = (Common._seed * 9301 + 49297) % 233280;
          return Common._seed / 233280;
        };
        /**
         * Converts a CSS hex colour string into an integer.
         * @method colorToNumber
         * @param {string} colorString
         * @return {number} An integer representing the CSS hex string
         */


        Common.colorToNumber = function (colorString) {
          colorString = colorString.replace('#', '');

          if (colorString.length == 3) {
            colorString = colorString.charAt(0) + colorString.charAt(0) + colorString.charAt(1) + colorString.charAt(1) + colorString.charAt(2) + colorString.charAt(2);
          }

          return parseInt(colorString, 16);
        };
        /**
         * The console logging level to use, where each level includes all levels above and excludes the levels below.
         * The default level is 'debug' which shows all console messages.  
         *
         * Possible level values are:
         * - 0 = None
         * - 1 = Debug
         * - 2 = Info
         * - 3 = Warn
         * - 4 = Error
         * @property Common.logLevel
         * @type {Number}
         * @default 1
         */


        Common.logLevel = 1;
        /**
         * Shows a `console.log` message only if the current `Common.logLevel` allows it.
         * The message will be prefixed with 'matter-js' to make it easily identifiable.
         * @method log
         * @param ...objs {} The objects to log.
         */

        Common.log = function () {
          if (console && Common.logLevel > 0 && Common.logLevel <= 3) {
            console.log.apply(console, ['matter-js:'].concat(Array.prototype.slice.call(arguments)));
          }
        };
        /**
         * Shows a `console.info` message only if the current `Common.logLevel` allows it.
         * The message will be prefixed with 'matter-js' to make it easily identifiable.
         * @method info
         * @param ...objs {} The objects to log.
         */


        Common.info = function () {
          if (console && Common.logLevel > 0 && Common.logLevel <= 2) {
            console.info.apply(console, ['matter-js:'].concat(Array.prototype.slice.call(arguments)));
          }
        };
        /**
         * Shows a `console.warn` message only if the current `Common.logLevel` allows it.
         * The message will be prefixed with 'matter-js' to make it easily identifiable.
         * @method warn
         * @param ...objs {} The objects to log.
         */


        Common.warn = function () {
          if (console && Common.logLevel > 0 && Common.logLevel <= 3) {
            console.warn.apply(console, ['matter-js:'].concat(Array.prototype.slice.call(arguments)));
          }
        };
        /**
         * Uses `Common.warn` to log the given message one time only.
         * @method warnOnce
         * @param ...objs {} The objects to log.
         */


        Common.warnOnce = function () {
          var message = Array.prototype.slice.call(arguments).join(' ');

          if (!Common._warnedOnce[message]) {
            Common.warn(message);
            Common._warnedOnce[message] = true;
          }
        };
        /**
         * Shows a deprecated console warning when the function on the given object is called.
         * The target function will be replaced with a new function that first shows the warning
         * and then calls the original function.
         * @method deprecated
         * @param {object} obj The object or module
         * @param {string} name The property name of the function on obj
         * @param {string} warning The one-time message to show if the function is called
         */


        Common.deprecated = function (obj, prop, warning) {
          obj[prop] = Common.chain(function () {
            Common.warnOnce('🔅 deprecated 🔅', warning);
          }, obj[prop]);
        };
        /**
         * Returns the next unique sequential ID.
         * @method nextId
         * @return {Number} Unique sequential ID
         */


        Common.nextId = function () {
          return Common._nextId++;
        };
        /**
         * A cross browser compatible indexOf implementation.
         * @method indexOf
         * @param {array} haystack
         * @param {object} needle
         * @return {number} The position of needle in haystack, otherwise -1.
         */


        Common.indexOf = function (haystack, needle) {
          if (haystack.indexOf) return haystack.indexOf(needle);

          for (var i = 0; i < haystack.length; i++) {
            if (haystack[i] === needle) return i;
          }

          return -1;
        };
        /**
         * A cross browser compatible array map implementation.
         * @method map
         * @param {array} list
         * @param {function} func
         * @return {array} Values from list transformed by func.
         */


        Common.map = function (list, func) {
          if (list.map) {
            return list.map(func);
          }

          var mapped = [];

          for (var i = 0; i < list.length; i += 1) {
            mapped.push(func(list[i]));
          }

          return mapped;
        };
        /**
         * Takes a directed graph and returns the partially ordered set of vertices in topological order.
         * Circular dependencies are allowed.
         * @method topologicalSort
         * @param {object} graph
         * @return {array} Partially ordered set of vertices in topological order.
         */


        Common.topologicalSort = function (graph) {
          // https://github.com/mgechev/javascript-algorithms
          // Copyright (c) Minko Gechev (MIT license)
          // Modifications: tidy formatting and naming
          var result = [],
              visited = [],
              temp = [];

          for (var node in graph) {
            if (!visited[node] && !temp[node]) {
              Common._topologicalSort(node, visited, temp, graph, result);
            }
          }

          return result;
        };

        Common._topologicalSort = function (node, visited, temp, graph, result) {
          var neighbors = graph[node] || [];
          temp[node] = true;

          for (var i = 0; i < neighbors.length; i += 1) {
            var neighbor = neighbors[i];

            if (temp[neighbor]) {
              // skip circular dependencies
              continue;
            }

            if (!visited[neighbor]) {
              Common._topologicalSort(neighbor, visited, temp, graph, result);
            }
          }

          temp[node] = false;
          visited[node] = true;
          result.push(node);
        };
        /**
         * Takes _n_ functions as arguments and returns a new function that calls them in order.
         * The arguments applied when calling the new function will also be applied to every function passed.
         * The value of `this` refers to the last value returned in the chain that was not `undefined`.
         * Therefore if a passed function does not return a value, the previously returned value is maintained.
         * After all passed functions have been called the new function returns the last returned value (if any).
         * If any of the passed functions are a chain, then the chain will be flattened.
         * @method chain
         * @param ...funcs {function} The functions to chain.
         * @return {function} A new function that calls the passed functions in order.
         */


        Common.chain = function () {
          var funcs = [];

          for (var i = 0; i < arguments.length; i += 1) {
            var func = arguments[i];

            if (func._chained) {
              // flatten already chained functions
              funcs.push.apply(funcs, func._chained);
            } else {
              funcs.push(func);
            }
          }

          var chain = function chain() {
            // https://github.com/GoogleChrome/devtools-docs/issues/53#issuecomment-51941358
            var lastResult,
                args = new Array(arguments.length);

            for (var i = 0, l = arguments.length; i < l; i++) {
              args[i] = arguments[i];
            }

            for (i = 0; i < funcs.length; i += 1) {
              var result = funcs[i].apply(lastResult, args);

              if (typeof result !== 'undefined') {
                lastResult = result;
              }
            }

            return lastResult;
          };

          chain._chained = funcs;
          return chain;
        };
        /**
         * Chains a function to excute before the original function on the given `path` relative to `base`.
         * See also docs for `Common.chain`.
         * @method chainPathBefore
         * @param {} base The base object
         * @param {string} path The path relative to `base`
         * @param {function} func The function to chain before the original
         * @return {function} The chained function that replaced the original
         */


        Common.chainPathBefore = function (base, path, func) {
          return Common.set(base, path, Common.chain(func, Common.get(base, path)));
        };
        /**
         * Chains a function to excute after the original function on the given `path` relative to `base`.
         * See also docs for `Common.chain`.
         * @method chainPathAfter
         * @param {} base The base object
         * @param {string} path The path relative to `base`
         * @param {function} func The function to chain after the original
         * @return {function} The chained function that replaced the original
         */


        Common.chainPathAfter = function (base, path, func) {
          return Common.set(base, path, Common.chain(Common.get(base, path), func));
        };
        /**
         * Provide the [poly-decomp](https://github.com/schteppe/poly-decomp.js) library module to enable
         * concave vertex decomposition support when using `Bodies.fromVertices` e.g. `Common.setDecomp(require('poly-decomp'))`.
         * @method setDecomp
         * @param {} decomp The [poly-decomp](https://github.com/schteppe/poly-decomp.js) library module.
         */


        Common.setDecomp = function (decomp) {
          Common._decomp = decomp;
        };
        /**
         * Returns the [poly-decomp](https://github.com/schteppe/poly-decomp.js) library module provided through `Common.setDecomp`,
         * otherwise returns the global `decomp` if set.
         * @method getDecomp
         * @return {} The [poly-decomp](https://github.com/schteppe/poly-decomp.js) library module if provided.
         */


        Common.getDecomp = function () {
          // get user provided decomp if set
          var decomp = Common._decomp;

          try {
            // otherwise from window global
            if (!decomp && typeof window !== 'undefined') {
              decomp = window.decomp;
            } // otherwise from node global


            if (!decomp && typeof global !== 'undefined') {
              decomp = global.decomp;
            }
          } catch (e) {
            // decomp not available
            decomp = null;
          }

          return decomp;
        };
      })();
      /***/

    },
    /* 1 */

    /***/
    function (module, exports) {
      /**
      * The `Matter.Bounds` module contains methods for creating and manipulating axis-aligned bounding boxes (AABB).
      *
      * @class Bounds
      */
      var Bounds = {};
      module.exports = Bounds;

      (function () {
        /**
         * Creates a new axis-aligned bounding box (AABB) for the given vertices.
         * @method create
         * @param {vertices} vertices
         * @return {bounds} A new bounds object
         */
        Bounds.create = function (vertices) {
          var bounds = {
            min: {
              x: 0,
              y: 0
            },
            max: {
              x: 0,
              y: 0
            }
          };
          if (vertices) Bounds.update(bounds, vertices);
          return bounds;
        };
        /**
         * Updates bounds using the given vertices and extends the bounds given a velocity.
         * @method update
         * @param {bounds} bounds
         * @param {vertices} vertices
         * @param {vector} velocity
         */


        Bounds.update = function (bounds, vertices, velocity) {
          bounds.min.x = Infinity;
          bounds.max.x = -Infinity;
          bounds.min.y = Infinity;
          bounds.max.y = -Infinity;

          for (var i = 0; i < vertices.length; i++) {
            var vertex = vertices[i];
            if (vertex.x > bounds.max.x) bounds.max.x = vertex.x;
            if (vertex.x < bounds.min.x) bounds.min.x = vertex.x;
            if (vertex.y > bounds.max.y) bounds.max.y = vertex.y;
            if (vertex.y < bounds.min.y) bounds.min.y = vertex.y;
          }

          if (velocity) {
            if (velocity.x > 0) {
              bounds.max.x += velocity.x;
            } else {
              bounds.min.x += velocity.x;
            }

            if (velocity.y > 0) {
              bounds.max.y += velocity.y;
            } else {
              bounds.min.y += velocity.y;
            }
          }
        };
        /**
         * Returns true if the bounds contains the given point.
         * @method contains
         * @param {bounds} bounds
         * @param {vector} point
         * @return {boolean} True if the bounds contain the point, otherwise false
         */


        Bounds.contains = function (bounds, point) {
          return point.x >= bounds.min.x && point.x <= bounds.max.x && point.y >= bounds.min.y && point.y <= bounds.max.y;
        };
        /**
         * Returns true if the two bounds intersect.
         * @method overlaps
         * @param {bounds} boundsA
         * @param {bounds} boundsB
         * @return {boolean} True if the bounds overlap, otherwise false
         */


        Bounds.overlaps = function (boundsA, boundsB) {
          return boundsA.min.x <= boundsB.max.x && boundsA.max.x >= boundsB.min.x && boundsA.max.y >= boundsB.min.y && boundsA.min.y <= boundsB.max.y;
        };
        /**
         * Translates the bounds by the given vector.
         * @method translate
         * @param {bounds} bounds
         * @param {vector} vector
         */


        Bounds.translate = function (bounds, vector) {
          bounds.min.x += vector.x;
          bounds.max.x += vector.x;
          bounds.min.y += vector.y;
          bounds.max.y += vector.y;
        };
        /**
         * Shifts the bounds to the given position.
         * @method shift
         * @param {bounds} bounds
         * @param {vector} position
         */


        Bounds.shift = function (bounds, position) {
          var deltaX = bounds.max.x - bounds.min.x,
              deltaY = bounds.max.y - bounds.min.y;
          bounds.min.x = position.x;
          bounds.max.x = position.x + deltaX;
          bounds.min.y = position.y;
          bounds.max.y = position.y + deltaY;
        };
      })();
      /***/

    },
    /* 2 */

    /***/
    function (module, exports) {
      /**
      * The `Matter.Vector` module contains methods for creating and manipulating vectors.
      * Vectors are the basis of all the geometry related operations in the engine.
      * A `Matter.Vector` object is of the form `{ x: 0, y: 0 }`.
      *
      * See the included usage [examples](https://github.com/liabru/matter-js/tree/master/examples).
      *
      * @class Vector
      */
      // TODO: consider params for reusing vector objects
      var Vector = {};
      module.exports = Vector;

      (function () {
        /**
         * Creates a new vector.
         * @method create
         * @param {number} x
         * @param {number} y
         * @return {vector} A new vector
         */
        Vector.create = function (x, y) {
          return {
            x: x || 0,
            y: y || 0
          };
        };
        /**
         * Returns a new vector with `x` and `y` copied from the given `vector`.
         * @method clone
         * @param {vector} vector
         * @return {vector} A new cloned vector
         */


        Vector.clone = function (vector) {
          return {
            x: vector.x,
            y: vector.y
          };
        };
        /**
         * Returns the magnitude (length) of a vector.
         * @method magnitude
         * @param {vector} vector
         * @return {number} The magnitude of the vector
         */


        Vector.magnitude = function (vector) {
          return Math.sqrt(vector.x * vector.x + vector.y * vector.y);
        };
        /**
         * Returns the magnitude (length) of a vector (therefore saving a `sqrt` operation).
         * @method magnitudeSquared
         * @param {vector} vector
         * @return {number} The squared magnitude of the vector
         */


        Vector.magnitudeSquared = function (vector) {
          return vector.x * vector.x + vector.y * vector.y;
        };
        /**
         * Rotates the vector about (0, 0) by specified angle.
         * @method rotate
         * @param {vector} vector
         * @param {number} angle
         * @param {vector} [output]
         * @return {vector} The vector rotated about (0, 0)
         */


        Vector.rotate = function (vector, angle, output) {
          var cos = Math.cos(angle),
              sin = Math.sin(angle);
          if (!output) output = {};
          var x = vector.x * cos - vector.y * sin;
          output.y = vector.x * sin + vector.y * cos;
          output.x = x;
          return output;
        };
        /**
         * Rotates the vector about a specified point by specified angle.
         * @method rotateAbout
         * @param {vector} vector
         * @param {number} angle
         * @param {vector} point
         * @param {vector} [output]
         * @return {vector} A new vector rotated about the point
         */


        Vector.rotateAbout = function (vector, angle, point, output) {
          var cos = Math.cos(angle),
              sin = Math.sin(angle);
          if (!output) output = {};
          var x = point.x + ((vector.x - point.x) * cos - (vector.y - point.y) * sin);
          output.y = point.y + ((vector.x - point.x) * sin + (vector.y - point.y) * cos);
          output.x = x;
          return output;
        };
        /**
         * Normalises a vector (such that its magnitude is `1`).
         * @method normalise
         * @param {vector} vector
         * @return {vector} A new vector normalised
         */


        Vector.normalise = function (vector) {
          var magnitude = Vector.magnitude(vector);
          if (magnitude === 0) return {
            x: 0,
            y: 0
          };
          return {
            x: vector.x / magnitude,
            y: vector.y / magnitude
          };
        };
        /**
         * Returns the dot-product of two vectors.
         * @method dot
         * @param {vector} vectorA
         * @param {vector} vectorB
         * @return {number} The dot product of the two vectors
         */


        Vector.dot = function (vectorA, vectorB) {
          return vectorA.x * vectorB.x + vectorA.y * vectorB.y;
        };
        /**
         * Returns the cross-product of two vectors.
         * @method cross
         * @param {vector} vectorA
         * @param {vector} vectorB
         * @return {number} The cross product of the two vectors
         */


        Vector.cross = function (vectorA, vectorB) {
          return vectorA.x * vectorB.y - vectorA.y * vectorB.x;
        };
        /**
         * Returns the cross-product of three vectors.
         * @method cross3
         * @param {vector} vectorA
         * @param {vector} vectorB
         * @param {vector} vectorC
         * @return {number} The cross product of the three vectors
         */


        Vector.cross3 = function (vectorA, vectorB, vectorC) {
          return (vectorB.x - vectorA.x) * (vectorC.y - vectorA.y) - (vectorB.y - vectorA.y) * (vectorC.x - vectorA.x);
        };
        /**
         * Adds the two vectors.
         * @method add
         * @param {vector} vectorA
         * @param {vector} vectorB
         * @param {vector} [output]
         * @return {vector} A new vector of vectorA and vectorB added
         */


        Vector.add = function (vectorA, vectorB, output) {
          if (!output) output = {};
          output.x = vectorA.x + vectorB.x;
          output.y = vectorA.y + vectorB.y;
          return output;
        };
        /**
         * Subtracts the two vectors.
         * @method sub
         * @param {vector} vectorA
         * @param {vector} vectorB
         * @param {vector} [output]
         * @return {vector} A new vector of vectorA and vectorB subtracted
         */


        Vector.sub = function (vectorA, vectorB, output) {
          if (!output) output = {};
          output.x = vectorA.x - vectorB.x;
          output.y = vectorA.y - vectorB.y;
          return output;
        };
        /**
         * Multiplies a vector and a scalar.
         * @method mult
         * @param {vector} vector
         * @param {number} scalar
         * @return {vector} A new vector multiplied by scalar
         */


        Vector.mult = function (vector, scalar) {
          return {
            x: vector.x * scalar,
            y: vector.y * scalar
          };
        };
        /**
         * Divides a vector and a scalar.
         * @method div
         * @param {vector} vector
         * @param {number} scalar
         * @return {vector} A new vector divided by scalar
         */


        Vector.div = function (vector, scalar) {
          return {
            x: vector.x / scalar,
            y: vector.y / scalar
          };
        };
        /**
         * Returns the perpendicular vector. Set `negate` to true for the perpendicular in the opposite direction.
         * @method perp
         * @param {vector} vector
         * @param {bool} [negate=false]
         * @return {vector} The perpendicular vector
         */


        Vector.perp = function (vector, negate) {
          negate = negate === true ? -1 : 1;
          return {
            x: negate * -vector.y,
            y: negate * vector.x
          };
        };
        /**
         * Negates both components of a vector such that it points in the opposite direction.
         * @method neg
         * @param {vector} vector
         * @return {vector} The negated vector
         */


        Vector.neg = function (vector) {
          return {
            x: -vector.x,
            y: -vector.y
          };
        };
        /**
         * Returns the angle between the vector `vectorB - vectorA` and the x-axis in radians.
         * @method angle
         * @param {vector} vectorA
         * @param {vector} vectorB
         * @return {number} The angle in radians
         */


        Vector.angle = function (vectorA, vectorB) {
          return Math.atan2(vectorB.y - vectorA.y, vectorB.x - vectorA.x);
        };
        /**
         * Temporary vector pool (not thread-safe).
         * @property _temp
         * @type {vector[]}
         * @private
         */


        Vector._temp = [Vector.create(), Vector.create(), Vector.create(), Vector.create(), Vector.create(), Vector.create()];
      })();
      /***/

    },
    /* 3 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * The `Matter.Vertices` module contains methods for creating and manipulating sets of vertices.
      * A set of vertices is an array of `Matter.Vector` with additional indexing properties inserted by `Vertices.create`.
      * A `Matter.Body` maintains a set of vertices to represent the shape of the object (its convex hull).
      *
      * See the included usage [examples](https://github.com/liabru/matter-js/tree/master/examples).
      *
      * @class Vertices
      */
      var Vertices = {};
      module.exports = Vertices;

      var Vector = __webpack_require__(2);

      var Common = __webpack_require__(0);

      (function () {
        /**
         * Creates a new set of `Matter.Body` compatible vertices.
         * The `points` argument accepts an array of `Matter.Vector` points orientated around the origin `(0, 0)`, for example:
         *
         *     [{ x: 0, y: 0 }, { x: 25, y: 50 }, { x: 50, y: 0 }]
         *
         * The `Vertices.create` method returns a new array of vertices, which are similar to Matter.Vector objects,
         * but with some additional references required for efficient collision detection routines.
         *
         * Vertices must be specified in clockwise order.
         *
         * Note that the `body` argument is not optional, a `Matter.Body` reference must be provided.
         *
         * @method create
         * @param {vector[]} points
         * @param {body} body
         */
        Vertices.create = function (points, body) {
          var vertices = [];

          for (var i = 0; i < points.length; i++) {
            var point = points[i],
                vertex = {
              x: point.x,
              y: point.y,
              index: i,
              body: body,
              isInternal: false
            };
            vertices.push(vertex);
          }

          return vertices;
        };
        /**
         * Parses a string containing ordered x y pairs separated by spaces (and optionally commas), 
         * into a `Matter.Vertices` object for the given `Matter.Body`.
         * For parsing SVG paths, see `Svg.pathToVertices`.
         * @method fromPath
         * @param {string} path
         * @param {body} body
         * @return {vertices} vertices
         */


        Vertices.fromPath = function (path, body) {
          var pathPattern = /L?\s*([-\d.e]+)[\s,]*([-\d.e]+)*/ig,
              points = [];
          path.replace(pathPattern, function (match, x, y) {
            points.push({
              x: parseFloat(x),
              y: parseFloat(y)
            });
          });
          return Vertices.create(points, body);
        };
        /**
         * Returns the centre (centroid) of the set of vertices.
         * @method centre
         * @param {vertices} vertices
         * @return {vector} The centre point
         */


        Vertices.centre = function (vertices) {
          var area = Vertices.area(vertices, true),
              centre = {
            x: 0,
            y: 0
          },
              cross,
              temp,
              j;

          for (var i = 0; i < vertices.length; i++) {
            j = (i + 1) % vertices.length;
            cross = Vector.cross(vertices[i], vertices[j]);
            temp = Vector.mult(Vector.add(vertices[i], vertices[j]), cross);
            centre = Vector.add(centre, temp);
          }

          return Vector.div(centre, 6 * area);
        };
        /**
         * Returns the average (mean) of the set of vertices.
         * @method mean
         * @param {vertices} vertices
         * @return {vector} The average point
         */


        Vertices.mean = function (vertices) {
          var average = {
            x: 0,
            y: 0
          };

          for (var i = 0; i < vertices.length; i++) {
            average.x += vertices[i].x;
            average.y += vertices[i].y;
          }

          return Vector.div(average, vertices.length);
        };
        /**
         * Returns the area of the set of vertices.
         * @method area
         * @param {vertices} vertices
         * @param {bool} signed
         * @return {number} The area
         */


        Vertices.area = function (vertices, signed) {
          var area = 0,
              j = vertices.length - 1;

          for (var i = 0; i < vertices.length; i++) {
            area += (vertices[j].x - vertices[i].x) * (vertices[j].y + vertices[i].y);
            j = i;
          }

          if (signed) return area / 2;
          return Math.abs(area) / 2;
        };
        /**
         * Returns the moment of inertia (second moment of area) of the set of vertices given the total mass.
         * @method inertia
         * @param {vertices} vertices
         * @param {number} mass
         * @return {number} The polygon's moment of inertia
         */


        Vertices.inertia = function (vertices, mass) {
          var numerator = 0,
              denominator = 0,
              v = vertices,
              cross,
              j; // find the polygon's moment of inertia, using second moment of area
          // from equations at http://www.physicsforums.com/showthread.php?t=25293

          for (var n = 0; n < v.length; n++) {
            j = (n + 1) % v.length;
            cross = Math.abs(Vector.cross(v[j], v[n]));
            numerator += cross * (Vector.dot(v[j], v[j]) + Vector.dot(v[j], v[n]) + Vector.dot(v[n], v[n]));
            denominator += cross;
          }

          return mass / 6 * (numerator / denominator);
        };
        /**
         * Translates the set of vertices in-place.
         * @method translate
         * @param {vertices} vertices
         * @param {vector} vector
         * @param {number} scalar
         */


        Vertices.translate = function (vertices, vector, scalar) {
          var i;

          if (scalar) {
            for (i = 0; i < vertices.length; i++) {
              vertices[i].x += vector.x * scalar;
              vertices[i].y += vector.y * scalar;
            }
          } else {
            for (i = 0; i < vertices.length; i++) {
              vertices[i].x += vector.x;
              vertices[i].y += vector.y;
            }
          }

          return vertices;
        };
        /**
         * Rotates the set of vertices in-place.
         * @method rotate
         * @param {vertices} vertices
         * @param {number} angle
         * @param {vector} point
         */


        Vertices.rotate = function (vertices, angle, point) {
          if (angle === 0) return;
          var cos = Math.cos(angle),
              sin = Math.sin(angle);

          for (var i = 0; i < vertices.length; i++) {
            var vertice = vertices[i],
                dx = vertice.x - point.x,
                dy = vertice.y - point.y;
            vertice.x = point.x + (dx * cos - dy * sin);
            vertice.y = point.y + (dx * sin + dy * cos);
          }

          return vertices;
        };
        /**
         * Returns `true` if the `point` is inside the set of `vertices`.
         * @method contains
         * @param {vertices} vertices
         * @param {vector} point
         * @return {boolean} True if the vertices contains point, otherwise false
         */


        Vertices.contains = function (vertices, point) {
          for (var i = 0; i < vertices.length; i++) {
            var vertice = vertices[i],
                nextVertice = vertices[(i + 1) % vertices.length];

            if ((point.x - vertice.x) * (nextVertice.y - vertice.y) + (point.y - vertice.y) * (vertice.x - nextVertice.x) > 0) {
              return false;
            }
          }

          return true;
        };
        /**
         * Scales the vertices from a point (default is centre) in-place.
         * @method scale
         * @param {vertices} vertices
         * @param {number} scaleX
         * @param {number} scaleY
         * @param {vector} point
         */


        Vertices.scale = function (vertices, scaleX, scaleY, point) {
          if (scaleX === 1 && scaleY === 1) return vertices;
          point = point || Vertices.centre(vertices);
          var vertex, delta;

          for (var i = 0; i < vertices.length; i++) {
            vertex = vertices[i];
            delta = Vector.sub(vertex, point);
            vertices[i].x = point.x + delta.x * scaleX;
            vertices[i].y = point.y + delta.y * scaleY;
          }

          return vertices;
        };
        /**
         * Chamfers a set of vertices by giving them rounded corners, returns a new set of vertices.
         * The radius parameter is a single number or an array to specify the radius for each vertex.
         * @method chamfer
         * @param {vertices} vertices
         * @param {number[]} radius
         * @param {number} quality
         * @param {number} qualityMin
         * @param {number} qualityMax
         */


        Vertices.chamfer = function (vertices, radius, quality, qualityMin, qualityMax) {
          if (typeof radius === 'number') {
            radius = [radius];
          } else {
            radius = radius || [8];
          } // quality defaults to -1, which is auto


          quality = typeof quality !== 'undefined' ? quality : -1;
          qualityMin = qualityMin || 2;
          qualityMax = qualityMax || 14;
          var newVertices = [];

          for (var i = 0; i < vertices.length; i++) {
            var prevVertex = vertices[i - 1 >= 0 ? i - 1 : vertices.length - 1],
                vertex = vertices[i],
                nextVertex = vertices[(i + 1) % vertices.length],
                currentRadius = radius[i < radius.length ? i : radius.length - 1];

            if (currentRadius === 0) {
              newVertices.push(vertex);
              continue;
            }

            var prevNormal = Vector.normalise({
              x: vertex.y - prevVertex.y,
              y: prevVertex.x - vertex.x
            });
            var nextNormal = Vector.normalise({
              x: nextVertex.y - vertex.y,
              y: vertex.x - nextVertex.x
            });
            var diagonalRadius = Math.sqrt(2 * Math.pow(currentRadius, 2)),
                radiusVector = Vector.mult(Common.clone(prevNormal), currentRadius),
                midNormal = Vector.normalise(Vector.mult(Vector.add(prevNormal, nextNormal), 0.5)),
                scaledVertex = Vector.sub(vertex, Vector.mult(midNormal, diagonalRadius));
            var precision = quality;

            if (quality === -1) {
              // automatically decide precision
              precision = Math.pow(currentRadius, 0.32) * 1.75;
            }

            precision = Common.clamp(precision, qualityMin, qualityMax); // use an even value for precision, more likely to reduce axes by using symmetry

            if (precision % 2 === 1) precision += 1;
            var alpha = Math.acos(Vector.dot(prevNormal, nextNormal)),
                theta = alpha / precision;

            for (var j = 0; j < precision; j++) {
              newVertices.push(Vector.add(Vector.rotate(radiusVector, theta * j), scaledVertex));
            }
          }

          return newVertices;
        };
        /**
         * Sorts the input vertices into clockwise order in place.
         * @method clockwiseSort
         * @param {vertices} vertices
         * @return {vertices} vertices
         */


        Vertices.clockwiseSort = function (vertices) {
          var centre = Vertices.mean(vertices);
          vertices.sort(function (vertexA, vertexB) {
            return Vector.angle(centre, vertexA) - Vector.angle(centre, vertexB);
          });
          return vertices;
        };
        /**
         * Returns true if the vertices form a convex shape (vertices must be in clockwise order).
         * @method isConvex
         * @param {vertices} vertices
         * @return {bool} `true` if the `vertices` are convex, `false` if not (or `null` if not computable).
         */


        Vertices.isConvex = function (vertices) {
          // http://paulbourke.net/geometry/polygonmesh/
          // Copyright (c) Paul Bourke (use permitted)
          var flag = 0,
              n = vertices.length,
              i,
              j,
              k,
              z;
          if (n < 3) return null;

          for (i = 0; i < n; i++) {
            j = (i + 1) % n;
            k = (i + 2) % n;
            z = (vertices[j].x - vertices[i].x) * (vertices[k].y - vertices[j].y);
            z -= (vertices[j].y - vertices[i].y) * (vertices[k].x - vertices[j].x);

            if (z < 0) {
              flag |= 1;
            } else if (z > 0) {
              flag |= 2;
            }

            if (flag === 3) {
              return false;
            }
          }

          if (flag !== 0) {
            return true;
          } else {
            return null;
          }
        };
        /**
         * Returns the convex hull of the input vertices as a new array of points.
         * @method hull
         * @param {vertices} vertices
         * @return [vertex] vertices
         */


        Vertices.hull = function (vertices) {
          // http://geomalgorithms.com/a10-_hull-1.html
          var upper = [],
              lower = [],
              vertex,
              i; // sort vertices on x-axis (y-axis for ties)

          vertices = vertices.slice(0);
          vertices.sort(function (vertexA, vertexB) {
            var dx = vertexA.x - vertexB.x;
            return dx !== 0 ? dx : vertexA.y - vertexB.y;
          }); // build lower hull

          for (i = 0; i < vertices.length; i += 1) {
            vertex = vertices[i];

            while (lower.length >= 2 && Vector.cross3(lower[lower.length - 2], lower[lower.length - 1], vertex) <= 0) {
              lower.pop();
            }

            lower.push(vertex);
          } // build upper hull


          for (i = vertices.length - 1; i >= 0; i -= 1) {
            vertex = vertices[i];

            while (upper.length >= 2 && Vector.cross3(upper[upper.length - 2], upper[upper.length - 1], vertex) <= 0) {
              upper.pop();
            }

            upper.push(vertex);
          } // concatenation of the lower and upper hulls gives the convex hull
          // omit last points because they are repeated at the beginning of the other list


          upper.pop();
          lower.pop();
          return upper.concat(lower);
        };
      })();
      /***/

    },
    /* 4 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * The `Matter.Events` module contains methods to fire and listen to events on other objects.
      *
      * See the included usage [examples](https://github.com/liabru/matter-js/tree/master/examples).
      *
      * @class Events
      */
      var Events = {};
      module.exports = Events;

      var Common = __webpack_require__(0);

      (function () {
        /**
         * Subscribes a callback function to the given object's `eventName`.
         * @method on
         * @param {} object
         * @param {string} eventNames
         * @param {function} callback
         */
        Events.on = function (object, eventNames, callback) {
          var names = eventNames.split(' '),
              name;

          for (var i = 0; i < names.length; i++) {
            name = names[i];
            object.events = object.events || {};
            object.events[name] = object.events[name] || [];
            object.events[name].push(callback);
          }

          return callback;
        };
        /**
         * Removes the given event callback. If no callback, clears all callbacks in `eventNames`. If no `eventNames`, clears all events.
         * @method off
         * @param {} object
         * @param {string} eventNames
         * @param {function} callback
         */


        Events.off = function (object, eventNames, callback) {
          if (!eventNames) {
            object.events = {};
            return;
          } // handle Events.off(object, callback)


          if (typeof eventNames === 'function') {
            callback = eventNames;
            eventNames = Common.keys(object.events).join(' ');
          }

          var names = eventNames.split(' ');

          for (var i = 0; i < names.length; i++) {
            var callbacks = object.events[names[i]],
                newCallbacks = [];

            if (callback && callbacks) {
              for (var j = 0; j < callbacks.length; j++) {
                if (callbacks[j] !== callback) newCallbacks.push(callbacks[j]);
              }
            }

            object.events[names[i]] = newCallbacks;
          }
        };
        /**
         * Fires all the callbacks subscribed to the given object's `eventName`, in the order they subscribed, if any.
         * @method trigger
         * @param {} object
         * @param {string} eventNames
         * @param {} event
         */


        Events.trigger = function (object, eventNames, event) {
          var names, name, callbacks, eventClone;
          var events = object.events;

          if (events && Common.keys(events).length > 0) {
            if (!event) event = {};
            names = eventNames.split(' ');

            for (var i = 0; i < names.length; i++) {
              name = names[i];
              callbacks = events[name];

              if (callbacks) {
                eventClone = Common.clone(event, false);
                eventClone.name = name;
                eventClone.source = object;

                for (var j = 0; j < callbacks.length; j++) {
                  callbacks[j].apply(object, [eventClone]);
                }
              }
            }
          }
        };
      })();
      /***/

    },
    /* 5 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * A composite is a collection of `Matter.Body`, `Matter.Constraint` and other `Matter.Composite` objects.
      *
      * They are a container that can represent complex objects made of multiple parts, even if they are not physically connected.
      * A composite could contain anything from a single body all the way up to a whole world.
      * 
      * When making any changes to composites, use the included functions rather than changing their properties directly.
      *
      * See the included usage [examples](https://github.com/liabru/matter-js/tree/master/examples).
      *
      * @class Composite
      */
      var Composite = {};
      module.exports = Composite;

      var Events = __webpack_require__(4);

      var Common = __webpack_require__(0);

      var Bounds = __webpack_require__(1);

      var Body = __webpack_require__(6);

      (function () {
        /**
         * Creates a new composite. The options parameter is an object that specifies any properties you wish to override the defaults.
         * See the properites section below for detailed information on what you can pass via the `options` object.
         * @method create
         * @param {} [options]
         * @return {composite} A new composite
         */
        Composite.create = function (options) {
          return Common.extend({
            id: Common.nextId(),
            type: 'composite',
            parent: null,
            isModified: false,
            bodies: [],
            constraints: [],
            composites: [],
            label: 'Composite',
            plugin: {}
          }, options);
        };
        /**
         * Sets the composite's `isModified` flag. 
         * If `updateParents` is true, all parents will be set (default: false).
         * If `updateChildren` is true, all children will be set (default: false).
         * @method setModified
         * @param {composite} composite
         * @param {boolean} isModified
         * @param {boolean} [updateParents=false]
         * @param {boolean} [updateChildren=false]
         */


        Composite.setModified = function (composite, isModified, updateParents, updateChildren) {
          composite.isModified = isModified;

          if (updateParents && composite.parent) {
            Composite.setModified(composite.parent, isModified, updateParents, updateChildren);
          }

          if (updateChildren) {
            for (var i = 0; i < composite.composites.length; i++) {
              var childComposite = composite.composites[i];
              Composite.setModified(childComposite, isModified, updateParents, updateChildren);
            }
          }
        };
        /**
         * Generic single or multi-add function. Adds a single or an array of body(s), constraint(s) or composite(s) to the given composite.
         * Triggers `beforeAdd` and `afterAdd` events on the `composite`.
         * @method add
         * @param {composite} composite
         * @param {object|array} object A single or an array of body(s), constraint(s) or composite(s)
         * @return {composite} The original composite with the objects added
         */


        Composite.add = function (composite, object) {
          var objects = [].concat(object);
          Events.trigger(composite, 'beforeAdd', {
            object: object
          });

          for (var i = 0; i < objects.length; i++) {
            var obj = objects[i];

            switch (obj.type) {
              case 'body':
                // skip adding compound parts
                if (obj.parent !== obj) {
                  Common.warn('Composite.add: skipped adding a compound body part (you must add its parent instead)');
                  break;
                }

                Composite.addBody(composite, obj);
                break;

              case 'constraint':
                Composite.addConstraint(composite, obj);
                break;

              case 'composite':
                Composite.addComposite(composite, obj);
                break;

              case 'mouseConstraint':
                Composite.addConstraint(composite, obj.constraint);
                break;
            }
          }

          Events.trigger(composite, 'afterAdd', {
            object: object
          });
          return composite;
        };
        /**
         * Generic remove function. Removes one or many body(s), constraint(s) or a composite(s) to the given composite.
         * Optionally searching its children recursively.
         * Triggers `beforeRemove` and `afterRemove` events on the `composite`.
         * @method remove
         * @param {composite} composite
         * @param {object|array} object
         * @param {boolean} [deep=false]
         * @return {composite} The original composite with the objects removed
         */


        Composite.remove = function (composite, object, deep) {
          var objects = [].concat(object);
          Events.trigger(composite, 'beforeRemove', {
            object: object
          });

          for (var i = 0; i < objects.length; i++) {
            var obj = objects[i];

            switch (obj.type) {
              case 'body':
                Composite.removeBody(composite, obj, deep);
                break;

              case 'constraint':
                Composite.removeConstraint(composite, obj, deep);
                break;

              case 'composite':
                Composite.removeComposite(composite, obj, deep);
                break;

              case 'mouseConstraint':
                Composite.removeConstraint(composite, obj.constraint);
                break;
            }
          }

          Events.trigger(composite, 'afterRemove', {
            object: object
          });
          return composite;
        };
        /**
         * Adds a composite to the given composite.
         * @private
         * @method addComposite
         * @param {composite} compositeA
         * @param {composite} compositeB
         * @return {composite} The original compositeA with the objects from compositeB added
         */


        Composite.addComposite = function (compositeA, compositeB) {
          compositeA.composites.push(compositeB);
          compositeB.parent = compositeA;
          Composite.setModified(compositeA, true, true, false);
          return compositeA;
        };
        /**
         * Removes a composite from the given composite, and optionally searching its children recursively.
         * @private
         * @method removeComposite
         * @param {composite} compositeA
         * @param {composite} compositeB
         * @param {boolean} [deep=false]
         * @return {composite} The original compositeA with the composite removed
         */


        Composite.removeComposite = function (compositeA, compositeB, deep) {
          var position = Common.indexOf(compositeA.composites, compositeB);

          if (position !== -1) {
            Composite.removeCompositeAt(compositeA, position);
            Composite.setModified(compositeA, true, true, false);
          }

          if (deep) {
            for (var i = 0; i < compositeA.composites.length; i++) {
              Composite.removeComposite(compositeA.composites[i], compositeB, true);
            }
          }

          return compositeA;
        };
        /**
         * Removes a composite from the given composite.
         * @private
         * @method removeCompositeAt
         * @param {composite} composite
         * @param {number} position
         * @return {composite} The original composite with the composite removed
         */


        Composite.removeCompositeAt = function (composite, position) {
          composite.composites.splice(position, 1);
          Composite.setModified(composite, true, true, false);
          return composite;
        };
        /**
         * Adds a body to the given composite.
         * @private
         * @method addBody
         * @param {composite} composite
         * @param {body} body
         * @return {composite} The original composite with the body added
         */


        Composite.addBody = function (composite, body) {
          composite.bodies.push(body);
          Composite.setModified(composite, true, true, false);
          return composite;
        };
        /**
         * Removes a body from the given composite, and optionally searching its children recursively.
         * @private
         * @method removeBody
         * @param {composite} composite
         * @param {body} body
         * @param {boolean} [deep=false]
         * @return {composite} The original composite with the body removed
         */


        Composite.removeBody = function (composite, body, deep) {
          var position = Common.indexOf(composite.bodies, body);

          if (position !== -1) {
            Composite.removeBodyAt(composite, position);
            Composite.setModified(composite, true, true, false);
          }

          if (deep) {
            for (var i = 0; i < composite.composites.length; i++) {
              Composite.removeBody(composite.composites[i], body, true);
            }
          }

          return composite;
        };
        /**
         * Removes a body from the given composite.
         * @private
         * @method removeBodyAt
         * @param {composite} composite
         * @param {number} position
         * @return {composite} The original composite with the body removed
         */


        Composite.removeBodyAt = function (composite, position) {
          composite.bodies.splice(position, 1);
          Composite.setModified(composite, true, true, false);
          return composite;
        };
        /**
         * Adds a constraint to the given composite.
         * @private
         * @method addConstraint
         * @param {composite} composite
         * @param {constraint} constraint
         * @return {composite} The original composite with the constraint added
         */


        Composite.addConstraint = function (composite, constraint) {
          composite.constraints.push(constraint);
          Composite.setModified(composite, true, true, false);
          return composite;
        };
        /**
         * Removes a constraint from the given composite, and optionally searching its children recursively.
         * @private
         * @method removeConstraint
         * @param {composite} composite
         * @param {constraint} constraint
         * @param {boolean} [deep=false]
         * @return {composite} The original composite with the constraint removed
         */


        Composite.removeConstraint = function (composite, constraint, deep) {
          var position = Common.indexOf(composite.constraints, constraint);

          if (position !== -1) {
            Composite.removeConstraintAt(composite, position);
          }

          if (deep) {
            for (var i = 0; i < composite.composites.length; i++) {
              Composite.removeConstraint(composite.composites[i], constraint, true);
            }
          }

          return composite;
        };
        /**
         * Removes a body from the given composite.
         * @private
         * @method removeConstraintAt
         * @param {composite} composite
         * @param {number} position
         * @return {composite} The original composite with the constraint removed
         */


        Composite.removeConstraintAt = function (composite, position) {
          composite.constraints.splice(position, 1);
          Composite.setModified(composite, true, true, false);
          return composite;
        };
        /**
         * Removes all bodies, constraints and composites from the given composite.
         * Optionally clearing its children recursively.
         * @method clear
         * @param {composite} composite
         * @param {boolean} keepStatic
         * @param {boolean} [deep=false]
         */


        Composite.clear = function (composite, keepStatic, deep) {
          if (deep) {
            for (var i = 0; i < composite.composites.length; i++) {
              Composite.clear(composite.composites[i], keepStatic, true);
            }
          }

          if (keepStatic) {
            composite.bodies = composite.bodies.filter(function (body) {
              return body.isStatic;
            });
          } else {
            composite.bodies.length = 0;
          }

          composite.constraints.length = 0;
          composite.composites.length = 0;
          Composite.setModified(composite, true, true, false);
          return composite;
        };
        /**
         * Returns all bodies in the given composite, including all bodies in its children, recursively.
         * @method allBodies
         * @param {composite} composite
         * @return {body[]} All the bodies
         */


        Composite.allBodies = function (composite) {
          var bodies = [].concat(composite.bodies);

          for (var i = 0; i < composite.composites.length; i++) {
            bodies = bodies.concat(Composite.allBodies(composite.composites[i]));
          }

          return bodies;
        };
        /**
         * Returns all constraints in the given composite, including all constraints in its children, recursively.
         * @method allConstraints
         * @param {composite} composite
         * @return {constraint[]} All the constraints
         */


        Composite.allConstraints = function (composite) {
          var constraints = [].concat(composite.constraints);

          for (var i = 0; i < composite.composites.length; i++) {
            constraints = constraints.concat(Composite.allConstraints(composite.composites[i]));
          }

          return constraints;
        };
        /**
         * Returns all composites in the given composite, including all composites in its children, recursively.
         * @method allComposites
         * @param {composite} composite
         * @return {composite[]} All the composites
         */


        Composite.allComposites = function (composite) {
          var composites = [].concat(composite.composites);

          for (var i = 0; i < composite.composites.length; i++) {
            composites = composites.concat(Composite.allComposites(composite.composites[i]));
          }

          return composites;
        };
        /**
         * Searches the composite recursively for an object matching the type and id supplied, null if not found.
         * @method get
         * @param {composite} composite
         * @param {number} id
         * @param {string} type
         * @return {object} The requested object, if found
         */


        Composite.get = function (composite, id, type) {
          var objects, object;

          switch (type) {
            case 'body':
              objects = Composite.allBodies(composite);
              break;

            case 'constraint':
              objects = Composite.allConstraints(composite);
              break;

            case 'composite':
              objects = Composite.allComposites(composite).concat(composite);
              break;
          }

          if (!objects) return null;
          object = objects.filter(function (object) {
            return object.id.toString() === id.toString();
          });
          return object.length === 0 ? null : object[0];
        };
        /**
         * Moves the given object(s) from compositeA to compositeB (equal to a remove followed by an add).
         * @method move
         * @param {compositeA} compositeA
         * @param {object[]} objects
         * @param {compositeB} compositeB
         * @return {composite} Returns compositeA
         */


        Composite.move = function (compositeA, objects, compositeB) {
          Composite.remove(compositeA, objects);
          Composite.add(compositeB, objects);
          return compositeA;
        };
        /**
         * Assigns new ids for all objects in the composite, recursively.
         * @method rebase
         * @param {composite} composite
         * @return {composite} Returns composite
         */


        Composite.rebase = function (composite) {
          var objects = Composite.allBodies(composite).concat(Composite.allConstraints(composite)).concat(Composite.allComposites(composite));

          for (var i = 0; i < objects.length; i++) {
            objects[i].id = Common.nextId();
          }

          Composite.setModified(composite, true, true, false);
          return composite;
        };
        /**
         * Translates all children in the composite by a given vector relative to their current positions, 
         * without imparting any velocity.
         * @method translate
         * @param {composite} composite
         * @param {vector} translation
         * @param {bool} [recursive=true]
         */


        Composite.translate = function (composite, translation, recursive) {
          var bodies = recursive ? Composite.allBodies(composite) : composite.bodies;

          for (var i = 0; i < bodies.length; i++) {
            Body.translate(bodies[i], translation);
          }

          Composite.setModified(composite, true, true, false);
          return composite;
        };
        /**
         * Rotates all children in the composite by a given angle about the given point, without imparting any angular velocity.
         * @method rotate
         * @param {composite} composite
         * @param {number} rotation
         * @param {vector} point
         * @param {bool} [recursive=true]
         */


        Composite.rotate = function (composite, rotation, point, recursive) {
          var cos = Math.cos(rotation),
              sin = Math.sin(rotation),
              bodies = recursive ? Composite.allBodies(composite) : composite.bodies;

          for (var i = 0; i < bodies.length; i++) {
            var body = bodies[i],
                dx = body.position.x - point.x,
                dy = body.position.y - point.y;
            Body.setPosition(body, {
              x: point.x + (dx * cos - dy * sin),
              y: point.y + (dx * sin + dy * cos)
            });
            Body.rotate(body, rotation);
          }

          Composite.setModified(composite, true, true, false);
          return composite;
        };
        /**
         * Scales all children in the composite, including updating physical properties (mass, area, axes, inertia), from a world-space point.
         * @method scale
         * @param {composite} composite
         * @param {number} scaleX
         * @param {number} scaleY
         * @param {vector} point
         * @param {bool} [recursive=true]
         */


        Composite.scale = function (composite, scaleX, scaleY, point, recursive) {
          var bodies = recursive ? Composite.allBodies(composite) : composite.bodies;

          for (var i = 0; i < bodies.length; i++) {
            var body = bodies[i],
                dx = body.position.x - point.x,
                dy = body.position.y - point.y;
            Body.setPosition(body, {
              x: point.x + dx * scaleX,
              y: point.y + dy * scaleY
            });
            Body.scale(body, scaleX, scaleY);
          }

          Composite.setModified(composite, true, true, false);
          return composite;
        };
        /**
         * Returns the union of the bounds of all of the composite's bodies.
         * @method bounds
         * @param {composite} composite The composite.
         * @returns {bounds} The composite bounds.
         */


        Composite.bounds = function (composite) {
          var bodies = Composite.allBodies(composite),
              vertices = [];

          for (var i = 0; i < bodies.length; i += 1) {
            var body = bodies[i];
            vertices.push(body.bounds.min, body.bounds.max);
          }

          return Bounds.create(vertices);
        };
        /*
        *
        *  Events Documentation
        *
        */

        /**
        * Fired when a call to `Composite.add` is made, before objects have been added.
        *
        * @event beforeAdd
        * @param {} event An event object
        * @param {} event.object The object(s) to be added (may be a single body, constraint, composite or a mixed array of these)
        * @param {} event.source The source object of the event
        * @param {} event.name The name of the event
        */

        /**
        * Fired when a call to `Composite.add` is made, after objects have been added.
        *
        * @event afterAdd
        * @param {} event An event object
        * @param {} event.object The object(s) that have been added (may be a single body, constraint, composite or a mixed array of these)
        * @param {} event.source The source object of the event
        * @param {} event.name The name of the event
        */

        /**
        * Fired when a call to `Composite.remove` is made, before objects have been removed.
        *
        * @event beforeRemove
        * @param {} event An event object
        * @param {} event.object The object(s) to be removed (may be a single body, constraint, composite or a mixed array of these)
        * @param {} event.source The source object of the event
        * @param {} event.name The name of the event
        */

        /**
        * Fired when a call to `Composite.remove` is made, after objects have been removed.
        *
        * @event afterRemove
        * @param {} event An event object
        * @param {} event.object The object(s) that have been removed (may be a single body, constraint, composite or a mixed array of these)
        * @param {} event.source The source object of the event
        * @param {} event.name The name of the event
        */

        /*
        *
        *  Properties Documentation
        *
        */

        /**
         * An integer `Number` uniquely identifying number generated in `Composite.create` by `Common.nextId`.
         *
         * @property id
         * @type number
         */

        /**
         * A `String` denoting the type of object.
         *
         * @property type
         * @type string
         * @default "composite"
         * @readOnly
         */

        /**
         * An arbitrary `String` name to help the user identify and manage composites.
         *
         * @property label
         * @type string
         * @default "Composite"
         */

        /**
         * A flag that specifies whether the composite has been modified during the current step.
         * Most `Matter.Composite` methods will automatically set this flag to `true` to inform the engine of changes to be handled.
         * If you need to change it manually, you should use the `Composite.setModified` method.
         *
         * @property isModified
         * @type boolean
         * @default false
         */

        /**
         * The `Composite` that is the parent of this composite. It is automatically managed by the `Matter.Composite` methods.
         *
         * @property parent
         * @type composite
         * @default null
         */

        /**
         * An array of `Body` that are _direct_ children of this composite.
         * To add or remove bodies you should use `Composite.add` and `Composite.remove` methods rather than directly modifying this property.
         * If you wish to recursively find all descendants, you should use the `Composite.allBodies` method.
         *
         * @property bodies
         * @type body[]
         * @default []
         */

        /**
         * An array of `Constraint` that are _direct_ children of this composite.
         * To add or remove constraints you should use `Composite.add` and `Composite.remove` methods rather than directly modifying this property.
         * If you wish to recursively find all descendants, you should use the `Composite.allConstraints` method.
         *
         * @property constraints
         * @type constraint[]
         * @default []
         */

        /**
         * An array of `Composite` that are _direct_ children of this composite.
         * To add or remove composites you should use `Composite.add` and `Composite.remove` methods rather than directly modifying this property.
         * If you wish to recursively find all descendants, you should use the `Composite.allComposites` method.
         *
         * @property composites
         * @type composite[]
         * @default []
         */

        /**
         * An object reserved for storing plugin-specific properties.
         *
         * @property plugin
         * @type {}
         */

      })();
      /***/

    },
    /* 6 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * The `Matter.Body` module contains methods for creating and manipulating body models.
      * A `Matter.Body` is a rigid body that can be simulated by a `Matter.Engine`.
      * Factories for commonly used body configurations (such as rectangles, circles and other polygons) can be found in the module `Matter.Bodies`.
      *
      * See the included usage [examples](https://github.com/liabru/matter-js/tree/master/examples).
      
      * @class Body
      */
      var Body = {};
      module.exports = Body;

      var Vertices = __webpack_require__(3);

      var Vector = __webpack_require__(2);

      var Sleeping = __webpack_require__(7);

      var Render = __webpack_require__(16);

      var Common = __webpack_require__(0);

      var Bounds = __webpack_require__(1);

      var Axes = __webpack_require__(10);

      (function () {
        Body._inertiaScale = 4;
        Body._nextCollidingGroupId = 1;
        Body._nextNonCollidingGroupId = -1;
        Body._nextCategory = 0x0001;
        /**
         * Creates a new rigid body model. The options parameter is an object that specifies any properties you wish to override the defaults.
         * All properties have default values, and many are pre-calculated automatically based on other properties.
         * Vertices must be specified in clockwise order.
         * See the properties section below for detailed information on what you can pass via the `options` object.
         * @method create
         * @param {} options
         * @return {body} body
         */

        Body.create = function (options) {
          var defaults = {
            id: Common.nextId(),
            type: 'body',
            label: 'Body',
            parts: [],
            plugin: {},
            angle: 0,
            vertices: Vertices.fromPath('L 0 0 L 40 0 L 40 40 L 0 40'),
            position: {
              x: 0,
              y: 0
            },
            force: {
              x: 0,
              y: 0
            },
            torque: 0,
            positionImpulse: {
              x: 0,
              y: 0
            },
            constraintImpulse: {
              x: 0,
              y: 0,
              angle: 0
            },
            totalContacts: 0,
            speed: 0,
            angularSpeed: 0,
            velocity: {
              x: 0,
              y: 0
            },
            angularVelocity: 0,
            isSensor: false,
            isStatic: false,
            isSleeping: false,
            motion: 0,
            sleepThreshold: 60,
            density: 0.001,
            restitution: 0,
            friction: 0.1,
            frictionStatic: 0.5,
            frictionAir: 0.01,
            collisionFilter: {
              category: 0x0001,
              mask: 0xFFFFFFFF,
              group: 0
            },
            slop: 0.05,
            timeScale: 1,
            render: {
              visible: true,
              opacity: 1,
              strokeStyle: null,
              fillStyle: null,
              lineWidth: null,
              sprite: {
                xScale: 1,
                yScale: 1,
                xOffset: 0,
                yOffset: 0
              }
            },
            events: null,
            bounds: null,
            chamfer: null,
            circleRadius: 0,
            positionPrev: null,
            anglePrev: 0,
            parent: null,
            axes: null,
            area: 0,
            mass: 0,
            inertia: 0,
            _original: null
          };
          var body = Common.extend(defaults, options);

          _initProperties(body, options);

          return body;
        };
        /**
         * Returns the next unique group index for which bodies will collide.
         * If `isNonColliding` is `true`, returns the next unique group index for which bodies will _not_ collide.
         * See `body.collisionFilter` for more information.
         * @method nextGroup
         * @param {bool} [isNonColliding=false]
         * @return {Number} Unique group index
         */


        Body.nextGroup = function (isNonColliding) {
          if (isNonColliding) return Body._nextNonCollidingGroupId--;
          return Body._nextCollidingGroupId++;
        };
        /**
         * Returns the next unique category bitfield (starting after the initial default category `0x0001`).
         * There are 32 available. See `body.collisionFilter` for more information.
         * @method nextCategory
         * @return {Number} Unique category bitfield
         */


        Body.nextCategory = function () {
          Body._nextCategory = Body._nextCategory << 1;
          return Body._nextCategory;
        };
        /**
         * Initialises body properties.
         * @method _initProperties
         * @private
         * @param {body} body
         * @param {} [options]
         */


        var _initProperties = function _initProperties(body, options) {
          options = options || {}; // init required properties (order is important)

          Body.set(body, {
            bounds: body.bounds || Bounds.create(body.vertices),
            positionPrev: body.positionPrev || Vector.clone(body.position),
            anglePrev: body.anglePrev || body.angle,
            vertices: body.vertices,
            parts: body.parts || [body],
            isStatic: body.isStatic,
            isSleeping: body.isSleeping,
            parent: body.parent || body
          });
          Vertices.rotate(body.vertices, body.angle, body.position);
          Axes.rotate(body.axes, body.angle);
          Bounds.update(body.bounds, body.vertices, body.velocity); // allow options to override the automatically calculated properties

          Body.set(body, {
            axes: options.axes || body.axes,
            area: options.area || body.area,
            mass: options.mass || body.mass,
            inertia: options.inertia || body.inertia
          }); // render properties

          var defaultFillStyle = body.isStatic ? '#14151f' : Common.choose(['#f19648', '#f5d259', '#f55a3c', '#063e7b', '#ececd1']),
              defaultStrokeStyle = body.isStatic ? '#555' : '#ccc',
              defaultLineWidth = body.isStatic && body.render.fillStyle === null ? 1 : 0;
          body.render.fillStyle = body.render.fillStyle || defaultFillStyle;
          body.render.strokeStyle = body.render.strokeStyle || defaultStrokeStyle;
          body.render.lineWidth = body.render.lineWidth || defaultLineWidth;
          body.render.sprite.xOffset += -(body.bounds.min.x - body.position.x) / (body.bounds.max.x - body.bounds.min.x);
          body.render.sprite.yOffset += -(body.bounds.min.y - body.position.y) / (body.bounds.max.y - body.bounds.min.y);
        };
        /**
         * Given a property and a value (or map of), sets the property(s) on the body, using the appropriate setter functions if they exist.
         * Prefer to use the actual setter functions in performance critical situations.
         * @method set
         * @param {body} body
         * @param {} settings A property name (or map of properties and values) to set on the body.
         * @param {} value The value to set if `settings` is a single property name.
         */


        Body.set = function (body, settings, value) {
          var property;

          if (typeof settings === 'string') {
            property = settings;
            settings = {};
            settings[property] = value;
          }

          for (property in settings) {
            if (!Object.prototype.hasOwnProperty.call(settings, property)) continue;
            value = settings[property];

            switch (property) {
              case 'isStatic':
                Body.setStatic(body, value);
                break;

              case 'isSleeping':
                Sleeping.set(body, value);
                break;

              case 'mass':
                Body.setMass(body, value);
                break;

              case 'density':
                Body.setDensity(body, value);
                break;

              case 'inertia':
                Body.setInertia(body, value);
                break;

              case 'vertices':
                Body.setVertices(body, value);
                break;

              case 'position':
                Body.setPosition(body, value);
                break;

              case 'angle':
                Body.setAngle(body, value);
                break;

              case 'velocity':
                Body.setVelocity(body, value);
                break;

              case 'angularVelocity':
                Body.setAngularVelocity(body, value);
                break;

              case 'parts':
                Body.setParts(body, value);
                break;

              case 'centre':
                Body.setCentre(body, value);
                break;

              default:
                body[property] = value;
            }
          }
        };
        /**
         * Sets the body as static, including isStatic flag and setting mass and inertia to Infinity.
         * @method setStatic
         * @param {body} body
         * @param {bool} isStatic
         */


        Body.setStatic = function (body, isStatic) {
          for (var i = 0; i < body.parts.length; i++) {
            var part = body.parts[i];
            part.isStatic = isStatic;

            if (isStatic) {
              part._original = {
                restitution: part.restitution,
                friction: part.friction,
                mass: part.mass,
                inertia: part.inertia,
                density: part.density,
                inverseMass: part.inverseMass,
                inverseInertia: part.inverseInertia
              };
              part.restitution = 0;
              part.friction = 1;
              part.mass = part.inertia = part.density = Infinity;
              part.inverseMass = part.inverseInertia = 0;
              part.positionPrev.x = part.position.x;
              part.positionPrev.y = part.position.y;
              part.anglePrev = part.angle;
              part.angularVelocity = 0;
              part.speed = 0;
              part.angularSpeed = 0;
              part.motion = 0;
            } else if (part._original) {
              part.restitution = part._original.restitution;
              part.friction = part._original.friction;
              part.mass = part._original.mass;
              part.inertia = part._original.inertia;
              part.density = part._original.density;
              part.inverseMass = part._original.inverseMass;
              part.inverseInertia = part._original.inverseInertia;
              part._original = null;
            }
          }
        };
        /**
         * Sets the mass of the body. Inverse mass, density and inertia are automatically updated to reflect the change.
         * @method setMass
         * @param {body} body
         * @param {number} mass
         */


        Body.setMass = function (body, mass) {
          var moment = body.inertia / (body.mass / 6);
          body.inertia = moment * (mass / 6);
          body.inverseInertia = 1 / body.inertia;
          body.mass = mass;
          body.inverseMass = 1 / body.mass;
          body.density = body.mass / body.area;
        };
        /**
         * Sets the density of the body. Mass and inertia are automatically updated to reflect the change.
         * @method setDensity
         * @param {body} body
         * @param {number} density
         */


        Body.setDensity = function (body, density) {
          Body.setMass(body, density * body.area);
          body.density = density;
        };
        /**
         * Sets the moment of inertia (i.e. second moment of area) of the body. 
         * Inverse inertia is automatically updated to reflect the change. Mass is not changed.
         * @method setInertia
         * @param {body} body
         * @param {number} inertia
         */


        Body.setInertia = function (body, inertia) {
          body.inertia = inertia;
          body.inverseInertia = 1 / body.inertia;
        };
        /**
         * Sets the body's vertices and updates body properties accordingly, including inertia, area and mass (with respect to `body.density`).
         * Vertices will be automatically transformed to be orientated around their centre of mass as the origin.
         * They are then automatically translated to world space based on `body.position`.
         *
         * The `vertices` argument should be passed as an array of `Matter.Vector` points (or a `Matter.Vertices` array).
         * Vertices must form a convex hull, concave hulls are not supported.
         *
         * @method setVertices
         * @param {body} body
         * @param {vector[]} vertices
         */


        Body.setVertices = function (body, vertices) {
          // change vertices
          if (vertices[0].body === body) {
            body.vertices = vertices;
          } else {
            body.vertices = Vertices.create(vertices, body);
          } // update properties


          body.axes = Axes.fromVertices(body.vertices);
          body.area = Vertices.area(body.vertices);
          Body.setMass(body, body.density * body.area); // orient vertices around the centre of mass at origin (0, 0)

          var centre = Vertices.centre(body.vertices);
          Vertices.translate(body.vertices, centre, -1); // update inertia while vertices are at origin (0, 0)

          Body.setInertia(body, Body._inertiaScale * Vertices.inertia(body.vertices, body.mass)); // update geometry

          Vertices.translate(body.vertices, body.position);
          Bounds.update(body.bounds, body.vertices, body.velocity);
        };
        /**
         * Sets the parts of the `body` and updates mass, inertia and centroid.
         * Each part will have its parent set to `body`.
         * By default the convex hull will be automatically computed and set on `body`, unless `autoHull` is set to `false.`
         * Note that this method will ensure that the first part in `body.parts` will always be the `body`.
         * @method setParts
         * @param {body} body
         * @param [body] parts
         * @param {bool} [autoHull=true]
         */


        Body.setParts = function (body, parts, autoHull) {
          var i; // add all the parts, ensuring that the first part is always the parent body

          parts = parts.slice(0);
          body.parts.length = 0;
          body.parts.push(body);
          body.parent = body;

          for (i = 0; i < parts.length; i++) {
            var part = parts[i];

            if (part !== body) {
              part.parent = body;
              body.parts.push(part);
            }
          }

          if (body.parts.length === 1) return;
          autoHull = typeof autoHull !== 'undefined' ? autoHull : true; // find the convex hull of all parts to set on the parent body

          if (autoHull) {
            var vertices = [];

            for (i = 0; i < parts.length; i++) {
              vertices = vertices.concat(parts[i].vertices);
            }

            Vertices.clockwiseSort(vertices);
            var hull = Vertices.hull(vertices),
                hullCentre = Vertices.centre(hull);
            Body.setVertices(body, hull);
            Vertices.translate(body.vertices, hullCentre);
          } // sum the properties of all compound parts of the parent body


          var total = Body._totalProperties(body);

          body.area = total.area;
          body.parent = body;
          body.position.x = total.centre.x;
          body.position.y = total.centre.y;
          body.positionPrev.x = total.centre.x;
          body.positionPrev.y = total.centre.y;
          Body.setMass(body, total.mass);
          Body.setInertia(body, total.inertia);
          Body.setPosition(body, total.centre);
        };
        /**
         * Set the centre of mass of the body. 
         * The `centre` is a vector in world-space unless `relative` is set, in which case it is a translation.
         * The centre of mass is the point the body rotates about and can be used to simulate non-uniform density.
         * This is equal to moving `body.position` but not the `body.vertices`.
         * Invalid if the `centre` falls outside the body's convex hull.
         * @method setCentre
         * @param {body} body
         * @param {vector} centre
         * @param {bool} relative
         */


        Body.setCentre = function (body, centre, relative) {
          if (!relative) {
            body.positionPrev.x = centre.x - (body.position.x - body.positionPrev.x);
            body.positionPrev.y = centre.y - (body.position.y - body.positionPrev.y);
            body.position.x = centre.x;
            body.position.y = centre.y;
          } else {
            body.positionPrev.x += centre.x;
            body.positionPrev.y += centre.y;
            body.position.x += centre.x;
            body.position.y += centre.y;
          }
        };
        /**
         * Sets the position of the body instantly. Velocity, angle, force etc. are unchanged.
         * @method setPosition
         * @param {body} body
         * @param {vector} position
         */


        Body.setPosition = function (body, position) {
          var delta = Vector.sub(position, body.position);
          body.positionPrev.x += delta.x;
          body.positionPrev.y += delta.y;

          for (var i = 0; i < body.parts.length; i++) {
            var part = body.parts[i];
            part.position.x += delta.x;
            part.position.y += delta.y;
            Vertices.translate(part.vertices, delta);
            Bounds.update(part.bounds, part.vertices, body.velocity);
          }
        };
        /**
         * Sets the angle of the body instantly. Angular velocity, position, force etc. are unchanged.
         * @method setAngle
         * @param {body} body
         * @param {number} angle
         */


        Body.setAngle = function (body, angle) {
          var delta = angle - body.angle;
          body.anglePrev += delta;

          for (var i = 0; i < body.parts.length; i++) {
            var part = body.parts[i];
            part.angle += delta;
            Vertices.rotate(part.vertices, delta, body.position);
            Axes.rotate(part.axes, delta);
            Bounds.update(part.bounds, part.vertices, body.velocity);

            if (i > 0) {
              Vector.rotateAbout(part.position, delta, body.position, part.position);
            }
          }
        };
        /**
         * Sets the linear velocity of the body instantly. Position, angle, force etc. are unchanged. See also `Body.applyForce`.
         * @method setVelocity
         * @param {body} body
         * @param {vector} velocity
         */


        Body.setVelocity = function (body, velocity) {
          body.positionPrev.x = body.position.x - velocity.x;
          body.positionPrev.y = body.position.y - velocity.y;
          body.velocity.x = velocity.x;
          body.velocity.y = velocity.y;
          body.speed = Vector.magnitude(body.velocity);
        };
        /**
         * Sets the angular velocity of the body instantly. Position, angle, force etc. are unchanged. See also `Body.applyForce`.
         * @method setAngularVelocity
         * @param {body} body
         * @param {number} velocity
         */


        Body.setAngularVelocity = function (body, velocity) {
          body.anglePrev = body.angle - velocity;
          body.angularVelocity = velocity;
          body.angularSpeed = Math.abs(body.angularVelocity);
        };
        /**
         * Moves a body by a given vector relative to its current position, without imparting any velocity.
         * @method translate
         * @param {body} body
         * @param {vector} translation
         */


        Body.translate = function (body, translation) {
          Body.setPosition(body, Vector.add(body.position, translation));
        };
        /**
         * Rotates a body by a given angle relative to its current angle, without imparting any angular velocity.
         * @method rotate
         * @param {body} body
         * @param {number} rotation
         * @param {vector} [point]
         */


        Body.rotate = function (body, rotation, point) {
          if (!point) {
            Body.setAngle(body, body.angle + rotation);
          } else {
            var cos = Math.cos(rotation),
                sin = Math.sin(rotation),
                dx = body.position.x - point.x,
                dy = body.position.y - point.y;
            Body.setPosition(body, {
              x: point.x + (dx * cos - dy * sin),
              y: point.y + (dx * sin + dy * cos)
            });
            Body.setAngle(body, body.angle + rotation);
          }
        };
        /**
         * Scales the body, including updating physical properties (mass, area, axes, inertia), from a world-space point (default is body centre).
         * @method scale
         * @param {body} body
         * @param {number} scaleX
         * @param {number} scaleY
         * @param {vector} [point]
         */


        Body.scale = function (body, scaleX, scaleY, point) {
          var totalArea = 0,
              totalInertia = 0;
          point = point || body.position;

          for (var i = 0; i < body.parts.length; i++) {
            var part = body.parts[i]; // scale vertices

            Vertices.scale(part.vertices, scaleX, scaleY, point); // update properties

            part.axes = Axes.fromVertices(part.vertices);
            part.area = Vertices.area(part.vertices);
            Body.setMass(part, body.density * part.area); // update inertia (requires vertices to be at origin)

            Vertices.translate(part.vertices, {
              x: -part.position.x,
              y: -part.position.y
            });
            Body.setInertia(part, Body._inertiaScale * Vertices.inertia(part.vertices, part.mass));
            Vertices.translate(part.vertices, {
              x: part.position.x,
              y: part.position.y
            });

            if (i > 0) {
              totalArea += part.area;
              totalInertia += part.inertia;
            } // scale position


            part.position.x = point.x + (part.position.x - point.x) * scaleX;
            part.position.y = point.y + (part.position.y - point.y) * scaleY; // update bounds

            Bounds.update(part.bounds, part.vertices, body.velocity);
          } // handle parent body


          if (body.parts.length > 1) {
            body.area = totalArea;

            if (!body.isStatic) {
              Body.setMass(body, body.density * totalArea);
              Body.setInertia(body, totalInertia);
            }
          } // handle circles


          if (body.circleRadius) {
            if (scaleX === scaleY) {
              body.circleRadius *= scaleX;
            } else {
              // body is no longer a circle
              body.circleRadius = null;
            }
          }
        };
        /**
         * Performs a simulation step for the given `body`, including updating position and angle using Verlet integration.
         * @method update
         * @param {body} body
         * @param {number} deltaTime
         * @param {number} timeScale
         * @param {number} correction
         */


        Body.update = function (body, deltaTime, timeScale, correction) {
          var deltaTimeSquared = Math.pow(deltaTime * timeScale * body.timeScale, 2); // from the previous step

          var frictionAir = 1 - body.frictionAir * timeScale * body.timeScale,
              velocityPrevX = body.position.x - body.positionPrev.x,
              velocityPrevY = body.position.y - body.positionPrev.y; // update velocity with Verlet integration

          body.velocity.x = velocityPrevX * frictionAir * correction + body.force.x / body.mass * deltaTimeSquared;
          body.velocity.y = velocityPrevY * frictionAir * correction + body.force.y / body.mass * deltaTimeSquared;
          body.positionPrev.x = body.position.x;
          body.positionPrev.y = body.position.y;
          body.position.x += body.velocity.x;
          body.position.y += body.velocity.y; // update angular velocity with Verlet integration

          body.angularVelocity = (body.angle - body.anglePrev) * frictionAir * correction + body.torque / body.inertia * deltaTimeSquared;
          body.anglePrev = body.angle;
          body.angle += body.angularVelocity; // track speed and acceleration

          body.speed = Vector.magnitude(body.velocity);
          body.angularSpeed = Math.abs(body.angularVelocity); // transform the body geometry

          for (var i = 0; i < body.parts.length; i++) {
            var part = body.parts[i];
            Vertices.translate(part.vertices, body.velocity);

            if (i > 0) {
              part.position.x += body.velocity.x;
              part.position.y += body.velocity.y;
            }

            if (body.angularVelocity !== 0) {
              Vertices.rotate(part.vertices, body.angularVelocity, body.position);
              Axes.rotate(part.axes, body.angularVelocity);

              if (i > 0) {
                Vector.rotateAbout(part.position, body.angularVelocity, body.position, part.position);
              }
            }

            Bounds.update(part.bounds, part.vertices, body.velocity);
          }
        };
        /**
         * Applies a force to a body from a given world-space position, including resulting torque.
         * @method applyForce
         * @param {body} body
         * @param {vector} position
         * @param {vector} force
         */


        Body.applyForce = function (body, position, force) {
          body.force.x += force.x;
          body.force.y += force.y;
          var offset = {
            x: position.x - body.position.x,
            y: position.y - body.position.y
          };
          body.torque += offset.x * force.y - offset.y * force.x;
        };
        /**
         * Returns the sums of the properties of all compound parts of the parent body.
         * @method _totalProperties
         * @private
         * @param {body} body
         * @return {}
         */


        Body._totalProperties = function (body) {
          // from equations at:
          // https://ecourses.ou.edu/cgi-bin/ebook.cgi?doc=&topic=st&chap_sec=07.2&page=theory
          // http://output.to/sideway/default.asp?qno=121100087
          var properties = {
            mass: 0,
            area: 0,
            inertia: 0,
            centre: {
              x: 0,
              y: 0
            }
          }; // sum the properties of all compound parts of the parent body

          for (var i = body.parts.length === 1 ? 0 : 1; i < body.parts.length; i++) {
            var part = body.parts[i],
                mass = part.mass !== Infinity ? part.mass : 1;
            properties.mass += mass;
            properties.area += part.area;
            properties.inertia += part.inertia;
            properties.centre = Vector.add(properties.centre, Vector.mult(part.position, mass));
          }

          properties.centre = Vector.div(properties.centre, properties.mass);
          return properties;
        };
        /*
        *
        *  Events Documentation
        *
        */

        /**
        * Fired when a body starts sleeping (where `this` is the body).
        *
        * @event sleepStart
        * @this {body} The body that has started sleeping
        * @param {} event An event object
        * @param {} event.source The source object of the event
        * @param {} event.name The name of the event
        */

        /**
        * Fired when a body ends sleeping (where `this` is the body).
        *
        * @event sleepEnd
        * @this {body} The body that has ended sleeping
        * @param {} event An event object
        * @param {} event.source The source object of the event
        * @param {} event.name The name of the event
        */

        /*
        *
        *  Properties Documentation
        *
        */

        /**
         * An integer `Number` uniquely identifying number generated in `Body.create` by `Common.nextId`.
         *
         * @property id
         * @type number
         */

        /**
         * A `String` denoting the type of object.
         *
         * @property type
         * @type string
         * @default "body"
         * @readOnly
         */

        /**
         * An arbitrary `String` name to help the user identify and manage bodies.
         *
         * @property label
         * @type string
         * @default "Body"
         */

        /**
         * An array of bodies that make up this body. 
         * The first body in the array must always be a self reference to the current body instance.
         * All bodies in the `parts` array together form a single rigid compound body.
         * Parts are allowed to overlap, have gaps or holes or even form concave bodies.
         * Parts themselves should never be added to a `World`, only the parent body should be.
         * Use `Body.setParts` when setting parts to ensure correct updates of all properties.
         *
         * @property parts
         * @type body[]
         */

        /**
         * An object reserved for storing plugin-specific properties.
         *
         * @property plugin
         * @type {}
         */

        /**
         * A self reference if the body is _not_ a part of another body.
         * Otherwise this is a reference to the body that this is a part of.
         * See `body.parts`.
         *
         * @property parent
         * @type body
         */

        /**
         * A `Number` specifying the angle of the body, in radians.
         *
         * @property angle
         * @type number
         * @default 0
         */

        /**
         * An array of `Vector` objects that specify the convex hull of the rigid body.
         * These should be provided about the origin `(0, 0)`. E.g.
         *
         *     [{ x: 0, y: 0 }, { x: 25, y: 50 }, { x: 50, y: 0 }]
         *
         * When passed via `Body.create`, the vertices are translated relative to `body.position` (i.e. world-space, and constantly updated by `Body.update` during simulation).
         * The `Vector` objects are also augmented with additional properties required for efficient collision detection. 
         *
         * Other properties such as `inertia` and `bounds` are automatically calculated from the passed vertices (unless provided via `options`).
         * Concave hulls are not currently supported. The module `Matter.Vertices` contains useful methods for working with vertices.
         *
         * @property vertices
         * @type vector[]
         */

        /**
         * A `Vector` that specifies the current world-space position of the body.
         *
         * @property position
         * @type vector
         * @default { x: 0, y: 0 }
         */

        /**
         * A `Vector` that specifies the force to apply in the current step. It is zeroed after every `Body.update`. See also `Body.applyForce`.
         *
         * @property force
         * @type vector
         * @default { x: 0, y: 0 }
         */

        /**
         * A `Number` that specifies the torque (turning force) to apply in the current step. It is zeroed after every `Body.update`.
         *
         * @property torque
         * @type number
         * @default 0
         */

        /**
         * A `Number` that _measures_ the current speed of the body after the last `Body.update`. It is read-only and always positive (it's the magnitude of `body.velocity`).
         *
         * @readOnly
         * @property speed
         * @type number
         * @default 0
         */

        /**
         * A `Number` that _measures_ the current angular speed of the body after the last `Body.update`. It is read-only and always positive (it's the magnitude of `body.angularVelocity`).
         *
         * @readOnly
         * @property angularSpeed
         * @type number
         * @default 0
         */

        /**
         * A `Vector` that _measures_ the current velocity of the body after the last `Body.update`. It is read-only. 
         * If you need to modify a body's velocity directly, you should either apply a force or simply change the body's `position` (as the engine uses position-Verlet integration).
         *
         * @readOnly
         * @property velocity
         * @type vector
         * @default { x: 0, y: 0 }
         */

        /**
         * A `Number` that _measures_ the current angular velocity of the body after the last `Body.update`. It is read-only. 
         * If you need to modify a body's angular velocity directly, you should apply a torque or simply change the body's `angle` (as the engine uses position-Verlet integration).
         *
         * @readOnly
         * @property angularVelocity
         * @type number
         * @default 0
         */

        /**
         * A flag that indicates whether a body is considered static. A static body can never change position or angle and is completely fixed.
         * If you need to set a body as static after its creation, you should use `Body.setStatic` as this requires more than just setting this flag.
         *
         * @property isStatic
         * @type boolean
         * @default false
         */

        /**
         * A flag that indicates whether a body is a sensor. Sensor triggers collision events, but doesn't react with colliding body physically.
         *
         * @property isSensor
         * @type boolean
         * @default false
         */

        /**
         * A flag that indicates whether the body is considered sleeping. A sleeping body acts similar to a static body, except it is only temporary and can be awoken.
         * If you need to set a body as sleeping, you should use `Sleeping.set` as this requires more than just setting this flag.
         *
         * @property isSleeping
         * @type boolean
         * @default false
         */

        /**
         * A `Number` that _measures_ the amount of movement a body currently has (a combination of `speed` and `angularSpeed`). It is read-only and always positive.
         * It is used and updated by the `Matter.Sleeping` module during simulation to decide if a body has come to rest.
         *
         * @readOnly
         * @property motion
         * @type number
         * @default 0
         */

        /**
         * A `Number` that defines the number of updates in which this body must have near-zero velocity before it is set as sleeping by the `Matter.Sleeping` module (if sleeping is enabled by the engine).
         *
         * @property sleepThreshold
         * @type number
         * @default 60
         */

        /**
         * A `Number` that defines the density of the body, that is its mass per unit area.
         * If you pass the density via `Body.create` the `mass` property is automatically calculated for you based on the size (area) of the object.
         * This is generally preferable to simply setting mass and allows for more intuitive definition of materials (e.g. rock has a higher density than wood).
         *
         * @property density
         * @type number
         * @default 0.001
         */

        /**
         * A `Number` that defines the mass of the body, although it may be more appropriate to specify the `density` property instead.
         * If you modify this value, you must also modify the `body.inverseMass` property (`1 / mass`).
         *
         * @property mass
         * @type number
         */

        /**
         * A `Number` that defines the inverse mass of the body (`1 / mass`).
         * If you modify this value, you must also modify the `body.mass` property.
         *
         * @property inverseMass
         * @type number
         */

        /**
         * A `Number` that defines the moment of inertia (i.e. second moment of area) of the body.
         * It is automatically calculated from the given convex hull (`vertices` array) and density in `Body.create`.
         * If you modify this value, you must also modify the `body.inverseInertia` property (`1 / inertia`).
         *
         * @property inertia
         * @type number
         */

        /**
         * A `Number` that defines the inverse moment of inertia of the body (`1 / inertia`).
         * If you modify this value, you must also modify the `body.inertia` property.
         *
         * @property inverseInertia
         * @type number
         */

        /**
         * A `Number` that defines the restitution (elasticity) of the body. The value is always positive and is in the range `(0, 1)`.
         * A value of `0` means collisions may be perfectly inelastic and no bouncing may occur. 
         * A value of `0.8` means the body may bounce back with approximately 80% of its kinetic energy.
         * Note that collision response is based on _pairs_ of bodies, and that `restitution` values are _combined_ with the following formula:
         *
         *     Math.max(bodyA.restitution, bodyB.restitution)
         *
         * @property restitution
         * @type number
         * @default 0
         */

        /**
         * A `Number` that defines the friction of the body. The value is always positive and is in the range `(0, 1)`.
         * A value of `0` means that the body may slide indefinitely.
         * A value of `1` means the body may come to a stop almost instantly after a force is applied.
         *
         * The effects of the value may be non-linear. 
         * High values may be unstable depending on the body.
         * The engine uses a Coulomb friction model including static and kinetic friction.
         * Note that collision response is based on _pairs_ of bodies, and that `friction` values are _combined_ with the following formula:
         *
         *     Math.min(bodyA.friction, bodyB.friction)
         *
         * @property friction
         * @type number
         * @default 0.1
         */

        /**
         * A `Number` that defines the static friction of the body (in the Coulomb friction model). 
         * A value of `0` means the body will never 'stick' when it is nearly stationary and only dynamic `friction` is used.
         * The higher the value (e.g. `10`), the more force it will take to initially get the body moving when nearly stationary.
         * This value is multiplied with the `friction` property to make it easier to change `friction` and maintain an appropriate amount of static friction.
         *
         * @property frictionStatic
         * @type number
         * @default 0.5
         */

        /**
         * A `Number` that defines the air friction of the body (air resistance). 
         * A value of `0` means the body will never slow as it moves through space.
         * The higher the value, the faster a body slows when moving through space.
         * The effects of the value are non-linear. 
         *
         * @property frictionAir
         * @type number
         * @default 0.01
         */

        /**
         * An `Object` that specifies the collision filtering properties of this body.
         *
         * Collisions between two bodies will obey the following rules:
         * - If the two bodies have the same non-zero value of `collisionFilter.group`,
         *   they will always collide if the value is positive, and they will never collide
         *   if the value is negative.
         * - If the two bodies have different values of `collisionFilter.group` or if one
         *   (or both) of the bodies has a value of 0, then the category/mask rules apply as follows:
         *
         * Each body belongs to a collision category, given by `collisionFilter.category`. This
         * value is used as a bit field and the category should have only one bit set, meaning that
         * the value of this property is a power of two in the range [1, 2^31]. Thus, there are 32
         * different collision categories available.
         *
         * Each body also defines a collision bitmask, given by `collisionFilter.mask` which specifies
         * the categories it collides with (the value is the bitwise AND value of all these categories).
         *
         * Using the category/mask rules, two bodies `A` and `B` collide if each includes the other's
         * category in its mask, i.e. `(categoryA & maskB) !== 0` and `(categoryB & maskA) !== 0`
         * are both true.
         *
         * @property collisionFilter
         * @type object
         */

        /**
         * An Integer `Number`, that specifies the collision group this body belongs to.
         * See `body.collisionFilter` for more information.
         *
         * @property collisionFilter.group
         * @type object
         * @default 0
         */

        /**
         * A bit field that specifies the collision category this body belongs to.
         * The category value should have only one bit set, for example `0x0001`.
         * This means there are up to 32 unique collision categories available.
         * See `body.collisionFilter` for more information.
         *
         * @property collisionFilter.category
         * @type object
         * @default 1
         */

        /**
         * A bit mask that specifies the collision categories this body may collide with.
         * See `body.collisionFilter` for more information.
         *
         * @property collisionFilter.mask
         * @type object
         * @default -1
         */

        /**
         * A `Number` that specifies a tolerance on how far a body is allowed to 'sink' or rotate into other bodies.
         * Avoid changing this value unless you understand the purpose of `slop` in physics engines.
         * The default should generally suffice, although very large bodies may require larger values for stable stacking.
         *
         * @property slop
         * @type number
         * @default 0.05
         */

        /**
         * A `Number` that allows per-body time scaling, e.g. a force-field where bodies inside are in slow-motion, while others are at full speed.
         *
         * @property timeScale
         * @type number
         * @default 1
         */

        /**
         * An `Object` that defines the rendering properties to be consumed by the module `Matter.Render`.
         *
         * @property render
         * @type object
         */

        /**
         * A flag that indicates if the body should be rendered.
         *
         * @property render.visible
         * @type boolean
         * @default true
         */

        /**
         * Sets the opacity to use when rendering.
         *
         * @property render.opacity
         * @type number
         * @default 1
        */

        /**
         * An `Object` that defines the sprite properties to use when rendering, if any.
         *
         * @property render.sprite
         * @type object
         */

        /**
         * An `String` that defines the path to the image to use as the sprite texture, if any.
         *
         * @property render.sprite.texture
         * @type string
         */

        /**
         * A `Number` that defines the scaling in the x-axis for the sprite, if any.
         *
         * @property render.sprite.xScale
         * @type number
         * @default 1
         */

        /**
         * A `Number` that defines the scaling in the y-axis for the sprite, if any.
         *
         * @property render.sprite.yScale
         * @type number
         * @default 1
         */

        /**
          * A `Number` that defines the offset in the x-axis for the sprite (normalised by texture width).
          *
          * @property render.sprite.xOffset
          * @type number
          * @default 0
          */

        /**
          * A `Number` that defines the offset in the y-axis for the sprite (normalised by texture height).
          *
          * @property render.sprite.yOffset
          * @type number
          * @default 0
          */

        /**
         * A `Number` that defines the line width to use when rendering the body outline (if a sprite is not defined).
         * A value of `0` means no outline will be rendered.
         *
         * @property render.lineWidth
         * @type number
         * @default 0
         */

        /**
         * A `String` that defines the fill style to use when rendering the body (if a sprite is not defined).
         * It is the same as when using a canvas, so it accepts CSS style property values.
         *
         * @property render.fillStyle
         * @type string
         * @default a random colour
         */

        /**
         * A `String` that defines the stroke style to use when rendering the body outline (if a sprite is not defined).
         * It is the same as when using a canvas, so it accepts CSS style property values.
         *
         * @property render.strokeStyle
         * @type string
         * @default a random colour
         */

        /**
         * An array of unique axis vectors (edge normals) used for collision detection.
         * These are automatically calculated from the given convex hull (`vertices` array) in `Body.create`.
         * They are constantly updated by `Body.update` during the simulation.
         *
         * @property axes
         * @type vector[]
         */

        /**
         * A `Number` that _measures_ the area of the body's convex hull, calculated at creation by `Body.create`.
         *
         * @property area
         * @type string
         * @default 
         */

        /**
         * A `Bounds` object that defines the AABB region for the body.
         * It is automatically calculated from the given convex hull (`vertices` array) in `Body.create` and constantly updated by `Body.update` during simulation.
         *
         * @property bounds
         * @type bounds
         */

      })();
      /***/

    },
    /* 7 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * The `Matter.Sleeping` module contains methods to manage the sleeping state of bodies.
      *
      * @class Sleeping
      */
      var Sleeping = {};
      module.exports = Sleeping;

      var Events = __webpack_require__(4);

      (function () {
        Sleeping._motionWakeThreshold = 0.18;
        Sleeping._motionSleepThreshold = 0.08;
        Sleeping._minBias = 0.9;
        /**
         * Puts bodies to sleep or wakes them up depending on their motion.
         * @method update
         * @param {body[]} bodies
         * @param {number} timeScale
         */

        Sleeping.update = function (bodies, timeScale) {
          var timeFactor = timeScale * timeScale * timeScale; // update bodies sleeping status

          for (var i = 0; i < bodies.length; i++) {
            var body = bodies[i],
                motion = body.speed * body.speed + body.angularSpeed * body.angularSpeed; // wake up bodies if they have a force applied

            if (body.force.x !== 0 || body.force.y !== 0) {
              Sleeping.set(body, false);
              continue;
            }

            var minMotion = Math.min(body.motion, motion),
                maxMotion = Math.max(body.motion, motion); // biased average motion estimation between frames

            body.motion = Sleeping._minBias * minMotion + (1 - Sleeping._minBias) * maxMotion;

            if (body.sleepThreshold > 0 && body.motion < Sleeping._motionSleepThreshold * timeFactor) {
              body.sleepCounter += 1;
              if (body.sleepCounter >= body.sleepThreshold) Sleeping.set(body, true);
            } else if (body.sleepCounter > 0) {
              body.sleepCounter -= 1;
            }
          }
        };
        /**
         * Given a set of colliding pairs, wakes the sleeping bodies involved.
         * @method afterCollisions
         * @param {pair[]} pairs
         * @param {number} timeScale
         */


        Sleeping.afterCollisions = function (pairs, timeScale) {
          var timeFactor = timeScale * timeScale * timeScale; // wake up bodies involved in collisions

          for (var i = 0; i < pairs.length; i++) {
            var pair = pairs[i]; // don't wake inactive pairs

            if (!pair.isActive) continue;
            var collision = pair.collision,
                bodyA = collision.bodyA.parent,
                bodyB = collision.bodyB.parent; // don't wake if at least one body is static

            if (bodyA.isSleeping && bodyB.isSleeping || bodyA.isStatic || bodyB.isStatic) continue;

            if (bodyA.isSleeping || bodyB.isSleeping) {
              var sleepingBody = bodyA.isSleeping && !bodyA.isStatic ? bodyA : bodyB,
                  movingBody = sleepingBody === bodyA ? bodyB : bodyA;

              if (!sleepingBody.isStatic && movingBody.motion > Sleeping._motionWakeThreshold * timeFactor) {
                Sleeping.set(sleepingBody, false);
              }
            }
          }
        };
        /**
         * Set a body as sleeping or awake.
         * @method set
         * @param {body} body
         * @param {boolean} isSleeping
         */


        Sleeping.set = function (body, isSleeping) {
          var wasSleeping = body.isSleeping;

          if (isSleeping) {
            body.isSleeping = true;
            body.sleepCounter = body.sleepThreshold;
            body.positionImpulse.x = 0;
            body.positionImpulse.y = 0;
            body.positionPrev.x = body.position.x;
            body.positionPrev.y = body.position.y;
            body.anglePrev = body.angle;
            body.speed = 0;
            body.angularSpeed = 0;
            body.motion = 0;

            if (!wasSleeping) {
              Events.trigger(body, 'sleepStart');
            }
          } else {
            body.isSleeping = false;
            body.sleepCounter = 0;

            if (wasSleeping) {
              Events.trigger(body, 'sleepEnd');
            }
          }
        };
      })();
      /***/

    },
    /* 8 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * The `Matter.Constraint` module contains methods for creating and manipulating constraints.
      * Constraints are used for specifying that a fixed distance must be maintained between two bodies (or a body and a fixed world-space position).
      * The stiffness of constraints can be modified to create springs or elastic.
      *
      * See the included usage [examples](https://github.com/liabru/matter-js/tree/master/examples).
      *
      * @class Constraint
      */
      var Constraint = {};
      module.exports = Constraint;

      var Vertices = __webpack_require__(3);

      var Vector = __webpack_require__(2);

      var Sleeping = __webpack_require__(7);

      var Bounds = __webpack_require__(1);

      var Axes = __webpack_require__(10);

      var Common = __webpack_require__(0);

      (function () {
        Constraint._warming = 0.4;
        Constraint._torqueDampen = 1;
        Constraint._minLength = 0.000001;
        /**
         * Creates a new constraint.
         * All properties have default values, and many are pre-calculated automatically based on other properties.
         * To simulate a revolute constraint (or pin joint) set `length: 0` and a high `stiffness` value (e.g. `0.7` or above).
         * If the constraint is unstable, try lowering the `stiffness` value and / or increasing `engine.constraintIterations`.
         * For compound bodies, constraints must be applied to the parent body (not one of its parts).
         * See the properties section below for detailed information on what you can pass via the `options` object.
         * @method create
         * @param {} options
         * @return {constraint} constraint
         */

        Constraint.create = function (options) {
          var constraint = options; // if bodies defined but no points, use body centre

          if (constraint.bodyA && !constraint.pointA) constraint.pointA = {
            x: 0,
            y: 0
          };
          if (constraint.bodyB && !constraint.pointB) constraint.pointB = {
            x: 0,
            y: 0
          }; // calculate static length using initial world space points

          var initialPointA = constraint.bodyA ? Vector.add(constraint.bodyA.position, constraint.pointA) : constraint.pointA,
              initialPointB = constraint.bodyB ? Vector.add(constraint.bodyB.position, constraint.pointB) : constraint.pointB,
              length = Vector.magnitude(Vector.sub(initialPointA, initialPointB));
          constraint.length = typeof constraint.length !== 'undefined' ? constraint.length : length; // option defaults

          constraint.id = constraint.id || Common.nextId();
          constraint.label = constraint.label || 'Constraint';
          constraint.type = 'constraint';
          constraint.stiffness = constraint.stiffness || (constraint.length > 0 ? 1 : 0.7);
          constraint.damping = constraint.damping || 0;
          constraint.angularStiffness = constraint.angularStiffness || 0;
          constraint.angleA = constraint.bodyA ? constraint.bodyA.angle : constraint.angleA;
          constraint.angleB = constraint.bodyB ? constraint.bodyB.angle : constraint.angleB;
          constraint.plugin = {}; // render

          var render = {
            visible: true,
            lineWidth: 2,
            strokeStyle: '#ffffff',
            type: 'line',
            anchors: true
          };

          if (constraint.length === 0 && constraint.stiffness > 0.1) {
            render.type = 'pin';
            render.anchors = false;
          } else if (constraint.stiffness < 0.9) {
            render.type = 'spring';
          }

          constraint.render = Common.extend(render, constraint.render);
          return constraint;
        };
        /**
         * Prepares for solving by constraint warming.
         * @private
         * @method preSolveAll
         * @param {body[]} bodies
         */


        Constraint.preSolveAll = function (bodies) {
          for (var i = 0; i < bodies.length; i += 1) {
            var body = bodies[i],
                impulse = body.constraintImpulse;

            if (body.isStatic || impulse.x === 0 && impulse.y === 0 && impulse.angle === 0) {
              continue;
            }

            body.position.x += impulse.x;
            body.position.y += impulse.y;
            body.angle += impulse.angle;
          }
        };
        /**
         * Solves all constraints in a list of collisions.
         * @private
         * @method solveAll
         * @param {constraint[]} constraints
         * @param {number} timeScale
         */


        Constraint.solveAll = function (constraints, timeScale) {
          // Solve fixed constraints first.
          for (var i = 0; i < constraints.length; i += 1) {
            var constraint = constraints[i],
                fixedA = !constraint.bodyA || constraint.bodyA && constraint.bodyA.isStatic,
                fixedB = !constraint.bodyB || constraint.bodyB && constraint.bodyB.isStatic;

            if (fixedA || fixedB) {
              Constraint.solve(constraints[i], timeScale);
            }
          } // Solve free constraints last.


          for (i = 0; i < constraints.length; i += 1) {
            constraint = constraints[i];
            fixedA = !constraint.bodyA || constraint.bodyA && constraint.bodyA.isStatic;
            fixedB = !constraint.bodyB || constraint.bodyB && constraint.bodyB.isStatic;

            if (!fixedA && !fixedB) {
              Constraint.solve(constraints[i], timeScale);
            }
          }
        };
        /**
         * Solves a distance constraint with Gauss-Siedel method.
         * @private
         * @method solve
         * @param {constraint} constraint
         * @param {number} timeScale
         */


        Constraint.solve = function (constraint, timeScale) {
          var bodyA = constraint.bodyA,
              bodyB = constraint.bodyB,
              pointA = constraint.pointA,
              pointB = constraint.pointB;
          if (!bodyA && !bodyB) return; // update reference angle

          if (bodyA && !bodyA.isStatic) {
            Vector.rotate(pointA, bodyA.angle - constraint.angleA, pointA);
            constraint.angleA = bodyA.angle;
          } // update reference angle


          if (bodyB && !bodyB.isStatic) {
            Vector.rotate(pointB, bodyB.angle - constraint.angleB, pointB);
            constraint.angleB = bodyB.angle;
          }

          var pointAWorld = pointA,
              pointBWorld = pointB;
          if (bodyA) pointAWorld = Vector.add(bodyA.position, pointA);
          if (bodyB) pointBWorld = Vector.add(bodyB.position, pointB);
          if (!pointAWorld || !pointBWorld) return;
          var delta = Vector.sub(pointAWorld, pointBWorld),
              currentLength = Vector.magnitude(delta); // prevent singularity

          if (currentLength < Constraint._minLength) {
            currentLength = Constraint._minLength;
          } // solve distance constraint with Gauss-Siedel method


          var difference = (currentLength - constraint.length) / currentLength,
              stiffness = constraint.stiffness < 1 ? constraint.stiffness * timeScale : constraint.stiffness,
              force = Vector.mult(delta, difference * stiffness),
              massTotal = (bodyA ? bodyA.inverseMass : 0) + (bodyB ? bodyB.inverseMass : 0),
              inertiaTotal = (bodyA ? bodyA.inverseInertia : 0) + (bodyB ? bodyB.inverseInertia : 0),
              resistanceTotal = massTotal + inertiaTotal,
              torque,
              share,
              normal,
              normalVelocity,
              relativeVelocity;

          if (constraint.damping) {
            var zero = Vector.create();
            normal = Vector.div(delta, currentLength);
            relativeVelocity = Vector.sub(bodyB && Vector.sub(bodyB.position, bodyB.positionPrev) || zero, bodyA && Vector.sub(bodyA.position, bodyA.positionPrev) || zero);
            normalVelocity = Vector.dot(normal, relativeVelocity);
          }

          if (bodyA && !bodyA.isStatic) {
            share = bodyA.inverseMass / massTotal; // keep track of applied impulses for post solving

            bodyA.constraintImpulse.x -= force.x * share;
            bodyA.constraintImpulse.y -= force.y * share; // apply forces

            bodyA.position.x -= force.x * share;
            bodyA.position.y -= force.y * share; // apply damping

            if (constraint.damping) {
              bodyA.positionPrev.x -= constraint.damping * normal.x * normalVelocity * share;
              bodyA.positionPrev.y -= constraint.damping * normal.y * normalVelocity * share;
            } // apply torque


            torque = Vector.cross(pointA, force) / resistanceTotal * Constraint._torqueDampen * bodyA.inverseInertia * (1 - constraint.angularStiffness);
            bodyA.constraintImpulse.angle -= torque;
            bodyA.angle -= torque;
          }

          if (bodyB && !bodyB.isStatic) {
            share = bodyB.inverseMass / massTotal; // keep track of applied impulses for post solving

            bodyB.constraintImpulse.x += force.x * share;
            bodyB.constraintImpulse.y += force.y * share; // apply forces

            bodyB.position.x += force.x * share;
            bodyB.position.y += force.y * share; // apply damping

            if (constraint.damping) {
              bodyB.positionPrev.x += constraint.damping * normal.x * normalVelocity * share;
              bodyB.positionPrev.y += constraint.damping * normal.y * normalVelocity * share;
            } // apply torque


            torque = Vector.cross(pointB, force) / resistanceTotal * Constraint._torqueDampen * bodyB.inverseInertia * (1 - constraint.angularStiffness);
            bodyB.constraintImpulse.angle += torque;
            bodyB.angle += torque;
          }
        };
        /**
         * Performs body updates required after solving constraints.
         * @private
         * @method postSolveAll
         * @param {body[]} bodies
         */


        Constraint.postSolveAll = function (bodies) {
          for (var i = 0; i < bodies.length; i++) {
            var body = bodies[i],
                impulse = body.constraintImpulse;

            if (body.isStatic || impulse.x === 0 && impulse.y === 0 && impulse.angle === 0) {
              continue;
            }

            Sleeping.set(body, false); // update geometry and reset

            for (var j = 0; j < body.parts.length; j++) {
              var part = body.parts[j];
              Vertices.translate(part.vertices, impulse);

              if (j > 0) {
                part.position.x += impulse.x;
                part.position.y += impulse.y;
              }

              if (impulse.angle !== 0) {
                Vertices.rotate(part.vertices, impulse.angle, body.position);
                Axes.rotate(part.axes, impulse.angle);

                if (j > 0) {
                  Vector.rotateAbout(part.position, impulse.angle, body.position, part.position);
                }
              }

              Bounds.update(part.bounds, part.vertices, body.velocity);
            } // dampen the cached impulse for warming next step


            impulse.angle *= Constraint._warming;
            impulse.x *= Constraint._warming;
            impulse.y *= Constraint._warming;
          }
        };
        /**
         * Returns the world-space position of `constraint.pointA`, accounting for `constraint.bodyA`.
         * @method pointAWorld
         * @param {constraint} constraint
         * @returns {vector} the world-space position
         */


        Constraint.pointAWorld = function (constraint) {
          return {
            x: (constraint.bodyA ? constraint.bodyA.position.x : 0) + constraint.pointA.x,
            y: (constraint.bodyA ? constraint.bodyA.position.y : 0) + constraint.pointA.y
          };
        };
        /**
         * Returns the world-space position of `constraint.pointB`, accounting for `constraint.bodyB`.
         * @method pointBWorld
         * @param {constraint} constraint
         * @returns {vector} the world-space position
         */


        Constraint.pointBWorld = function (constraint) {
          return {
            x: (constraint.bodyB ? constraint.bodyB.position.x : 0) + constraint.pointB.x,
            y: (constraint.bodyB ? constraint.bodyB.position.y : 0) + constraint.pointB.y
          };
        };
        /*
        *
        *  Properties Documentation
        *
        */

        /**
         * An integer `Number` uniquely identifying number generated in `Composite.create` by `Common.nextId`.
         *
         * @property id
         * @type number
         */

        /**
         * A `String` denoting the type of object.
         *
         * @property type
         * @type string
         * @default "constraint"
         * @readOnly
         */

        /**
         * An arbitrary `String` name to help the user identify and manage bodies.
         *
         * @property label
         * @type string
         * @default "Constraint"
         */

        /**
         * An `Object` that defines the rendering properties to be consumed by the module `Matter.Render`.
         *
         * @property render
         * @type object
         */

        /**
         * A flag that indicates if the constraint should be rendered.
         *
         * @property render.visible
         * @type boolean
         * @default true
         */

        /**
         * A `Number` that defines the line width to use when rendering the constraint outline.
         * A value of `0` means no outline will be rendered.
         *
         * @property render.lineWidth
         * @type number
         * @default 2
         */

        /**
         * A `String` that defines the stroke style to use when rendering the constraint outline.
         * It is the same as when using a canvas, so it accepts CSS style property values.
         *
         * @property render.strokeStyle
         * @type string
         * @default a random colour
         */

        /**
         * A `String` that defines the constraint rendering type. 
         * The possible values are 'line', 'pin', 'spring'.
         * An appropriate render type will be automatically chosen unless one is given in options.
         *
         * @property render.type
         * @type string
         * @default 'line'
         */

        /**
         * A `Boolean` that defines if the constraint's anchor points should be rendered.
         *
         * @property render.anchors
         * @type boolean
         * @default true
         */

        /**
         * The first possible `Body` that this constraint is attached to.
         *
         * @property bodyA
         * @type body
         * @default null
         */

        /**
         * The second possible `Body` that this constraint is attached to.
         *
         * @property bodyB
         * @type body
         * @default null
         */

        /**
         * A `Vector` that specifies the offset of the constraint from center of the `constraint.bodyA` if defined, otherwise a world-space position.
         *
         * @property pointA
         * @type vector
         * @default { x: 0, y: 0 }
         */

        /**
         * A `Vector` that specifies the offset of the constraint from center of the `constraint.bodyB` if defined, otherwise a world-space position.
         *
         * @property pointB
         * @type vector
         * @default { x: 0, y: 0 }
         */

        /**
         * A `Number` that specifies the stiffness of the constraint, i.e. the rate at which it returns to its resting `constraint.length`.
         * A value of `1` means the constraint should be very stiff.
         * A value of `0.2` means the constraint acts like a soft spring.
         *
         * @property stiffness
         * @type number
         * @default 1
         */

        /**
         * A `Number` that specifies the damping of the constraint, 
         * i.e. the amount of resistance applied to each body based on their velocities to limit the amount of oscillation.
         * Damping will only be apparent when the constraint also has a very low `stiffness`.
         * A value of `0.1` means the constraint will apply heavy damping, resulting in little to no oscillation.
         * A value of `0` means the constraint will apply no damping.
         *
         * @property damping
         * @type number
         * @default 0
         */

        /**
         * A `Number` that specifies the target resting length of the constraint. 
         * It is calculated automatically in `Constraint.create` from initial positions of the `constraint.bodyA` and `constraint.bodyB`.
         *
         * @property length
         * @type number
         */

        /**
         * An object reserved for storing plugin-specific properties.
         *
         * @property plugin
         * @type {}
         */

      })();
      /***/

    },
    /* 9 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * The `Matter.Pair` module contains methods for creating and manipulating collision pairs.
      *
      * @class Pair
      */
      var Pair = {};
      module.exports = Pair;

      var Contact = __webpack_require__(17);

      (function () {
        /**
         * Creates a pair.
         * @method create
         * @param {collision} collision
         * @param {number} timestamp
         * @return {pair} A new pair
         */
        Pair.create = function (collision, timestamp) {
          var bodyA = collision.bodyA,
              bodyB = collision.bodyB,
              parentA = collision.parentA,
              parentB = collision.parentB;
          var pair = {
            id: Pair.id(bodyA, bodyB),
            bodyA: bodyA,
            bodyB: bodyB,
            contacts: {},
            activeContacts: [],
            separation: 0,
            isActive: true,
            confirmedActive: true,
            isSensor: bodyA.isSensor || bodyB.isSensor,
            timeCreated: timestamp,
            timeUpdated: timestamp,
            inverseMass: parentA.inverseMass + parentB.inverseMass,
            friction: Math.min(parentA.friction, parentB.friction),
            frictionStatic: Math.max(parentA.frictionStatic, parentB.frictionStatic),
            restitution: Math.max(parentA.restitution, parentB.restitution),
            slop: Math.max(parentA.slop, parentB.slop)
          };
          Pair.update(pair, collision, timestamp);
          return pair;
        };
        /**
         * Updates a pair given a collision.
         * @method update
         * @param {pair} pair
         * @param {collision} collision
         * @param {number} timestamp
         */


        Pair.update = function (pair, collision, timestamp) {
          var contacts = pair.contacts,
              supports = collision.supports,
              activeContacts = pair.activeContacts,
              parentA = collision.parentA,
              parentB = collision.parentB;
          pair.collision = collision;
          pair.inverseMass = parentA.inverseMass + parentB.inverseMass;
          pair.friction = Math.min(parentA.friction, parentB.friction);
          pair.frictionStatic = Math.max(parentA.frictionStatic, parentB.frictionStatic);
          pair.restitution = Math.max(parentA.restitution, parentB.restitution);
          pair.slop = Math.max(parentA.slop, parentB.slop);
          activeContacts.length = 0;

          if (collision.collided) {
            for (var i = 0; i < supports.length; i++) {
              var support = supports[i],
                  contactId = Contact.id(support),
                  contact = contacts[contactId];

              if (contact) {
                activeContacts.push(contact);
              } else {
                activeContacts.push(contacts[contactId] = Contact.create(support));
              }
            }

            pair.separation = collision.depth;
            Pair.setActive(pair, true, timestamp);
          } else {
            if (pair.isActive === true) Pair.setActive(pair, false, timestamp);
          }
        };
        /**
         * Set a pair as active or inactive.
         * @method setActive
         * @param {pair} pair
         * @param {bool} isActive
         * @param {number} timestamp
         */


        Pair.setActive = function (pair, isActive, timestamp) {
          if (isActive) {
            pair.isActive = true;
            pair.timeUpdated = timestamp;
          } else {
            pair.isActive = false;
            pair.activeContacts.length = 0;
          }
        };
        /**
         * Get the id for the given pair.
         * @method id
         * @param {body} bodyA
         * @param {body} bodyB
         * @return {string} Unique pairId
         */


        Pair.id = function (bodyA, bodyB) {
          if (bodyA.id < bodyB.id) {
            return 'A' + bodyA.id + 'B' + bodyB.id;
          } else {
            return 'A' + bodyB.id + 'B' + bodyA.id;
          }
        };
      })();
      /***/

    },
    /* 10 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * The `Matter.Axes` module contains methods for creating and manipulating sets of axes.
      *
      * @class Axes
      */
      var Axes = {};
      module.exports = Axes;

      var Vector = __webpack_require__(2);

      var Common = __webpack_require__(0);

      (function () {
        /**
         * Creates a new set of axes from the given vertices.
         * @method fromVertices
         * @param {vertices} vertices
         * @return {axes} A new axes from the given vertices
         */
        Axes.fromVertices = function (vertices) {
          var axes = {}; // find the unique axes, using edge normal gradients

          for (var i = 0; i < vertices.length; i++) {
            var j = (i + 1) % vertices.length,
                normal = Vector.normalise({
              x: vertices[j].y - vertices[i].y,
              y: vertices[i].x - vertices[j].x
            }),
                gradient = normal.y === 0 ? Infinity : normal.x / normal.y; // limit precision

            gradient = gradient.toFixed(3).toString();
            axes[gradient] = normal;
          }

          return Common.values(axes);
        };
        /**
         * Rotates a set of axes by the given angle.
         * @method rotate
         * @param {axes} axes
         * @param {number} angle
         */


        Axes.rotate = function (axes, angle) {
          if (angle === 0) return;
          var cos = Math.cos(angle),
              sin = Math.sin(angle);

          for (var i = 0; i < axes.length; i++) {
            var axis = axes[i],
                xx;
            xx = axis.x * cos - axis.y * sin;
            axis.y = axis.x * sin + axis.y * cos;
            axis.x = xx;
          }
        };
      })();
      /***/

    },
    /* 11 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * The `Matter.Bodies` module contains factory methods for creating rigid body models 
      * with commonly used body configurations (such as rectangles, circles and other polygons).
      *
      * See the included usage [examples](https://github.com/liabru/matter-js/tree/master/examples).
      *
      * @class Bodies
      */
      // TODO: true circle bodies
      var Bodies = {};
      module.exports = Bodies;

      var Vertices = __webpack_require__(3);

      var Common = __webpack_require__(0);

      var Body = __webpack_require__(6);

      var Bounds = __webpack_require__(1);

      var Vector = __webpack_require__(2);

      (function () {
        /**
         * Creates a new rigid body model with a rectangle hull. 
         * The options parameter is an object that specifies any properties you wish to override the defaults.
         * See the properties section of the `Matter.Body` module for detailed information on what you can pass via the `options` object.
         * @method rectangle
         * @param {number} x
         * @param {number} y
         * @param {number} width
         * @param {number} height
         * @param {object} [options]
         * @return {body} A new rectangle body
         */
        Bodies.rectangle = function (x, y, width, height, options) {
          options = options || {};
          var rectangle = {
            label: 'Rectangle Body',
            position: {
              x: x,
              y: y
            },
            vertices: Vertices.fromPath('L 0 0 L ' + width + ' 0 L ' + width + ' ' + height + ' L 0 ' + height)
          };

          if (options.chamfer) {
            var chamfer = options.chamfer;
            rectangle.vertices = Vertices.chamfer(rectangle.vertices, chamfer.radius, chamfer.quality, chamfer.qualityMin, chamfer.qualityMax);
            delete options.chamfer;
          }

          return Body.create(Common.extend({}, rectangle, options));
        };
        /**
         * Creates a new rigid body model with a trapezoid hull. 
         * The options parameter is an object that specifies any properties you wish to override the defaults.
         * See the properties section of the `Matter.Body` module for detailed information on what you can pass via the `options` object.
         * @method trapezoid
         * @param {number} x
         * @param {number} y
         * @param {number} width
         * @param {number} height
         * @param {number} slope
         * @param {object} [options]
         * @return {body} A new trapezoid body
         */


        Bodies.trapezoid = function (x, y, width, height, slope, options) {
          options = options || {};
          slope *= 0.5;
          var roof = (1 - slope * 2) * width;
          var x1 = width * slope,
              x2 = x1 + roof,
              x3 = x2 + x1,
              verticesPath;

          if (slope < 0.5) {
            verticesPath = 'L 0 0 L ' + x1 + ' ' + -height + ' L ' + x2 + ' ' + -height + ' L ' + x3 + ' 0';
          } else {
            verticesPath = 'L 0 0 L ' + x2 + ' ' + -height + ' L ' + x3 + ' 0';
          }

          var trapezoid = {
            label: 'Trapezoid Body',
            position: {
              x: x,
              y: y
            },
            vertices: Vertices.fromPath(verticesPath)
          };

          if (options.chamfer) {
            var chamfer = options.chamfer;
            trapezoid.vertices = Vertices.chamfer(trapezoid.vertices, chamfer.radius, chamfer.quality, chamfer.qualityMin, chamfer.qualityMax);
            delete options.chamfer;
          }

          return Body.create(Common.extend({}, trapezoid, options));
        };
        /**
         * Creates a new rigid body model with a circle hull. 
         * The options parameter is an object that specifies any properties you wish to override the defaults.
         * See the properties section of the `Matter.Body` module for detailed information on what you can pass via the `options` object.
         * @method circle
         * @param {number} x
         * @param {number} y
         * @param {number} radius
         * @param {object} [options]
         * @param {number} [maxSides]
         * @return {body} A new circle body
         */


        Bodies.circle = function (x, y, radius, options, maxSides) {
          options = options || {};
          var circle = {
            label: 'Circle Body',
            circleRadius: radius
          }; // approximate circles with polygons until true circles implemented in SAT

          maxSides = maxSides || 25;
          var sides = Math.ceil(Math.max(10, Math.min(maxSides, radius))); // optimisation: always use even number of sides (half the number of unique axes)

          if (sides % 2 === 1) sides += 1;
          return Bodies.polygon(x, y, sides, radius, Common.extend({}, circle, options));
        };
        /**
         * Creates a new rigid body model with a regular polygon hull with the given number of sides. 
         * The options parameter is an object that specifies any properties you wish to override the defaults.
         * See the properties section of the `Matter.Body` module for detailed information on what you can pass via the `options` object.
         * @method polygon
         * @param {number} x
         * @param {number} y
         * @param {number} sides
         * @param {number} radius
         * @param {object} [options]
         * @return {body} A new regular polygon body
         */


        Bodies.polygon = function (x, y, sides, radius, options) {
          options = options || {};
          if (sides < 3) return Bodies.circle(x, y, radius, options);
          var theta = 2 * Math.PI / sides,
              path = '',
              offset = theta * 0.5;

          for (var i = 0; i < sides; i += 1) {
            var angle = offset + i * theta,
                xx = Math.cos(angle) * radius,
                yy = Math.sin(angle) * radius;
            path += 'L ' + xx.toFixed(3) + ' ' + yy.toFixed(3) + ' ';
          }

          var polygon = {
            label: 'Polygon Body',
            position: {
              x: x,
              y: y
            },
            vertices: Vertices.fromPath(path)
          };

          if (options.chamfer) {
            var chamfer = options.chamfer;
            polygon.vertices = Vertices.chamfer(polygon.vertices, chamfer.radius, chamfer.quality, chamfer.qualityMin, chamfer.qualityMax);
            delete options.chamfer;
          }

          return Body.create(Common.extend({}, polygon, options));
        };
        /**
         * Utility to create a compound body based on set(s) of vertices.
         * 
         * _Note:_ To optionally enable automatic concave vertices decomposition the [poly-decomp](https://github.com/schteppe/poly-decomp.js) 
         * package must be first installed and provided see `Common.setDecomp`, otherwise the convex hull of each vertex set will be used.
         * 
         * The resulting vertices are reorientated about their centre of mass,
         * and offset such that `body.position` corresponds to this point.
         * 
         * The resulting offset may be found if needed by subtracting `body.bounds` from the original input bounds.
         * To later move the centre of mass see `Body.setCentre`.
         * 
         * Note that automatic conconcave decomposition results are not always optimal. 
         * For best results, simplify the input vertices as much as possible first.
         * By default this function applies some addtional simplification to help.
         * 
         * Some outputs may also require further manual processing afterwards to be robust.
         * In particular some parts may need to be overlapped to avoid collision gaps.
         * Thin parts and sharp points should be avoided or removed where possible.
         *
         * The options parameter object specifies any `Matter.Body` properties you wish to override the defaults.
         * 
         * See the properties section of the `Matter.Body` module for detailed information on what you can pass via the `options` object.
         * @method fromVertices
         * @param {number} x
         * @param {number} y
         * @param {array} vertexSets One or more arrays of vertex points e.g. `[[{ x: 0, y: 0 }...], ...]`.
         * @param {object} [options] The body options.
         * @param {bool} [flagInternal=false] Optionally marks internal edges with `isInternal`.
         * @param {number} [removeCollinear=0.01] Threshold when simplifying vertices along the same edge.
         * @param {number} [minimumArea=10] Threshold when removing small parts.
         * @param {number} [removeDuplicatePoints=0.01] Threshold when simplifying nearby vertices.
         * @return {body}
         */


        Bodies.fromVertices = function (x, y, vertexSets, options, flagInternal, removeCollinear, minimumArea, removeDuplicatePoints) {
          var decomp = Common.getDecomp(),
              canDecomp,
              body,
              parts,
              isConvex,
              isConcave,
              vertices,
              i,
              j,
              k,
              v,
              z; // check decomp is as expected

          canDecomp = Boolean(decomp && decomp.quickDecomp);
          options = options || {};
          parts = [];
          flagInternal = typeof flagInternal !== 'undefined' ? flagInternal : false;
          removeCollinear = typeof removeCollinear !== 'undefined' ? removeCollinear : 0.01;
          minimumArea = typeof minimumArea !== 'undefined' ? minimumArea : 10;
          removeDuplicatePoints = typeof removeDuplicatePoints !== 'undefined' ? removeDuplicatePoints : 0.01; // ensure vertexSets is an array of arrays

          if (!Common.isArray(vertexSets[0])) {
            vertexSets = [vertexSets];
          }

          for (v = 0; v < vertexSets.length; v += 1) {
            vertices = vertexSets[v];
            isConvex = Vertices.isConvex(vertices);
            isConcave = !isConvex;

            if (isConcave && !canDecomp) {
              Common.warnOnce('Bodies.fromVertices: Install the \'poly-decomp\' library and use Common.setDecomp or provide \'decomp\' as a global to decompose concave vertices.');
            }

            if (isConvex || !canDecomp) {
              if (isConvex) {
                vertices = Vertices.clockwiseSort(vertices);
              } else {
                // fallback to convex hull when decomposition is not possible
                vertices = Vertices.hull(vertices);
              }

              parts.push({
                position: {
                  x: x,
                  y: y
                },
                vertices: vertices
              });
            } else {
              // initialise a decomposition
              var concave = vertices.map(function (vertex) {
                return [vertex.x, vertex.y];
              }); // vertices are concave and simple, we can decompose into parts

              decomp.makeCCW(concave);
              if (removeCollinear !== false) decomp.removeCollinearPoints(concave, removeCollinear);
              if (removeDuplicatePoints !== false && decomp.removeDuplicatePoints) decomp.removeDuplicatePoints(concave, removeDuplicatePoints); // use the quick decomposition algorithm (Bayazit)

              var decomposed = decomp.quickDecomp(concave); // for each decomposed chunk

              for (i = 0; i < decomposed.length; i++) {
                var chunk = decomposed[i]; // convert vertices into the correct structure

                var chunkVertices = chunk.map(function (vertices) {
                  return {
                    x: vertices[0],
                    y: vertices[1]
                  };
                }); // skip small chunks

                if (minimumArea > 0 && Vertices.area(chunkVertices) < minimumArea) continue; // create a compound part

                parts.push({
                  position: Vertices.centre(chunkVertices),
                  vertices: chunkVertices
                });
              }
            }
          } // create body parts


          for (i = 0; i < parts.length; i++) {
            parts[i] = Body.create(Common.extend(parts[i], options));
          } // flag internal edges (coincident part edges)


          if (flagInternal) {
            var coincident_max_dist = 5;

            for (i = 0; i < parts.length; i++) {
              var partA = parts[i];

              for (j = i + 1; j < parts.length; j++) {
                var partB = parts[j];

                if (Bounds.overlaps(partA.bounds, partB.bounds)) {
                  var pav = partA.vertices,
                      pbv = partB.vertices; // iterate vertices of both parts

                  for (k = 0; k < partA.vertices.length; k++) {
                    for (z = 0; z < partB.vertices.length; z++) {
                      // find distances between the vertices
                      var da = Vector.magnitudeSquared(Vector.sub(pav[(k + 1) % pav.length], pbv[z])),
                          db = Vector.magnitudeSquared(Vector.sub(pav[k], pbv[(z + 1) % pbv.length])); // if both vertices are very close, consider the edge concident (internal)

                      if (da < coincident_max_dist && db < coincident_max_dist) {
                        pav[k].isInternal = true;
                        pbv[z].isInternal = true;
                      }
                    }
                  }
                }
              }
            }
          }

          if (parts.length > 1) {
            // create the parent body to be returned, that contains generated compound parts
            body = Body.create(Common.extend({
              parts: parts.slice(0)
            }, options)); // offset such that body.position is at the centre off mass

            Body.setPosition(body, {
              x: x,
              y: y
            });
            return body;
          } else {
            return parts[0];
          }
        };
      })();
      /***/

    },
    /* 12 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * The `Matter.Mouse` module contains methods for creating and manipulating mouse inputs.
      *
      * @class Mouse
      */
      var Mouse = {};
      module.exports = Mouse;

      var Common = __webpack_require__(0);

      (function () {
        /**
         * Creates a mouse input.
         * @method create
         * @param {HTMLElement} element
         * @return {mouse} A new mouse
         */
        Mouse.create = function (element) {
          var mouse = {};

          if (!element) {
            Common.log('Mouse.create: element was undefined, defaulting to document.body', 'warn');
          }

          mouse.element = element || document.body;
          mouse.absolute = {
            x: 0,
            y: 0
          };
          mouse.position = {
            x: 0,
            y: 0
          };
          mouse.mousedownPosition = {
            x: 0,
            y: 0
          };
          mouse.mouseupPosition = {
            x: 0,
            y: 0
          };
          mouse.offset = {
            x: 0,
            y: 0
          };
          mouse.scale = {
            x: 1,
            y: 1
          };
          mouse.wheelDelta = 0;
          mouse.button = -1;
          mouse.pixelRatio = parseInt(mouse.element.getAttribute('data-pixel-ratio'), 10) || 1;
          mouse.sourceEvents = {
            mousemove: null,
            mousedown: null,
            mouseup: null,
            mousewheel: null
          };

          mouse.mousemove = function (event) {
            var position = Mouse._getRelativeMousePosition(event, mouse.element, mouse.pixelRatio),
                touches = event.changedTouches;

            if (touches) {
              mouse.button = 0;
              event.preventDefault();
            }

            mouse.absolute.x = position.x;
            mouse.absolute.y = position.y;
            mouse.position.x = mouse.absolute.x * mouse.scale.x + mouse.offset.x;
            mouse.position.y = mouse.absolute.y * mouse.scale.y + mouse.offset.y;
            mouse.sourceEvents.mousemove = event;
          };

          mouse.mousedown = function (event) {
            var position = Mouse._getRelativeMousePosition(event, mouse.element, mouse.pixelRatio),
                touches = event.changedTouches;

            if (touches) {
              mouse.button = 0;
              event.preventDefault();
            } else {
              mouse.button = event.button;
            }

            mouse.absolute.x = position.x;
            mouse.absolute.y = position.y;
            mouse.position.x = mouse.absolute.x * mouse.scale.x + mouse.offset.x;
            mouse.position.y = mouse.absolute.y * mouse.scale.y + mouse.offset.y;
            mouse.mousedownPosition.x = mouse.position.x;
            mouse.mousedownPosition.y = mouse.position.y;
            mouse.sourceEvents.mousedown = event;
          };

          mouse.mouseup = function (event) {
            var position = Mouse._getRelativeMousePosition(event, mouse.element, mouse.pixelRatio),
                touches = event.changedTouches;

            if (touches) {
              event.preventDefault();
            }

            mouse.button = -1;
            mouse.absolute.x = position.x;
            mouse.absolute.y = position.y;
            mouse.position.x = mouse.absolute.x * mouse.scale.x + mouse.offset.x;
            mouse.position.y = mouse.absolute.y * mouse.scale.y + mouse.offset.y;
            mouse.mouseupPosition.x = mouse.position.x;
            mouse.mouseupPosition.y = mouse.position.y;
            mouse.sourceEvents.mouseup = event;
          };

          mouse.mousewheel = function (event) {
            mouse.wheelDelta = Math.max(-1, Math.min(1, event.wheelDelta || -event.detail));
            event.preventDefault();
          };

          Mouse.setElement(mouse, mouse.element);
          return mouse;
        };
        /**
         * Sets the element the mouse is bound to (and relative to).
         * @method setElement
         * @param {mouse} mouse
         * @param {HTMLElement} element
         */


        Mouse.setElement = function (mouse, element) {
          mouse.element = element;
          element.addEventListener('mousemove', mouse.mousemove);
          element.addEventListener('mousedown', mouse.mousedown);
          element.addEventListener('mouseup', mouse.mouseup);
          element.addEventListener('mousewheel', mouse.mousewheel);
          element.addEventListener('DOMMouseScroll', mouse.mousewheel);
          element.addEventListener('touchmove', mouse.mousemove);
          element.addEventListener('touchstart', mouse.mousedown);
          element.addEventListener('touchend', mouse.mouseup);
        };
        /**
         * Clears all captured source events.
         * @method clearSourceEvents
         * @param {mouse} mouse
         */


        Mouse.clearSourceEvents = function (mouse) {
          mouse.sourceEvents.mousemove = null;
          mouse.sourceEvents.mousedown = null;
          mouse.sourceEvents.mouseup = null;
          mouse.sourceEvents.mousewheel = null;
          mouse.wheelDelta = 0;
        };
        /**
         * Sets the mouse position offset.
         * @method setOffset
         * @param {mouse} mouse
         * @param {vector} offset
         */


        Mouse.setOffset = function (mouse, offset) {
          mouse.offset.x = offset.x;
          mouse.offset.y = offset.y;
          mouse.position.x = mouse.absolute.x * mouse.scale.x + mouse.offset.x;
          mouse.position.y = mouse.absolute.y * mouse.scale.y + mouse.offset.y;
        };
        /**
         * Sets the mouse position scale.
         * @method setScale
         * @param {mouse} mouse
         * @param {vector} scale
         */


        Mouse.setScale = function (mouse, scale) {
          mouse.scale.x = scale.x;
          mouse.scale.y = scale.y;
          mouse.position.x = mouse.absolute.x * mouse.scale.x + mouse.offset.x;
          mouse.position.y = mouse.absolute.y * mouse.scale.y + mouse.offset.y;
        };
        /**
         * Gets the mouse position relative to an element given a screen pixel ratio.
         * @method _getRelativeMousePosition
         * @private
         * @param {} event
         * @param {} element
         * @param {number} pixelRatio
         * @return {}
         */


        Mouse._getRelativeMousePosition = function (event, element, pixelRatio) {
          var elementBounds = element.getBoundingClientRect(),
              rootNode = document.documentElement || document.body.parentNode || document.body,
              scrollX = window.pageXOffset !== undefined ? window.pageXOffset : rootNode.scrollLeft,
              scrollY = window.pageYOffset !== undefined ? window.pageYOffset : rootNode.scrollTop,
              touches = event.changedTouches,
              x,
              y;

          if (touches) {
            x = touches[0].pageX - elementBounds.left - scrollX;
            y = touches[0].pageY - elementBounds.top - scrollY;
          } else {
            x = event.pageX - elementBounds.left - scrollX;
            y = event.pageY - elementBounds.top - scrollY;
          }

          return {
            x: x / (element.clientWidth / (element.width || element.clientWidth) * pixelRatio),
            y: y / (element.clientHeight / (element.height || element.clientHeight) * pixelRatio)
          };
        };
      })();
      /***/

    },
    /* 13 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * The `Matter.Detector` module contains methods for detecting collisions given a set of pairs.
      *
      * @class Detector
      */
      // TODO: speculative contacts
      var Detector = {};
      module.exports = Detector;

      var SAT = __webpack_require__(14);

      var Pair = __webpack_require__(9);

      var Bounds = __webpack_require__(1);

      (function () {
        /**
         * Finds all collisions given a list of pairs.
         * @method collisions
         * @param {pair[]} broadphasePairs
         * @param {engine} engine
         * @return {array} collisions
         */
        Detector.collisions = function (broadphasePairs, engine) {
          var collisions = [],
              pairsTable = engine.pairs.table;

          for (var i = 0; i < broadphasePairs.length; i++) {
            var bodyA = broadphasePairs[i][0],
                bodyB = broadphasePairs[i][1];
            if ((bodyA.isStatic || bodyA.isSleeping) && (bodyB.isStatic || bodyB.isSleeping)) continue;
            if (!Detector.canCollide(bodyA.collisionFilter, bodyB.collisionFilter)) continue; // mid phase

            if (Bounds.overlaps(bodyA.bounds, bodyB.bounds)) {
              for (var j = bodyA.parts.length > 1 ? 1 : 0; j < bodyA.parts.length; j++) {
                var partA = bodyA.parts[j];

                for (var k = bodyB.parts.length > 1 ? 1 : 0; k < bodyB.parts.length; k++) {
                  var partB = bodyB.parts[k];

                  if (partA === bodyA && partB === bodyB || Bounds.overlaps(partA.bounds, partB.bounds)) {
                    // find a previous collision we could reuse
                    var pairId = Pair.id(partA, partB),
                        pair = pairsTable[pairId],
                        previousCollision;

                    if (pair && pair.isActive) {
                      previousCollision = pair.collision;
                    } else {
                      previousCollision = null;
                    } // narrow phase


                    var collision = SAT.collides(partA, partB, previousCollision);

                    if (collision.collided) {
                      collisions.push(collision);
                    }
                  }
                }
              }
            }
          }

          return collisions;
        };
        /**
         * Returns `true` if both supplied collision filters will allow a collision to occur.
         * See `body.collisionFilter` for more information.
         * @method canCollide
         * @param {} filterA
         * @param {} filterB
         * @return {bool} `true` if collision can occur
         */


        Detector.canCollide = function (filterA, filterB) {
          if (filterA.group === filterB.group && filterA.group !== 0) return filterA.group > 0;
          return (filterA.mask & filterB.category) !== 0 && (filterB.mask & filterA.category) !== 0;
        };
      })();
      /***/

    },
    /* 14 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * The `Matter.SAT` module contains methods for detecting collisions using the Separating Axis Theorem.
      *
      * @class SAT
      */
      // TODO: true circles and curves
      var SAT = {};
      module.exports = SAT;

      var Vertices = __webpack_require__(3);

      var Vector = __webpack_require__(2);

      (function () {
        /**
         * Detect collision between two bodies using the Separating Axis Theorem.
         * @method collides
         * @param {body} bodyA
         * @param {body} bodyB
         * @param {collision} previousCollision
         * @return {collision} collision
         */
        SAT.collides = function (bodyA, bodyB, previousCollision) {
          var overlapAB,
              overlapBA,
              minOverlap,
              collision,
              canReusePrevCol = false;

          if (previousCollision) {
            // estimate total motion
            var parentA = bodyA.parent,
                parentB = bodyB.parent,
                motion = parentA.speed * parentA.speed + parentA.angularSpeed * parentA.angularSpeed + parentB.speed * parentB.speed + parentB.angularSpeed * parentB.angularSpeed; // we may be able to (partially) reuse collision result 
            // but only safe if collision was resting

            canReusePrevCol = previousCollision && previousCollision.collided && motion < 0.2; // reuse collision object

            collision = previousCollision;
          } else {
            collision = {
              collided: false,
              bodyA: bodyA,
              bodyB: bodyB
            };
          }

          if (previousCollision && canReusePrevCol) {
            // if we can reuse the collision result
            // we only need to test the previously found axis
            var axisBodyA = collision.axisBody,
                axisBodyB = axisBodyA === bodyA ? bodyB : bodyA,
                axes = [axisBodyA.axes[previousCollision.axisNumber]];
            minOverlap = SAT._overlapAxes(axisBodyA.vertices, axisBodyB.vertices, axes);
            collision.reused = true;

            if (minOverlap.overlap <= 0) {
              collision.collided = false;
              return collision;
            }
          } else {
            // if we can't reuse a result, perform a full SAT test
            overlapAB = SAT._overlapAxes(bodyA.vertices, bodyB.vertices, bodyA.axes);

            if (overlapAB.overlap <= 0) {
              collision.collided = false;
              return collision;
            }

            overlapBA = SAT._overlapAxes(bodyB.vertices, bodyA.vertices, bodyB.axes);

            if (overlapBA.overlap <= 0) {
              collision.collided = false;
              return collision;
            }

            if (overlapAB.overlap < overlapBA.overlap) {
              minOverlap = overlapAB;
              collision.axisBody = bodyA;
            } else {
              minOverlap = overlapBA;
              collision.axisBody = bodyB;
            } // important for reuse later


            collision.axisNumber = minOverlap.axisNumber;
          }

          collision.bodyA = bodyA.id < bodyB.id ? bodyA : bodyB;
          collision.bodyB = bodyA.id < bodyB.id ? bodyB : bodyA;
          collision.collided = true;
          collision.depth = minOverlap.overlap;
          collision.parentA = collision.bodyA.parent;
          collision.parentB = collision.bodyB.parent;
          bodyA = collision.bodyA;
          bodyB = collision.bodyB; // ensure normal is facing away from bodyA

          if (Vector.dot(minOverlap.axis, Vector.sub(bodyB.position, bodyA.position)) < 0) {
            collision.normal = {
              x: minOverlap.axis.x,
              y: minOverlap.axis.y
            };
          } else {
            collision.normal = {
              x: -minOverlap.axis.x,
              y: -minOverlap.axis.y
            };
          }

          collision.tangent = Vector.perp(collision.normal);
          collision.penetration = collision.penetration || {};
          collision.penetration.x = collision.normal.x * collision.depth;
          collision.penetration.y = collision.normal.y * collision.depth; // find support points, there is always either exactly one or two

          var verticesB = SAT._findSupports(bodyA, bodyB, collision.normal),
              supports = []; // find the supports from bodyB that are inside bodyA


          if (Vertices.contains(bodyA.vertices, verticesB[0])) supports.push(verticesB[0]);
          if (Vertices.contains(bodyA.vertices, verticesB[1])) supports.push(verticesB[1]); // find the supports from bodyA that are inside bodyB

          if (supports.length < 2) {
            var verticesA = SAT._findSupports(bodyB, bodyA, Vector.neg(collision.normal));

            if (Vertices.contains(bodyB.vertices, verticesA[0])) supports.push(verticesA[0]);
            if (supports.length < 2 && Vertices.contains(bodyB.vertices, verticesA[1])) supports.push(verticesA[1]);
          } // account for the edge case of overlapping but no vertex containment


          if (supports.length < 1) supports = [verticesB[0]];
          collision.supports = supports;
          return collision;
        };
        /**
         * Find the overlap between two sets of vertices.
         * @method _overlapAxes
         * @private
         * @param {} verticesA
         * @param {} verticesB
         * @param {} axes
         * @return result
         */


        SAT._overlapAxes = function (verticesA, verticesB, axes) {
          var projectionA = Vector._temp[0],
              projectionB = Vector._temp[1],
              result = {
            overlap: Number.MAX_VALUE
          },
              overlap,
              axis;

          for (var i = 0; i < axes.length; i++) {
            axis = axes[i];

            SAT._projectToAxis(projectionA, verticesA, axis);

            SAT._projectToAxis(projectionB, verticesB, axis);

            overlap = Math.min(projectionA.max - projectionB.min, projectionB.max - projectionA.min);

            if (overlap <= 0) {
              result.overlap = overlap;
              return result;
            }

            if (overlap < result.overlap) {
              result.overlap = overlap;
              result.axis = axis;
              result.axisNumber = i;
            }
          }

          return result;
        };
        /**
         * Projects vertices on an axis and returns an interval.
         * @method _projectToAxis
         * @private
         * @param {} projection
         * @param {} vertices
         * @param {} axis
         */


        SAT._projectToAxis = function (projection, vertices, axis) {
          var min = Vector.dot(vertices[0], axis),
              max = min;

          for (var i = 1; i < vertices.length; i += 1) {
            var dot = Vector.dot(vertices[i], axis);

            if (dot > max) {
              max = dot;
            } else if (dot < min) {
              min = dot;
            }
          }

          projection.min = min;
          projection.max = max;
        };
        /**
         * Finds supporting vertices given two bodies along a given direction using hill-climbing.
         * @method _findSupports
         * @private
         * @param {} bodyA
         * @param {} bodyB
         * @param {} normal
         * @return [vector]
         */


        SAT._findSupports = function (bodyA, bodyB, normal) {
          var nearestDistance = Number.MAX_VALUE,
              vertexToBody = Vector._temp[0],
              vertices = bodyB.vertices,
              bodyAPosition = bodyA.position,
              distance,
              vertex,
              vertexA,
              vertexB; // find closest vertex on bodyB

          for (var i = 0; i < vertices.length; i++) {
            vertex = vertices[i];
            vertexToBody.x = vertex.x - bodyAPosition.x;
            vertexToBody.y = vertex.y - bodyAPosition.y;
            distance = -Vector.dot(normal, vertexToBody);

            if (distance < nearestDistance) {
              nearestDistance = distance;
              vertexA = vertex;
            }
          } // find next closest vertex using the two connected to it


          var prevIndex = vertexA.index - 1 >= 0 ? vertexA.index - 1 : vertices.length - 1;
          vertex = vertices[prevIndex];
          vertexToBody.x = vertex.x - bodyAPosition.x;
          vertexToBody.y = vertex.y - bodyAPosition.y;
          nearestDistance = -Vector.dot(normal, vertexToBody);
          vertexB = vertex;
          var nextIndex = (vertexA.index + 1) % vertices.length;
          vertex = vertices[nextIndex];
          vertexToBody.x = vertex.x - bodyAPosition.x;
          vertexToBody.y = vertex.y - bodyAPosition.y;
          distance = -Vector.dot(normal, vertexToBody);

          if (distance < nearestDistance) {
            vertexB = vertex;
          }

          return [vertexA, vertexB];
        };
      })();
      /***/

    },
    /* 15 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * The `Matter.Plugin` module contains functions for registering and installing plugins on modules.
      *
      * @class Plugin
      */
      var Plugin = {};
      module.exports = Plugin;

      var Common = __webpack_require__(0);

      (function () {
        Plugin._registry = {};
        /**
         * Registers a plugin object so it can be resolved later by name.
         * @method register
         * @param plugin {} The plugin to register.
         * @return {object} The plugin.
         */

        Plugin.register = function (plugin) {
          if (!Plugin.isPlugin(plugin)) {
            Common.warn('Plugin.register:', Plugin.toString(plugin), 'does not implement all required fields.');
          }

          if (plugin.name in Plugin._registry) {
            var registered = Plugin._registry[plugin.name],
                pluginVersion = Plugin.versionParse(plugin.version).number,
                registeredVersion = Plugin.versionParse(registered.version).number;

            if (pluginVersion > registeredVersion) {
              Common.warn('Plugin.register:', Plugin.toString(registered), 'was upgraded to', Plugin.toString(plugin));
              Plugin._registry[plugin.name] = plugin;
            } else if (pluginVersion < registeredVersion) {
              Common.warn('Plugin.register:', Plugin.toString(registered), 'can not be downgraded to', Plugin.toString(plugin));
            } else if (plugin !== registered) {
              Common.warn('Plugin.register:', Plugin.toString(plugin), 'is already registered to different plugin object');
            }
          } else {
            Plugin._registry[plugin.name] = plugin;
          }

          return plugin;
        };
        /**
         * Resolves a dependency to a plugin object from the registry if it exists. 
         * The `dependency` may contain a version, but only the name matters when resolving.
         * @method resolve
         * @param dependency {string} The dependency.
         * @return {object} The plugin if resolved, otherwise `undefined`.
         */


        Plugin.resolve = function (dependency) {
          return Plugin._registry[Plugin.dependencyParse(dependency).name];
        };
        /**
         * Returns a pretty printed plugin name and version.
         * @method toString
         * @param plugin {} The plugin.
         * @return {string} Pretty printed plugin name and version.
         */


        Plugin.toString = function (plugin) {
          return typeof plugin === 'string' ? plugin : (plugin.name || 'anonymous') + '@' + (plugin.version || plugin.range || '0.0.0');
        };
        /**
         * Returns `true` if the object meets the minimum standard to be considered a plugin.
         * This means it must define the following properties:
         * - `name`
         * - `version`
         * - `install`
         * @method isPlugin
         * @param obj {} The obj to test.
         * @return {boolean} `true` if the object can be considered a plugin otherwise `false`.
         */


        Plugin.isPlugin = function (obj) {
          return obj && obj.name && obj.version && obj.install;
        };
        /**
         * Returns `true` if a plugin with the given `name` been installed on `module`.
         * @method isUsed
         * @param module {} The module.
         * @param name {string} The plugin name.
         * @return {boolean} `true` if a plugin with the given `name` been installed on `module`, otherwise `false`.
         */


        Plugin.isUsed = function (module, name) {
          return module.used.indexOf(name) > -1;
        };
        /**
         * Returns `true` if `plugin.for` is applicable to `module` by comparing against `module.name` and `module.version`.
         * If `plugin.for` is not specified then it is assumed to be applicable.
         * The value of `plugin.for` is a string of the format `'module-name'` or `'module-name@version'`.
         * @method isFor
         * @param plugin {} The plugin.
         * @param module {} The module.
         * @return {boolean} `true` if `plugin.for` is applicable to `module`, otherwise `false`.
         */


        Plugin.isFor = function (plugin, module) {
          var parsed = plugin["for"] && Plugin.dependencyParse(plugin["for"]);
          return !plugin["for"] || module.name === parsed.name && Plugin.versionSatisfies(module.version, parsed.range);
        };
        /**
         * Installs the plugins by calling `plugin.install` on each plugin specified in `plugins` if passed, otherwise `module.uses`.
         * For installing plugins on `Matter` see the convenience function `Matter.use`.
         * Plugins may be specified either by their name or a reference to the plugin object.
         * Plugins themselves may specify further dependencies, but each plugin is installed only once.
         * Order is important, a topological sort is performed to find the best resulting order of installation.
         * This sorting attempts to satisfy every dependency's requested ordering, but may not be exact in all cases.
         * This function logs the resulting status of each dependency in the console, along with any warnings.
         * - A green tick ✅ indicates a dependency was resolved and installed.
         * - An orange diamond 🔶 indicates a dependency was resolved but a warning was thrown for it or one if its dependencies.
         * - A red cross ❌ indicates a dependency could not be resolved.
         * Avoid calling this function multiple times on the same module unless you intend to manually control installation order.
         * @method use
         * @param module {} The module install plugins on.
         * @param [plugins=module.uses] {} The plugins to install on module (optional, defaults to `module.uses`).
         */


        Plugin.use = function (module, plugins) {
          module.uses = (module.uses || []).concat(plugins || []);

          if (module.uses.length === 0) {
            Common.warn('Plugin.use:', Plugin.toString(module), 'does not specify any dependencies to install.');
            return;
          }

          var dependencies = Plugin.dependencies(module),
              sortedDependencies = Common.topologicalSort(dependencies),
              status = [];

          for (var i = 0; i < sortedDependencies.length; i += 1) {
            if (sortedDependencies[i] === module.name) {
              continue;
            }

            var plugin = Plugin.resolve(sortedDependencies[i]);

            if (!plugin) {
              status.push('❌ ' + sortedDependencies[i]);
              continue;
            }

            if (Plugin.isUsed(module, plugin.name)) {
              continue;
            }

            if (!Plugin.isFor(plugin, module)) {
              Common.warn('Plugin.use:', Plugin.toString(plugin), 'is for', plugin["for"], 'but installed on', Plugin.toString(module) + '.');
              plugin._warned = true;
            }

            if (plugin.install) {
              plugin.install(module);
            } else {
              Common.warn('Plugin.use:', Plugin.toString(plugin), 'does not specify an install function.');
              plugin._warned = true;
            }

            if (plugin._warned) {
              status.push('🔶 ' + Plugin.toString(plugin));
              delete plugin._warned;
            } else {
              status.push('✅ ' + Plugin.toString(plugin));
            }

            module.used.push(plugin.name);
          }

          if (status.length > 0) {
            Common.info(status.join('  '));
          }
        };
        /**
         * Recursively finds all of a module's dependencies and returns a flat dependency graph.
         * @method dependencies
         * @param module {} The module.
         * @return {object} A dependency graph.
         */


        Plugin.dependencies = function (module, tracked) {
          var parsedBase = Plugin.dependencyParse(module),
              name = parsedBase.name;
          tracked = tracked || {};

          if (name in tracked) {
            return;
          }

          module = Plugin.resolve(module) || module;
          tracked[name] = Common.map(module.uses || [], function (dependency) {
            if (Plugin.isPlugin(dependency)) {
              Plugin.register(dependency);
            }

            var parsed = Plugin.dependencyParse(dependency),
                resolved = Plugin.resolve(dependency);

            if (resolved && !Plugin.versionSatisfies(resolved.version, parsed.range)) {
              Common.warn('Plugin.dependencies:', Plugin.toString(resolved), 'does not satisfy', Plugin.toString(parsed), 'used by', Plugin.toString(parsedBase) + '.');
              resolved._warned = true;
              module._warned = true;
            } else if (!resolved) {
              Common.warn('Plugin.dependencies:', Plugin.toString(dependency), 'used by', Plugin.toString(parsedBase), 'could not be resolved.');
              module._warned = true;
            }

            return parsed.name;
          });

          for (var i = 0; i < tracked[name].length; i += 1) {
            Plugin.dependencies(tracked[name][i], tracked);
          }

          return tracked;
        };
        /**
         * Parses a dependency string into its components.
         * The `dependency` is a string of the format `'module-name'` or `'module-name@version'`.
         * See documentation for `Plugin.versionParse` for a description of the format.
         * This function can also handle dependencies that are already resolved (e.g. a module object).
         * @method dependencyParse
         * @param dependency {string} The dependency of the format `'module-name'` or `'module-name@version'`.
         * @return {object} The dependency parsed into its components.
         */


        Plugin.dependencyParse = function (dependency) {
          if (Common.isString(dependency)) {
            var pattern = /^[\w-]+(@(\*|[\^~]?\d+\.\d+\.\d+(-[0-9A-Za-z-]+)?))?$/;

            if (!pattern.test(dependency)) {
              Common.warn('Plugin.dependencyParse:', dependency, 'is not a valid dependency string.');
            }

            return {
              name: dependency.split('@')[0],
              range: dependency.split('@')[1] || '*'
            };
          }

          return {
            name: dependency.name,
            range: dependency.range || dependency.version
          };
        };
        /**
         * Parses a version string into its components.  
         * Versions are strictly of the format `x.y.z` (as in [semver](http://semver.org/)).
         * Versions may optionally have a prerelease tag in the format `x.y.z-alpha`.
         * Ranges are a strict subset of [npm ranges](https://docs.npmjs.com/misc/semver#advanced-range-syntax).
         * Only the following range types are supported:
         * - Tilde ranges e.g. `~1.2.3`
         * - Caret ranges e.g. `^1.2.3`
         * - Greater than ranges e.g. `>1.2.3`
         * - Greater than or equal ranges e.g. `>=1.2.3`
         * - Exact version e.g. `1.2.3`
         * - Any version `*`
         * @method versionParse
         * @param range {string} The version string.
         * @return {object} The version range parsed into its components.
         */


        Plugin.versionParse = function (range) {
          var pattern = /^(\*)|(\^|~|>=|>)?\s*((\d+)\.(\d+)\.(\d+))(-[0-9A-Za-z-]+)?$/;

          if (!pattern.test(range)) {
            Common.warn('Plugin.versionParse:', range, 'is not a valid version or range.');
          }

          var parts = pattern.exec(range);
          var major = Number(parts[4]);
          var minor = Number(parts[5]);
          var patch = Number(parts[6]);
          return {
            isRange: Boolean(parts[1] || parts[2]),
            version: parts[3],
            range: range,
            operator: parts[1] || parts[2] || '',
            major: major,
            minor: minor,
            patch: patch,
            parts: [major, minor, patch],
            prerelease: parts[7],
            number: major * 1e8 + minor * 1e4 + patch
          };
        };
        /**
         * Returns `true` if `version` satisfies the given `range`.
         * See documentation for `Plugin.versionParse` for a description of the format.
         * If a version or range is not specified, then any version (`*`) is assumed to satisfy.
         * @method versionSatisfies
         * @param version {string} The version string.
         * @param range {string} The range string.
         * @return {boolean} `true` if `version` satisfies `range`, otherwise `false`.
         */


        Plugin.versionSatisfies = function (version, range) {
          range = range || '*';
          var r = Plugin.versionParse(range),
              v = Plugin.versionParse(version);

          if (r.isRange) {
            if (r.operator === '*' || version === '*') {
              return true;
            }

            if (r.operator === '>') {
              return v.number > r.number;
            }

            if (r.operator === '>=') {
              return v.number >= r.number;
            }

            if (r.operator === '~') {
              return v.major === r.major && v.minor === r.minor && v.patch >= r.patch;
            }

            if (r.operator === '^') {
              if (r.major > 0) {
                return v.major === r.major && v.number >= r.number;
              }

              if (r.minor > 0) {
                return v.minor === r.minor && v.patch >= r.patch;
              }

              return v.patch === r.patch;
            }
          }

          return version === range || version === '*';
        };
      })();
      /***/

    },
    /* 16 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * The `Matter.Render` module is a simple canvas based renderer for visualising instances of `Matter.Engine`.
      * It is intended for development and debugging purposes, but may also be suitable for simple games.
      * It includes a number of drawing options including wireframe, vector with support for sprites and viewports.
      *
      * @class Render
      */
      var Render = {};
      module.exports = Render;

      var Common = __webpack_require__(0);

      var Composite = __webpack_require__(5);

      var Bounds = __webpack_require__(1);

      var Events = __webpack_require__(4);

      var Vector = __webpack_require__(2);

      var Mouse = __webpack_require__(12);

      (function () {
        var _requestAnimationFrame, _cancelAnimationFrame;

        if (typeof window !== 'undefined') {
          _requestAnimationFrame = window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.msRequestAnimationFrame || function (callback) {
            window.setTimeout(function () {
              callback(Common.now());
            }, 1000 / 60);
          };

          _cancelAnimationFrame = window.cancelAnimationFrame || window.mozCancelAnimationFrame || window.webkitCancelAnimationFrame || window.msCancelAnimationFrame;
        }

        Render._goodFps = 30;
        Render._goodDelta = 1000 / 60;
        /**
         * Creates a new renderer. The options parameter is an object that specifies any properties you wish to override the defaults.
         * All properties have default values, and many are pre-calculated automatically based on other properties.
         * See the properties section below for detailed information on what you can pass via the `options` object.
         * @method create
         * @param {object} [options]
         * @return {render} A new renderer
         */

        Render.create = function (options) {
          var defaults = {
            controller: Render,
            engine: null,
            element: null,
            canvas: null,
            mouse: null,
            frameRequestId: null,
            timing: {
              historySize: 60,
              delta: 0,
              deltaHistory: [],
              lastTime: 0,
              lastTimestamp: 0,
              lastElapsed: 0,
              timestampElapsed: 0,
              timestampElapsedHistory: [],
              engineDeltaHistory: [],
              engineElapsedHistory: [],
              elapsedHistory: []
            },
            options: {
              width: 800,
              height: 600,
              pixelRatio: 1,
              background: '#14151f',
              wireframeBackground: '#14151f',
              hasBounds: !!options.bounds,
              enabled: true,
              wireframes: true,
              showSleeping: true,
              showDebug: false,
              showStats: false,
              showPerformance: false,
              showBroadphase: false,
              showBounds: false,
              showVelocity: false,
              showCollisions: false,
              showSeparations: false,
              showAxes: false,
              showPositions: false,
              showAngleIndicator: false,
              showIds: false,
              showVertexNumbers: false,
              showConvexHulls: false,
              showInternalEdges: false,
              showMousePosition: false
            }
          };
          var render = Common.extend(defaults, options);

          if (render.canvas) {
            render.canvas.width = render.options.width || render.canvas.width;
            render.canvas.height = render.options.height || render.canvas.height;
          }

          render.mouse = options.mouse;
          render.engine = options.engine;
          render.canvas = render.canvas || _createCanvas(render.options.width, render.options.height);
          render.context = render.canvas.getContext('2d');
          render.textures = {};
          render.bounds = render.bounds || {
            min: {
              x: 0,
              y: 0
            },
            max: {
              x: render.canvas.width,
              y: render.canvas.height
            }
          };

          if (render.options.pixelRatio !== 1) {
            Render.setPixelRatio(render, render.options.pixelRatio);
          }

          if (Common.isElement(render.element)) {
            render.element.appendChild(render.canvas);
          } else if (!render.canvas.parentNode) {
            Common.log('Render.create: options.element was undefined, render.canvas was created but not appended', 'warn');
          }

          return render;
        };
        /**
         * Continuously updates the render canvas on the `requestAnimationFrame` event.
         * @method run
         * @param {render} render
         */


        Render.run = function (render) {
          (function loop(time) {
            render.frameRequestId = _requestAnimationFrame(loop);

            _updateTiming(render, time);

            Render.world(render, time);

            if (render.options.showStats || render.options.showDebug) {
              Render.stats(render, render.context, time);
            }

            if (render.options.showPerformance || render.options.showDebug) {
              Render.performance(render, render.context, time);
            }
          })();
        };
        /**
         * Ends execution of `Render.run` on the given `render`, by canceling the animation frame request event loop.
         * @method stop
         * @param {render} render
         */


        Render.stop = function (render) {
          _cancelAnimationFrame(render.frameRequestId);
        };
        /**
         * Sets the pixel ratio of the renderer and updates the canvas.
         * To automatically detect the correct ratio, pass the string `'auto'` for `pixelRatio`.
         * @method setPixelRatio
         * @param {render} render
         * @param {number} pixelRatio
         */


        Render.setPixelRatio = function (render, pixelRatio) {
          var options = render.options,
              canvas = render.canvas;

          if (pixelRatio === 'auto') {
            pixelRatio = _getPixelRatio(canvas);
          }

          options.pixelRatio = pixelRatio;
          canvas.setAttribute('data-pixel-ratio', pixelRatio);
          canvas.width = options.width * pixelRatio;
          canvas.height = options.height * pixelRatio;
          canvas.style.width = options.width + 'px';
          canvas.style.height = options.height + 'px';
        };
        /**
         * Positions and sizes the viewport around the given object bounds.
         * Objects must have at least one of the following properties:
         * - `object.bounds`
         * - `object.position`
         * - `object.min` and `object.max`
         * - `object.x` and `object.y`
         * @method lookAt
         * @param {render} render
         * @param {object[]} objects
         * @param {vector} [padding]
         * @param {bool} [center=true]
         */


        Render.lookAt = function (render, objects, padding, center) {
          center = typeof center !== 'undefined' ? center : true;
          objects = Common.isArray(objects) ? objects : [objects];
          padding = padding || {
            x: 0,
            y: 0
          }; // find bounds of all objects

          var bounds = {
            min: {
              x: Infinity,
              y: Infinity
            },
            max: {
              x: -Infinity,
              y: -Infinity
            }
          };

          for (var i = 0; i < objects.length; i += 1) {
            var object = objects[i],
                min = object.bounds ? object.bounds.min : object.min || object.position || object,
                max = object.bounds ? object.bounds.max : object.max || object.position || object;

            if (min && max) {
              if (min.x < bounds.min.x) bounds.min.x = min.x;
              if (max.x > bounds.max.x) bounds.max.x = max.x;
              if (min.y < bounds.min.y) bounds.min.y = min.y;
              if (max.y > bounds.max.y) bounds.max.y = max.y;
            }
          } // find ratios


          var width = bounds.max.x - bounds.min.x + 2 * padding.x,
              height = bounds.max.y - bounds.min.y + 2 * padding.y,
              viewHeight = render.canvas.height,
              viewWidth = render.canvas.width,
              outerRatio = viewWidth / viewHeight,
              innerRatio = width / height,
              scaleX = 1,
              scaleY = 1; // find scale factor

          if (innerRatio > outerRatio) {
            scaleY = innerRatio / outerRatio;
          } else {
            scaleX = outerRatio / innerRatio;
          } // enable bounds


          render.options.hasBounds = true; // position and size

          render.bounds.min.x = bounds.min.x;
          render.bounds.max.x = bounds.min.x + width * scaleX;
          render.bounds.min.y = bounds.min.y;
          render.bounds.max.y = bounds.min.y + height * scaleY; // center

          if (center) {
            render.bounds.min.x += width * 0.5 - width * scaleX * 0.5;
            render.bounds.max.x += width * 0.5 - width * scaleX * 0.5;
            render.bounds.min.y += height * 0.5 - height * scaleY * 0.5;
            render.bounds.max.y += height * 0.5 - height * scaleY * 0.5;
          } // padding


          render.bounds.min.x -= padding.x;
          render.bounds.max.x -= padding.x;
          render.bounds.min.y -= padding.y;
          render.bounds.max.y -= padding.y; // update mouse

          if (render.mouse) {
            Mouse.setScale(render.mouse, {
              x: (render.bounds.max.x - render.bounds.min.x) / render.canvas.width,
              y: (render.bounds.max.y - render.bounds.min.y) / render.canvas.height
            });
            Mouse.setOffset(render.mouse, render.bounds.min);
          }
        };
        /**
         * Applies viewport transforms based on `render.bounds` to a render context.
         * @method startViewTransform
         * @param {render} render
         */


        Render.startViewTransform = function (render) {
          var boundsWidth = render.bounds.max.x - render.bounds.min.x,
              boundsHeight = render.bounds.max.y - render.bounds.min.y,
              boundsScaleX = boundsWidth / render.options.width,
              boundsScaleY = boundsHeight / render.options.height;
          render.context.setTransform(render.options.pixelRatio / boundsScaleX, 0, 0, render.options.pixelRatio / boundsScaleY, 0, 0);
          render.context.translate(-render.bounds.min.x, -render.bounds.min.y);
        };
        /**
         * Resets all transforms on the render context.
         * @method endViewTransform
         * @param {render} render
         */


        Render.endViewTransform = function (render) {
          render.context.setTransform(render.options.pixelRatio, 0, 0, render.options.pixelRatio, 0, 0);
        };
        /**
         * Renders the given `engine`'s `Matter.World` object.
         * This is the entry point for all rendering and should be called every time the scene changes.
         * @method world
         * @param {render} render
         */


        Render.world = function (render, time) {
          var startTime = Common.now(),
              engine = render.engine,
              world = engine.world,
              canvas = render.canvas,
              context = render.context,
              options = render.options,
              timing = render.timing;
          var allBodies = Composite.allBodies(world),
              allConstraints = Composite.allConstraints(world),
              background = options.wireframes ? options.wireframeBackground : options.background,
              bodies = [],
              constraints = [],
              i;
          var event = {
            timestamp: engine.timing.timestamp
          };
          Events.trigger(render, 'beforeRender', event); // apply background if it has changed

          if (render.currentBackground !== background) _applyBackground(render, background); // clear the canvas with a transparent fill, to allow the canvas background to show

          context.globalCompositeOperation = 'source-in';
          context.fillStyle = "transparent";
          context.fillRect(0, 0, canvas.width, canvas.height);
          context.globalCompositeOperation = 'source-over'; // handle bounds

          if (options.hasBounds) {
            // filter out bodies that are not in view
            for (i = 0; i < allBodies.length; i++) {
              var body = allBodies[i];
              if (Bounds.overlaps(body.bounds, render.bounds)) bodies.push(body);
            } // filter out constraints that are not in view


            for (i = 0; i < allConstraints.length; i++) {
              var constraint = allConstraints[i],
                  bodyA = constraint.bodyA,
                  bodyB = constraint.bodyB,
                  pointAWorld = constraint.pointA,
                  pointBWorld = constraint.pointB;
              if (bodyA) pointAWorld = Vector.add(bodyA.position, constraint.pointA);
              if (bodyB) pointBWorld = Vector.add(bodyB.position, constraint.pointB);
              if (!pointAWorld || !pointBWorld) continue;
              if (Bounds.contains(render.bounds, pointAWorld) || Bounds.contains(render.bounds, pointBWorld)) constraints.push(constraint);
            } // transform the view


            Render.startViewTransform(render); // update mouse

            if (render.mouse) {
              Mouse.setScale(render.mouse, {
                x: (render.bounds.max.x - render.bounds.min.x) / render.options.width,
                y: (render.bounds.max.y - render.bounds.min.y) / render.options.height
              });
              Mouse.setOffset(render.mouse, render.bounds.min);
            }
          } else {
            constraints = allConstraints;
            bodies = allBodies;

            if (render.options.pixelRatio !== 1) {
              render.context.setTransform(render.options.pixelRatio, 0, 0, render.options.pixelRatio, 0, 0);
            }
          }

          if (!options.wireframes || engine.enableSleeping && options.showSleeping) {
            // fully featured rendering of bodies
            Render.bodies(render, bodies, context);
          } else {
            if (options.showConvexHulls) Render.bodyConvexHulls(render, bodies, context); // optimised method for wireframes only

            Render.bodyWireframes(render, bodies, context);
          }

          if (options.showBounds) Render.bodyBounds(render, bodies, context);
          if (options.showAxes || options.showAngleIndicator) Render.bodyAxes(render, bodies, context);
          if (options.showPositions) Render.bodyPositions(render, bodies, context);
          if (options.showVelocity) Render.bodyVelocity(render, bodies, context);
          if (options.showIds) Render.bodyIds(render, bodies, context);
          if (options.showSeparations) Render.separations(render, engine.pairs.list, context);
          if (options.showCollisions) Render.collisions(render, engine.pairs.list, context);
          if (options.showVertexNumbers) Render.vertexNumbers(render, bodies, context);
          if (options.showMousePosition) Render.mousePosition(render, render.mouse, context);
          Render.constraints(constraints, context);
          if (options.showBroadphase) Render.grid(render, engine.grid, context);

          if (options.hasBounds) {
            // revert view transforms
            Render.endViewTransform(render);
          }

          Events.trigger(render, 'afterRender', event); // log the time elapsed computing this update

          timing.lastElapsed = Common.now() - startTime;
        };
        /**
         * Renders statistics about the engine and world useful for debugging.
         * @private
         * @method stats
         * @param {render} render
         * @param {RenderingContext} context
         * @param {Number} time
         */


        Render.stats = function (render, context, time) {
          var engine = render.engine,
              world = engine.world,
              bodies = Composite.allBodies(world),
              parts = 0,
              width = 55,
              height = 44,
              x = 0,
              y = 0; // count parts

          for (var i = 0; i < bodies.length; i += 1) {
            parts += bodies[i].parts.length;
          } // sections


          var sections = {
            'Part': parts,
            'Body': bodies.length,
            'Cons': Composite.allConstraints(world).length,
            'Comp': Composite.allComposites(world).length,
            'Pair': engine.pairs.list.length
          }; // background

          context.fillStyle = '#0e0f19';
          context.fillRect(x, y, width * 5.5, height);
          context.font = '12px Arial';
          context.textBaseline = 'top';
          context.textAlign = 'right'; // sections

          for (var key in sections) {
            var section = sections[key]; // label

            context.fillStyle = '#aaa';
            context.fillText(key, x + width, y + 8); // value

            context.fillStyle = '#eee';
            context.fillText(section, x + width, y + 26);
            x += width;
          }
        };
        /**
         * Renders engine and render performance information.
         * @private
         * @method performance
         * @param {render} render
         * @param {RenderingContext} context
         */


        Render.performance = function (render, context) {
          var engine = render.engine,
              timing = render.timing,
              deltaHistory = timing.deltaHistory,
              elapsedHistory = timing.elapsedHistory,
              timestampElapsedHistory = timing.timestampElapsedHistory,
              engineDeltaHistory = timing.engineDeltaHistory,
              engineElapsedHistory = timing.engineElapsedHistory,
              lastEngineDelta = engine.timing.lastDelta;

          var deltaMean = _mean(deltaHistory),
              elapsedMean = _mean(elapsedHistory),
              engineDeltaMean = _mean(engineDeltaHistory),
              engineElapsedMean = _mean(engineElapsedHistory),
              timestampElapsedMean = _mean(timestampElapsedHistory),
              rateMean = timestampElapsedMean / deltaMean || 0,
              fps = 1000 / deltaMean || 0;

          var graphHeight = 4,
              gap = 12,
              width = 60,
              height = 34,
              x = 10,
              y = 69; // background

          context.fillStyle = '#0e0f19';
          context.fillRect(0, 50, gap * 4 + width * 5 + 22, height); // show FPS

          Render.status(context, x, y, width, graphHeight, deltaHistory.length, Math.round(fps) + ' fps', fps / Render._goodFps, function (i) {
            return deltaHistory[i] / deltaMean - 1;
          }); // show engine delta

          Render.status(context, x + gap + width, y, width, graphHeight, engineDeltaHistory.length, lastEngineDelta.toFixed(2) + ' dt', Render._goodDelta / lastEngineDelta, function (i) {
            return engineDeltaHistory[i] / engineDeltaMean - 1;
          }); // show engine update time

          Render.status(context, x + (gap + width) * 2, y, width, graphHeight, engineElapsedHistory.length, engineElapsedMean.toFixed(2) + ' ut', 1 - engineElapsedMean / Render._goodFps, function (i) {
            return engineElapsedHistory[i] / engineElapsedMean - 1;
          }); // show render time

          Render.status(context, x + (gap + width) * 3, y, width, graphHeight, elapsedHistory.length, elapsedMean.toFixed(2) + ' rt', 1 - elapsedMean / Render._goodFps, function (i) {
            return elapsedHistory[i] / elapsedMean - 1;
          }); // show effective speed

          Render.status(context, x + (gap + width) * 4, y, width, graphHeight, timestampElapsedHistory.length, rateMean.toFixed(2) + ' x', rateMean * rateMean * rateMean, function (i) {
            return (timestampElapsedHistory[i] / deltaHistory[i] / rateMean || 0) - 1;
          });
        };
        /**
         * Renders a label, indicator and a chart.
         * @private
         * @method status
         * @param {RenderingContext} context
         * @param {number} x
         * @param {number} y
         * @param {number} width
         * @param {number} height
         * @param {number} count
         * @param {string} label
         * @param {string} indicator
         * @param {function} plotY
         */


        Render.status = function (context, x, y, width, height, count, label, indicator, plotY) {
          // background
          context.strokeStyle = '#888';
          context.fillStyle = '#444';
          context.lineWidth = 1;
          context.fillRect(x, y + 7, width, 1); // chart

          context.beginPath();
          context.moveTo(x, y + 7 - height * Common.clamp(0.4 * plotY(0), -2, 2));

          for (var i = 0; i < width; i += 1) {
            context.lineTo(x + i, y + 7 - (i < count ? height * Common.clamp(0.4 * plotY(i), -2, 2) : 0));
          }

          context.stroke(); // indicator

          context.fillStyle = 'hsl(' + Common.clamp(25 + 95 * indicator, 0, 120) + ',100%,60%)';
          context.fillRect(x, y - 7, 4, 4); // label

          context.font = '12px Arial';
          context.textBaseline = 'middle';
          context.textAlign = 'right';
          context.fillStyle = '#eee';
          context.fillText(label, x + width, y - 5);
        };
        /**
         * Description
         * @private
         * @method constraints
         * @param {constraint[]} constraints
         * @param {RenderingContext} context
         */


        Render.constraints = function (constraints, context) {
          var c = context;

          for (var i = 0; i < constraints.length; i++) {
            var constraint = constraints[i];
            if (!constraint.render.visible || !constraint.pointA || !constraint.pointB) continue;
            var bodyA = constraint.bodyA,
                bodyB = constraint.bodyB,
                start,
                end;

            if (bodyA) {
              start = Vector.add(bodyA.position, constraint.pointA);
            } else {
              start = constraint.pointA;
            }

            if (constraint.render.type === 'pin') {
              c.beginPath();
              c.arc(start.x, start.y, 3, 0, 2 * Math.PI);
              c.closePath();
            } else {
              if (bodyB) {
                end = Vector.add(bodyB.position, constraint.pointB);
              } else {
                end = constraint.pointB;
              }

              c.beginPath();
              c.moveTo(start.x, start.y);

              if (constraint.render.type === 'spring') {
                var delta = Vector.sub(end, start),
                    normal = Vector.perp(Vector.normalise(delta)),
                    coils = Math.ceil(Common.clamp(constraint.length / 5, 12, 20)),
                    offset;

                for (var j = 1; j < coils; j += 1) {
                  offset = j % 2 === 0 ? 1 : -1;
                  c.lineTo(start.x + delta.x * (j / coils) + normal.x * offset * 4, start.y + delta.y * (j / coils) + normal.y * offset * 4);
                }
              }

              c.lineTo(end.x, end.y);
            }

            if (constraint.render.lineWidth) {
              c.lineWidth = constraint.render.lineWidth;
              c.strokeStyle = constraint.render.strokeStyle;
              c.stroke();
            }

            if (constraint.render.anchors) {
              c.fillStyle = constraint.render.strokeStyle;
              c.beginPath();
              c.arc(start.x, start.y, 3, 0, 2 * Math.PI);
              c.arc(end.x, end.y, 3, 0, 2 * Math.PI);
              c.closePath();
              c.fill();
            }
          }
        };
        /**
         * Description
         * @private
         * @method bodies
         * @param {render} render
         * @param {body[]} bodies
         * @param {RenderingContext} context
         */


        Render.bodies = function (render, bodies, context) {
          var c = context,
              engine = render.engine,
              options = render.options,
              showInternalEdges = options.showInternalEdges || !options.wireframes,
              body,
              part,
              i,
              k;

          for (i = 0; i < bodies.length; i++) {
            body = bodies[i];
            if (!body.render.visible) continue; // handle compound parts

            for (k = body.parts.length > 1 ? 1 : 0; k < body.parts.length; k++) {
              part = body.parts[k];
              if (!part.render.visible) continue;

              if (options.showSleeping && body.isSleeping) {
                c.globalAlpha = 0.5 * part.render.opacity;
              } else if (part.render.opacity !== 1) {
                c.globalAlpha = part.render.opacity;
              }

              if (part.render.sprite && part.render.sprite.texture && !options.wireframes) {
                // part sprite
                var sprite = part.render.sprite,
                    texture = _getTexture(render, sprite.texture);

                c.translate(part.position.x, part.position.y);
                c.rotate(part.angle);
                c.drawImage(texture, texture.width * -sprite.xOffset * sprite.xScale, texture.height * -sprite.yOffset * sprite.yScale, texture.width * sprite.xScale, texture.height * sprite.yScale); // revert translation, hopefully faster than save / restore

                c.rotate(-part.angle);
                c.translate(-part.position.x, -part.position.y);
              } else {
                // part polygon
                if (part.circleRadius) {
                  c.beginPath();
                  c.arc(part.position.x, part.position.y, part.circleRadius, 0, 2 * Math.PI);
                } else {
                  c.beginPath();
                  c.moveTo(part.vertices[0].x, part.vertices[0].y);

                  for (var j = 1; j < part.vertices.length; j++) {
                    if (!part.vertices[j - 1].isInternal || showInternalEdges) {
                      c.lineTo(part.vertices[j].x, part.vertices[j].y);
                    } else {
                      c.moveTo(part.vertices[j].x, part.vertices[j].y);
                    }

                    if (part.vertices[j].isInternal && !showInternalEdges) {
                      c.moveTo(part.vertices[(j + 1) % part.vertices.length].x, part.vertices[(j + 1) % part.vertices.length].y);
                    }
                  }

                  c.lineTo(part.vertices[0].x, part.vertices[0].y);
                  c.closePath();
                }

                if (!options.wireframes) {
                  c.fillStyle = part.render.fillStyle;

                  if (part.render.lineWidth) {
                    c.lineWidth = part.render.lineWidth;
                    c.strokeStyle = part.render.strokeStyle;
                    c.stroke();
                  }

                  c.fill();
                } else {
                  c.lineWidth = 1;
                  c.strokeStyle = '#bbb';
                  c.stroke();
                }
              }

              c.globalAlpha = 1;
            }
          }
        };
        /**
         * Optimised method for drawing body wireframes in one pass
         * @private
         * @method bodyWireframes
         * @param {render} render
         * @param {body[]} bodies
         * @param {RenderingContext} context
         */


        Render.bodyWireframes = function (render, bodies, context) {
          var c = context,
              showInternalEdges = render.options.showInternalEdges,
              body,
              part,
              i,
              j,
              k;
          c.beginPath(); // render all bodies

          for (i = 0; i < bodies.length; i++) {
            body = bodies[i];
            if (!body.render.visible) continue; // handle compound parts

            for (k = body.parts.length > 1 ? 1 : 0; k < body.parts.length; k++) {
              part = body.parts[k];
              c.moveTo(part.vertices[0].x, part.vertices[0].y);

              for (j = 1; j < part.vertices.length; j++) {
                if (!part.vertices[j - 1].isInternal || showInternalEdges) {
                  c.lineTo(part.vertices[j].x, part.vertices[j].y);
                } else {
                  c.moveTo(part.vertices[j].x, part.vertices[j].y);
                }

                if (part.vertices[j].isInternal && !showInternalEdges) {
                  c.moveTo(part.vertices[(j + 1) % part.vertices.length].x, part.vertices[(j + 1) % part.vertices.length].y);
                }
              }

              c.lineTo(part.vertices[0].x, part.vertices[0].y);
            }
          }

          c.lineWidth = 1;
          c.strokeStyle = '#bbb';
          c.stroke();
        };
        /**
         * Optimised method for drawing body convex hull wireframes in one pass
         * @private
         * @method bodyConvexHulls
         * @param {render} render
         * @param {body[]} bodies
         * @param {RenderingContext} context
         */


        Render.bodyConvexHulls = function (render, bodies, context) {
          var c = context,
              body,
              part,
              i,
              j,
              k;
          c.beginPath(); // render convex hulls

          for (i = 0; i < bodies.length; i++) {
            body = bodies[i];
            if (!body.render.visible || body.parts.length === 1) continue;
            c.moveTo(body.vertices[0].x, body.vertices[0].y);

            for (j = 1; j < body.vertices.length; j++) {
              c.lineTo(body.vertices[j].x, body.vertices[j].y);
            }

            c.lineTo(body.vertices[0].x, body.vertices[0].y);
          }

          c.lineWidth = 1;
          c.strokeStyle = 'rgba(255,255,255,0.2)';
          c.stroke();
        };
        /**
         * Renders body vertex numbers.
         * @private
         * @method vertexNumbers
         * @param {render} render
         * @param {body[]} bodies
         * @param {RenderingContext} context
         */


        Render.vertexNumbers = function (render, bodies, context) {
          var c = context,
              i,
              j,
              k;

          for (i = 0; i < bodies.length; i++) {
            var parts = bodies[i].parts;

            for (k = parts.length > 1 ? 1 : 0; k < parts.length; k++) {
              var part = parts[k];

              for (j = 0; j < part.vertices.length; j++) {
                c.fillStyle = 'rgba(255,255,255,0.2)';
                c.fillText(i + '_' + j, part.position.x + (part.vertices[j].x - part.position.x) * 0.8, part.position.y + (part.vertices[j].y - part.position.y) * 0.8);
              }
            }
          }
        };
        /**
         * Renders mouse position.
         * @private
         * @method mousePosition
         * @param {render} render
         * @param {mouse} mouse
         * @param {RenderingContext} context
         */


        Render.mousePosition = function (render, mouse, context) {
          var c = context;
          c.fillStyle = 'rgba(255,255,255,0.8)';
          c.fillText(mouse.position.x + '  ' + mouse.position.y, mouse.position.x + 5, mouse.position.y - 5);
        };
        /**
         * Draws body bounds
         * @private
         * @method bodyBounds
         * @param {render} render
         * @param {body[]} bodies
         * @param {RenderingContext} context
         */


        Render.bodyBounds = function (render, bodies, context) {
          var c = context,
              engine = render.engine,
              options = render.options;
          c.beginPath();

          for (var i = 0; i < bodies.length; i++) {
            var body = bodies[i];

            if (body.render.visible) {
              var parts = bodies[i].parts;

              for (var j = parts.length > 1 ? 1 : 0; j < parts.length; j++) {
                var part = parts[j];
                c.rect(part.bounds.min.x, part.bounds.min.y, part.bounds.max.x - part.bounds.min.x, part.bounds.max.y - part.bounds.min.y);
              }
            }
          }

          if (options.wireframes) {
            c.strokeStyle = 'rgba(255,255,255,0.08)';
          } else {
            c.strokeStyle = 'rgba(0,0,0,0.1)';
          }

          c.lineWidth = 1;
          c.stroke();
        };
        /**
         * Draws body angle indicators and axes
         * @private
         * @method bodyAxes
         * @param {render} render
         * @param {body[]} bodies
         * @param {RenderingContext} context
         */


        Render.bodyAxes = function (render, bodies, context) {
          var c = context,
              engine = render.engine,
              options = render.options,
              part,
              i,
              j,
              k;
          c.beginPath();

          for (i = 0; i < bodies.length; i++) {
            var body = bodies[i],
                parts = body.parts;
            if (!body.render.visible) continue;

            if (options.showAxes) {
              // render all axes
              for (j = parts.length > 1 ? 1 : 0; j < parts.length; j++) {
                part = parts[j];

                for (k = 0; k < part.axes.length; k++) {
                  var axis = part.axes[k];
                  c.moveTo(part.position.x, part.position.y);
                  c.lineTo(part.position.x + axis.x * 20, part.position.y + axis.y * 20);
                }
              }
            } else {
              for (j = parts.length > 1 ? 1 : 0; j < parts.length; j++) {
                part = parts[j];

                for (k = 0; k < part.axes.length; k++) {
                  // render a single axis indicator
                  c.moveTo(part.position.x, part.position.y);
                  c.lineTo((part.vertices[0].x + part.vertices[part.vertices.length - 1].x) / 2, (part.vertices[0].y + part.vertices[part.vertices.length - 1].y) / 2);
                }
              }
            }
          }

          if (options.wireframes) {
            c.strokeStyle = 'indianred';
            c.lineWidth = 1;
          } else {
            c.strokeStyle = 'rgba(255, 255, 255, 0.4)';
            c.globalCompositeOperation = 'overlay';
            c.lineWidth = 2;
          }

          c.stroke();
          c.globalCompositeOperation = 'source-over';
        };
        /**
         * Draws body positions
         * @private
         * @method bodyPositions
         * @param {render} render
         * @param {body[]} bodies
         * @param {RenderingContext} context
         */


        Render.bodyPositions = function (render, bodies, context) {
          var c = context,
              engine = render.engine,
              options = render.options,
              body,
              part,
              i,
              k;
          c.beginPath(); // render current positions

          for (i = 0; i < bodies.length; i++) {
            body = bodies[i];
            if (!body.render.visible) continue; // handle compound parts

            for (k = 0; k < body.parts.length; k++) {
              part = body.parts[k];
              c.arc(part.position.x, part.position.y, 3, 0, 2 * Math.PI, false);
              c.closePath();
            }
          }

          if (options.wireframes) {
            c.fillStyle = 'indianred';
          } else {
            c.fillStyle = 'rgba(0,0,0,0.5)';
          }

          c.fill();
          c.beginPath(); // render previous positions

          for (i = 0; i < bodies.length; i++) {
            body = bodies[i];

            if (body.render.visible) {
              c.arc(body.positionPrev.x, body.positionPrev.y, 2, 0, 2 * Math.PI, false);
              c.closePath();
            }
          }

          c.fillStyle = 'rgba(255,165,0,0.8)';
          c.fill();
        };
        /**
         * Draws body velocity
         * @private
         * @method bodyVelocity
         * @param {render} render
         * @param {body[]} bodies
         * @param {RenderingContext} context
         */


        Render.bodyVelocity = function (render, bodies, context) {
          var c = context;
          c.beginPath();

          for (var i = 0; i < bodies.length; i++) {
            var body = bodies[i];
            if (!body.render.visible) continue;
            c.moveTo(body.position.x, body.position.y);
            c.lineTo(body.position.x + (body.position.x - body.positionPrev.x) * 2, body.position.y + (body.position.y - body.positionPrev.y) * 2);
          }

          c.lineWidth = 3;
          c.strokeStyle = 'cornflowerblue';
          c.stroke();
        };
        /**
         * Draws body ids
         * @private
         * @method bodyIds
         * @param {render} render
         * @param {body[]} bodies
         * @param {RenderingContext} context
         */


        Render.bodyIds = function (render, bodies, context) {
          var c = context,
              i,
              j;

          for (i = 0; i < bodies.length; i++) {
            if (!bodies[i].render.visible) continue;
            var parts = bodies[i].parts;

            for (j = parts.length > 1 ? 1 : 0; j < parts.length; j++) {
              var part = parts[j];
              c.font = "12px Arial";
              c.fillStyle = 'rgba(255,255,255,0.5)';
              c.fillText(part.id, part.position.x + 10, part.position.y - 10);
            }
          }
        };
        /**
         * Description
         * @private
         * @method collisions
         * @param {render} render
         * @param {pair[]} pairs
         * @param {RenderingContext} context
         */


        Render.collisions = function (render, pairs, context) {
          var c = context,
              options = render.options,
              pair,
              collision,
              corrected,
              bodyA,
              bodyB,
              i,
              j;
          c.beginPath(); // render collision positions

          for (i = 0; i < pairs.length; i++) {
            pair = pairs[i];
            if (!pair.isActive) continue;
            collision = pair.collision;

            for (j = 0; j < pair.activeContacts.length; j++) {
              var contact = pair.activeContacts[j],
                  vertex = contact.vertex;
              c.rect(vertex.x - 1.5, vertex.y - 1.5, 3.5, 3.5);
            }
          }

          if (options.wireframes) {
            c.fillStyle = 'rgba(255,255,255,0.7)';
          } else {
            c.fillStyle = 'orange';
          }

          c.fill();
          c.beginPath(); // render collision normals

          for (i = 0; i < pairs.length; i++) {
            pair = pairs[i];
            if (!pair.isActive) continue;
            collision = pair.collision;

            if (pair.activeContacts.length > 0) {
              var normalPosX = pair.activeContacts[0].vertex.x,
                  normalPosY = pair.activeContacts[0].vertex.y;

              if (pair.activeContacts.length === 2) {
                normalPosX = (pair.activeContacts[0].vertex.x + pair.activeContacts[1].vertex.x) / 2;
                normalPosY = (pair.activeContacts[0].vertex.y + pair.activeContacts[1].vertex.y) / 2;
              }

              if (collision.bodyB === collision.supports[0].body || collision.bodyA.isStatic === true) {
                c.moveTo(normalPosX - collision.normal.x * 8, normalPosY - collision.normal.y * 8);
              } else {
                c.moveTo(normalPosX + collision.normal.x * 8, normalPosY + collision.normal.y * 8);
              }

              c.lineTo(normalPosX, normalPosY);
            }
          }

          if (options.wireframes) {
            c.strokeStyle = 'rgba(255,165,0,0.7)';
          } else {
            c.strokeStyle = 'orange';
          }

          c.lineWidth = 1;
          c.stroke();
        };
        /**
         * Description
         * @private
         * @method separations
         * @param {render} render
         * @param {pair[]} pairs
         * @param {RenderingContext} context
         */


        Render.separations = function (render, pairs, context) {
          var c = context,
              options = render.options,
              pair,
              collision,
              corrected,
              bodyA,
              bodyB,
              i,
              j;
          c.beginPath(); // render separations

          for (i = 0; i < pairs.length; i++) {
            pair = pairs[i];
            if (!pair.isActive) continue;
            collision = pair.collision;
            bodyA = collision.bodyA;
            bodyB = collision.bodyB;
            var k = 1;
            if (!bodyB.isStatic && !bodyA.isStatic) k = 0.5;
            if (bodyB.isStatic) k = 0;
            c.moveTo(bodyB.position.x, bodyB.position.y);
            c.lineTo(bodyB.position.x - collision.penetration.x * k, bodyB.position.y - collision.penetration.y * k);
            k = 1;
            if (!bodyB.isStatic && !bodyA.isStatic) k = 0.5;
            if (bodyA.isStatic) k = 0;
            c.moveTo(bodyA.position.x, bodyA.position.y);
            c.lineTo(bodyA.position.x + collision.penetration.x * k, bodyA.position.y + collision.penetration.y * k);
          }

          if (options.wireframes) {
            c.strokeStyle = 'rgba(255,165,0,0.5)';
          } else {
            c.strokeStyle = 'orange';
          }

          c.stroke();
        };
        /**
         * Description
         * @private
         * @method grid
         * @param {render} render
         * @param {grid} grid
         * @param {RenderingContext} context
         */


        Render.grid = function (render, grid, context) {
          var c = context,
              options = render.options;

          if (options.wireframes) {
            c.strokeStyle = 'rgba(255,180,0,0.1)';
          } else {
            c.strokeStyle = 'rgba(255,180,0,0.5)';
          }

          c.beginPath();
          var bucketKeys = Common.keys(grid.buckets);

          for (var i = 0; i < bucketKeys.length; i++) {
            var bucketId = bucketKeys[i];
            if (grid.buckets[bucketId].length < 2) continue;
            var region = bucketId.split(/C|R/);
            c.rect(0.5 + parseInt(region[1], 10) * grid.bucketWidth, 0.5 + parseInt(region[2], 10) * grid.bucketHeight, grid.bucketWidth, grid.bucketHeight);
          }

          c.lineWidth = 1;
          c.stroke();
        };
        /**
         * Description
         * @private
         * @method inspector
         * @param {inspector} inspector
         * @param {RenderingContext} context
         */


        Render.inspector = function (inspector, context) {
          var engine = inspector.engine,
              selected = inspector.selected,
              render = inspector.render,
              options = render.options,
              bounds;

          if (options.hasBounds) {
            var boundsWidth = render.bounds.max.x - render.bounds.min.x,
                boundsHeight = render.bounds.max.y - render.bounds.min.y,
                boundsScaleX = boundsWidth / render.options.width,
                boundsScaleY = boundsHeight / render.options.height;
            context.scale(1 / boundsScaleX, 1 / boundsScaleY);
            context.translate(-render.bounds.min.x, -render.bounds.min.y);
          }

          for (var i = 0; i < selected.length; i++) {
            var item = selected[i].data;
            context.translate(0.5, 0.5);
            context.lineWidth = 1;
            context.strokeStyle = 'rgba(255,165,0,0.9)';
            context.setLineDash([1, 2]);

            switch (item.type) {
              case 'body':
                // render body selections
                bounds = item.bounds;
                context.beginPath();
                context.rect(Math.floor(bounds.min.x - 3), Math.floor(bounds.min.y - 3), Math.floor(bounds.max.x - bounds.min.x + 6), Math.floor(bounds.max.y - bounds.min.y + 6));
                context.closePath();
                context.stroke();
                break;

              case 'constraint':
                // render constraint selections
                var point = item.pointA;
                if (item.bodyA) point = item.pointB;
                context.beginPath();
                context.arc(point.x, point.y, 10, 0, 2 * Math.PI);
                context.closePath();
                context.stroke();
                break;
            }

            context.setLineDash([]);
            context.translate(-0.5, -0.5);
          } // render selection region


          if (inspector.selectStart !== null) {
            context.translate(0.5, 0.5);
            context.lineWidth = 1;
            context.strokeStyle = 'rgba(255,165,0,0.6)';
            context.fillStyle = 'rgba(255,165,0,0.1)';
            bounds = inspector.selectBounds;
            context.beginPath();
            context.rect(Math.floor(bounds.min.x), Math.floor(bounds.min.y), Math.floor(bounds.max.x - bounds.min.x), Math.floor(bounds.max.y - bounds.min.y));
            context.closePath();
            context.stroke();
            context.fill();
            context.translate(-0.5, -0.5);
          }

          if (options.hasBounds) context.setTransform(1, 0, 0, 1, 0, 0);
        };
        /**
         * Updates render timing.
         * @method _updateTiming
         * @private
         * @param {render} render
         * @param {number} time
         */


        var _updateTiming = function _updateTiming(render, time) {
          var engine = render.engine,
              timing = render.timing,
              historySize = timing.historySize,
              timestamp = engine.timing.timestamp;
          timing.delta = time - timing.lastTime || Render._goodDelta;
          timing.lastTime = time;
          timing.timestampElapsed = timestamp - timing.lastTimestamp || 0;
          timing.lastTimestamp = timestamp;
          timing.deltaHistory.unshift(timing.delta);
          timing.deltaHistory.length = Math.min(timing.deltaHistory.length, historySize);
          timing.engineDeltaHistory.unshift(engine.timing.lastDelta);
          timing.engineDeltaHistory.length = Math.min(timing.engineDeltaHistory.length, historySize);
          timing.timestampElapsedHistory.unshift(timing.timestampElapsed);
          timing.timestampElapsedHistory.length = Math.min(timing.timestampElapsedHistory.length, historySize);
          timing.engineElapsedHistory.unshift(engine.timing.lastElapsed);
          timing.engineElapsedHistory.length = Math.min(timing.engineElapsedHistory.length, historySize);
          timing.elapsedHistory.unshift(timing.lastElapsed);
          timing.elapsedHistory.length = Math.min(timing.elapsedHistory.length, historySize);
        };
        /**
         * Returns the mean value of the given numbers.
         * @method _mean
         * @private
         * @param {Number[]} values
         * @return {Number} the mean of given values
         */


        var _mean = function _mean(values) {
          var result = 0;

          for (var i = 0; i < values.length; i += 1) {
            result += values[i];
          }

          return result / values.length || 0;
        };
        /**
         * @method _createCanvas
         * @private
         * @param {} width
         * @param {} height
         * @return canvas
         */


        var _createCanvas = function _createCanvas(width, height) {
          var canvas = document.createElement('canvas');
          canvas.width = width;
          canvas.height = height;

          canvas.oncontextmenu = function () {
            return false;
          };

          canvas.onselectstart = function () {
            return false;
          };

          return canvas;
        };
        /**
         * Gets the pixel ratio of the canvas.
         * @method _getPixelRatio
         * @private
         * @param {HTMLElement} canvas
         * @return {Number} pixel ratio
         */


        var _getPixelRatio = function _getPixelRatio(canvas) {
          var context = canvas.getContext('2d'),
              devicePixelRatio = window.devicePixelRatio || 1,
              backingStorePixelRatio = context.webkitBackingStorePixelRatio || context.mozBackingStorePixelRatio || context.msBackingStorePixelRatio || context.oBackingStorePixelRatio || context.backingStorePixelRatio || 1;
          return devicePixelRatio / backingStorePixelRatio;
        };
        /**
         * Gets the requested texture (an Image) via its path
         * @method _getTexture
         * @private
         * @param {render} render
         * @param {string} imagePath
         * @return {Image} texture
         */


        var _getTexture = function _getTexture(render, imagePath) {
          var image = render.textures[imagePath];
          if (image) return image;
          image = render.textures[imagePath] = new Image();
          image.src = imagePath;
          return image;
        };
        /**
         * Applies the background to the canvas using CSS.
         * @method applyBackground
         * @private
         * @param {render} render
         * @param {string} background
         */


        var _applyBackground = function _applyBackground(render, background) {
          var cssBackground = background;
          if (/(jpg|gif|png)$/.test(background)) cssBackground = 'url(' + background + ')';
          render.canvas.style.background = cssBackground;
          render.canvas.style.backgroundSize = "contain";
          render.currentBackground = background;
        };
        /*
        *
        *  Events Documentation
        *
        */

        /**
        * Fired before rendering
        *
        * @event beforeRender
        * @param {} event An event object
        * @param {number} event.timestamp The engine.timing.timestamp of the event
        * @param {} event.source The source object of the event
        * @param {} event.name The name of the event
        */

        /**
        * Fired after rendering
        *
        * @event afterRender
        * @param {} event An event object
        * @param {number} event.timestamp The engine.timing.timestamp of the event
        * @param {} event.source The source object of the event
        * @param {} event.name The name of the event
        */

        /*
        *
        *  Properties Documentation
        *
        */

        /**
         * A back-reference to the `Matter.Render` module.
         *
         * @property controller
         * @type render
         */

        /**
         * A reference to the `Matter.Engine` instance to be used.
         *
         * @property engine
         * @type engine
         */

        /**
         * A reference to the element where the canvas is to be inserted (if `render.canvas` has not been specified)
         *
         * @property element
         * @type HTMLElement
         * @default null
         */

        /**
         * The canvas element to render to. If not specified, one will be created if `render.element` has been specified.
         *
         * @property canvas
         * @type HTMLCanvasElement
         * @default null
         */

        /**
         * A `Bounds` object that specifies the drawing view region.
         * Rendering will be automatically transformed and scaled to fit within the canvas size (`render.options.width` and `render.options.height`).
         * This allows for creating views that can pan or zoom around the scene.
         * You must also set `render.options.hasBounds` to `true` to enable bounded rendering.
         *
         * @property bounds
         * @type bounds
         */

        /**
         * The 2d rendering context from the `render.canvas` element.
         *
         * @property context
         * @type CanvasRenderingContext2D
         */

        /**
         * The sprite texture cache.
         *
         * @property textures
         * @type {}
         */

        /**
         * The mouse to render if `render.options.showMousePosition` is enabled.
         *
         * @property mouse
         * @type mouse
         * @default null
         */

        /**
         * The configuration options of the renderer.
         *
         * @property options
         * @type {}
         */

        /**
         * The target width in pixels of the `render.canvas` to be created.
         * See also the `options.pixelRatio` property to change render quality.
         *
         * @property options.width
         * @type number
         * @default 800
         */

        /**
         * The target height in pixels of the `render.canvas` to be created.
         * See also the `options.pixelRatio` property to change render quality.
         *
         * @property options.height
         * @type number
         * @default 600
         */

        /**
         * The [pixel ratio](https://developer.mozilla.org/en-US/docs/Web/API/Window/devicePixelRatio) to use when rendering.
         *
         * @property options.pixelRatio
         * @type number
         * @default 1
         */

        /**
         * A CSS background color string to use when `render.options.wireframes` is disabled.
         * This may be also set to `'transparent'` or equivalent.
         *
         * @property options.background
         * @type string
         * @default '#14151f'
         */

        /**
         * A CSS background color string to use when `render.options.wireframes` is enabled.
         * This may be also set to `'transparent'` or equivalent.
         *
         * @property options.wireframeBackground
         * @type string
         * @default '#14151f'
         */

        /**
         * A flag that specifies if `render.bounds` should be used when rendering.
         *
         * @property options.hasBounds
         * @type boolean
         * @default false
         */

        /**
         * A flag to enable or disable all debug information overlays together.  
         * This includes and has priority over the values of:
         *
         * - `render.options.showStats`
         * - `render.options.showPerformance`
         *
         * @property options.showDebug
         * @type boolean
         * @default false
         */

        /**
         * A flag to enable or disable the engine stats info overlay.  
         * From left to right, the values shown are:
         *
         * - body parts total
         * - body total
         * - constraints total
         * - composites total
         * - collision pairs total
         *
         * @property options.showStats
         * @type boolean
         * @default false
         */

        /**
         * A flag to enable or disable performance charts.  
         * From left to right, the values shown are:
         *
         * - average render frequency (e.g. 60 fps)
         * - exact engine delta time used for last update (e.g. 16.66ms)
         * - average engine execution duration (e.g. 5.00ms)
         * - average render execution duration (e.g. 0.40ms)
         * - average effective play speed (e.g. '1.00x' is 'real-time')
         *
         * Each value is recorded over a fixed sample of past frames (60 frames).
         *
         * A chart shown below each value indicates the variance from the average over the sample.
         * The more stable or fixed the value is the flatter the chart will appear.
         *
         * @property options.showPerformance
         * @type boolean
         * @default false
         */

        /**
         * A flag to enable or disable rendering entirely.
         *
         * @property options.enabled
         * @type boolean
         * @default false
         */

        /**
         * A flag to toggle wireframe rendering otherwise solid fill rendering is used.
         *
         * @property options.wireframes
         * @type boolean
         * @default true
         */

        /**
         * A flag to enable or disable sleeping bodies indicators.
         *
         * @property options.showSleeping
         * @type boolean
         * @default true
         */

        /**
         * A flag to enable or disable the debug information overlay.
         *
         * @property options.showDebug
         * @type boolean
         * @default false
         */

        /**
         * A flag to enable or disable the collision broadphase debug overlay.
         *
         * @property options.showBroadphase
         * @type boolean
         * @default false
         */

        /**
         * A flag to enable or disable the body bounds debug overlay.
         *
         * @property options.showBounds
         * @type boolean
         * @default false
         */

        /**
         * A flag to enable or disable the body velocity debug overlay.
         *
         * @property options.showVelocity
         * @type boolean
         * @default false
         */

        /**
         * A flag to enable or disable the body collisions debug overlay.
         *
         * @property options.showCollisions
         * @type boolean
         * @default false
         */

        /**
         * A flag to enable or disable the collision resolver separations debug overlay.
         *
         * @property options.showSeparations
         * @type boolean
         * @default false
         */

        /**
         * A flag to enable or disable the body axes debug overlay.
         *
         * @property options.showAxes
         * @type boolean
         * @default false
         */

        /**
         * A flag to enable or disable the body positions debug overlay.
         *
         * @property options.showPositions
         * @type boolean
         * @default false
         */

        /**
         * A flag to enable or disable the body angle debug overlay.
         *
         * @property options.showAngleIndicator
         * @type boolean
         * @default false
         */

        /**
         * A flag to enable or disable the body and part ids debug overlay.
         *
         * @property options.showIds
         * @type boolean
         * @default false
         */

        /**
         * A flag to enable or disable the body vertex numbers debug overlay.
         *
         * @property options.showVertexNumbers
         * @type boolean
         * @default false
         */

        /**
         * A flag to enable or disable the body convex hulls debug overlay.
         *
         * @property options.showConvexHulls
         * @type boolean
         * @default false
         */

        /**
         * A flag to enable or disable the body internal edges debug overlay.
         *
         * @property options.showInternalEdges
         * @type boolean
         * @default false
         */

        /**
         * A flag to enable or disable the mouse position debug overlay.
         *
         * @property options.showMousePosition
         * @type boolean
         * @default false
         */

      })();
      /***/

    },
    /* 17 */

    /***/
    function (module, exports) {
      /**
      * The `Matter.Contact` module contains methods for creating and manipulating collision contacts.
      *
      * @class Contact
      */
      var Contact = {};
      module.exports = Contact;

      (function () {
        /**
         * Creates a new contact.
         * @method create
         * @param {vertex} vertex
         * @return {contact} A new contact
         */
        Contact.create = function (vertex) {
          return {
            id: Contact.id(vertex),
            vertex: vertex,
            normalImpulse: 0,
            tangentImpulse: 0
          };
        };
        /**
         * Generates a contact id.
         * @method id
         * @param {vertex} vertex
         * @return {string} Unique contactID
         */


        Contact.id = function (vertex) {
          return vertex.body.id + '_' + vertex.index;
        };
      })();
      /***/

    },
    /* 18 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * The `Matter.Engine` module contains methods for creating and manipulating engines.
      * An engine is a controller that manages updating the simulation of the world.
      * See `Matter.Runner` for an optional game loop utility.
      *
      * See the included usage [examples](https://github.com/liabru/matter-js/tree/master/examples).
      *
      * @class Engine
      */
      var Engine = {};
      module.exports = Engine;

      var Sleeping = __webpack_require__(7);

      var Resolver = __webpack_require__(19);

      var Detector = __webpack_require__(13);

      var Pairs = __webpack_require__(20);

      var Grid = __webpack_require__(21);

      var Events = __webpack_require__(4);

      var Composite = __webpack_require__(5);

      var Constraint = __webpack_require__(8);

      var Common = __webpack_require__(0);

      var Body = __webpack_require__(6);

      (function () {
        /**
         * Creates a new engine. The options parameter is an object that specifies any properties you wish to override the defaults.
         * All properties have default values, and many are pre-calculated automatically based on other properties.
         * See the properties section below for detailed information on what you can pass via the `options` object.
         * @method create
         * @param {object} [options]
         * @return {engine} engine
         */
        Engine.create = function (options) {
          options = options || {};
          var defaults = {
            positionIterations: 6,
            velocityIterations: 4,
            constraintIterations: 2,
            enableSleeping: false,
            events: [],
            plugin: {},
            grid: null,
            gravity: {
              x: 0,
              y: 1,
              scale: 0.001
            },
            timing: {
              timestamp: 0,
              timeScale: 1,
              lastDelta: 0,
              lastElapsed: 0
            }
          };
          var engine = Common.extend(defaults, options);
          engine.world = options.world || Composite.create({
            label: 'World'
          });
          engine.grid = Grid.create(options.grid || options.broadphase);
          engine.pairs = Pairs.create(); // temporary back compatibility

          engine.world.gravity = engine.gravity;
          engine.broadphase = engine.grid;
          engine.metrics = {};
          return engine;
        };
        /**
         * Moves the simulation forward in time by `delta` ms.
         * The `correction` argument is an optional `Number` that specifies the time correction factor to apply to the update.
         * This can help improve the accuracy of the simulation in cases where `delta` is changing between updates.
         * The value of `correction` is defined as `delta / lastDelta`, i.e. the percentage change of `delta` over the last step.
         * Therefore the value is always `1` (no correction) when `delta` constant (or when no correction is desired, which is the default).
         * See the paper on <a href="http://lonesock.net/article/verlet.html">Time Corrected Verlet</a> for more information.
         *
         * Triggers `beforeUpdate` and `afterUpdate` events.
         * Triggers `collisionStart`, `collisionActive` and `collisionEnd` events.
         * @method update
         * @param {engine} engine
         * @param {number} [delta=16.666]
         * @param {number} [correction=1]
         */


        Engine.update = function (engine, delta, correction) {
          var startTime = Common.now();
          delta = delta || 1000 / 60;
          correction = correction || 1;
          var world = engine.world,
              timing = engine.timing,
              grid = engine.grid,
              gridPairs = [],
              i; // increment timestamp

          timing.timestamp += delta * timing.timeScale;
          timing.lastDelta = delta * timing.timeScale; // create an event object

          var event = {
            timestamp: timing.timestamp
          };
          Events.trigger(engine, 'beforeUpdate', event); // get lists of all bodies and constraints, no matter what composites they are in

          var allBodies = Composite.allBodies(world),
              allConstraints = Composite.allConstraints(world); // if sleeping enabled, call the sleeping controller

          if (engine.enableSleeping) Sleeping.update(allBodies, timing.timeScale); // applies gravity to all bodies

          Engine._bodiesApplyGravity(allBodies, engine.gravity); // update all body position and rotation by integration


          Engine._bodiesUpdate(allBodies, delta, timing.timeScale, correction, world.bounds); // update all constraints (first pass)


          Constraint.preSolveAll(allBodies);

          for (i = 0; i < engine.constraintIterations; i++) {
            Constraint.solveAll(allConstraints, timing.timeScale);
          }

          Constraint.postSolveAll(allBodies); // broadphase pass: find potential collision pairs
          // if world is dirty, we must flush the whole grid

          if (world.isModified) Grid.clear(grid); // update the grid buckets based on current bodies

          Grid.update(grid, allBodies, engine, world.isModified);
          gridPairs = grid.pairsList; // clear all composite modified flags

          if (world.isModified) {
            Composite.setModified(world, false, false, true);
          } // narrowphase pass: find actual collisions, then create or update collision pairs


          var collisions = Detector.collisions(gridPairs, engine); // update collision pairs

          var pairs = engine.pairs,
              timestamp = timing.timestamp;
          Pairs.update(pairs, collisions, timestamp);
          Pairs.removeOld(pairs, timestamp); // wake up bodies involved in collisions

          if (engine.enableSleeping) Sleeping.afterCollisions(pairs.list, timing.timeScale); // trigger collision events

          if (pairs.collisionStart.length > 0) Events.trigger(engine, 'collisionStart', {
            pairs: pairs.collisionStart
          }); // iteratively resolve position between collisions

          Resolver.preSolvePosition(pairs.list);

          for (i = 0; i < engine.positionIterations; i++) {
            Resolver.solvePosition(pairs.list, timing.timeScale);
          }

          Resolver.postSolvePosition(allBodies); // update all constraints (second pass)

          Constraint.preSolveAll(allBodies);

          for (i = 0; i < engine.constraintIterations; i++) {
            Constraint.solveAll(allConstraints, timing.timeScale);
          }

          Constraint.postSolveAll(allBodies); // iteratively resolve velocity between collisions

          Resolver.preSolveVelocity(pairs.list);

          for (i = 0; i < engine.velocityIterations; i++) {
            Resolver.solveVelocity(pairs.list, timing.timeScale);
          } // trigger collision events


          if (pairs.collisionActive.length > 0) Events.trigger(engine, 'collisionActive', {
            pairs: pairs.collisionActive
          });
          if (pairs.collisionEnd.length > 0) Events.trigger(engine, 'collisionEnd', {
            pairs: pairs.collisionEnd
          }); // clear force buffers

          Engine._bodiesClearForces(allBodies);

          Events.trigger(engine, 'afterUpdate', event); // log the time elapsed computing this update

          engine.timing.lastElapsed = Common.now() - startTime;
          return engine;
        };
        /**
         * Merges two engines by keeping the configuration of `engineA` but replacing the world with the one from `engineB`.
         * @method merge
         * @param {engine} engineA
         * @param {engine} engineB
         */


        Engine.merge = function (engineA, engineB) {
          Common.extend(engineA, engineB);

          if (engineB.world) {
            engineA.world = engineB.world;
            Engine.clear(engineA);
            var bodies = Composite.allBodies(engineA.world);

            for (var i = 0; i < bodies.length; i++) {
              var body = bodies[i];
              Sleeping.set(body, false);
              body.id = Common.nextId();
            }
          }
        };
        /**
         * Clears the engine including the world, pairs and broadphase.
         * @method clear
         * @param {engine} engine
         */


        Engine.clear = function (engine) {
          var world = engine.world,
              bodies = Composite.allBodies(world);
          Pairs.clear(engine.pairs);
          Grid.clear(engine.grid);
          Grid.update(engine.grid, bodies, engine, true);
        };
        /**
         * Zeroes the `body.force` and `body.torque` force buffers.
         * @method _bodiesClearForces
         * @private
         * @param {body[]} bodies
         */


        Engine._bodiesClearForces = function (bodies) {
          for (var i = 0; i < bodies.length; i++) {
            var body = bodies[i]; // reset force buffers

            body.force.x = 0;
            body.force.y = 0;
            body.torque = 0;
          }
        };
        /**
         * Applys a mass dependant force to all given bodies.
         * @method _bodiesApplyGravity
         * @private
         * @param {body[]} bodies
         * @param {vector} gravity
         */


        Engine._bodiesApplyGravity = function (bodies, gravity) {
          var gravityScale = typeof gravity.scale !== 'undefined' ? gravity.scale : 0.001;

          if (gravity.x === 0 && gravity.y === 0 || gravityScale === 0) {
            return;
          }

          for (var i = 0; i < bodies.length; i++) {
            var body = bodies[i];
            if (body.isStatic || body.isSleeping) continue; // apply gravity

            body.force.y += body.mass * gravity.y * gravityScale;
            body.force.x += body.mass * gravity.x * gravityScale;
          }
        };
        /**
         * Applys `Body.update` to all given `bodies`.
         * @method _bodiesUpdate
         * @private
         * @param {body[]} bodies
         * @param {number} deltaTime 
         * The amount of time elapsed between updates
         * @param {number} timeScale
         * @param {number} correction 
         * The Verlet correction factor (deltaTime / lastDeltaTime)
         * @param {bounds} worldBounds
         */


        Engine._bodiesUpdate = function (bodies, deltaTime, timeScale, correction, worldBounds) {
          for (var i = 0; i < bodies.length; i++) {
            var body = bodies[i];
            if (body.isStatic || body.isSleeping) continue;
            Body.update(body, deltaTime, timeScale, correction);
          }
        };
        /**
         * A deprecated alias for `Runner.run`, use `Matter.Runner.run(engine)` instead and see `Matter.Runner` for more information.
         * @deprecated use Matter.Runner.run(engine) instead
         * @method run
         * @param {engine} engine
         */

        /**
        * Fired just before an update
        *
        * @event beforeUpdate
        * @param {} event An event object
        * @param {number} event.timestamp The engine.timing.timestamp of the event
        * @param {} event.source The source object of the event
        * @param {} event.name The name of the event
        */

        /**
        * Fired after engine update and all collision events
        *
        * @event afterUpdate
        * @param {} event An event object
        * @param {number} event.timestamp The engine.timing.timestamp of the event
        * @param {} event.source The source object of the event
        * @param {} event.name The name of the event
        */

        /**
        * Fired after engine update, provides a list of all pairs that have started to collide in the current tick (if any)
        *
        * @event collisionStart
        * @param {} event An event object
        * @param {} event.pairs List of affected pairs
        * @param {number} event.timestamp The engine.timing.timestamp of the event
        * @param {} event.source The source object of the event
        * @param {} event.name The name of the event
        */

        /**
        * Fired after engine update, provides a list of all pairs that are colliding in the current tick (if any)
        *
        * @event collisionActive
        * @param {} event An event object
        * @param {} event.pairs List of affected pairs
        * @param {number} event.timestamp The engine.timing.timestamp of the event
        * @param {} event.source The source object of the event
        * @param {} event.name The name of the event
        */

        /**
        * Fired after engine update, provides a list of all pairs that have ended collision in the current tick (if any)
        *
        * @event collisionEnd
        * @param {} event An event object
        * @param {} event.pairs List of affected pairs
        * @param {number} event.timestamp The engine.timing.timestamp of the event
        * @param {} event.source The source object of the event
        * @param {} event.name The name of the event
        */

        /*
        *
        *  Properties Documentation
        *
        */

        /**
         * An integer `Number` that specifies the number of position iterations to perform each update.
         * The higher the value, the higher quality the simulation will be at the expense of performance.
         *
         * @property positionIterations
         * @type number
         * @default 6
         */

        /**
         * An integer `Number` that specifies the number of velocity iterations to perform each update.
         * The higher the value, the higher quality the simulation will be at the expense of performance.
         *
         * @property velocityIterations
         * @type number
         * @default 4
         */

        /**
         * An integer `Number` that specifies the number of constraint iterations to perform each update.
         * The higher the value, the higher quality the simulation will be at the expense of performance.
         * The default value of `2` is usually very adequate.
         *
         * @property constraintIterations
         * @type number
         * @default 2
         */

        /**
         * A flag that specifies whether the engine should allow sleeping via the `Matter.Sleeping` module.
         * Sleeping can improve stability and performance, but often at the expense of accuracy.
         *
         * @property enableSleeping
         * @type boolean
         * @default false
         */

        /**
         * An `Object` containing properties regarding the timing systems of the engine. 
         *
         * @property timing
         * @type object
         */

        /**
         * A `Number` that specifies the global scaling factor of time for all bodies.
         * A value of `0` freezes the simulation.
         * A value of `0.1` gives a slow-motion effect.
         * A value of `1.2` gives a speed-up effect.
         *
         * @property timing.timeScale
         * @type number
         * @default 1
         */

        /**
         * A `Number` that specifies the current simulation-time in milliseconds starting from `0`. 
         * It is incremented on every `Engine.update` by the given `delta` argument. 
         *
         * @property timing.timestamp
         * @type number
         * @default 0
         */

        /**
         * A `Number` that represents the total execution time elapsed during the last `Engine.update` in milliseconds.
         * It is updated by timing from the start of the last `Engine.update` call until it ends.
         *
         * This value will also include the total execution time of all event handlers directly or indirectly triggered by the engine update.
         *
         * @property timing.lastElapsed
         * @type number
         * @default 0
         */

        /**
         * A `Number` that represents the `delta` value used in the last engine update.
         *
         * @property timing.lastDelta
         * @type number
         * @default 0
         */

        /**
         * A `Matter.Grid` instance.
         *
         * @property grid
         * @type grid
         * @default a Matter.Grid instance
         */

        /**
         * Replaced by and now alias for `engine.grid`.
         *
         * @deprecated use `engine.grid`
         * @property broadphase
         * @type grid
         * @default a Matter.Grid instance
         */

        /**
         * The root `Matter.Composite` instance that will contain all bodies, constraints and other composites to be simulated by this engine.
         *
         * @property world
         * @type composite
         * @default a Matter.Composite instance
         */

        /**
         * An object reserved for storing plugin-specific properties.
         *
         * @property plugin
         * @type {}
         */

        /**
         * The gravity to apply on all bodies in `engine.world`.
         *
         * @property gravity
         * @type object
         */

        /**
         * The gravity x component.
         *
         * @property gravity.x
         * @type object
         * @default 0
         */

        /**
         * The gravity y component.
         *
         * @property gravity.y
         * @type object
         * @default 1
         */

        /**
         * The gravity scale factor.
         *
         * @property gravity.scale
         * @type object
         * @default 0.001
         */

      })();
      /***/

    },
    /* 19 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * The `Matter.Resolver` module contains methods for resolving collision pairs.
      *
      * @class Resolver
      */
      var Resolver = {};
      module.exports = Resolver;

      var Vertices = __webpack_require__(3);

      var Vector = __webpack_require__(2);

      var Common = __webpack_require__(0);

      var Bounds = __webpack_require__(1);

      (function () {
        Resolver._restingThresh = 4;
        Resolver._restingThreshTangent = 6;
        Resolver._positionDampen = 0.9;
        Resolver._positionWarming = 0.8;
        Resolver._frictionNormalMultiplier = 5;
        /**
         * Prepare pairs for position solving.
         * @method preSolvePosition
         * @param {pair[]} pairs
         */

        Resolver.preSolvePosition = function (pairs) {
          var i, pair, activeCount; // find total contacts on each body

          for (i = 0; i < pairs.length; i++) {
            pair = pairs[i];
            if (!pair.isActive) continue;
            activeCount = pair.activeContacts.length;
            pair.collision.parentA.totalContacts += activeCount;
            pair.collision.parentB.totalContacts += activeCount;
          }
        };
        /**
         * Find a solution for pair positions.
         * @method solvePosition
         * @param {pair[]} pairs
         * @param {number} timeScale
         */


        Resolver.solvePosition = function (pairs, timeScale) {
          var i,
              pair,
              collision,
              bodyA,
              bodyB,
              normal,
              bodyBtoA,
              contactShare,
              positionImpulse,
              contactCount = {},
              tempA = Vector._temp[0],
              tempB = Vector._temp[1],
              tempC = Vector._temp[2],
              tempD = Vector._temp[3]; // find impulses required to resolve penetration

          for (i = 0; i < pairs.length; i++) {
            pair = pairs[i];
            if (!pair.isActive || pair.isSensor) continue;
            collision = pair.collision;
            bodyA = collision.parentA;
            bodyB = collision.parentB;
            normal = collision.normal; // get current separation between body edges involved in collision

            bodyBtoA = Vector.sub(Vector.add(bodyB.positionImpulse, bodyB.position, tempA), Vector.add(bodyA.positionImpulse, Vector.sub(bodyB.position, collision.penetration, tempB), tempC), tempD);
            pair.separation = Vector.dot(normal, bodyBtoA);
          }

          for (i = 0; i < pairs.length; i++) {
            pair = pairs[i];
            if (!pair.isActive || pair.isSensor) continue;
            collision = pair.collision;
            bodyA = collision.parentA;
            bodyB = collision.parentB;
            normal = collision.normal;
            positionImpulse = (pair.separation - pair.slop) * timeScale;
            if (bodyA.isStatic || bodyB.isStatic) positionImpulse *= 2;

            if (!(bodyA.isStatic || bodyA.isSleeping)) {
              contactShare = Resolver._positionDampen / bodyA.totalContacts;
              bodyA.positionImpulse.x += normal.x * positionImpulse * contactShare;
              bodyA.positionImpulse.y += normal.y * positionImpulse * contactShare;
            }

            if (!(bodyB.isStatic || bodyB.isSleeping)) {
              contactShare = Resolver._positionDampen / bodyB.totalContacts;
              bodyB.positionImpulse.x -= normal.x * positionImpulse * contactShare;
              bodyB.positionImpulse.y -= normal.y * positionImpulse * contactShare;
            }
          }
        };
        /**
         * Apply position resolution.
         * @method postSolvePosition
         * @param {body[]} bodies
         */


        Resolver.postSolvePosition = function (bodies) {
          for (var i = 0; i < bodies.length; i++) {
            var body = bodies[i]; // reset contact count

            body.totalContacts = 0;

            if (body.positionImpulse.x !== 0 || body.positionImpulse.y !== 0) {
              // update body geometry
              for (var j = 0; j < body.parts.length; j++) {
                var part = body.parts[j];
                Vertices.translate(part.vertices, body.positionImpulse);
                Bounds.update(part.bounds, part.vertices, body.velocity);
                part.position.x += body.positionImpulse.x;
                part.position.y += body.positionImpulse.y;
              } // move the body without changing velocity


              body.positionPrev.x += body.positionImpulse.x;
              body.positionPrev.y += body.positionImpulse.y;

              if (Vector.dot(body.positionImpulse, body.velocity) < 0) {
                // reset cached impulse if the body has velocity along it
                body.positionImpulse.x = 0;
                body.positionImpulse.y = 0;
              } else {
                // warm the next iteration
                body.positionImpulse.x *= Resolver._positionWarming;
                body.positionImpulse.y *= Resolver._positionWarming;
              }
            }
          }
        };
        /**
         * Prepare pairs for velocity solving.
         * @method preSolveVelocity
         * @param {pair[]} pairs
         */


        Resolver.preSolveVelocity = function (pairs) {
          var i,
              j,
              pair,
              contacts,
              collision,
              bodyA,
              bodyB,
              normal,
              tangent,
              contact,
              contactVertex,
              normalImpulse,
              tangentImpulse,
              offset,
              impulse = Vector._temp[0],
              tempA = Vector._temp[1];

          for (i = 0; i < pairs.length; i++) {
            pair = pairs[i];
            if (!pair.isActive || pair.isSensor) continue;
            contacts = pair.activeContacts;
            collision = pair.collision;
            bodyA = collision.parentA;
            bodyB = collision.parentB;
            normal = collision.normal;
            tangent = collision.tangent; // resolve each contact

            for (j = 0; j < contacts.length; j++) {
              contact = contacts[j];
              contactVertex = contact.vertex;
              normalImpulse = contact.normalImpulse;
              tangentImpulse = contact.tangentImpulse;

              if (normalImpulse !== 0 || tangentImpulse !== 0) {
                // total impulse from contact
                impulse.x = normal.x * normalImpulse + tangent.x * tangentImpulse;
                impulse.y = normal.y * normalImpulse + tangent.y * tangentImpulse; // apply impulse from contact

                if (!(bodyA.isStatic || bodyA.isSleeping)) {
                  offset = Vector.sub(contactVertex, bodyA.position, tempA);
                  bodyA.positionPrev.x += impulse.x * bodyA.inverseMass;
                  bodyA.positionPrev.y += impulse.y * bodyA.inverseMass;
                  bodyA.anglePrev += Vector.cross(offset, impulse) * bodyA.inverseInertia;
                }

                if (!(bodyB.isStatic || bodyB.isSleeping)) {
                  offset = Vector.sub(contactVertex, bodyB.position, tempA);
                  bodyB.positionPrev.x -= impulse.x * bodyB.inverseMass;
                  bodyB.positionPrev.y -= impulse.y * bodyB.inverseMass;
                  bodyB.anglePrev -= Vector.cross(offset, impulse) * bodyB.inverseInertia;
                }
              }
            }
          }
        };
        /**
         * Find a solution for pair velocities.
         * @method solveVelocity
         * @param {pair[]} pairs
         * @param {number} timeScale
         */


        Resolver.solveVelocity = function (pairs, timeScale) {
          var timeScaleSquared = timeScale * timeScale,
              impulse = Vector._temp[0],
              tempA = Vector._temp[1],
              tempB = Vector._temp[2],
              tempC = Vector._temp[3],
              tempD = Vector._temp[4],
              tempE = Vector._temp[5];

          for (var i = 0; i < pairs.length; i++) {
            var pair = pairs[i];
            if (!pair.isActive || pair.isSensor) continue;
            var collision = pair.collision,
                bodyA = collision.parentA,
                bodyB = collision.parentB,
                normal = collision.normal,
                tangent = collision.tangent,
                contacts = pair.activeContacts,
                contactShare = 1 / contacts.length; // update body velocities

            bodyA.velocity.x = bodyA.position.x - bodyA.positionPrev.x;
            bodyA.velocity.y = bodyA.position.y - bodyA.positionPrev.y;
            bodyB.velocity.x = bodyB.position.x - bodyB.positionPrev.x;
            bodyB.velocity.y = bodyB.position.y - bodyB.positionPrev.y;
            bodyA.angularVelocity = bodyA.angle - bodyA.anglePrev;
            bodyB.angularVelocity = bodyB.angle - bodyB.anglePrev; // resolve each contact

            for (var j = 0; j < contacts.length; j++) {
              var contact = contacts[j],
                  contactVertex = contact.vertex,
                  offsetA = Vector.sub(contactVertex, bodyA.position, tempA),
                  offsetB = Vector.sub(contactVertex, bodyB.position, tempB),
                  velocityPointA = Vector.add(bodyA.velocity, Vector.mult(Vector.perp(offsetA), bodyA.angularVelocity), tempC),
                  velocityPointB = Vector.add(bodyB.velocity, Vector.mult(Vector.perp(offsetB), bodyB.angularVelocity), tempD),
                  relativeVelocity = Vector.sub(velocityPointA, velocityPointB, tempE),
                  normalVelocity = Vector.dot(normal, relativeVelocity);
              var tangentVelocity = Vector.dot(tangent, relativeVelocity),
                  tangentSpeed = Math.abs(tangentVelocity),
                  tangentVelocityDirection = Common.sign(tangentVelocity); // raw impulses

              var normalImpulse = (1 + pair.restitution) * normalVelocity,
                  normalForce = Common.clamp(pair.separation + normalVelocity, 0, 1) * Resolver._frictionNormalMultiplier; // coulomb friction


              var tangentImpulse = tangentVelocity,
                  maxFriction = Infinity;

              if (tangentSpeed > pair.friction * pair.frictionStatic * normalForce * timeScaleSquared) {
                maxFriction = tangentSpeed;
                tangentImpulse = Common.clamp(pair.friction * tangentVelocityDirection * timeScaleSquared, -maxFriction, maxFriction);
              } // modify impulses accounting for mass, inertia and offset


              var oAcN = Vector.cross(offsetA, normal),
                  oBcN = Vector.cross(offsetB, normal),
                  share = contactShare / (bodyA.inverseMass + bodyB.inverseMass + bodyA.inverseInertia * oAcN * oAcN + bodyB.inverseInertia * oBcN * oBcN);
              normalImpulse *= share;
              tangentImpulse *= share; // handle high velocity and resting collisions separately

              if (normalVelocity < 0 && normalVelocity * normalVelocity > Resolver._restingThresh * timeScaleSquared) {
                // high normal velocity so clear cached contact normal impulse
                contact.normalImpulse = 0;
              } else {
                // solve resting collision constraints using Erin Catto's method (GDC08)
                // impulse constraint tends to 0
                var contactNormalImpulse = contact.normalImpulse;
                contact.normalImpulse = Math.min(contact.normalImpulse + normalImpulse, 0);
                normalImpulse = contact.normalImpulse - contactNormalImpulse;
              } // handle high velocity and resting collisions separately


              if (tangentVelocity * tangentVelocity > Resolver._restingThreshTangent * timeScaleSquared) {
                // high tangent velocity so clear cached contact tangent impulse
                contact.tangentImpulse = 0;
              } else {
                // solve resting collision constraints using Erin Catto's method (GDC08)
                // tangent impulse tends to -tangentSpeed or +tangentSpeed
                var contactTangentImpulse = contact.tangentImpulse;
                contact.tangentImpulse = Common.clamp(contact.tangentImpulse + tangentImpulse, -maxFriction, maxFriction);
                tangentImpulse = contact.tangentImpulse - contactTangentImpulse;
              } // total impulse from contact


              impulse.x = normal.x * normalImpulse + tangent.x * tangentImpulse;
              impulse.y = normal.y * normalImpulse + tangent.y * tangentImpulse; // apply impulse from contact

              if (!(bodyA.isStatic || bodyA.isSleeping)) {
                bodyA.positionPrev.x += impulse.x * bodyA.inverseMass;
                bodyA.positionPrev.y += impulse.y * bodyA.inverseMass;
                bodyA.anglePrev += Vector.cross(offsetA, impulse) * bodyA.inverseInertia;
              }

              if (!(bodyB.isStatic || bodyB.isSleeping)) {
                bodyB.positionPrev.x -= impulse.x * bodyB.inverseMass;
                bodyB.positionPrev.y -= impulse.y * bodyB.inverseMass;
                bodyB.anglePrev -= Vector.cross(offsetB, impulse) * bodyB.inverseInertia;
              }
            }
          }
        };
      })();
      /***/

    },
    /* 20 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * The `Matter.Pairs` module contains methods for creating and manipulating collision pair sets.
      *
      * @class Pairs
      */
      var Pairs = {};
      module.exports = Pairs;

      var Pair = __webpack_require__(9);

      var Common = __webpack_require__(0);

      (function () {
        Pairs._pairMaxIdleLife = 1000;
        /**
         * Creates a new pairs structure.
         * @method create
         * @param {object} options
         * @return {pairs} A new pairs structure
         */

        Pairs.create = function (options) {
          return Common.extend({
            table: {},
            list: [],
            collisionStart: [],
            collisionActive: [],
            collisionEnd: []
          }, options);
        };
        /**
         * Updates pairs given a list of collisions.
         * @method update
         * @param {object} pairs
         * @param {collision[]} collisions
         * @param {number} timestamp
         */


        Pairs.update = function (pairs, collisions, timestamp) {
          var pairsList = pairs.list,
              pairsTable = pairs.table,
              collisionStart = pairs.collisionStart,
              collisionEnd = pairs.collisionEnd,
              collisionActive = pairs.collisionActive,
              collision,
              pairId,
              pair,
              i; // clear collision state arrays, but maintain old reference

          collisionStart.length = 0;
          collisionEnd.length = 0;
          collisionActive.length = 0;

          for (i = 0; i < pairsList.length; i++) {
            pairsList[i].confirmedActive = false;
          }

          for (i = 0; i < collisions.length; i++) {
            collision = collisions[i];

            if (collision.collided) {
              pairId = Pair.id(collision.bodyA, collision.bodyB);
              pair = pairsTable[pairId];

              if (pair) {
                // pair already exists (but may or may not be active)
                if (pair.isActive) {
                  // pair exists and is active
                  collisionActive.push(pair);
                } else {
                  // pair exists but was inactive, so a collision has just started again
                  collisionStart.push(pair);
                } // update the pair


                Pair.update(pair, collision, timestamp);
                pair.confirmedActive = true;
              } else {
                // pair did not exist, create a new pair
                pair = Pair.create(collision, timestamp);
                pairsTable[pairId] = pair; // push the new pair

                collisionStart.push(pair);
                pairsList.push(pair);
              }
            }
          } // deactivate previously active pairs that are now inactive


          for (i = 0; i < pairsList.length; i++) {
            pair = pairsList[i];

            if (pair.isActive && !pair.confirmedActive) {
              Pair.setActive(pair, false, timestamp);
              collisionEnd.push(pair);
            }
          }
        };
        /**
         * Finds and removes pairs that have been inactive for a set amount of time.
         * @method removeOld
         * @param {object} pairs
         * @param {number} timestamp
         */


        Pairs.removeOld = function (pairs, timestamp) {
          var pairsList = pairs.list,
              pairsTable = pairs.table,
              indexesToRemove = [],
              pair,
              collision,
              pairIndex,
              i;

          for (i = 0; i < pairsList.length; i++) {
            pair = pairsList[i];
            collision = pair.collision; // never remove sleeping pairs

            if (collision.bodyA.isSleeping || collision.bodyB.isSleeping) {
              pair.timeUpdated = timestamp;
              continue;
            } // if pair is inactive for too long, mark it to be removed


            if (timestamp - pair.timeUpdated > Pairs._pairMaxIdleLife) {
              indexesToRemove.push(i);
            }
          } // remove marked pairs


          for (i = 0; i < indexesToRemove.length; i++) {
            pairIndex = indexesToRemove[i] - i;
            pair = pairsList[pairIndex];
            delete pairsTable[pair.id];
            pairsList.splice(pairIndex, 1);
          }
        };
        /**
         * Clears the given pairs structure.
         * @method clear
         * @param {pairs} pairs
         * @return {pairs} pairs
         */


        Pairs.clear = function (pairs) {
          pairs.table = {};
          pairs.list.length = 0;
          pairs.collisionStart.length = 0;
          pairs.collisionActive.length = 0;
          pairs.collisionEnd.length = 0;
          return pairs;
        };
      })();
      /***/

    },
    /* 21 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * The `Matter.Grid` module contains methods for creating and manipulating collision broadphase grid structures.
      *
      * @class Grid
      */
      var Grid = {};
      module.exports = Grid;

      var Pair = __webpack_require__(9);

      var Common = __webpack_require__(0);

      (function () {
        /**
         * Creates a new grid.
         * @method create
         * @param {} options
         * @return {grid} A new grid
         */
        Grid.create = function (options) {
          var defaults = {
            buckets: {},
            pairs: {},
            pairsList: [],
            bucketWidth: 48,
            bucketHeight: 48
          };
          return Common.extend(defaults, options);
        };
        /**
         * The width of a single grid bucket.
         *
         * @property bucketWidth
         * @type number
         * @default 48
         */

        /**
         * The height of a single grid bucket.
         *
         * @property bucketHeight
         * @type number
         * @default 48
         */

        /**
         * Updates the grid.
         * @method update
         * @param {grid} grid
         * @param {body[]} bodies
         * @param {engine} engine
         * @param {boolean} forceUpdate
         */


        Grid.update = function (grid, bodies, engine, forceUpdate) {
          var i,
              col,
              row,
              world = engine.world,
              buckets = grid.buckets,
              bucket,
              bucketId,
              gridChanged = false;

          for (i = 0; i < bodies.length; i++) {
            var body = bodies[i];
            if (body.isSleeping && !forceUpdate) continue; // temporary back compatibility bounds check

            if (world.bounds && (body.bounds.max.x < world.bounds.min.x || body.bounds.min.x > world.bounds.max.x || body.bounds.max.y < world.bounds.min.y || body.bounds.min.y > world.bounds.max.y)) continue;

            var newRegion = Grid._getRegion(grid, body); // if the body has changed grid region


            if (!body.region || newRegion.id !== body.region.id || forceUpdate) {
              if (!body.region || forceUpdate) body.region = newRegion;

              var union = Grid._regionUnion(newRegion, body.region); // update grid buckets affected by region change
              // iterate over the union of both regions


              for (col = union.startCol; col <= union.endCol; col++) {
                for (row = union.startRow; row <= union.endRow; row++) {
                  bucketId = Grid._getBucketId(col, row);
                  bucket = buckets[bucketId];
                  var isInsideNewRegion = col >= newRegion.startCol && col <= newRegion.endCol && row >= newRegion.startRow && row <= newRegion.endRow;
                  var isInsideOldRegion = col >= body.region.startCol && col <= body.region.endCol && row >= body.region.startRow && row <= body.region.endRow; // remove from old region buckets

                  if (!isInsideNewRegion && isInsideOldRegion) {
                    if (isInsideOldRegion) {
                      if (bucket) Grid._bucketRemoveBody(grid, bucket, body);
                    }
                  } // add to new region buckets


                  if (body.region === newRegion || isInsideNewRegion && !isInsideOldRegion || forceUpdate) {
                    if (!bucket) bucket = Grid._createBucket(buckets, bucketId);

                    Grid._bucketAddBody(grid, bucket, body);
                  }
                }
              } // set the new region


              body.region = newRegion; // flag changes so we can update pairs

              gridChanged = true;
            }
          } // update pairs list only if pairs changed (i.e. a body changed region)


          if (gridChanged) grid.pairsList = Grid._createActivePairsList(grid);
        };
        /**
         * Clears the grid.
         * @method clear
         * @param {grid} grid
         */


        Grid.clear = function (grid) {
          grid.buckets = {};
          grid.pairs = {};
          grid.pairsList = [];
        };
        /**
         * Finds the union of two regions.
         * @method _regionUnion
         * @private
         * @param {} regionA
         * @param {} regionB
         * @return {} region
         */


        Grid._regionUnion = function (regionA, regionB) {
          var startCol = Math.min(regionA.startCol, regionB.startCol),
              endCol = Math.max(regionA.endCol, regionB.endCol),
              startRow = Math.min(regionA.startRow, regionB.startRow),
              endRow = Math.max(regionA.endRow, regionB.endRow);
          return Grid._createRegion(startCol, endCol, startRow, endRow);
        };
        /**
         * Gets the region a given body falls in for a given grid.
         * @method _getRegion
         * @private
         * @param {} grid
         * @param {} body
         * @return {} region
         */


        Grid._getRegion = function (grid, body) {
          var bounds = body.bounds,
              startCol = Math.floor(bounds.min.x / grid.bucketWidth),
              endCol = Math.floor(bounds.max.x / grid.bucketWidth),
              startRow = Math.floor(bounds.min.y / grid.bucketHeight),
              endRow = Math.floor(bounds.max.y / grid.bucketHeight);
          return Grid._createRegion(startCol, endCol, startRow, endRow);
        };
        /**
         * Creates a region.
         * @method _createRegion
         * @private
         * @param {} startCol
         * @param {} endCol
         * @param {} startRow
         * @param {} endRow
         * @return {} region
         */


        Grid._createRegion = function (startCol, endCol, startRow, endRow) {
          return {
            id: startCol + ',' + endCol + ',' + startRow + ',' + endRow,
            startCol: startCol,
            endCol: endCol,
            startRow: startRow,
            endRow: endRow
          };
        };
        /**
         * Gets the bucket id at the given position.
         * @method _getBucketId
         * @private
         * @param {} column
         * @param {} row
         * @return {string} bucket id
         */


        Grid._getBucketId = function (column, row) {
          return 'C' + column + 'R' + row;
        };
        /**
         * Creates a bucket.
         * @method _createBucket
         * @private
         * @param {} buckets
         * @param {} bucketId
         * @return {} bucket
         */


        Grid._createBucket = function (buckets, bucketId) {
          var bucket = buckets[bucketId] = [];
          return bucket;
        };
        /**
         * Adds a body to a bucket.
         * @method _bucketAddBody
         * @private
         * @param {} grid
         * @param {} bucket
         * @param {} body
         */


        Grid._bucketAddBody = function (grid, bucket, body) {
          // add new pairs
          for (var i = 0; i < bucket.length; i++) {
            var bodyB = bucket[i];
            if (body.id === bodyB.id || body.isStatic && bodyB.isStatic) continue; // keep track of the number of buckets the pair exists in
            // important for Grid.update to work

            var pairId = Pair.id(body, bodyB),
                pair = grid.pairs[pairId];

            if (pair) {
              pair[2] += 1;
            } else {
              grid.pairs[pairId] = [body, bodyB, 1];
            }
          } // add to bodies (after pairs, otherwise pairs with self)


          bucket.push(body);
        };
        /**
         * Removes a body from a bucket.
         * @method _bucketRemoveBody
         * @private
         * @param {} grid
         * @param {} bucket
         * @param {} body
         */


        Grid._bucketRemoveBody = function (grid, bucket, body) {
          // remove from bucket
          bucket.splice(Common.indexOf(bucket, body), 1); // update pair counts

          for (var i = 0; i < bucket.length; i++) {
            // keep track of the number of buckets the pair exists in
            // important for _createActivePairsList to work
            var bodyB = bucket[i],
                pairId = Pair.id(body, bodyB),
                pair = grid.pairs[pairId];
            if (pair) pair[2] -= 1;
          }
        };
        /**
         * Generates a list of the active pairs in the grid.
         * @method _createActivePairsList
         * @private
         * @param {} grid
         * @return [] pairs
         */


        Grid._createActivePairsList = function (grid) {
          var pairKeys,
              pair,
              pairs = []; // grid.pairs is used as a hashmap

          pairKeys = Common.keys(grid.pairs); // iterate over grid.pairs

          for (var k = 0; k < pairKeys.length; k++) {
            pair = grid.pairs[pairKeys[k]]; // if pair exists in at least one bucket
            // it is a pair that needs further collision testing so push it

            if (pair[2] > 0) {
              pairs.push(pair);
            } else {
              delete grid.pairs[pairKeys[k]];
            }
          }

          return pairs;
        };
      })();
      /***/

    },
    /* 22 */

    /***/
    function (module, exports, __webpack_require__) {
      var Matter = module.exports = __webpack_require__(23);

      Matter.Axes = __webpack_require__(10);
      Matter.Bodies = __webpack_require__(11);
      Matter.Body = __webpack_require__(6);
      Matter.Bounds = __webpack_require__(1);
      Matter.Common = __webpack_require__(0);
      Matter.Composite = __webpack_require__(5);
      Matter.Composites = __webpack_require__(24);
      Matter.Constraint = __webpack_require__(8);
      Matter.Contact = __webpack_require__(17);
      Matter.Detector = __webpack_require__(13);
      Matter.Engine = __webpack_require__(18);
      Matter.Events = __webpack_require__(4);
      Matter.Grid = __webpack_require__(21);
      Matter.Mouse = __webpack_require__(12);
      Matter.MouseConstraint = __webpack_require__(25);
      Matter.Pair = __webpack_require__(9);
      Matter.Pairs = __webpack_require__(20);
      Matter.Plugin = __webpack_require__(15);
      Matter.Query = __webpack_require__(26);
      Matter.Render = __webpack_require__(16);
      Matter.Resolver = __webpack_require__(19);
      Matter.Runner = __webpack_require__(27);
      Matter.SAT = __webpack_require__(14);
      Matter.Sleeping = __webpack_require__(7);
      Matter.Svg = __webpack_require__(28);
      Matter.Vector = __webpack_require__(2);
      Matter.Vertices = __webpack_require__(3);
      Matter.World = __webpack_require__(29); // temporary back compatibility

      Matter.Engine.run = Matter.Runner.run;
      Matter.Common.deprecated(Matter.Engine, 'run', 'Engine.run ➤ use Matter.Runner.run(engine) instead');
      /***/
    },
    /* 23 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * The `Matter` module is the top level namespace. It also includes a function for installing plugins on top of the library.
      *
      * @class Matter
      */
      var Matter = {};
      module.exports = Matter;

      var Plugin = __webpack_require__(15);

      var Common = __webpack_require__(0);

      (function () {
        /**
         * The library name.
         * @property name
         * @readOnly
         * @type {String}
         */
        Matter.name = 'matter-js';
        /**
         * The library version.
         * @property version
         * @readOnly
         * @type {String}
         */

        Matter.version = true ? "0.17.1" : undefined;
        /**
         * A list of plugin dependencies to be installed. These are normally set and installed through `Matter.use`.
         * Alternatively you may set `Matter.uses` manually and install them by calling `Plugin.use(Matter)`.
         * @property uses
         * @type {Array}
         */

        Matter.uses = [];
        /**
         * The plugins that have been installed through `Matter.Plugin.install`. Read only.
         * @property used
         * @readOnly
         * @type {Array}
         */

        Matter.used = [];
        /**
         * Installs the given plugins on the `Matter` namespace.
         * This is a short-hand for `Plugin.use`, see it for more information.
         * Call this function once at the start of your code, with all of the plugins you wish to install as arguments.
         * Avoid calling this function multiple times unless you intend to manually control installation order.
         * @method use
         * @param ...plugin {Function} The plugin(s) to install on `base` (multi-argument).
         */

        Matter.use = function () {
          Plugin.use(Matter, Array.prototype.slice.call(arguments));
        };
        /**
         * Chains a function to excute before the original function on the given `path` relative to `Matter`.
         * See also docs for `Common.chain`.
         * @method before
         * @param {string} path The path relative to `Matter`
         * @param {function} func The function to chain before the original
         * @return {function} The chained function that replaced the original
         */


        Matter.before = function (path, func) {
          path = path.replace(/^Matter./, '');
          return Common.chainPathBefore(Matter, path, func);
        };
        /**
         * Chains a function to excute after the original function on the given `path` relative to `Matter`.
         * See also docs for `Common.chain`.
         * @method after
         * @param {string} path The path relative to `Matter`
         * @param {function} func The function to chain after the original
         * @return {function} The chained function that replaced the original
         */


        Matter.after = function (path, func) {
          path = path.replace(/^Matter./, '');
          return Common.chainPathAfter(Matter, path, func);
        };
      })();
      /***/

    },
    /* 24 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * The `Matter.Composites` module contains factory methods for creating composite bodies
      * with commonly used configurations (such as stacks and chains).
      *
      * See the included usage [examples](https://github.com/liabru/matter-js/tree/master/examples).
      *
      * @class Composites
      */
      var Composites = {};
      module.exports = Composites;

      var Composite = __webpack_require__(5);

      var Constraint = __webpack_require__(8);

      var Common = __webpack_require__(0);

      var Body = __webpack_require__(6);

      var Bodies = __webpack_require__(11);

      var deprecated = Common.deprecated;

      (function () {
        /**
         * Create a new composite containing bodies created in the callback in a grid arrangement.
         * This function uses the body's bounds to prevent overlaps.
         * @method stack
         * @param {number} xx
         * @param {number} yy
         * @param {number} columns
         * @param {number} rows
         * @param {number} columnGap
         * @param {number} rowGap
         * @param {function} callback
         * @return {composite} A new composite containing objects created in the callback
         */
        Composites.stack = function (xx, yy, columns, rows, columnGap, rowGap, callback) {
          var stack = Composite.create({
            label: 'Stack'
          }),
              x = xx,
              y = yy,
              lastBody,
              i = 0;

          for (var row = 0; row < rows; row++) {
            var maxHeight = 0;

            for (var column = 0; column < columns; column++) {
              var body = callback(x, y, column, row, lastBody, i);

              if (body) {
                var bodyHeight = body.bounds.max.y - body.bounds.min.y,
                    bodyWidth = body.bounds.max.x - body.bounds.min.x;
                if (bodyHeight > maxHeight) maxHeight = bodyHeight;
                Body.translate(body, {
                  x: bodyWidth * 0.5,
                  y: bodyHeight * 0.5
                });
                x = body.bounds.max.x + columnGap;
                Composite.addBody(stack, body);
                lastBody = body;
                i += 1;
              } else {
                x += columnGap;
              }
            }

            y += maxHeight + rowGap;
            x = xx;
          }

          return stack;
        };
        /**
         * Chains all bodies in the given composite together using constraints.
         * @method chain
         * @param {composite} composite
         * @param {number} xOffsetA
         * @param {number} yOffsetA
         * @param {number} xOffsetB
         * @param {number} yOffsetB
         * @param {object} options
         * @return {composite} A new composite containing objects chained together with constraints
         */


        Composites.chain = function (composite, xOffsetA, yOffsetA, xOffsetB, yOffsetB, options) {
          var bodies = composite.bodies;

          for (var i = 1; i < bodies.length; i++) {
            var bodyA = bodies[i - 1],
                bodyB = bodies[i],
                bodyAHeight = bodyA.bounds.max.y - bodyA.bounds.min.y,
                bodyAWidth = bodyA.bounds.max.x - bodyA.bounds.min.x,
                bodyBHeight = bodyB.bounds.max.y - bodyB.bounds.min.y,
                bodyBWidth = bodyB.bounds.max.x - bodyB.bounds.min.x;
            var defaults = {
              bodyA: bodyA,
              pointA: {
                x: bodyAWidth * xOffsetA,
                y: bodyAHeight * yOffsetA
              },
              bodyB: bodyB,
              pointB: {
                x: bodyBWidth * xOffsetB,
                y: bodyBHeight * yOffsetB
              }
            };
            var constraint = Common.extend(defaults, options);
            Composite.addConstraint(composite, Constraint.create(constraint));
          }

          composite.label += ' Chain';
          return composite;
        };
        /**
         * Connects bodies in the composite with constraints in a grid pattern, with optional cross braces.
         * @method mesh
         * @param {composite} composite
         * @param {number} columns
         * @param {number} rows
         * @param {boolean} crossBrace
         * @param {object} options
         * @return {composite} The composite containing objects meshed together with constraints
         */


        Composites.mesh = function (composite, columns, rows, crossBrace, options) {
          var bodies = composite.bodies,
              row,
              col,
              bodyA,
              bodyB,
              bodyC;

          for (row = 0; row < rows; row++) {
            for (col = 1; col < columns; col++) {
              bodyA = bodies[col - 1 + row * columns];
              bodyB = bodies[col + row * columns];
              Composite.addConstraint(composite, Constraint.create(Common.extend({
                bodyA: bodyA,
                bodyB: bodyB
              }, options)));
            }

            if (row > 0) {
              for (col = 0; col < columns; col++) {
                bodyA = bodies[col + (row - 1) * columns];
                bodyB = bodies[col + row * columns];
                Composite.addConstraint(composite, Constraint.create(Common.extend({
                  bodyA: bodyA,
                  bodyB: bodyB
                }, options)));

                if (crossBrace && col > 0) {
                  bodyC = bodies[col - 1 + (row - 1) * columns];
                  Composite.addConstraint(composite, Constraint.create(Common.extend({
                    bodyA: bodyC,
                    bodyB: bodyB
                  }, options)));
                }

                if (crossBrace && col < columns - 1) {
                  bodyC = bodies[col + 1 + (row - 1) * columns];
                  Composite.addConstraint(composite, Constraint.create(Common.extend({
                    bodyA: bodyC,
                    bodyB: bodyB
                  }, options)));
                }
              }
            }
          }

          composite.label += ' Mesh';
          return composite;
        };
        /**
         * Create a new composite containing bodies created in the callback in a pyramid arrangement.
         * This function uses the body's bounds to prevent overlaps.
         * @method pyramid
         * @param {number} xx
         * @param {number} yy
         * @param {number} columns
         * @param {number} rows
         * @param {number} columnGap
         * @param {number} rowGap
         * @param {function} callback
         * @return {composite} A new composite containing objects created in the callback
         */


        Composites.pyramid = function (xx, yy, columns, rows, columnGap, rowGap, callback) {
          return Composites.stack(xx, yy, columns, rows, columnGap, rowGap, function (x, y, column, row, lastBody, i) {
            var actualRows = Math.min(rows, Math.ceil(columns / 2)),
                lastBodyWidth = lastBody ? lastBody.bounds.max.x - lastBody.bounds.min.x : 0;
            if (row > actualRows) return; // reverse row order

            row = actualRows - row;
            var start = row,
                end = columns - 1 - row;
            if (column < start || column > end) return; // retroactively fix the first body's position, since width was unknown

            if (i === 1) {
              Body.translate(lastBody, {
                x: (column + (columns % 2 === 1 ? 1 : -1)) * lastBodyWidth,
                y: 0
              });
            }

            var xOffset = lastBody ? column * lastBodyWidth : 0;
            return callback(xx + xOffset + column * columnGap, y, column, row, lastBody, i);
          });
        };
        /**
         * This has now moved to the [newtonsCradle example](https://github.com/liabru/matter-js/blob/master/examples/newtonsCradle.js), follow that instead as this function is deprecated here.
         * @deprecated moved to newtonsCradle example
         * @method newtonsCradle
         * @param {number} xx
         * @param {number} yy
         * @param {number} number
         * @param {number} size
         * @param {number} length
         * @return {composite} A new composite newtonsCradle body
         */


        Composites.newtonsCradle = function (xx, yy, number, size, length) {
          var newtonsCradle = Composite.create({
            label: 'Newtons Cradle'
          });

          for (var i = 0; i < number; i++) {
            var separation = 1.9,
                circle = Bodies.circle(xx + i * (size * separation), yy + length, size, {
              inertia: Infinity,
              restitution: 1,
              friction: 0,
              frictionAir: 0.0001,
              slop: 1
            }),
                constraint = Constraint.create({
              pointA: {
                x: xx + i * (size * separation),
                y: yy
              },
              bodyB: circle
            });
            Composite.addBody(newtonsCradle, circle);
            Composite.addConstraint(newtonsCradle, constraint);
          }

          return newtonsCradle;
        };

        deprecated(Composites, 'newtonsCradle', 'Composites.newtonsCradle ➤ moved to newtonsCradle example');
        /**
         * This has now moved to the [car example](https://github.com/liabru/matter-js/blob/master/examples/car.js), follow that instead as this function is deprecated here.
         * @deprecated moved to car example
         * @method car
         * @param {number} xx
         * @param {number} yy
         * @param {number} width
         * @param {number} height
         * @param {number} wheelSize
         * @return {composite} A new composite car body
         */

        Composites.car = function (xx, yy, width, height, wheelSize) {
          var group = Body.nextGroup(true),
              wheelBase = 20,
              wheelAOffset = -width * 0.5 + wheelBase,
              wheelBOffset = width * 0.5 - wheelBase,
              wheelYOffset = 0;
          var car = Composite.create({
            label: 'Car'
          }),
              body = Bodies.rectangle(xx, yy, width, height, {
            collisionFilter: {
              group: group
            },
            chamfer: {
              radius: height * 0.5
            },
            density: 0.0002
          });
          var wheelA = Bodies.circle(xx + wheelAOffset, yy + wheelYOffset, wheelSize, {
            collisionFilter: {
              group: group
            },
            friction: 0.8
          });
          var wheelB = Bodies.circle(xx + wheelBOffset, yy + wheelYOffset, wheelSize, {
            collisionFilter: {
              group: group
            },
            friction: 0.8
          });
          var axelA = Constraint.create({
            bodyB: body,
            pointB: {
              x: wheelAOffset,
              y: wheelYOffset
            },
            bodyA: wheelA,
            stiffness: 1,
            length: 0
          });
          var axelB = Constraint.create({
            bodyB: body,
            pointB: {
              x: wheelBOffset,
              y: wheelYOffset
            },
            bodyA: wheelB,
            stiffness: 1,
            length: 0
          });
          Composite.addBody(car, body);
          Composite.addBody(car, wheelA);
          Composite.addBody(car, wheelB);
          Composite.addConstraint(car, axelA);
          Composite.addConstraint(car, axelB);
          return car;
        };

        deprecated(Composites, 'car', 'Composites.car ➤ moved to car example');
        /**
         * This has now moved to the [softBody example](https://github.com/liabru/matter-js/blob/master/examples/softBody.js)
         * and the [cloth example](https://github.com/liabru/matter-js/blob/master/examples/cloth.js), follow those instead as this function is deprecated here.
         * @deprecated moved to softBody and cloth examples
         * @method softBody
         * @param {number} xx
         * @param {number} yy
         * @param {number} columns
         * @param {number} rows
         * @param {number} columnGap
         * @param {number} rowGap
         * @param {boolean} crossBrace
         * @param {number} particleRadius
         * @param {} particleOptions
         * @param {} constraintOptions
         * @return {composite} A new composite softBody
         */

        Composites.softBody = function (xx, yy, columns, rows, columnGap, rowGap, crossBrace, particleRadius, particleOptions, constraintOptions) {
          particleOptions = Common.extend({
            inertia: Infinity
          }, particleOptions);
          constraintOptions = Common.extend({
            stiffness: 0.2,
            render: {
              type: 'line',
              anchors: false
            }
          }, constraintOptions);
          var softBody = Composites.stack(xx, yy, columns, rows, columnGap, rowGap, function (x, y) {
            return Bodies.circle(x, y, particleRadius, particleOptions);
          });
          Composites.mesh(softBody, columns, rows, crossBrace, constraintOptions);
          softBody.label = 'Soft Body';
          return softBody;
        };

        deprecated(Composites, 'softBody', 'Composites.softBody ➤ moved to softBody and cloth examples');
      })();
      /***/

    },
    /* 25 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * The `Matter.MouseConstraint` module contains methods for creating mouse constraints.
      * Mouse constraints are used for allowing user interaction, providing the ability to move bodies via the mouse or touch.
      *
      * See the included usage [examples](https://github.com/liabru/matter-js/tree/master/examples).
      *
      * @class MouseConstraint
      */
      var MouseConstraint = {};
      module.exports = MouseConstraint;

      var Vertices = __webpack_require__(3);

      var Sleeping = __webpack_require__(7);

      var Mouse = __webpack_require__(12);

      var Events = __webpack_require__(4);

      var Detector = __webpack_require__(13);

      var Constraint = __webpack_require__(8);

      var Composite = __webpack_require__(5);

      var Common = __webpack_require__(0);

      var Bounds = __webpack_require__(1);

      (function () {
        /**
         * Creates a new mouse constraint.
         * All properties have default values, and many are pre-calculated automatically based on other properties.
         * See the properties section below for detailed information on what you can pass via the `options` object.
         * @method create
         * @param {engine} engine
         * @param {} options
         * @return {MouseConstraint} A new MouseConstraint
         */
        MouseConstraint.create = function (engine, options) {
          var mouse = (engine ? engine.mouse : null) || (options ? options.mouse : null);

          if (!mouse) {
            if (engine && engine.render && engine.render.canvas) {
              mouse = Mouse.create(engine.render.canvas);
            } else if (options && options.element) {
              mouse = Mouse.create(options.element);
            } else {
              mouse = Mouse.create();
              Common.warn('MouseConstraint.create: options.mouse was undefined, options.element was undefined, may not function as expected');
            }
          }

          var constraint = Constraint.create({
            label: 'Mouse Constraint',
            pointA: mouse.position,
            pointB: {
              x: 0,
              y: 0
            },
            length: 0.01,
            stiffness: 0.1,
            angularStiffness: 1,
            render: {
              strokeStyle: '#90EE90',
              lineWidth: 3
            }
          });
          var defaults = {
            type: 'mouseConstraint',
            mouse: mouse,
            element: null,
            body: null,
            constraint: constraint,
            collisionFilter: {
              category: 0x0001,
              mask: 0xFFFFFFFF,
              group: 0
            }
          };
          var mouseConstraint = Common.extend(defaults, options);
          Events.on(engine, 'beforeUpdate', function () {
            var allBodies = Composite.allBodies(engine.world);
            MouseConstraint.update(mouseConstraint, allBodies);

            MouseConstraint._triggerEvents(mouseConstraint);
          });
          return mouseConstraint;
        };
        /**
         * Updates the given mouse constraint.
         * @private
         * @method update
         * @param {MouseConstraint} mouseConstraint
         * @param {body[]} bodies
         */


        MouseConstraint.update = function (mouseConstraint, bodies) {
          var mouse = mouseConstraint.mouse,
              constraint = mouseConstraint.constraint,
              body = mouseConstraint.body;

          if (mouse.button === 0) {
            if (!constraint.bodyB) {
              for (var i = 0; i < bodies.length; i++) {
                body = bodies[i];

                if (Bounds.contains(body.bounds, mouse.position) && Detector.canCollide(body.collisionFilter, mouseConstraint.collisionFilter)) {
                  for (var j = body.parts.length > 1 ? 1 : 0; j < body.parts.length; j++) {
                    var part = body.parts[j];

                    if (Vertices.contains(part.vertices, mouse.position)) {
                      constraint.pointA = mouse.position;
                      constraint.bodyB = mouseConstraint.body = body;
                      constraint.pointB = {
                        x: mouse.position.x - body.position.x,
                        y: mouse.position.y - body.position.y
                      };
                      constraint.angleB = body.angle;
                      Sleeping.set(body, false);
                      Events.trigger(mouseConstraint, 'startdrag', {
                        mouse: mouse,
                        body: body
                      });
                      break;
                    }
                  }
                }
              }
            } else {
              Sleeping.set(constraint.bodyB, false);
              constraint.pointA = mouse.position;
            }
          } else {
            constraint.bodyB = mouseConstraint.body = null;
            constraint.pointB = null;
            if (body) Events.trigger(mouseConstraint, 'enddrag', {
              mouse: mouse,
              body: body
            });
          }
        };
        /**
         * Triggers mouse constraint events.
         * @method _triggerEvents
         * @private
         * @param {mouse} mouseConstraint
         */


        MouseConstraint._triggerEvents = function (mouseConstraint) {
          var mouse = mouseConstraint.mouse,
              mouseEvents = mouse.sourceEvents;
          if (mouseEvents.mousemove) Events.trigger(mouseConstraint, 'mousemove', {
            mouse: mouse
          });
          if (mouseEvents.mousedown) Events.trigger(mouseConstraint, 'mousedown', {
            mouse: mouse
          });
          if (mouseEvents.mouseup) Events.trigger(mouseConstraint, 'mouseup', {
            mouse: mouse
          }); // reset the mouse state ready for the next step

          Mouse.clearSourceEvents(mouse);
        };
        /*
        *
        *  Events Documentation
        *
        */

        /**
        * Fired when the mouse has moved (or a touch moves) during the last step
        *
        * @event mousemove
        * @param {} event An event object
        * @param {mouse} event.mouse The engine's mouse instance
        * @param {} event.source The source object of the event
        * @param {} event.name The name of the event
        */

        /**
        * Fired when the mouse is down (or a touch has started) during the last step
        *
        * @event mousedown
        * @param {} event An event object
        * @param {mouse} event.mouse The engine's mouse instance
        * @param {} event.source The source object of the event
        * @param {} event.name The name of the event
        */

        /**
        * Fired when the mouse is up (or a touch has ended) during the last step
        *
        * @event mouseup
        * @param {} event An event object
        * @param {mouse} event.mouse The engine's mouse instance
        * @param {} event.source The source object of the event
        * @param {} event.name The name of the event
        */

        /**
        * Fired when the user starts dragging a body
        *
        * @event startdrag
        * @param {} event An event object
        * @param {mouse} event.mouse The engine's mouse instance
        * @param {body} event.body The body being dragged
        * @param {} event.source The source object of the event
        * @param {} event.name The name of the event
        */

        /**
        * Fired when the user ends dragging a body
        *
        * @event enddrag
        * @param {} event An event object
        * @param {mouse} event.mouse The engine's mouse instance
        * @param {body} event.body The body that has stopped being dragged
        * @param {} event.source The source object of the event
        * @param {} event.name The name of the event
        */

        /*
        *
        *  Properties Documentation
        *
        */

        /**
         * A `String` denoting the type of object.
         *
         * @property type
         * @type string
         * @default "constraint"
         * @readOnly
         */

        /**
         * The `Mouse` instance in use. If not supplied in `MouseConstraint.create`, one will be created.
         *
         * @property mouse
         * @type mouse
         * @default mouse
         */

        /**
         * The `Body` that is currently being moved by the user, or `null` if no body.
         *
         * @property body
         * @type body
         * @default null
         */

        /**
         * The `Constraint` object that is used to move the body during interaction.
         *
         * @property constraint
         * @type constraint
         */

        /**
         * An `Object` that specifies the collision filter properties.
         * The collision filter allows the user to define which types of body this mouse constraint can interact with.
         * See `body.collisionFilter` for more information.
         *
         * @property collisionFilter
         * @type object
         */

      })();
      /***/

    },
    /* 26 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * The `Matter.Query` module contains methods for performing collision queries.
      *
      * See the included usage [examples](https://github.com/liabru/matter-js/tree/master/examples).
      *
      * @class Query
      */
      var Query = {};
      module.exports = Query;

      var Vector = __webpack_require__(2);

      var SAT = __webpack_require__(14);

      var Bounds = __webpack_require__(1);

      var Bodies = __webpack_require__(11);

      var Vertices = __webpack_require__(3);

      (function () {
        /**
         * Returns a list of collisions between `body` and `bodies`.
         * @method collides
         * @param {body} body
         * @param {body[]} bodies
         * @return {object[]} Collisions
         */
        Query.collides = function (body, bodies) {
          var collisions = [];

          for (var i = 0; i < bodies.length; i++) {
            var bodyA = bodies[i];

            if (Bounds.overlaps(bodyA.bounds, body.bounds)) {
              for (var j = bodyA.parts.length === 1 ? 0 : 1; j < bodyA.parts.length; j++) {
                var part = bodyA.parts[j];

                if (Bounds.overlaps(part.bounds, body.bounds)) {
                  var collision = SAT.collides(part, body);

                  if (collision.collided) {
                    collisions.push(collision);
                    break;
                  }
                }
              }
            }
          }

          return collisions;
        };
        /**
         * Casts a ray segment against a set of bodies and returns all collisions, ray width is optional. Intersection points are not provided.
         * @method ray
         * @param {body[]} bodies
         * @param {vector} startPoint
         * @param {vector} endPoint
         * @param {number} [rayWidth]
         * @return {object[]} Collisions
         */


        Query.ray = function (bodies, startPoint, endPoint, rayWidth) {
          rayWidth = rayWidth || 1e-100;
          var rayAngle = Vector.angle(startPoint, endPoint),
              rayLength = Vector.magnitude(Vector.sub(startPoint, endPoint)),
              rayX = (endPoint.x + startPoint.x) * 0.5,
              rayY = (endPoint.y + startPoint.y) * 0.5,
              ray = Bodies.rectangle(rayX, rayY, rayLength, rayWidth, {
            angle: rayAngle
          }),
              collisions = Query.collides(ray, bodies);

          for (var i = 0; i < collisions.length; i += 1) {
            var collision = collisions[i];
            collision.body = collision.bodyB = collision.bodyA;
          }

          return collisions;
        };
        /**
         * Returns all bodies whose bounds are inside (or outside if set) the given set of bounds, from the given set of bodies.
         * @method region
         * @param {body[]} bodies
         * @param {bounds} bounds
         * @param {bool} [outside=false]
         * @return {body[]} The bodies matching the query
         */


        Query.region = function (bodies, bounds, outside) {
          var result = [];

          for (var i = 0; i < bodies.length; i++) {
            var body = bodies[i],
                overlaps = Bounds.overlaps(body.bounds, bounds);
            if (overlaps && !outside || !overlaps && outside) result.push(body);
          }

          return result;
        };
        /**
         * Returns all bodies whose vertices contain the given point, from the given set of bodies.
         * @method point
         * @param {body[]} bodies
         * @param {vector} point
         * @return {body[]} The bodies matching the query
         */


        Query.point = function (bodies, point) {
          var result = [];

          for (var i = 0; i < bodies.length; i++) {
            var body = bodies[i];

            if (Bounds.contains(body.bounds, point)) {
              for (var j = body.parts.length === 1 ? 0 : 1; j < body.parts.length; j++) {
                var part = body.parts[j];

                if (Bounds.contains(part.bounds, point) && Vertices.contains(part.vertices, point)) {
                  result.push(body);
                  break;
                }
              }
            }
          }

          return result;
        };
      })();
      /***/

    },
    /* 27 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * The `Matter.Runner` module is an optional utility which provides a game loop, 
      * that handles continuously updating a `Matter.Engine` for you within a browser.
      * It is intended for development and debugging purposes, but may also be suitable for simple games.
      * If you are using your own game loop instead, then you do not need the `Matter.Runner` module.
      * Instead just call `Engine.update(engine, delta)` in your own loop.
      *
      * See the included usage [examples](https://github.com/liabru/matter-js/tree/master/examples).
      *
      * @class Runner
      */
      var Runner = {};
      module.exports = Runner;

      var Events = __webpack_require__(4);

      var Engine = __webpack_require__(18);

      var Common = __webpack_require__(0);

      (function () {
        var _requestAnimationFrame, _cancelAnimationFrame;

        if (typeof window !== 'undefined') {
          _requestAnimationFrame = window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.msRequestAnimationFrame;
          _cancelAnimationFrame = window.cancelAnimationFrame || window.mozCancelAnimationFrame || window.webkitCancelAnimationFrame || window.msCancelAnimationFrame;
        }

        if (!_requestAnimationFrame) {
          var _frameTimeout;

          _requestAnimationFrame = function _requestAnimationFrame(callback) {
            _frameTimeout = setTimeout(function () {
              callback(Common.now());
            }, 1000 / 60);
          };

          _cancelAnimationFrame = function _cancelAnimationFrame() {
            clearTimeout(_frameTimeout);
          };
        }
        /**
         * Creates a new Runner. The options parameter is an object that specifies any properties you wish to override the defaults.
         * @method create
         * @param {} options
         */


        Runner.create = function (options) {
          var defaults = {
            fps: 60,
            correction: 1,
            deltaSampleSize: 60,
            counterTimestamp: 0,
            frameCounter: 0,
            deltaHistory: [],
            timePrev: null,
            timeScalePrev: 1,
            frameRequestId: null,
            isFixed: false,
            enabled: true
          };
          var runner = Common.extend(defaults, options);
          runner.delta = runner.delta || 1000 / runner.fps;
          runner.deltaMin = runner.deltaMin || 1000 / runner.fps;
          runner.deltaMax = runner.deltaMax || 1000 / (runner.fps * 0.5);
          runner.fps = 1000 / runner.delta;
          return runner;
        };
        /**
         * Continuously ticks a `Matter.Engine` by calling `Runner.tick` on the `requestAnimationFrame` event.
         * @method run
         * @param {engine} engine
         */


        Runner.run = function (runner, engine) {
          // create runner if engine is first argument
          if (typeof runner.positionIterations !== 'undefined') {
            engine = runner;
            runner = Runner.create();
          }

          (function render(time) {
            runner.frameRequestId = _requestAnimationFrame(render);

            if (time && runner.enabled) {
              Runner.tick(runner, engine, time);
            }
          })();

          return runner;
        };
        /**
         * A game loop utility that updates the engine and renderer by one step (a 'tick').
         * Features delta smoothing, time correction and fixed or dynamic timing.
         * Consider just `Engine.update(engine, delta)` if you're using your own loop.
         * @method tick
         * @param {runner} runner
         * @param {engine} engine
         * @param {number} time
         */


        Runner.tick = function (runner, engine, time) {
          var timing = engine.timing,
              correction = 1,
              delta; // create an event object

          var event = {
            timestamp: timing.timestamp
          };
          Events.trigger(runner, 'beforeTick', event);

          if (runner.isFixed) {
            // fixed timestep
            delta = runner.delta;
          } else {
            // dynamic timestep based on wall clock between calls
            delta = time - runner.timePrev || runner.delta;
            runner.timePrev = time; // optimistically filter delta over a few frames, to improve stability

            runner.deltaHistory.push(delta);
            runner.deltaHistory = runner.deltaHistory.slice(-runner.deltaSampleSize);
            delta = Math.min.apply(null, runner.deltaHistory); // limit delta

            delta = delta < runner.deltaMin ? runner.deltaMin : delta;
            delta = delta > runner.deltaMax ? runner.deltaMax : delta; // correction for delta

            correction = delta / runner.delta; // update engine timing object

            runner.delta = delta;
          } // time correction for time scaling


          if (runner.timeScalePrev !== 0) correction *= timing.timeScale / runner.timeScalePrev;
          if (timing.timeScale === 0) correction = 0;
          runner.timeScalePrev = timing.timeScale;
          runner.correction = correction; // fps counter

          runner.frameCounter += 1;

          if (time - runner.counterTimestamp >= 1000) {
            runner.fps = runner.frameCounter * ((time - runner.counterTimestamp) / 1000);
            runner.counterTimestamp = time;
            runner.frameCounter = 0;
          }

          Events.trigger(runner, 'tick', event); // update

          Events.trigger(runner, 'beforeUpdate', event);
          Engine.update(engine, delta, correction);
          Events.trigger(runner, 'afterUpdate', event);
          Events.trigger(runner, 'afterTick', event);
        };
        /**
         * Ends execution of `Runner.run` on the given `runner`, by canceling the animation frame request event loop.
         * If you wish to only temporarily pause the engine, see `engine.enabled` instead.
         * @method stop
         * @param {runner} runner
         */


        Runner.stop = function (runner) {
          _cancelAnimationFrame(runner.frameRequestId);
        };
        /**
         * Alias for `Runner.run`.
         * @method start
         * @param {runner} runner
         * @param {engine} engine
         */


        Runner.start = function (runner, engine) {
          Runner.run(runner, engine);
        };
        /*
        *
        *  Events Documentation
        *
        */

        /**
        * Fired at the start of a tick, before any updates to the engine or timing
        *
        * @event beforeTick
        * @param {} event An event object
        * @param {number} event.timestamp The engine.timing.timestamp of the event
        * @param {} event.source The source object of the event
        * @param {} event.name The name of the event
        */

        /**
        * Fired after engine timing updated, but just before update
        *
        * @event tick
        * @param {} event An event object
        * @param {number} event.timestamp The engine.timing.timestamp of the event
        * @param {} event.source The source object of the event
        * @param {} event.name The name of the event
        */

        /**
        * Fired at the end of a tick, after engine update and after rendering
        *
        * @event afterTick
        * @param {} event An event object
        * @param {number} event.timestamp The engine.timing.timestamp of the event
        * @param {} event.source The source object of the event
        * @param {} event.name The name of the event
        */

        /**
        * Fired before update
        *
        * @event beforeUpdate
        * @param {} event An event object
        * @param {number} event.timestamp The engine.timing.timestamp of the event
        * @param {} event.source The source object of the event
        * @param {} event.name The name of the event
        */

        /**
        * Fired after update
        *
        * @event afterUpdate
        * @param {} event An event object
        * @param {number} event.timestamp The engine.timing.timestamp of the event
        * @param {} event.source The source object of the event
        * @param {} event.name The name of the event
        */

        /*
        *
        *  Properties Documentation
        *
        */

        /**
         * A flag that specifies whether the runner is running or not.
         *
         * @property enabled
         * @type boolean
         * @default true
         */

        /**
         * A `Boolean` that specifies if the runner should use a fixed timestep (otherwise it is variable).
         * If timing is fixed, then the apparent simulation speed will change depending on the frame rate (but behaviour will be deterministic).
         * If the timing is variable, then the apparent simulation speed will be constant (approximately, but at the cost of determininism).
         *
         * @property isFixed
         * @type boolean
         * @default false
         */

        /**
         * A `Number` that specifies the time step between updates in milliseconds.
         * If `engine.timing.isFixed` is set to `true`, then `delta` is fixed.
         * If it is `false`, then `delta` can dynamically change to maintain the correct apparent simulation speed.
         *
         * @property delta
         * @type number
         * @default 1000 / 60
         */

      })();
      /***/

    },
    /* 28 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * The `Matter.Svg` module contains methods for converting SVG images into an array of vector points.
      *
      * To use this module you also need the SVGPathSeg polyfill: https://github.com/progers/pathseg
      *
      * See the included usage [examples](https://github.com/liabru/matter-js/tree/master/examples).
      *
      * @class Svg
      */
      var Svg = {};
      module.exports = Svg;

      var Bounds = __webpack_require__(1);

      var Common = __webpack_require__(0);

      (function () {
        /**
         * Converts an SVG path into an array of vector points.
         * If the input path forms a concave shape, you must decompose the result into convex parts before use.
         * See `Bodies.fromVertices` which provides support for this.
         * Note that this function is not guaranteed to support complex paths (such as those with holes).
         * You must load the `pathseg.js` polyfill on newer browsers.
         * @method pathToVertices
         * @param {SVGPathElement} path
         * @param {Number} [sampleLength=15]
         * @return {Vector[]} points
         */
        Svg.pathToVertices = function (path, sampleLength) {
          if (typeof window !== 'undefined' && !('SVGPathSeg' in window)) {
            Common.warn('Svg.pathToVertices: SVGPathSeg not defined, a polyfill is required.');
          } // https://github.com/wout/svg.topoly.js/blob/master/svg.topoly.js


          var i,
              il,
              total,
              point,
              segment,
              segments,
              segmentsQueue,
              lastSegment,
              lastPoint,
              segmentIndex,
              points = [],
              lx,
              ly,
              length = 0,
              x = 0,
              y = 0;
          sampleLength = sampleLength || 15;

          var addPoint = function addPoint(px, py, pathSegType) {
            // all odd-numbered path types are relative except PATHSEG_CLOSEPATH (1)
            var isRelative = pathSegType % 2 === 1 && pathSegType > 1; // when the last point doesn't equal the current point add the current point

            if (!lastPoint || px != lastPoint.x || py != lastPoint.y) {
              if (lastPoint && isRelative) {
                lx = lastPoint.x;
                ly = lastPoint.y;
              } else {
                lx = 0;
                ly = 0;
              }

              var point = {
                x: lx + px,
                y: ly + py
              }; // set last point

              if (isRelative || !lastPoint) {
                lastPoint = point;
              }

              points.push(point);
              x = lx + px;
              y = ly + py;
            }
          };

          var addSegmentPoint = function addSegmentPoint(segment) {
            var segType = segment.pathSegTypeAsLetter.toUpperCase(); // skip path ends

            if (segType === 'Z') return; // map segment to x and y

            switch (segType) {
              case 'M':
              case 'L':
              case 'T':
              case 'C':
              case 'S':
              case 'Q':
                x = segment.x;
                y = segment.y;
                break;

              case 'H':
                x = segment.x;
                break;

              case 'V':
                y = segment.y;
                break;
            }

            addPoint(x, y, segment.pathSegType);
          }; // ensure path is absolute


          Svg._svgPathToAbsolute(path); // get total length


          total = path.getTotalLength(); // queue segments

          segments = [];

          for (i = 0; i < path.pathSegList.numberOfItems; i += 1) {
            segments.push(path.pathSegList.getItem(i));
          }

          segmentsQueue = segments.concat(); // sample through path

          while (length < total) {
            // get segment at position
            segmentIndex = path.getPathSegAtLength(length);
            segment = segments[segmentIndex]; // new segment

            if (segment != lastSegment) {
              while (segmentsQueue.length && segmentsQueue[0] != segment) {
                addSegmentPoint(segmentsQueue.shift());
              }

              lastSegment = segment;
            } // add points in between when curving
            // TODO: adaptive sampling


            switch (segment.pathSegTypeAsLetter.toUpperCase()) {
              case 'C':
              case 'T':
              case 'S':
              case 'Q':
              case 'A':
                point = path.getPointAtLength(length);
                addPoint(point.x, point.y, 0);
                break;
            } // increment by sample value


            length += sampleLength;
          } // add remaining segments not passed by sampling


          for (i = 0, il = segmentsQueue.length; i < il; ++i) {
            addSegmentPoint(segmentsQueue[i]);
          }

          return points;
        };

        Svg._svgPathToAbsolute = function (path) {
          // http://phrogz.net/convert-svg-path-to-all-absolute-commands
          // Copyright (c) Gavin Kistner
          // http://phrogz.net/js/_ReuseLicense.txt
          // Modifications: tidy formatting and naming
          var x0,
              y0,
              x1,
              y1,
              x2,
              y2,
              segs = path.pathSegList,
              x = 0,
              y = 0,
              len = segs.numberOfItems;

          for (var i = 0; i < len; ++i) {
            var seg = segs.getItem(i),
                segType = seg.pathSegTypeAsLetter;

            if (/[MLHVCSQTA]/.test(segType)) {
              if ('x' in seg) x = seg.x;
              if ('y' in seg) y = seg.y;
            } else {
              if ('x1' in seg) x1 = x + seg.x1;
              if ('x2' in seg) x2 = x + seg.x2;
              if ('y1' in seg) y1 = y + seg.y1;
              if ('y2' in seg) y2 = y + seg.y2;
              if ('x' in seg) x += seg.x;
              if ('y' in seg) y += seg.y;

              switch (segType) {
                case 'm':
                  segs.replaceItem(path.createSVGPathSegMovetoAbs(x, y), i);
                  break;

                case 'l':
                  segs.replaceItem(path.createSVGPathSegLinetoAbs(x, y), i);
                  break;

                case 'h':
                  segs.replaceItem(path.createSVGPathSegLinetoHorizontalAbs(x), i);
                  break;

                case 'v':
                  segs.replaceItem(path.createSVGPathSegLinetoVerticalAbs(y), i);
                  break;

                case 'c':
                  segs.replaceItem(path.createSVGPathSegCurvetoCubicAbs(x, y, x1, y1, x2, y2), i);
                  break;

                case 's':
                  segs.replaceItem(path.createSVGPathSegCurvetoCubicSmoothAbs(x, y, x2, y2), i);
                  break;

                case 'q':
                  segs.replaceItem(path.createSVGPathSegCurvetoQuadraticAbs(x, y, x1, y1), i);
                  break;

                case 't':
                  segs.replaceItem(path.createSVGPathSegCurvetoQuadraticSmoothAbs(x, y), i);
                  break;

                case 'a':
                  segs.replaceItem(path.createSVGPathSegArcAbs(x, y, seg.r1, seg.r2, seg.angle, seg.largeArcFlag, seg.sweepFlag), i);
                  break;

                case 'z':
                case 'Z':
                  x = x0;
                  y = y0;
                  break;
              }
            }

            if (segType == 'M' || segType == 'm') {
              x0 = x;
              y0 = y;
            }
          }
        };
      })();
      /***/

    },
    /* 29 */

    /***/
    function (module, exports, __webpack_require__) {
      /**
      * This module has now been replaced by `Matter.Composite`.
      *
      * All usage should be migrated to the equivalent functions found on `Matter.Composite`.
      * For example `World.add(world, body)` now becomes `Composite.add(world, body)`.
      *
      * The property `world.gravity` has been moved to `engine.gravity`.
      *
      * For back-compatibility purposes this module will remain as a direct alias to `Matter.Composite` in the short term during migration.
      * Eventually this alias module will be marked as deprecated and then later removed in a future release.
      *
      * @class World
      */
      var World = {};
      module.exports = World;

      var Composite = __webpack_require__(5);

      var Common = __webpack_require__(0);

      (function () {
        /**
         * See above, aliases for back compatibility only
         */
        World.create = Composite.create;
        World.add = Composite.add;
        World.remove = Composite.remove;
        World.clear = Composite.clear;
        World.addComposite = Composite.addComposite;
        World.addBody = Composite.addBody;
        World.addConstraint = Composite.addConstraint;
      })();
      /***/

    }
    /******/
    ])
  );
});
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../../webpack/buildin/global.js */ "./node_modules/webpack/buildin/global.js"), __webpack_require__(/*! ./../../webpack/buildin/module.js */ "./node_modules/webpack/buildin/module.js")(module)))

/***/ }),

/***/ "./node_modules/webpack/buildin/global.js":
/*!***********************************!*\
  !*** (webpack)/buildin/global.js ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports) {

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var g; // This works in non-strict mode

g = function () {
  return this;
}();

try {
  // This works if eval is allowed (see CSP)
  g = g || new Function("return this")();
} catch (e) {
  // This works if the window reference is available
  if ((typeof window === "undefined" ? "undefined" : _typeof(window)) === "object") g = window;
} // g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}


module.exports = g;

/***/ }),

/***/ "./node_modules/webpack/buildin/module.js":
/*!***********************************!*\
  !*** (webpack)/buildin/module.js ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = function (module) {
  if (!module.webpackPolyfill) {
    module.deprecate = function () {};

    module.paths = []; // module.parent = undefined by default

    if (!module.children) module.children = [];
    Object.defineProperty(module, "loaded", {
      enumerable: true,
      get: function get() {
        return module.l;
      }
    });
    Object.defineProperty(module, "id", {
      enumerable: true,
      get: function get() {
        return module.i;
      }
    });
    module.webpackPolyfill = 1;
  }

  return module;
};

/***/ }),

/***/ "./src/Clock.ts":
/*!**********************!*\
  !*** ./src/Clock.ts ***!
  \**********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var Clock = (function () {
    function Clock(autoStart) {
        if (autoStart === void 0) { autoStart = true; }
        this.autoStart = autoStart;
        this.startTime = 0;
        this.oldTime = 0;
        this.elapsedTime = 0;
        this.running = false;
    }
    Clock.prototype.start = function () {
        this.startTime = (typeof performance === 'undefined' ? Date : performance).now();
        this.oldTime = this.startTime;
        this.elapsedTime = 0;
        this.running = true;
    };
    Clock.prototype.stop = function () {
        this.running = false;
        this.autoStart = false;
        return this.getElapsedTime();
    };
    Clock.prototype.getElapsedTime = function () {
        this.getDelta();
        return this.elapsedTime;
    };
    Clock.prototype.getDelta = function () {
        var diff = 0;
        if (this.autoStart && !this.running) {
            this.start();
            return 0;
        }
        if (this.running) {
            var newTime = (typeof performance === 'undefined' ? Date : performance).now();
            diff = (newTime - this.oldTime) / 1000;
            this.oldTime = newTime;
            this.elapsedTime += diff;
        }
        return diff;
    };
    return Clock;
}());
exports.default = Clock;


/***/ }),

/***/ "./src/Main.ts":
/*!*********************!*\
  !*** ./src/Main.ts ***!
  \*********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Main = exports.GDispatcher = void 0;
var layers_1 = __webpack_require__(/*! ../module/views/layers */ "./module/views/layers.ts");
var RES_1 = __webpack_require__(/*! ../module/RES */ "./module/RES.ts");
var ctrls_1 = __webpack_require__(/*! ../module/ctrls */ "./module/ctrls/index.ts");
var ResJson_1 = __webpack_require__(/*! ./ResJson */ "./src/ResJson.ts");
var IndexScene_1 = __importDefault(__webpack_require__(/*! ./scenes/IndexScene */ "./src/scenes/IndexScene.ts"));
var TaoBaoNet_1 = __webpack_require__(/*! ./TaoBaoNet */ "./src/TaoBaoNet.ts");
var SkinJson_1 = __webpack_require__(/*! ./SkinJson */ "./src/SkinJson.ts");
var G_EVENT_1 = __webpack_require__(/*! ./common/G_EVENT */ "./src/common/G_EVENT.ts");
var Tools_1 = __webpack_require__(/*! ./Tools */ "./src/Tools.ts");
var InvationScene_1 = __importDefault(__webpack_require__(/*! ./scenes/HomeScene/InvationScene */ "./src/scenes/HomeScene/InvationScene.ts"));
var HomeScene_1 = __importDefault(__webpack_require__(/*! ./scenes/HomeScene/HomeScene */ "./src/scenes/HomeScene/HomeScene.ts"));
exports.GDispatcher = new FYGE.EventDispatcher();
var Main = (function () {
    function Main(canvas) {
        var sysInfo;
        if (!window) {
            FYGE.initedByCanvas(canvas);
            sysInfo = my.getSystemInfoSync();
        }
        var stage = new FYGE.Stage(canvas, 750, 1624, sysInfo && sysInfo.windowWidth || document.body.clientWidth, sysInfo && sysInfo.windowHeight || document.body.clientHeight, FYGE.RENDERER_TYPE.WEBGL, true, false, sysInfo && sysInfo.pixelRatio || window.devicePixelRatio || 1);
        this.stage = stage;
        this.canvas = canvas;
        stage.addEventListener(FYGE.Event.INIT_STAGE, this.onAddToStage, this);
        var self = this;
        loop();
        function loop() {
            if (!self._pause) {
                FYGE.Tween.flush();
                stage.flush();
            }
            FYGE.getEnv() == "tb" ? self.requestID = canvas.requestAnimationFrame(loop) :
                self.requestID = window.requestAnimationFrame(loop);
        }
    }
    Main.prototype.run = function () {
        this._pause = false;
        FYGE.Tween._lastTime = null;
        exports.GDispatcher.dispatchEvent({ type: G_EVENT_1.G_EVENT.ON_SHOW });
    };
    Main.prototype.pause = function () {
        exports.GDispatcher.dispatchEvent({ type: G_EVENT_1.G_EVENT.ON_HIDE });
    };
    Main.prototype.addGlobalEvent = function (name, fun, thisObj, once) {
        if (once === void 0) { once = false; }
        if (once) {
            exports.GDispatcher.once(name, fun, thisObj);
        }
        else {
            exports.GDispatcher.addEventListener(name, fun, thisObj);
        }
    };
    Main.prototype.dispatchGlobalEvent = function (name, data) {
        exports.GDispatcher.dispatchEvent(name, data);
    };
    Main.prototype.removeGlobalEvent = function (name, fun, thisObj) {
        exports.GDispatcher.removeEventListener(name, fun, thisObj);
    };
    Main.prototype.destroy = function () {
        FYGE.Tween.removeAllTweens();
        FYGE.getEnv() == "tb" ? this.canvas.cancelAnimationFrame(this.requestID) :
            window.cancelAnimationFrame(this.requestID);
        layers_1.destroyLayers();
        ctrls_1.destroyAllCtrls();
        this.stage.destroy();
        exports.GDispatcher.removeAllEventListener();
        TaoBaoNet_1.destroyTbNetData();
    };
    Main.prototype.onAddToStage = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a, _b, newUser, _c, firstLoginToday;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        layers_1.layers.init(this.stage);
                        RES_1.RES.loadConfig(ResJson_1.ResJson);
                        RES_1.RES.loadSkinConfig(SkinJson_1.SkinJson);
                        return [4, RES_1.RES.loadGroup("common")];
                    case 1:
                        _d.sent();
                        if (FYGE.getEnv() == "web" && document.getElementById("__loading__"))
                            document.getElementById("__loading__").style.display = "none";
                        ctrls_1.showWaiting();
                        return [4, Tools_1.Tools.getGlobalData()];
                    case 2:
                        _d.sent();
                        return [4, Tools_1.Tools.getActivityInfo()];
                    case 3:
                        _d.sent();
                        console.log("9999---->>>>", Tools_1.Tools.globalData);
                        _a = Tools_1.Tools.globalData, _b = _a.newUser, newUser = _b === void 0 ? false : _b, _c = _a.firstLoginToday, firstLoginToday = _c === void 0 ? false : _c;
                        if (newUser && firstLoginToday) {
                            ctrls_1.changeScene(InvationScene_1.default, { first: true });
                        }
                        else {
                            ctrls_1.changeScene(HomeScene_1.default);
                        }
                        getApp().goGameScene = function () {
                            ctrls_1.changeScene(IndexScene_1.default);
                        };
                        ctrls_1.hideWaiting();
                        return [2];
                }
            });
        });
    };
    return Main;
}());
exports.Main = Main;


/***/ }),

/***/ "./src/ResJson.ts":
/*!************************!*\
  !*** ./src/ResJson.ts ***!
  \************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ResJson = void 0;
exports.ResJson = {
    "groups": [
        {
            "keys": "again.png,组.png",
            "name": "FailPanel",
            "atlas": {
                "组.png": {
                    "x": 2,
                    "y": 2,
                    "w": 614,
                    "h": 708,
                    "ox": 0,
                    "oy": 0,
                    "sw": 614,
                    "sh": 708,
                    "ro": false
                },
                "again.png": {
                    "x": 618,
                    "y": 2,
                    "w": 313,
                    "h": 120,
                    "ox": 0,
                    "oy": 0,
                    "sw": 313,
                    "sh": 120,
                    "ro": true
                }
            }
        },
        {
            "keys": "gameBg.jpg,goal_AI.png,goal_Player.png,score_0.png,score_1.png,score_2.png,score_3.png,score_4.png,score_5.png,score_6.png,score_7.png,score_8.png,score_9.png,timeBg.png,time_0.png,time_1.png,time_2.png,time_3.png,time_4.png,time_5.png,time_6.png,time_7.png,time_8.png,time_9.png,time_f.png,推手.png,红球.png",
            "name": "GameScene",
            "atlas": {
                "goal_AI.png": {
                    "x": 2,
                    "y": 2,
                    "w": 663,
                    "h": 297,
                    "ox": 0,
                    "oy": 0,
                    "sw": 663,
                    "sh": 297,
                    "ro": false
                },
                "goal_Player.png": {
                    "x": 2,
                    "y": 301,
                    "w": 663,
                    "h": 288,
                    "ox": 0,
                    "oy": 0,
                    "sw": 663,
                    "sh": 288,
                    "ro": false
                },
                "timeBg.png": {
                    "x": 2,
                    "y": 591,
                    "w": 237,
                    "h": 76,
                    "ox": 0,
                    "oy": 0,
                    "sw": 237,
                    "sh": 76,
                    "ro": false
                },
                "推手.png": {
                    "x": 667,
                    "y": 2,
                    "w": 187,
                    "h": 191,
                    "ox": 0,
                    "oy": 0,
                    "sw": 187,
                    "sh": 191,
                    "ro": false
                },
                "红球.png": {
                    "x": 667,
                    "y": 195,
                    "w": 150,
                    "h": 155,
                    "ox": 0,
                    "oy": 0,
                    "sw": 150,
                    "sh": 155,
                    "ro": true
                },
                "score_0.png": {
                    "x": 241,
                    "y": 591,
                    "w": 46,
                    "h": 64,
                    "ox": 0,
                    "oy": 0,
                    "sw": 46,
                    "sh": 64,
                    "ro": false
                },
                "score_3.png": {
                    "x": 289,
                    "y": 591,
                    "w": 46,
                    "h": 64,
                    "ox": 0,
                    "oy": 0,
                    "sw": 46,
                    "sh": 64,
                    "ro": false
                },
                "score_6.png": {
                    "x": 337,
                    "y": 591,
                    "w": 46,
                    "h": 64,
                    "ox": 0,
                    "oy": 0,
                    "sw": 46,
                    "sh": 64,
                    "ro": false
                },
                "score_8.png": {
                    "x": 385,
                    "y": 591,
                    "w": 46,
                    "h": 64,
                    "ox": 0,
                    "oy": 0,
                    "sw": 46,
                    "sh": 64,
                    "ro": false
                },
                "score_9.png": {
                    "x": 433,
                    "y": 591,
                    "w": 46,
                    "h": 64,
                    "ox": 0,
                    "oy": 0,
                    "sw": 46,
                    "sh": 64,
                    "ro": false
                },
                "score_1.png": {
                    "x": 481,
                    "y": 591,
                    "w": 34,
                    "h": 63,
                    "ox": 0,
                    "oy": 0,
                    "sw": 34,
                    "sh": 64,
                    "ro": false
                },
                "score_2.png": {
                    "x": 517,
                    "y": 591,
                    "w": 44,
                    "h": 63,
                    "ox": 0,
                    "oy": 0,
                    "sw": 44,
                    "sh": 64,
                    "ro": false
                },
                "score_4.png": {
                    "x": 563,
                    "y": 591,
                    "w": 47,
                    "h": 63,
                    "ox": 0,
                    "oy": 0,
                    "sw": 47,
                    "sh": 64,
                    "ro": false
                },
                "score_5.png": {
                    "x": 612,
                    "y": 591,
                    "w": 45,
                    "h": 62,
                    "ox": 0,
                    "oy": 1,
                    "sw": 45,
                    "sh": 64,
                    "ro": false
                },
                "score_7.png": {
                    "x": 659,
                    "y": 591,
                    "w": 45,
                    "h": 61,
                    "ox": 0,
                    "oy": 1,
                    "sw": 44,
                    "sh": 64,
                    "ro": false
                },
                "time_0.png": {
                    "x": 824,
                    "y": 195,
                    "w": 26,
                    "h": 34,
                    "ox": 0,
                    "oy": 0,
                    "sw": 26,
                    "sh": 34,
                    "ro": false
                },
                "time_3.png": {
                    "x": 824,
                    "y": 231,
                    "w": 25,
                    "h": 34,
                    "ox": 0,
                    "oy": 0,
                    "sw": 25,
                    "sh": 34,
                    "ro": false
                },
                "time_6.png": {
                    "x": 824,
                    "y": 267,
                    "w": 25,
                    "h": 34,
                    "ox": 0,
                    "oy": 0,
                    "sw": 25,
                    "sh": 34,
                    "ro": false
                },
                "time_8.png": {
                    "x": 824,
                    "y": 303,
                    "w": 26,
                    "h": 34,
                    "ox": 0,
                    "oy": 0,
                    "sw": 26,
                    "sh": 34,
                    "ro": false
                },
                "time_9.png": {
                    "x": 824,
                    "y": 339,
                    "w": 25,
                    "h": 34,
                    "ox": 0,
                    "oy": 0,
                    "sw": 25,
                    "sh": 34,
                    "ro": false
                },
                "time_1.png": {
                    "x": 706,
                    "y": 347,
                    "w": 19,
                    "h": 33,
                    "ox": 0,
                    "oy": 0,
                    "sw": 18,
                    "sh": 34,
                    "ro": true
                },
                "time_2.png": {
                    "x": 667,
                    "y": 347,
                    "w": 25,
                    "h": 33,
                    "ox": 0,
                    "oy": 0,
                    "sw": 25,
                    "sh": 34,
                    "ro": true
                },
                "time_4.png": {
                    "x": 741,
                    "y": 347,
                    "w": 27,
                    "h": 33,
                    "ox": 0,
                    "oy": 0,
                    "sw": 27,
                    "sh": 34,
                    "ro": true
                },
                "time_5.png": {
                    "x": 706,
                    "y": 368,
                    "w": 25,
                    "h": 33,
                    "ox": 0,
                    "oy": 0,
                    "sw": 25,
                    "sh": 34,
                    "ro": true
                },
                "time_7.png": {
                    "x": 667,
                    "y": 374,
                    "w": 24,
                    "h": 32,
                    "ox": 0,
                    "oy": 1,
                    "sw": 24,
                    "sh": 34,
                    "ro": true
                },
                "time_f.png": {
                    "x": 241,
                    "y": 657,
                    "w": 10,
                    "h": 27,
                    "ox": 0,
                    "oy": 3,
                    "sw": 10,
                    "sh": 34,
                    "ro": true
                }
            }
        },
        {
            "keys": "guide0.png,guide1.png,guide2.png,guide3.png,guide4.png,guideBtn.png,guidePoint.png",
            "name": "GuidePanel",
            "atlas": {
                "guide0.png": {
                    "x": 2,
                    "y": 2,
                    "w": 464,
                    "h": 890,
                    "ox": 0,
                    "oy": 0,
                    "sw": 464,
                    "sh": 890,
                    "ro": false
                },
                "guide1.png": {
                    "x": 468,
                    "y": 2,
                    "w": 464,
                    "h": 890,
                    "ox": 0,
                    "oy": 0,
                    "sw": 464,
                    "sh": 890,
                    "ro": false
                },
                "guide2.png": {
                    "x": 2,
                    "y": 894,
                    "w": 464,
                    "h": 890,
                    "ox": 0,
                    "oy": 0,
                    "sw": 464,
                    "sh": 890,
                    "ro": true
                },
                "guide3.png": {
                    "x": 934,
                    "y": 2,
                    "w": 464,
                    "h": 890,
                    "ox": 0,
                    "oy": 0,
                    "sw": 464,
                    "sh": 890,
                    "ro": false
                },
                "guide4.png": {
                    "x": 2,
                    "y": 1360,
                    "w": 464,
                    "h": 890,
                    "ox": 0,
                    "oy": 0,
                    "sw": 464,
                    "sh": 890,
                    "ro": true
                },
                "guideBtn.png": {
                    "x": 894,
                    "y": 894,
                    "w": 466,
                    "h": 188,
                    "ox": 0,
                    "oy": 0,
                    "sw": 466,
                    "sh": 188,
                    "ro": false
                },
                "guidePoint.png": {
                    "x": 1362,
                    "y": 894,
                    "w": 16,
                    "h": 16,
                    "ox": 0,
                    "oy": 0,
                    "sw": 16,
                    "sh": 16,
                    "ro": false
                }
            }
        },
        {
            "keys": "desc.png,line.png,title.png,toast2.png,产品.png,兑换奖品.png,右滑.png,大秀标题.png,左滑.png,已结束.png,按钮-订阅直播间__m.png,未开播.png,框.png,步入秘境-首页1.5屏_01.png,步入秘境-首页1.5屏_03.png,活动规则.png,直播中.png,神秘尖货.png,进入游戏.png,邀请函.png,门票.png,限量.png,雪花页1.png,雪花页2.png,雪花页_01.png,首页.png",
            "name": "HomeScene",
            "atlas": {
                "首页.png": {
                    "x": 2,
                    "y": 2,
                    "w": 750,
                    "h": 2436,
                    "ox": 0,
                    "oy": 0,
                    "sw": 750,
                    "sh": 2436,
                    "ro": false
                },
                "步入秘境-首页1.5屏_01.png": {
                    "x": 754,
                    "y": 2,
                    "w": 750,
                    "h": 1624,
                    "ox": 0,
                    "oy": 0,
                    "sw": 750,
                    "sh": 1624,
                    "ro": false
                },
                "雪花页1.png": {
                    "x": 1506,
                    "y": 2,
                    "w": 750,
                    "h": 1132,
                    "ox": 0,
                    "oy": 0,
                    "sw": 750,
                    "sh": 1132,
                    "ro": false
                },
                "雪花页_01.png": {
                    "x": 1506,
                    "y": 1136,
                    "w": 750,
                    "h": 1132,
                    "ox": 0,
                    "oy": 0,
                    "sw": 750,
                    "sh": 1132,
                    "ro": false
                },
                "框.png": {
                    "x": 2258,
                    "y": 2,
                    "w": 642,
                    "h": 880,
                    "ox": 0,
                    "oy": 0,
                    "sw": 642,
                    "sh": 880,
                    "ro": false
                },
                "步入秘境-首页1.5屏_03.png": {
                    "x": 754,
                    "y": 1628,
                    "w": 750,
                    "h": 811,
                    "ox": 0,
                    "oy": 0,
                    "sw": 750,
                    "sh": 811,
                    "ro": false
                },
                "雪花页2.png": {
                    "x": 2,
                    "y": 2440,
                    "w": 750,
                    "h": 731,
                    "ox": 0,
                    "oy": 401,
                    "sw": 750,
                    "sh": 1132,
                    "ro": false
                },
                "line.png": {
                    "x": 2258,
                    "y": 884,
                    "w": 624,
                    "h": 28,
                    "ox": 0,
                    "oy": 0,
                    "sw": 624,
                    "sh": 28,
                    "ro": false
                },
                "toast2.png": {
                    "x": 2258,
                    "y": 914,
                    "w": 586,
                    "h": 188,
                    "ox": 0,
                    "oy": 0,
                    "sw": 586,
                    "sh": 188,
                    "ro": false
                },
                "右滑.png": {
                    "x": 2258,
                    "y": 1104,
                    "w": 88,
                    "h": 540,
                    "ox": 0,
                    "oy": 0,
                    "sw": 88,
                    "sh": 540,
                    "ro": true
                },
                "左滑.png": {
                    "x": 2800,
                    "y": 1104,
                    "w": 62,
                    "h": 533,
                    "ox": 0,
                    "oy": 4,
                    "sw": 62,
                    "sh": 542,
                    "ro": false
                },
                "title.png": {
                    "x": 2258,
                    "y": 1194,
                    "w": 499,
                    "h": 221,
                    "ox": 0,
                    "oy": 0,
                    "sw": 499,
                    "sh": 221,
                    "ro": false
                },
                "按钮-订阅直播间__m.png": {
                    "x": 2258,
                    "y": 1417,
                    "w": 466,
                    "h": 188,
                    "ox": 0,
                    "oy": 0,
                    "sw": 466,
                    "sh": 188,
                    "ro": false
                },
                "desc.png": {
                    "x": 2726,
                    "y": 1417,
                    "w": 441,
                    "h": 61,
                    "ox": 0,
                    "oy": 0,
                    "sw": 441,
                    "sh": 61,
                    "ro": true
                },
                "神秘尖货.png": {
                    "x": 2258,
                    "y": 1607,
                    "w": 422,
                    "h": 269,
                    "ox": 0,
                    "oy": 0,
                    "sw": 422,
                    "sh": 269,
                    "ro": false
                },
                "产品.png": {
                    "x": 2258,
                    "y": 1878,
                    "w": 300,
                    "h": 364,
                    "ox": 0,
                    "oy": 0,
                    "sw": 300,
                    "sh": 364,
                    "ro": true
                },
                "大秀标题.png": {
                    "x": 2682,
                    "y": 1860,
                    "w": 345,
                    "h": 144,
                    "ox": 0,
                    "oy": 0,
                    "sw": 345,
                    "sh": 144,
                    "ro": true
                },
                "门票.png": {
                    "x": 2258,
                    "y": 2180,
                    "w": 148,
                    "h": 117,
                    "ox": 0,
                    "oy": 0,
                    "sw": 148,
                    "sh": 117,
                    "ro": false
                },
                "兑换奖品.png": {
                    "x": 2828,
                    "y": 1639,
                    "w": 135,
                    "h": 62,
                    "ox": 0,
                    "oy": 0,
                    "sw": 135,
                    "sh": 62,
                    "ro": true
                },
                "活动规则.png": {
                    "x": 2846,
                    "y": 914,
                    "w": 131,
                    "h": 52,
                    "ox": 0,
                    "oy": 0,
                    "sw": 131,
                    "sh": 52,
                    "ro": true
                },
                "邀请函.png": {
                    "x": 2408,
                    "y": 2180,
                    "w": 87,
                    "h": 120,
                    "ox": 0,
                    "oy": 0,
                    "sw": 87,
                    "sh": 120,
                    "ro": true
                },
                "限量.png": {
                    "x": 2530,
                    "y": 2180,
                    "w": 120,
                    "h": 109,
                    "ox": 0,
                    "oy": 0,
                    "sw": 120,
                    "sh": 109,
                    "ro": false
                },
                "直播中.png": {
                    "x": 2408,
                    "y": 2269,
                    "w": 116,
                    "h": 116,
                    "ox": 0,
                    "oy": 0,
                    "sw": 116,
                    "sh": 116,
                    "ro": false
                },
                "进入游戏.png": {
                    "x": 2652,
                    "y": 2207,
                    "w": 114,
                    "h": 109,
                    "ox": 0,
                    "oy": 0,
                    "sw": 114,
                    "sh": 109,
                    "ro": false
                },
                "已结束.png": {
                    "x": 2526,
                    "y": 2291,
                    "w": 95,
                    "h": 95,
                    "ox": 0,
                    "oy": 0,
                    "sw": 95,
                    "sh": 95,
                    "ro": false
                },
                "未开播.png": {
                    "x": 2768,
                    "y": 2207,
                    "w": 95,
                    "h": 95,
                    "ox": 0,
                    "oy": 0,
                    "sw": 95,
                    "sh": 95,
                    "ro": false
                }
            }
        },
        {
            "keys": "indexBg.jpg,indexGameTimeBg.png,indexGuide.png,indexMyPrize.png,indexStart.png,indexStart2.png,indexTask.png,index_0.png,index_1.png,index_2.png,index_3.png,index_4.png,index_5.png,index_6.png,index_7.png,index_8.png,index_9.png,index_人.png,index_分.png,index_前.png,index_当.png,index_择.png,index_数.png,index_选.png,index光.png,index扫光.png,index红.png,index蓝.png",
            "name": "IndexScene",
            "atlas": {
                "index红.png": {
                    "x": 2,
                    "y": 2,
                    "w": 486,
                    "h": 780,
                    "ox": 0,
                    "oy": 0,
                    "sw": 486,
                    "sh": 780,
                    "ro": false
                },
                "index蓝.png": {
                    "x": 490,
                    "y": 2,
                    "w": 494,
                    "h": 780,
                    "ox": 0,
                    "oy": 0,
                    "sw": 494,
                    "sh": 780,
                    "ro": false
                },
                "index光.png": {
                    "x": 2,
                    "y": 784,
                    "w": 750,
                    "h": 657,
                    "ox": 0,
                    "oy": 0,
                    "sw": 750,
                    "sh": 657,
                    "ro": false
                },
                "indexStart.png": {
                    "x": 754,
                    "y": 784,
                    "w": 466,
                    "h": 188,
                    "ox": 0,
                    "oy": 0,
                    "sw": 466,
                    "sh": 188,
                    "ro": true
                },
                "indexStart2.png": {
                    "x": 986,
                    "y": 2,
                    "w": 466,
                    "h": 188,
                    "ox": 0,
                    "oy": 0,
                    "sw": 466,
                    "sh": 188,
                    "ro": true
                },
                "index扫光.png": {
                    "x": 1176,
                    "y": 2,
                    "w": 234,
                    "h": 235,
                    "ox": 0,
                    "oy": 0,
                    "sw": 234,
                    "sh": 235,
                    "ro": false
                },
                "indexTask.png": {
                    "x": 754,
                    "y": 1252,
                    "w": 41,
                    "h": 188,
                    "ox": 0,
                    "oy": 0,
                    "sw": 41,
                    "sh": 188,
                    "ro": false
                },
                "indexGameTimeBg.png": {
                    "x": 797,
                    "y": 1252,
                    "w": 151,
                    "h": 98,
                    "ox": 0,
                    "oy": 0,
                    "sw": 151,
                    "sh": 98,
                    "ro": true
                },
                "indexMyPrize.png": {
                    "x": 897,
                    "y": 1252,
                    "w": 135,
                    "h": 62,
                    "ox": 0,
                    "oy": 0,
                    "sw": 135,
                    "sh": 62,
                    "ro": true
                },
                "indexGuide.png": {
                    "x": 897,
                    "y": 1389,
                    "w": 129,
                    "h": 52,
                    "ox": 0,
                    "oy": 0,
                    "sw": 129,
                    "sh": 52,
                    "ro": false
                },
                "index_数.png": {
                    "x": 1176,
                    "y": 239,
                    "w": 50,
                    "h": 48,
                    "ox": 0,
                    "oy": 0,
                    "sw": 49,
                    "sh": 49,
                    "ro": false
                },
                "index_分.png": {
                    "x": 1228,
                    "y": 239,
                    "w": 49,
                    "h": 48,
                    "ox": 0,
                    "oy": 0,
                    "sw": 48,
                    "sh": 49,
                    "ro": false
                },
                "index_前.png": {
                    "x": 1279,
                    "y": 239,
                    "w": 49,
                    "h": 48,
                    "ox": 0,
                    "oy": 0,
                    "sw": 49,
                    "sh": 49,
                    "ro": false
                },
                "index_当.png": {
                    "x": 1330,
                    "y": 239,
                    "w": 47,
                    "h": 49,
                    "ox": 0,
                    "oy": 0,
                    "sw": 47,
                    "sh": 49,
                    "ro": true
                },
                "index_择.png": {
                    "x": 1330,
                    "y": 288,
                    "w": 49,
                    "h": 49,
                    "ox": 0,
                    "oy": 0,
                    "sw": 49,
                    "sh": 49,
                    "ro": false
                },
                "index_选.png": {
                    "x": 1176,
                    "y": 289,
                    "w": 49,
                    "h": 49,
                    "ox": 0,
                    "oy": 0,
                    "sw": 49,
                    "sh": 49,
                    "ro": false
                },
                "index_0.png": {
                    "x": 1227,
                    "y": 289,
                    "w": 40,
                    "h": 48,
                    "ox": 0,
                    "oy": 0,
                    "sw": 40,
                    "sh": 49,
                    "ro": true
                },
                "index_2.png": {
                    "x": 1277,
                    "y": 289,
                    "w": 38,
                    "h": 48,
                    "ox": 0,
                    "oy": 0,
                    "sw": 38,
                    "sh": 49,
                    "ro": true
                },
                "index_3.png": {
                    "x": 1277,
                    "y": 329,
                    "w": 38,
                    "h": 48,
                    "ox": 0,
                    "oy": 0,
                    "sw": 38,
                    "sh": 49,
                    "ro": true
                },
                "index_6.png": {
                    "x": 1227,
                    "y": 331,
                    "w": 40,
                    "h": 48,
                    "ox": 0,
                    "oy": 0,
                    "sw": 39,
                    "sh": 49,
                    "ro": true
                },
                "index_8.png": {
                    "x": 1176,
                    "y": 340,
                    "w": 41,
                    "h": 48,
                    "ox": 0,
                    "oy": 0,
                    "sw": 40,
                    "sh": 49,
                    "ro": true
                },
                "index_9.png": {
                    "x": 1327,
                    "y": 339,
                    "w": 41,
                    "h": 48,
                    "ox": 0,
                    "oy": 0,
                    "sw": 40,
                    "sh": 49,
                    "ro": true
                },
                "index_5.png": {
                    "x": 1277,
                    "y": 369,
                    "w": 39,
                    "h": 47,
                    "ox": 0,
                    "oy": 1,
                    "sw": 38,
                    "sh": 49,
                    "ro": true
                },
                "index_人.png": {
                    "x": 1226,
                    "y": 373,
                    "w": 47,
                    "h": 47,
                    "ox": 0,
                    "oy": 1,
                    "sw": 47,
                    "sh": 49,
                    "ro": false
                },
                "index_1.png": {
                    "x": 797,
                    "y": 1405,
                    "w": 34,
                    "h": 46,
                    "ox": 0,
                    "oy": 1,
                    "sw": 33,
                    "sh": 49,
                    "ro": true
                },
                "index_4.png": {
                    "x": 1176,
                    "y": 383,
                    "w": 40,
                    "h": 46,
                    "ox": 0,
                    "oy": 1,
                    "sw": 40,
                    "sh": 49,
                    "ro": true
                },
                "index_7.png": {
                    "x": 1326,
                    "y": 382,
                    "w": 40,
                    "h": 46,
                    "ox": 0,
                    "oy": 1,
                    "sw": 39,
                    "sh": 49,
                    "ro": true
                }
            }
        },
        {
            "keys": "back.png,toast1.png,弹窗-接受邀请.png,弹窗-邀请函__m.png,按钮-接受邀请__m.png,雪花页.png,首页.png",
            "name": "InvationScene",
            "atlas": {
                "首页.png": {
                    "x": 2,
                    "y": 2,
                    "w": 750,
                    "h": 2436,
                    "ox": 0,
                    "oy": 0,
                    "sw": 750,
                    "sh": 2436,
                    "ro": false
                },
                "雪花页.png": {
                    "x": 754,
                    "y": 2,
                    "w": 750,
                    "h": 1624,
                    "ox": 0,
                    "oy": 0,
                    "sw": 750,
                    "sh": 1624,
                    "ro": false
                },
                "弹窗-接受邀请.png": {
                    "x": 1506,
                    "y": 2,
                    "w": 619,
                    "h": 974,
                    "ox": 71,
                    "oy": 0,
                    "sw": 750,
                    "sh": 974,
                    "ro": false
                },
                "弹窗-邀请函__m.png": {
                    "x": 1506,
                    "y": 978,
                    "w": 619,
                    "h": 974,
                    "ox": 0,
                    "oy": 0,
                    "sw": 619,
                    "sh": 974,
                    "ro": false
                },
                "toast1.png": {
                    "x": 754,
                    "y": 1628,
                    "w": 492,
                    "h": 158,
                    "ox": 0,
                    "oy": 0,
                    "sw": 492,
                    "sh": 158,
                    "ro": false
                },
                "按钮-接受邀请__m.png": {
                    "x": 754,
                    "y": 1954,
                    "w": 404,
                    "h": 174,
                    "ox": 0,
                    "oy": 0,
                    "sw": 404,
                    "sh": 174,
                    "ro": true
                },
                "back.png": {
                    "x": 1248,
                    "y": 1628,
                    "w": 391,
                    "h": 188,
                    "ox": 0,
                    "oy": 0,
                    "sw": 391,
                    "sh": 188,
                    "ro": true
                }
            }
        },
        {
            "keys": "loserBg.png,loserBtn.png",
            "name": "LoserPanel",
            "atlas": {
                "loserBg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 616,
                    "h": 766,
                    "ox": 0,
                    "oy": 0,
                    "sw": 616,
                    "sh": 766,
                    "ro": false
                },
                "loserBtn.png": {
                    "x": 620,
                    "y": 2,
                    "w": 466,
                    "h": 188,
                    "ox": 0,
                    "oy": 0,
                    "sw": 466,
                    "sh": 188,
                    "ro": true
                }
            }
        },
        {
            "keys": "matchAvatarBg.png,matchCancel.png,matchPointer.png,matchTimeBg.png",
            "name": "MatchScene",
            "atlas": {
                "matchCancel.png": {
                    "x": 2,
                    "y": 2,
                    "w": 466,
                    "h": 188,
                    "ox": 0,
                    "oy": 0,
                    "sw": 466,
                    "sh": 188,
                    "ro": false
                },
                "matchTimeBg.png": {
                    "x": 2,
                    "y": 192,
                    "w": 446,
                    "h": 104,
                    "ox": 0,
                    "oy": 0,
                    "sw": 446,
                    "sh": 104,
                    "ro": false
                },
                "matchPointer.png": {
                    "x": 2,
                    "y": 298,
                    "w": 168,
                    "h": 426,
                    "ox": 0,
                    "oy": 0,
                    "sw": 168,
                    "sh": 426,
                    "ro": true
                },
                "matchAvatarBg.png": {
                    "x": 2,
                    "y": 468,
                    "w": 235,
                    "h": 234,
                    "ox": 0,
                    "oy": 0,
                    "sw": 235,
                    "sh": 234,
                    "ro": false
                }
            }
        },
        {
            "keys": "noTimeBg.png,noTimeBtn.png",
            "name": "NoTime",
            "atlas": {
                "noTimeBg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 616,
                    "h": 766,
                    "ox": 0,
                    "oy": 0,
                    "sw": 616,
                    "sh": 766,
                    "ro": false
                },
                "noTimeBtn.png": {
                    "x": 620,
                    "y": 2,
                    "w": 466,
                    "h": 188,
                    "ox": 0,
                    "oy": 0,
                    "sw": 466,
                    "sh": 188,
                    "ro": true
                }
            }
        },
        {
            "keys": "overBtn.png,overScore_0.png,overScore_1.png,overScore_2.png,overScore_3.png,overScore_4.png,overScore_5.png,overScore_6.png,overScore_7.png,overScore_8.png,overScore_9.png,over失败.png,over平.png,over平局.png,over红.png,over胜利.png,over蓝.png",
            "name": "OverScene",
            "atlas": {
                "over平.png": {
                    "x": 2,
                    "y": 2,
                    "w": 750,
                    "h": 1254,
                    "ox": 0,
                    "oy": 0,
                    "sw": 750,
                    "sh": 1254,
                    "ro": false
                },
                "over红.png": {
                    "x": 754,
                    "y": 2,
                    "w": 750,
                    "h": 1128,
                    "ox": 0,
                    "oy": 0,
                    "sw": 750,
                    "sh": 1128,
                    "ro": false
                },
                "over蓝.png": {
                    "x": 2,
                    "y": 1258,
                    "w": 750,
                    "h": 1112,
                    "ox": 0,
                    "oy": 0,
                    "sw": 750,
                    "sh": 1112,
                    "ro": true
                },
                "overBtn.png": {
                    "x": 1116,
                    "y": 1132,
                    "w": 466,
                    "h": 188,
                    "ox": 0,
                    "oy": 0,
                    "sw": 466,
                    "sh": 188,
                    "ro": true
                },
                "over平局.png": {
                    "x": 754,
                    "y": 1132,
                    "w": 143,
                    "h": 77,
                    "ox": 0,
                    "oy": 0,
                    "sw": 143,
                    "sh": 77,
                    "ro": false
                },
                "over胜利.png": {
                    "x": 899,
                    "y": 1132,
                    "w": 143,
                    "h": 79,
                    "ox": 0,
                    "oy": 0,
                    "sw": 143,
                    "sh": 79,
                    "ro": false
                },
                "overScore_0.png": {
                    "x": 1306,
                    "y": 1132,
                    "w": 98,
                    "h": 126,
                    "ox": 0,
                    "oy": 0,
                    "sw": 98,
                    "sh": 126,
                    "ro": true
                },
                "overScore_3.png": {
                    "x": 1306,
                    "y": 1232,
                    "w": 97,
                    "h": 126,
                    "ox": 0,
                    "oy": 0,
                    "sw": 97,
                    "sh": 126,
                    "ro": true
                },
                "overScore_6.png": {
                    "x": 1306,
                    "y": 1331,
                    "w": 98,
                    "h": 126,
                    "ox": 0,
                    "oy": 0,
                    "sw": 98,
                    "sh": 126,
                    "ro": true
                },
                "overScore_8.png": {
                    "x": 1306,
                    "y": 1431,
                    "w": 98,
                    "h": 126,
                    "ox": 0,
                    "oy": 0,
                    "sw": 98,
                    "sh": 126,
                    "ro": true
                },
                "overScore_9.png": {
                    "x": 1306,
                    "y": 1531,
                    "w": 97,
                    "h": 126,
                    "ox": 0,
                    "oy": 0,
                    "sw": 97,
                    "sh": 126,
                    "ro": true
                },
                "overScore_2.png": {
                    "x": 1116,
                    "y": 1600,
                    "w": 95,
                    "h": 124,
                    "ox": 0,
                    "oy": 0,
                    "sw": 95,
                    "sh": 124,
                    "ro": true
                },
                "overScore_5.png": {
                    "x": 1242,
                    "y": 1630,
                    "w": 97,
                    "h": 124,
                    "ox": 0,
                    "oy": 0,
                    "sw": 97,
                    "sh": 124,
                    "ro": true
                },
                "overScore_1.png": {
                    "x": 1116,
                    "y": 1697,
                    "w": 75,
                    "h": 122,
                    "ox": 0,
                    "oy": 0,
                    "sw": 75,
                    "sh": 122,
                    "ro": true
                },
                "overScore_4.png": {
                    "x": 1368,
                    "y": 1630,
                    "w": 103,
                    "h": 122,
                    "ox": 0,
                    "oy": 0,
                    "sw": 103,
                    "sh": 122,
                    "ro": true
                },
                "over失败.png": {
                    "x": 1044,
                    "y": 1132,
                    "w": 122,
                    "h": 68,
                    "ox": 0,
                    "oy": 0,
                    "sw": 122,
                    "sh": 68,
                    "ro": true
                },
                "overScore_7.png": {
                    "x": 1240,
                    "y": 1729,
                    "w": 95,
                    "h": 121,
                    "ox": 0,
                    "oy": 0,
                    "sw": 95,
                    "sh": 121,
                    "ro": true
                }
            }
        },
        {
            "keys": "preBg.jpg,pre光.png,pre红.png,pre蓝.png",
            "name": "PreScene",
            "atlas": {
                "pre红.png": {
                    "x": 2,
                    "y": 2,
                    "w": 497,
                    "h": 973,
                    "ox": 0,
                    "oy": 0,
                    "sw": 497,
                    "sh": 973,
                    "ro": false
                },
                "pre蓝.png": {
                    "x": 501,
                    "y": 2,
                    "w": 507,
                    "h": 964,
                    "ox": 0,
                    "oy": 0,
                    "sw": 507,
                    "sh": 964,
                    "ro": false
                },
                "pre光.png": {
                    "x": 2,
                    "y": 977,
                    "w": 555,
                    "h": 657,
                    "ox": 0,
                    "oy": 0,
                    "sw": 555,
                    "sh": 657,
                    "ro": true
                }
            }
        },
        {
            "keys": "弹窗-活动规则.png",
            "name": "RulePanel",
            "atlas": {
                "弹窗-活动规则.png": {
                    "x": 2,
                    "y": 2,
                    "w": 619,
                    "h": 974,
                    "ox": 0,
                    "oy": 0,
                    "sw": 619,
                    "sh": 974,
                    "ro": false
                }
            }
        },
        {
            "keys": "winnerBtn.png,winner红.png,winner蓝.png",
            "name": "WinnerPanel",
            "atlas": {
                "winner红.png": {
                    "x": 2,
                    "y": 2,
                    "w": 733,
                    "h": 1177,
                    "ox": 0,
                    "oy": 0,
                    "sw": 733,
                    "sh": 1177,
                    "ro": false
                },
                "winner蓝.png": {
                    "x": 737,
                    "y": 2,
                    "w": 732,
                    "h": 1155,
                    "ox": 0,
                    "oy": 0,
                    "sw": 732,
                    "sh": 1155,
                    "ro": false
                },
                "winnerBtn.png": {
                    "x": 2,
                    "y": 1181,
                    "w": 466,
                    "h": 188,
                    "ox": 0,
                    "oy": 0,
                    "sw": 466,
                    "sh": 188,
                    "ro": false
                }
            }
        },
        {
            "keys": "按钮-接受邀请.png,活动邀请.png",
            "name": "assist",
            "atlas": {
                "活动邀请.png": {
                    "x": 2,
                    "y": 2,
                    "w": 616,
                    "h": 766,
                    "ox": 0,
                    "oy": 0,
                    "sw": 616,
                    "sh": 766,
                    "ro": false
                },
                "按钮-接受邀请.png": {
                    "x": 620,
                    "y": 2,
                    "w": 466,
                    "h": 188,
                    "ox": 0,
                    "oy": 0,
                    "sw": 466,
                    "sh": 188,
                    "ro": true
                }
            }
        },
        {
            "keys": "backBtn.png,blueBg.jpg,blueTeamTip.png,redTeamTip.png,toastBg.png,waitingBg.png,waitingRot.png,关闭.png",
            "name": "common",
            "atlas": {
                "toastBg.png": {
                    "x": 2,
                    "y": 2,
                    "w": 460,
                    "h": 130,
                    "ox": 0,
                    "oy": 0,
                    "sw": 460,
                    "sh": 130,
                    "ro": false
                },
                "waitingBg.png": {
                    "x": 2,
                    "y": 134,
                    "w": 160,
                    "h": 180,
                    "ox": 0,
                    "oy": 0,
                    "sw": 160,
                    "sh": 180,
                    "ro": true
                },
                "blueTeamTip.png": {
                    "x": 184,
                    "y": 134,
                    "w": 161,
                    "h": 42,
                    "ox": 0,
                    "oy": 0,
                    "sw": 161,
                    "sh": 42,
                    "ro": false
                },
                "redTeamTip.png": {
                    "x": 347,
                    "y": 134,
                    "w": 160,
                    "h": 42,
                    "ox": 0,
                    "oy": 0,
                    "sw": 160,
                    "sh": 42,
                    "ro": true
                },
                "backBtn.png": {
                    "x": 391,
                    "y": 134,
                    "w": 63,
                    "h": 73,
                    "ox": 0,
                    "oy": 0,
                    "sw": 63,
                    "sh": 73,
                    "ro": false
                },
                "关闭.png": {
                    "x": 391,
                    "y": 209,
                    "w": 58,
                    "h": 58,
                    "ox": 0,
                    "oy": 0,
                    "sw": 58,
                    "sh": 58,
                    "ro": false
                },
                "waitingRot.png": {
                    "x": 184,
                    "y": 178,
                    "w": 56,
                    "h": 56,
                    "ox": 0,
                    "oy": 0,
                    "sw": 56,
                    "sh": 56,
                    "ro": false
                }
            }
        },
        {
            "keys": "ct_红色dis.png,ct_红色en.png,ct_蓝色dis.png,ct_蓝色en.png,ct光.png,ct按钮.png,ct文案.png,ct红.png,ct蓝.png",
            "name": "ct",
            "atlas": {
                "ct红.png": {
                    "x": 2,
                    "y": 2,
                    "w": 486,
                    "h": 780,
                    "ox": 0,
                    "oy": 0,
                    "sw": 486,
                    "sh": 780,
                    "ro": false
                },
                "ct蓝.png": {
                    "x": 490,
                    "y": 2,
                    "w": 494,
                    "h": 780,
                    "ox": 0,
                    "oy": 0,
                    "sw": 494,
                    "sh": 780,
                    "ro": false
                },
                "ct光.png": {
                    "x": 2,
                    "y": 784,
                    "w": 750,
                    "h": 657,
                    "ox": 0,
                    "oy": 0,
                    "sw": 750,
                    "sh": 657,
                    "ro": false
                },
                "ct文案.png": {
                    "x": 754,
                    "y": 784,
                    "w": 511,
                    "h": 147,
                    "ox": 0,
                    "oy": 0,
                    "sw": 511,
                    "sh": 147,
                    "ro": true
                },
                "ct按钮.png": {
                    "x": 986,
                    "y": 2,
                    "w": 467,
                    "h": 188,
                    "ox": 0,
                    "oy": 0,
                    "sw": 467,
                    "sh": 188,
                    "ro": true
                },
                "ct_红色dis.png": {
                    "x": 754,
                    "y": 1297,
                    "w": 96,
                    "h": 96,
                    "ox": 0,
                    "oy": 0,
                    "sw": 96,
                    "sh": 96,
                    "ro": false
                },
                "ct_红色en.png": {
                    "x": 852,
                    "y": 1297,
                    "w": 96,
                    "h": 96,
                    "ox": 0,
                    "oy": 0,
                    "sw": 96,
                    "sh": 96,
                    "ro": false
                },
                "ct_蓝色dis.png": {
                    "x": 986,
                    "y": 471,
                    "w": 96,
                    "h": 96,
                    "ox": 0,
                    "oy": 0,
                    "sw": 96,
                    "sh": 96,
                    "ro": false
                },
                "ct_蓝色en.png": {
                    "x": 986,
                    "y": 569,
                    "w": 96,
                    "h": 96,
                    "ox": 0,
                    "oy": 0,
                    "sw": 96,
                    "sh": 96,
                    "ro": false
                }
            }
        },
        {
            "keys": "347e5647227e2b4c766b5ce4a4dab126.png,d9ab6da10be2355daea097f1e92eb75f.png",
            "name": "icon",
            "atlas": {
                "d9ab6da10be2355daea097f1e92eb75f.png": {
                    "x": 2,
                    "y": 2,
                    "w": 114,
                    "h": 32,
                    "ox": 0,
                    "oy": 0,
                    "sw": 114,
                    "sh": 32,
                    "ro": false
                },
                "347e5647227e2b4c766b5ce4a4dab126.png": {
                    "x": 2,
                    "y": 36,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                }
            }
        },
        {
            "keys": "347e5647227e2b4c766b5ce4a4dab126.png,d9ab6da10be2355daea097f1e92eb75f.png",
            "name": "icon2",
            "atlas": {
                "d9ab6da10be2355daea097f1e92eb75f.png": {
                    "x": 2,
                    "y": 2,
                    "w": 114,
                    "h": 32,
                    "ox": 0,
                    "oy": 0,
                    "sw": 114,
                    "sh": 32,
                    "ro": false
                },
                "347e5647227e2b4c766b5ce4a4dab126.png": {
                    "x": 2,
                    "y": 36,
                    "w": 100,
                    "h": 100,
                    "ox": 0,
                    "oy": 0,
                    "sw": 100,
                    "sh": 100,
                    "ro": false
                }
            }
        },
        {
            "keys": "39b11020dae7b9a8f0635df5b457de4d.png,78490eecdae83bb7bfc15b973c08cc05.png",
            "name": "invation",
            "atlas": {
                "78490eecdae83bb7bfc15b973c08cc05.png": {
                    "x": 2,
                    "y": 2,
                    "w": 90,
                    "h": 117,
                    "ox": 0,
                    "oy": 0,
                    "sw": 90,
                    "sh": 117,
                    "ro": false
                },
                "39b11020dae7b9a8f0635df5b457de4d.png": {
                    "x": 94,
                    "y": 2,
                    "w": 35,
                    "h": 108,
                    "ox": 0,
                    "oy": 0,
                    "sw": 35,
                    "sh": 108,
                    "ro": false
                }
            }
        },
        {
            "keys": "我知道了.png,次数不足.png",
            "name": "invite",
            "atlas": {
                "次数不足.png": {
                    "x": 2,
                    "y": 2,
                    "w": 616,
                    "h": 766,
                    "ox": 0,
                    "oy": 0,
                    "sw": 616,
                    "sh": 766,
                    "ro": false
                },
                "我知道了.png": {
                    "x": 620,
                    "y": 2,
                    "w": 466,
                    "h": 188,
                    "ox": 0,
                    "oy": 0,
                    "sw": 466,
                    "sh": 188,
                    "ro": true
                }
            }
        },
        {
            "keys": "loading_bg.jpg,loading_fill.png,loading_sp.png",
            "name": "loading",
            "atlas": {
                "loading_fill.png": {
                    "x": 2,
                    "y": 2,
                    "w": 563,
                    "h": 44,
                    "ox": 0,
                    "oy": 0,
                    "sw": 563,
                    "sh": 44,
                    "ro": false
                },
                "loading_sp.png": {
                    "x": 2,
                    "y": 48,
                    "w": 104,
                    "h": 82,
                    "ox": 0,
                    "oy": 0,
                    "sw": 104,
                    "sh": 82,
                    "ro": false
                }
            }
        },
        {
            "keys": "1764dbef451b8b4fb9ae3728a893be28.png,235a6cc3033ebfc1d9d9bd60d600e117.png,3c911e3ce7c16eb04b024651ac52b328.png,6546f1f365d9c777b1c32aea164d869c.png,95a3435e347423fa1f437af35fa2e1e4.png,a3151c6c673305582ba9657383c81039.png",
            "name": "match",
            "atlas": {
                "235a6cc3033ebfc1d9d9bd60d600e117.png": {
                    "x": 2,
                    "y": 2,
                    "w": 837,
                    "h": 838,
                    "ox": 0,
                    "oy": 0,
                    "sw": 837,
                    "sh": 838,
                    "ro": false
                },
                "95a3435e347423fa1f437af35fa2e1e4.png": {
                    "x": 841,
                    "y": 2,
                    "w": 168,
                    "h": 426,
                    "ox": 0,
                    "oy": 0,
                    "sw": 168,
                    "sh": 426,
                    "ro": false
                },
                "a3151c6c673305582ba9657383c81039.png": {
                    "x": 2,
                    "y": 842,
                    "w": 393,
                    "h": 392,
                    "ox": 0,
                    "oy": 0,
                    "sw": 393,
                    "sh": 392,
                    "ro": false
                },
                "6546f1f365d9c777b1c32aea164d869c.png": {
                    "x": 841,
                    "y": 430,
                    "w": 13,
                    "h": 13,
                    "ox": 0,
                    "oy": 0,
                    "sw": 13,
                    "sh": 13,
                    "ro": false
                },
                "3c911e3ce7c16eb04b024651ac52b328.png": {
                    "x": 856,
                    "y": 430,
                    "w": 7,
                    "h": 7,
                    "ox": 0,
                    "oy": 0,
                    "sw": 7,
                    "sh": 7,
                    "ro": false
                },
                "1764dbef451b8b4fb9ae3728a893be28.png": {
                    "x": 865,
                    "y": 430,
                    "w": 5,
                    "h": 5,
                    "ox": 0,
                    "oy": 0,
                    "sw": 5,
                    "sh": 5,
                    "ro": false
                }
            }
        },
        {
            "keys": "052f3a5104d8c2d772b821e6eb716872.png,25f973924e5a61cf6cf03bc766f99347.png,48cf05c2d8c9d789b6d57e86833f593a.png,4c484b252217ecf249439245271742d4.png,62dd234c6ed46a272d65e66791040aef.png,65ec5b1c3d96dc171dec7e04d0a4fd2a.png,66ae34bb9f3c90590a85caa758ba3733.png,6b035aaf773a0db0a603b792554cc173.png,8a667db765f7eb4304ab03086cbcfe90.png,8c8a04951c4c1c3a3196c07f1d5bcd9c.png",
            "name": "snow",
            "atlas": {
                "25f973924e5a61cf6cf03bc766f99347.png": {
                    "x": 2,
                    "y": 2,
                    "w": 751,
                    "h": 1619,
                    "ox": 0,
                    "oy": 5,
                    "sw": 750,
                    "sh": 1624,
                    "ro": false
                },
                "4c484b252217ecf249439245271742d4.png": {
                    "x": 755,
                    "y": 2,
                    "w": 751,
                    "h": 1619,
                    "ox": 0,
                    "oy": 5,
                    "sw": 750,
                    "sh": 1624,
                    "ro": false
                },
                "8a667db765f7eb4304ab03086cbcfe90.png": {
                    "x": 1508,
                    "y": 2,
                    "w": 751,
                    "h": 1619,
                    "ox": 0,
                    "oy": 5,
                    "sw": 750,
                    "sh": 1624,
                    "ro": false
                },
                "8c8a04951c4c1c3a3196c07f1d5bcd9c.png": {
                    "x": 2,
                    "y": 1623,
                    "w": 750,
                    "h": 1619,
                    "ox": 0,
                    "oy": 5,
                    "sw": 750,
                    "sh": 1624,
                    "ro": true
                },
                "48cf05c2d8c9d789b6d57e86833f593a.png": {
                    "x": 2261,
                    "y": 2,
                    "w": 736,
                    "h": 1610,
                    "ox": 0,
                    "oy": 5,
                    "sw": 750,
                    "sh": 1624,
                    "ro": false
                },
                "66ae34bb9f3c90590a85caa758ba3733.png": {
                    "x": 2,
                    "y": 2375,
                    "w": 750,
                    "h": 1610,
                    "ox": 0,
                    "oy": 14,
                    "sw": 750,
                    "sh": 1624,
                    "ro": true
                },
                "62dd234c6ed46a272d65e66791040aef.png": {
                    "x": 2999,
                    "y": 2,
                    "w": 749,
                    "h": 1603,
                    "ox": 1,
                    "oy": 21,
                    "sw": 750,
                    "sh": 1624,
                    "ro": false
                },
                "65ec5b1c3d96dc171dec7e04d0a4fd2a.png": {
                    "x": 1614,
                    "y": 2375,
                    "w": 733,
                    "h": 1586,
                    "ox": 0,
                    "oy": 38,
                    "sw": 750,
                    "sh": 1624,
                    "ro": true
                },
                "6b035aaf773a0db0a603b792554cc173.png": {
                    "x": 2,
                    "y": 3127,
                    "w": 751,
                    "h": 1561,
                    "ox": 0,
                    "oy": 63,
                    "sw": 750,
                    "sh": 1624,
                    "ro": true
                },
                "052f3a5104d8c2d772b821e6eb716872.png": {
                    "x": 1565,
                    "y": 3127,
                    "w": 751,
                    "h": 1540,
                    "ox": 0,
                    "oy": 82,
                    "sw": 750,
                    "sh": 1624,
                    "ro": true
                }
            }
        },
        {
            "keys": "085fe94b8f8a9b1eb32c3931bb4ff0ec.png,177e173b59be1daff16e34f483cc089d.png,208645e157f757946896b8cb4d181464.png,6022f3ad3b734f9dee43285d67a03438.png,793a6898a3f4a7bd50c23ee0ae08d43a.png,84474856504ef8b9e8c19ec77bcdbd65.png,845fcf6c9a22cdf4fad0ea8a9bfba230.png,a5be43e52e4eff7bf6505ee18468bdc7.png",
            "name": "snow1",
            "atlas": {
                "085fe94b8f8a9b1eb32c3931bb4ff0ec.png": {
                    "x": 2,
                    "y": 2,
                    "w": 750,
                    "h": 1619,
                    "ox": 0,
                    "oy": 5,
                    "sw": 750,
                    "sh": 1624,
                    "ro": false
                },
                "845fcf6c9a22cdf4fad0ea8a9bfba230.png": {
                    "x": 754,
                    "y": 2,
                    "w": 751,
                    "h": 1619,
                    "ox": 0,
                    "oy": 5,
                    "sw": 750,
                    "sh": 1624,
                    "ro": false
                },
                "a5be43e52e4eff7bf6505ee18468bdc7.png": {
                    "x": 1507,
                    "y": 2,
                    "w": 750,
                    "h": 1619,
                    "ox": 0,
                    "oy": 5,
                    "sw": 750,
                    "sh": 1624,
                    "ro": false
                },
                "84474856504ef8b9e8c19ec77bcdbd65.png": {
                    "x": 2,
                    "y": 1623,
                    "w": 728,
                    "h": 1617,
                    "ox": 22,
                    "oy": 5,
                    "sw": 750,
                    "sh": 1624,
                    "ro": true
                },
                "6022f3ad3b734f9dee43285d67a03438.png": {
                    "x": 2259,
                    "y": 2,
                    "w": 747,
                    "h": 1610,
                    "ox": 0,
                    "oy": 14,
                    "sw": 750,
                    "sh": 1624,
                    "ro": false
                },
                "793a6898a3f4a7bd50c23ee0ae08d43a.png": {
                    "x": 2,
                    "y": 2353,
                    "w": 749,
                    "h": 1592,
                    "ox": 1,
                    "oy": 32,
                    "sw": 750,
                    "sh": 1624,
                    "ro": true
                },
                "208645e157f757946896b8cb4d181464.png": {
                    "x": 3008,
                    "y": 2,
                    "w": 750,
                    "h": 1584,
                    "ox": 0,
                    "oy": 40,
                    "sw": 750,
                    "sh": 1624,
                    "ro": false
                },
                "177e173b59be1daff16e34f483cc089d.png": {
                    "x": 1621,
                    "y": 1623,
                    "w": 750,
                    "h": 1553,
                    "ox": 0,
                    "oy": 49,
                    "sw": 750,
                    "sh": 1624,
                    "ro": true
                }
            }
        },
        {
            "keys": "a15b4c75da987fdac06857662dad28e0.png,ac69d7230079802e223fc9cc1355945c.png,c2a7347b80e9924e9360f15c86ab3b35.png,cf7a396caaff8d70d63ef52392c04436.png,dc6dbbc6484ea70eaf541c88dd192f5d.png,df77466e5edfdf7696e3a00cdc821bb3.png,e10b8855440fab51f658075c94bc2419.png,eb0c4428630226b4acf1beac273792d9.png,ebf60357fb6c8051026ce17c22ac239a.png",
            "name": "snow2",
            "atlas": {
                "ac69d7230079802e223fc9cc1355945c.png": {
                    "x": 2,
                    "y": 2,
                    "w": 750,
                    "h": 1619,
                    "ox": 0,
                    "oy": 5,
                    "sw": 750,
                    "sh": 1624,
                    "ro": false
                },
                "cf7a396caaff8d70d63ef52392c04436.png": {
                    "x": 754,
                    "y": 2,
                    "w": 751,
                    "h": 1619,
                    "ox": 0,
                    "oy": 5,
                    "sw": 750,
                    "sh": 1624,
                    "ro": false
                },
                "e10b8855440fab51f658075c94bc2419.png": {
                    "x": 1507,
                    "y": 2,
                    "w": 741,
                    "h": 1619,
                    "ox": 0,
                    "oy": 5,
                    "sw": 750,
                    "sh": 1624,
                    "ro": false
                },
                "ebf60357fb6c8051026ce17c22ac239a.png": {
                    "x": 2,
                    "y": 1623,
                    "w": 748,
                    "h": 1619,
                    "ox": 2,
                    "oy": 5,
                    "sw": 750,
                    "sh": 1624,
                    "ro": true
                },
                "dc6dbbc6484ea70eaf541c88dd192f5d.png": {
                    "x": 2250,
                    "y": 2,
                    "w": 751,
                    "h": 1617,
                    "ox": 0,
                    "oy": 7,
                    "sw": 750,
                    "sh": 1624,
                    "ro": false
                },
                "df77466e5edfdf7696e3a00cdc821bb3.png": {
                    "x": 2,
                    "y": 2373,
                    "w": 751,
                    "h": 1584,
                    "ox": 0,
                    "oy": 40,
                    "sw": 750,
                    "sh": 1624,
                    "ro": true
                },
                "eb0c4428630226b4acf1beac273792d9.png": {
                    "x": 3003,
                    "y": 2,
                    "w": 735,
                    "h": 1533,
                    "ox": 16,
                    "oy": 91,
                    "sw": 750,
                    "sh": 1624,
                    "ro": false
                },
                "c2a7347b80e9924e9360f15c86ab3b35.png": {
                    "x": 1588,
                    "y": 2373,
                    "w": 750,
                    "h": 1511,
                    "ox": 0,
                    "oy": 113,
                    "sw": 750,
                    "sh": 1624,
                    "ro": true
                },
                "a15b4c75da987fdac06857662dad28e0.png": {
                    "x": 2,
                    "y": 3126,
                    "w": 751,
                    "h": 1493,
                    "ox": 0,
                    "oy": 131,
                    "sw": 750,
                    "sh": 1624,
                    "ro": true
                }
            }
        }
    ],
    "path": "https://yun.duiba.com.cn/db_games/activity/template/1626835566/resource/"
};


/***/ }),

/***/ "./src/SkinJson.ts":
/*!*************************!*\
  !*** ./src/SkinJson.ts ***!
  \*************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.SkinJson = void 0;
exports.SkinJson = {
    "x": 0,
    "y": 0,
    "type": "container",
    "children": [
        {
            "name": "UpdatePanel",
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "update",
                    "x": 160,
                    "y": 651,
                    "type": "button",
                    "props": {
                        "tUp": "update.png"
                    },
                    "id": "btn"
                },
                {
                    "name": "updateBG",
                    "x": 12,
                    "y": 0,
                    "type": "sprite",
                    "props": {
                        "source": "updateBG.png"
                    }
                }
            ]
        },
        {
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "SuccessPanel",
                    "x": 0,
                    "y": 0,
                    "type": "container",
                    "children": [
                        {
                            "name": "prize",
                            "x": 12,
                            "y": 0,
                            "type": "sprite",
                            "props": {
                                "source": "successBg.png"
                            },
                            "id": "id"
                        },
                        {
                            "name": "title",
                            "x": 40,
                            "y": 0,
                            "type": "sprite",
                            "props": {
                                "source": "successTitle.png"
                            },
                            "id": "id"
                        }
                    ]
                }
            ]
        },
        {
            "x": 0,
            "y": 0,
            "type": "container",
            "children": [
                {
                    "name": "FailPanel",
                    "x": 0,
                    "y": 0,
                    "type": "container",
                    "children": [
                        {
                            "name": "组",
                            "x": 57,
                            "y": 0,
                            "type": "sprite",
                            "props": {
                                "source": "组.png"
                            },
                            "id": "id"
                        },
                        {
                            "name": "again",
                            "x": 206,
                            "y": 613,
                            "type": "button",
                            "props": {
                                "tUp": "again.png"
                            },
                            "id": "id"
                        }
                    ]
                }
            ]
        }
    ]
};


/***/ }),

/***/ "./src/TaoBaoNet.ts":
/*!**************************!*\
  !*** ./src/TaoBaoNet.ts ***!
  \**************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TBPRIZE_TYPE = exports.getTbServerTime = exports.checkTbDownloadPermission = exports.clickLogTb = exports.LogTbEnum = exports.destroyTbNetData = exports.getTbData = exports.addData = exports.sendTbNet = exports.TbNetName = exports.addStat = void 0;
var ctrls_1 = __webpack_require__(/*! ../module/ctrls */ "./module/ctrls/index.ts");
var Main_1 = __webpack_require__(/*! ./Main */ "./src/Main.ts");
function addStat(type) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4, sendTbNet(TbNetName.addData, { type: type })];
                case 1:
                    _a.sent();
                    return [2];
            }
        });
    });
}
exports.addStat = addStat;
var TbNetName;
(function (TbNetName) {
    TbNetName["addData"] = "fila.addStat";
    TbNetName["getMyActivityInfo"] = "fila.getMyActivityInfo";
    TbNetName["chooseTeam"] = "fila.chooseTeam";
    TbNetName["startGame"] = "fila.startGame";
    TbNetName["getTeamInfo"] = "fila.getTeamInfo";
    TbNetName["getRobot"] = "fila.getRobot";
    TbNetName["submitGame"] = "fila.submitGame";
    TbNetName["getActivityBaseInfo"] = "cow.getActivityBaseInfo";
    TbNetName["getIndex"] = "cow.getIndex";
    TbNetName["receiveEnamePrize"] = "cow.receiveEnamePrize";
    TbNetName["getUserAddress"] = "mine.getUserAddress";
    TbNetName["navigateToRelationMiniProgram"] = "mine.navigateToRelationMiniProgram";
    TbNetName["authorize"] = "mine.authorize";
    TbNetName["favorShop"] = "mine.favorShop";
    TbNetName["getAdoptName"] = "mine.getAdoptName";
    TbNetName["getAppData"] = "mine.getAppData";
    TbNetName["navigateToOutside"] = "mine.navigateToOutside";
    TbNetName["navigateTo"] = "mine.navigateTo";
    TbNetName["navigateBack"] = "mine.navigateBack";
    TbNetName["showSharePanel"] = "mine.showSharePanel";
    TbNetName["openDetail"] = "mine.openDetail";
    TbNetName["openTask"] = "mine.openTask";
    TbNetName["openMember"] = "mine.openMember";
    TbNetName["reportAnalytics"] = "mine.reportAnalytics";
    TbNetName["openMusic"] = "mine.openMusic";
    TbNetName["getActivityBaseInfoById"] = "fila.getActivityBaseInfoById";
    TbNetName["openPanel"] = "mine.openPanel";
    TbNetName["getAppInfoData"] = "mine.getAppInfoData";
    TbNetName["getHuhuSnow"] = "mine.huhuSnow";
    TbNetName["getAssistCb"] = "mine.getAssistCb";
    TbNetName["getUploadImg"] = "mine.uploadImage";
})(TbNetName = exports.TbNetName || (exports.TbNetName = {}));
var dataRecord = {};
function sendTbNet(netName, parameter, callback, hideMsg) {
    if (hideMsg === void 0) { hideMsg = false; }
    return new Promise(function (resolve, reject) {
        if (!my) {
            var netInfo = netName.split(".");
            var url = "../../mock/miniTb/" + netInfo[0] + "/" + netInfo[1] + ".json";
            fetchAsync(url)
                .then(function (data) {
                dataRecord[netName] = data;
                if (!hideMsg && !data.success)
                    ctrls_1.showToast(data.message || "网络异常");
                callback && callback(data.success, data);
                resolve(data);
                console.log("\n%c[ mock ]\n"
                    + ("NAME  : " + netName + " \n")
                    + "STATE : %o \n"
                    + "PARAM : %o \n"
                    + "%cDATA  : %o \n", "" + (data.success ? 'color:green' : 'color:red'), data.success, parameter, "" + (data.success ? 'color:green' : 'color:red'), data);
            }, function () {
                resolve({ success: false, data: null });
            });
            return;
        }
        var fun = function (e) {
            Main_1.GDispatcher.removeEventListener(netName, fun);
            var d = e.data;
            dataRecord[netName] = d;
            if (!hideMsg && !d.success)
                ctrls_1.showToast(d.message || "网络超时");
            callback && callback(d.success, d);
            resolve(d);
        };
        Main_1.GDispatcher.addEventListener(netName, fun);
        Main_1.GDispatcher.dispatchEvent({ type: "onMessage" }, { netName: netName, parameter: parameter });
    });
}
exports.sendTbNet = sendTbNet;
function addData(type) {
    sendTbNet(TbNetName.addData, { type: type }, null, true);
}
exports.addData = addData;
function getTbData(netName) {
    return dataRecord[netName] || null;
}
exports.getTbData = getTbData;
function destroyTbNetData() {
    dataRecord = {};
}
exports.destroyTbNetData = destroyTbNetData;
function fetchAsync(url) {
    return __awaiter(this, void 0, void 0, function () {
        var response, data;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4, fetch(url)];
                case 1:
                    response = _a.sent();
                    return [4, response.json()];
                case 2:
                    data = _a.sent();
                    return [2, data];
            }
        });
    });
}
var LogTbEnum;
(function (LogTbEnum) {
    LogTbEnum["AD"] = "ad";
    LogTbEnum["TASK_ICON"] = "taskIcon";
    LogTbEnum["FOLLOW_SHOP"] = "followShop";
    LogTbEnum["INVITE_FRIEND"] = "inviteFriend";
    LogTbEnum["BROWSE_PRODUCT"] = "browseProduct";
    LogTbEnum["COLLECTION_PRODUCT"] = "collectionProduct";
    LogTbEnum["BUY_PRODUCT"] = "buyProduct";
    LogTbEnum["IMPROVE_INFORMATION"] = "improveInformation";
    LogTbEnum["SECRET_ORDER"] = "secretOrder";
    LogTbEnum["SIGN_ICON"] = "signIcon";
    LogTbEnum["BAG_ICON"] = "bagIcon";
})(LogTbEnum = exports.LogTbEnum || (exports.LogTbEnum = {}));
function clickLogTb(elemType) {
    sendTbNet(TbNetName.addData, { params: { elemType: elemType }, type: "click" }, function () {
    }, true);
    sendTbNet(TbNetName.reportAnalytics, { logkey: elemType }, function () {
    }, true);
}
exports.clickLogTb = clickLogTb;
function checkTbDownloadPermission(tryCloudUrl) {
    return __awaiter(this, void 0, void 0, function () {
        var tbMy, cloud, url, urls;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    try {
                        tbMy = my;
                    }
                    catch (err) {
                    }
                    if (!tbMy)
                        return [2];
                    cloud = getApp().cloud;
                    url = tryCloudUrl;
                    return [4, cloud.file.getTempFileURL({ fileId: [url] })];
                case 1:
                    urls = _a.sent();
                    url = urls[0].url.replace('-internal', '');
                    tbMy.downloadFile({
                        url: url,
                        success: function (res) {
                            var i = res.apFilePath;
                            tbMy.getFileSystemManager().readFile({
                                filePath: i,
                                success: function (r) {
                                },
                                fail: function (res) {
                                }
                            });
                        },
                        fail: function (res) {
                        },
                    });
                    return [2];
            }
        });
    });
}
exports.checkTbDownloadPermission = checkTbDownloadPermission;
exports.getTbServerTime = function () {
    return new Promise(function (resolve, reject) {
        if (FYGE.getEnv() == "tb") {
            my.getServerTime({
                success: function (res) {
                    resolve(+res.time);
                },
                fail: function (err) {
                    resolve(Date.now());
                }
            });
        }
        else {
            resolve(Date.now());
        }
    });
};
var TBPRIZE_TYPE;
(function (TBPRIZE_TYPE) {
    TBPRIZE_TYPE[TBPRIZE_TYPE["ENAME"] = 1] = "ENAME";
    TBPRIZE_TYPE[TBPRIZE_TYPE["CREDITS"] = 2] = "CREDITS";
    TBPRIZE_TYPE[TBPRIZE_TYPE["OBJECT"] = 3] = "OBJECT";
    TBPRIZE_TYPE[TBPRIZE_TYPE["THANKS"] = 5] = "THANKS";
})(TBPRIZE_TYPE = exports.TBPRIZE_TYPE || (exports.TBPRIZE_TYPE = {}));


/***/ }),

/***/ "./src/TbFunc.ts":
/*!***********************!*\
  !*** ./src/TbFunc.ts ***!
  \***********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var TaoBaoNet_1 = __webpack_require__(/*! ./TaoBaoNet */ "./src/TaoBaoNet.ts");
var app = getApp();
var TbFunc = (function () {
    function TbFunc() {
    }
    TbFunc.openMember = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.openMember)];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    TbFunc.checkMember = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, app.checkMember()];
            });
        });
    };
    TbFunc.showTask = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.openTask)];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    TbFunc.goMyPrize = function () {
        my && my.navigateTo({
            url: '/pages/myPrize/myPrize'
        });
    };
    TbFunc.goExchangeGoods = function () {
        my && my.navigateTo({
            url: '/pages/exchangeGoods/exchangeGoods'
        });
    };
    TbFunc.navigateBack = function () {
        my && my.navigateBack();
    };
    TbFunc.alert = function (title) {
        my && my.alert({
            title: title
        });
    };
    TbFunc.saveImg = function (url) {
        if (my) {
            my.saveImage({
                url: url,
                showActionSheet: true,
                success: function () {
                    my.alert({
                        title: '保存成功',
                    });
                },
            });
        }
    };
    return TbFunc;
}());
exports.default = TbFunc;


/***/ }),

/***/ "./src/Tools.ts":
/*!**********************!*\
  !*** ./src/Tools.ts ***!
  \**********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.numLimit = exports.prefixInteger = exports.getRandomArrayElements = exports.Tools = exports.sleep = void 0;
var ctrls_1 = __webpack_require__(/*! ../module/ctrls */ "./module/ctrls/index.ts");
var RES_1 = __webpack_require__(/*! ../module/RES */ "./module/RES.ts");
var layers_1 = __webpack_require__(/*! ../module/views/layers */ "./module/views/layers.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ./TaoBaoNet */ "./src/TaoBaoNet.ts");
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var Tween = FYGE.Tween;
function sleep(time) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2, new Promise(function (resolve) {
                    Tween.get(FYGE)
                        .wait(time)
                        .call(resolve);
                })];
        });
    });
}
exports.sleep = sleep;
var Tools = (function () {
    function Tools() {
    }
    Tools.getGlobalData = function () {
        return __awaiter(this, void 0, void 0, function () {
            var data;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getAppData)];
                    case 1:
                        data = (_a.sent()).data;
                        Tools.globalData = __assign({}, data);
                        console.log("11", Tools.globalData);
                        return [2];
                }
            });
        });
    };
    Tools.getActivityInfo = function () {
        return __awaiter(this, void 0, void 0, function () {
            var getActivityBaseInfo, getMyActivityInfo, myActivityInfo, baseInfo;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        getActivityBaseInfo = {}, getMyActivityInfo = {};
                        return [4, TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getMyActivityInfo)];
                    case 1:
                        myActivityInfo = _a.sent();
                        if (myActivityInfo === null || myActivityInfo === void 0 ? void 0 : myActivityInfo.success) {
                            getMyActivityInfo = myActivityInfo === null || myActivityInfo === void 0 ? void 0 : myActivityInfo.data;
                        }
                        else {
                            ctrls_1.showToast(myActivityInfo === null || myActivityInfo === void 0 ? void 0 : myActivityInfo.message);
                        }
                        return [4, TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getActivityBaseInfoById)];
                    case 2:
                        baseInfo = _a.sent();
                        if (baseInfo === null || baseInfo === void 0 ? void 0 : baseInfo.success) {
                            getActivityBaseInfo = baseInfo === null || baseInfo === void 0 ? void 0 : baseInfo.data;
                        }
                        else {
                            ctrls_1.showToast(baseInfo === null || baseInfo === void 0 ? void 0 : baseInfo.message);
                        }
                        Tools.globalData.getActivityBaseInfo = getActivityBaseInfo;
                        Tools.globalData.getMyActivityInfo = getMyActivityInfo;
                        console.log("00", Tools.globalData);
                        return [2];
                }
            });
        });
    };
    Tools.getActivityBaseInfo = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a, success, data;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4, TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getActivityBaseInfo)];
                    case 1:
                        _a = _b.sent(), success = _a.success, data = _a.data;
                        Tools.activityBaseInfo = data;
                        return [2, success && data];
                }
            });
        });
    };
    Tools.getMyActivityInfo = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a, success, data;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4, TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getMyActivityInfo)];
                    case 1:
                        _a = _b.sent(), success = _a.success, data = _a.data;
                        Tools.myActivityInfo = data;
                        return [2, success && data];
                }
            });
        });
    };
    Tools.getTeamInfo = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a, success, data, i;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4, TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getTeamInfo)];
                    case 1:
                        _a = _b.sent(), success = _a.success, data = _a.data;
                        if (success) {
                            for (i = 0; i < data.length; i++) {
                                Tools.teamInfo[data[i].type] = data[i];
                            }
                        }
                        return [2, success];
                }
            });
        });
    };
    Tools.getPrize = function (prize, callFun) {
        if (callFun === void 0) { callFun = function () { return 0; }; }
        return __awaiter(this, void 0, void 0, function () {
            var call, type, id, _a;
            var _this = this;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        call = function () { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4, sleep(500)];
                                    case 1:
                                        _a.sent();
                                        callFun();
                                        return [2];
                                }
                            });
                        }); };
                        type = prize.type, id = prize.id;
                        _a = type;
                        switch (_a) {
                            case 1: return [3, 1];
                            case 3: return [3, 3];
                            case 2: return [3, 5];
                            case 5: return [3, 5];
                        }
                        return [3, 7];
                    case 1: return [4, TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.receiveEnamePrize, { id: id }, function (success, res) { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0:
                                        if (!(!success || !res)) return [3, 2];
                                        ctrls_1.showToast('奖品发放失败\n请前往我的奖品处进行处理');
                                        return [4, call()];
                                    case 1:
                                        _a.sent();
                                        return [2];
                                    case 2:
                                        if (res.data && res.data.drawStatus == 3) {
                                            ctrls_1.showToast('奖品发放成功\n请前往我的奖品处查看');
                                        }
                                        else {
                                            ctrls_1.showToast('奖品发放失败\n请前往我的奖品处进行处理');
                                        }
                                        return [4, call()];
                                    case 3:
                                        _a.sent();
                                        return [2];
                                }
                            });
                        }); }, true)];
                    case 2:
                        _b.sent();
                        return [3, 7];
                    case 3: return [4, TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getUserAddress, { prizeId: id }, function (success, res) { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0:
                                        if (!success) {
                                            return [2];
                                        }
                                        ctrls_1.showToast('奖品发放成功\n请前往我的奖品处查看');
                                        return [4, call()];
                                    case 1:
                                        _a.sent();
                                        return [2];
                                }
                            });
                        }); }, true)];
                    case 4:
                        _b.sent();
                        return [3, 7];
                    case 5: return [4, call()];
                    case 6:
                        _b.sent();
                        return [3, 7];
                    case 7: return [2];
                }
            });
        });
    };
    Tools.changeTextAlign = function (text, align, textWidth) {
        if (align == TEXT_ALIGN.LEFT)
            return;
        text.textAlign = align;
        textWidth = textWidth || text.textWidth;
        if (align == TEXT_ALIGN.CENTER)
            text.x -= (textWidth - text.textWidth) / 2;
        if (align == TEXT_ALIGN.RIGHT)
            text.x -= textWidth - text.textWidth;
        text.textWidth = textWidth;
    };
    Tools.btnDelay = function (target, delay) {
        if (delay === void 0) { delay = 2000; }
        target.mouseEnable = false;
        target.mouseChildren = false;
        setTimeout(function () {
            target.mouseEnable = true;
            target.mouseChildren = true;
        }, delay);
    };
    Tools.getNumTextures = function (name) {
        var arr = {};
        for (var i = 0; i <= 9; i++)
            arr[i] = RES_1.RES.getRes(name + i + ".png");
        return arr;
    };
    Tools.getAdjustBottomHeight = function (percent) {
        return layers_1.layers.stageHeight - layers_1.layers.stageHeight * percent + layers_1.layers.stageOffsetY;
    };
    Tools.getAdjustTopHeight = function (percent) {
        return layers_1.layers.stageHeight * percent + layers_1.layers.stageOffsetY;
    };
    Tools.cacheKey = "cow_xiaobujian";
    Tools.myActivityInfo = {
        coin: 0,
        gameTimes: 0,
        todayScore: 0,
        showPkModal: false,
        todaySelectTeam: undefined,
        yesterdaySelectTeam: undefined,
        yesterdayWinCoin: 0,
    };
    Tools.teamInfo = {
        1: {
            name: "",
            type: 1,
            people: 0,
            score: 0,
        },
        2: {
            name: "",
            type: 2,
            people: 0,
            score: 0,
        }
    };
    return Tools;
}());
exports.Tools = Tools;
function getRandomArrayElements(arr, count) {
    if (arr.length <= count)
        return arr;
    var shuffled = arr.slice(0), i = arr.length, min = i - count, temp, index;
    while (i-- > min) {
        index = (i + 1) * Math.random() >> 0;
        temp = shuffled[index];
        shuffled[index] = shuffled[i];
        shuffled[i] = temp;
    }
    return shuffled.slice(min);
}
exports.getRandomArrayElements = getRandomArrayElements;
function prefixInteger(num, length) {
    return (Array(length).join('0') + num).slice(-length);
}
exports.prefixInteger = prefixInteger;
function numLimit(num, min, max) {
    if (num > max)
        return max;
    else if (num < min)
        return min;
    return num;
}
exports.numLimit = numLimit;


/***/ }),

/***/ "./src/UI.ts":
/*!*******************!*\
  !*** ./src/UI.ts ***!
  \*******************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var RES_1 = __webpack_require__(/*! ../module/RES */ "./module/RES.ts");
var Container = FYGE.Container;
var Button = FYGE.Button;
var MouseEvent = FYGE.MouseEvent;
var Sprite = FYGE.Sprite;
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var TextField = FYGE.TextField;
var Shape = FYGE.Shape;
var Lottie = FYGE.Lottie;
var BitmapText = FYGE.BitmapText;
var UI = (function () {
    function UI() {
    }
    UI.Btn = function (parent, enImg, func, that, x, y, anchorX, anchorY, tImg, disImg) {
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        if (tImg === void 0) { tImg = enImg; }
        if (disImg === void 0) { disImg = enImg; }
        var btn = new Button(RES_1.RES.getRes(enImg), RES_1.RES.getRes(tImg), RES_1.RES.getRes(disImg));
        func && btn.addEventListener(MouseEvent.CLICK, func, that || btn);
        btn.position.set(x, y);
        anchorX !== undefined && (btn.anchorX = anchorX);
        anchorY !== undefined && (btn.anchorY = anchorY);
        parent && parent.addChild(btn);
        return btn;
    };
    UI.Sp = function (parent, imageName, x, y) {
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        var sprite = new Sprite(RES_1.RES.getRes(imageName));
        sprite.position.set(x, y);
        parent && parent.addChild(sprite);
        return sprite;
    };
    UI.Shape = function (parent, x, y) {
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        var shape = new Shape();
        shape.position.set(x, y);
        parent && parent.addChild(shape);
        return shape;
    };
    UI.Ctn = function (parent, x, y) {
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        var ctn = new Container();
        ctn.position.set(x, y);
        ctn && parent.addChild(ctn);
        return ctn;
    };
    UI.Txt = function (parent, txt, size, color, align, textWidth, x, y) {
        if (color === void 0) { color = "#000000"; }
        if (align === void 0) { align = TEXT_ALIGN.LEFT; }
        if (textWidth === void 0) { textWidth = 0; }
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        var text = new TextField();
        text.fillColor = color;
        text.size = size;
        text.textWidth = textWidth;
        text.textAlign = align;
        text.position.set(x, y);
        text.text = txt;
        parent && parent.addChild(text);
        return text;
    };
    UI.Rect = function (parent, width, height, color, radius, x, y, alpha) {
        if (color === void 0) { color = 0xff0000; }
        if (radius === void 0) { radius = 0; }
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        if (alpha === void 0) { alpha = 1; }
        var shape = new Shape();
        shape.beginFill(color);
        if (!radius) {
            shape.drawRect(0, 0, width, height);
        }
        else {
            shape.drawRoundedRect(0, 0, width, height, radius);
        }
        shape.endFill();
        shape.alpha = alpha;
        shape.position.set(x, y);
        parent && parent.addChild(shape);
        return shape;
    };
    UI.Circle = function (parent, x, y, radius, color, alpha) {
        if (radius === void 0) { radius = 0; }
        if (color === void 0) { color = 0xff0000; }
        if (alpha === void 0) { alpha = 1; }
        var shape = new Shape();
        shape.beginFill(color);
        shape.drawCircle(0, 0, radius);
        shape.endFill();
        shape.alpha = alpha;
        shape.position.set(x, y);
        parent && parent.addChild(shape);
        return shape;
    };
    UI.Lottie = function (parent, data) {
        var lottie = new Lottie(data);
        parent && parent.addChild(lottie);
        return lottie;
    };
    UI.BitTxt = function (parent, texture, text, x, y) {
        if (text === void 0) { text = ""; }
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        var bitTxt = new BitmapText(texture);
        bitTxt.position.set(x, y);
        bitTxt.text = text;
        parent && parent.addChild(bitTxt);
        return bitTxt;
    };
    return UI;
}());
exports.default = UI;


/***/ }),

/***/ "./src/common/G_EVENT.ts":
/*!*******************************!*\
  !*** ./src/common/G_EVENT.ts ***!
  \*******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.G_EVENT = void 0;
var G_EVENT;
(function (G_EVENT) {
    G_EVENT["ON_SHOW"] = "onShow";
    G_EVENT["ON_HIDE"] = "onHide";
    G_EVENT["UPDATE_TASK"] = "onUpdateTask";
    G_EVENT["JOIN_MEMBER"] = "onJoinMember";
})(G_EVENT = exports.G_EVENT || (exports.G_EVENT = {}));


/***/ }),

/***/ "./src/lotties/icon2.ts":
/*!******************************!*\
  !*** ./src/lotties/icon2.ts ***!
  \******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.icon2 = void 0;
exports.icon2 = {
    "fr": 24,
    "ip": 0,
    "op": 49,
    "w": 118,
    "h": 120,
    "nm": "游戏icon__m 拷贝",
    "assets": [
        {
            "id": "image_0",
            "w": 114,
            "h": 32,
            "u": "",
            "p": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAHIAAAAgCAYAAADOmyyBAAAACXBIWXMAAAABAAAAAQBPJcTWAAAAJHpUWHRDcmVhdG9yAAAImXNMyU9KVXBMK0ktUnBNS0tNLikGAEF6Bs5qehXFAAAV2klEQVRoge2beXiU1bnAf2dmksySkIlKMkGFTACVAoGIXg3WlrBd6aNsfXBBUBYFUWwv4Nq6RC3WrVKlgloNVhRUNFi0RoESqIUIAoGgBNAsVzSZBJUhmUkmy/ed+8e3ziS55Wnv8o/v84SZvN85776d8wXBPwm1tdLtOSvSx6MmpXeinuFyOvqoCklOp8gA1eFwCL+q4nQ5nX3s+1RVFU4nPhBJp8NHBVUqstnhcMjEZ4qiRISDzm6bJB2qlNFe6LlcDpHWfYvwOoUjJUE+hxCk6xs90iHcaMh0QAhIEkL4NBxeIXSdBD4gUT/hEKIPPYCUdEpkqymipFlKqaqSFpBtqqRdlfKUQHyrqrIm1q7sefvLz8oWXnSRqbvoiTBAdfX36Wf09Y1xJTlGOpHnO4TjXIdTZDqEyBBC+IUgCQHIHijpOClASOszTnihb5H6Xkl3acxn+hc7v7itEmE8J36NCYk87HwT1ySK09PehPW98k6UPxH0R93Ut8kn7Vt1vKLIxmhbxwM3z9v08oYNVyvxpIuKHI1L7pjQx+3+ZZLLOVGA06BgMrJxTJRPSglCxOkt0Z1o32z7sGygu8N41oOxRILCGjsNo/HR+HeXVerP46OnJ98ge+PTc6wl2DzBt2aIJcgieo0Jw+8iMTG6BbtG52Rz21233vz+0yZ6wQsvJD0xa+7qVHfS/LigSoxanVo8OlFF63eBFlE90eiZfiJ0N5+RheiSyF7W9aoCPTjwv1kv9H+k3duGDU5Tfktmm13ozT52Obrb2y57p6I0TrjlT4MdADNmvOUs+vn1d3jdSfNVqS0wPqWqKSClhlOlQJUSBYmU0sRLqRV3ieRUSzvLnyvlnQ8rUKRBQ6JKmLW0mPPGPmCjB+eNvZ9ZS4pRpUFTms80fqACXzeEmbWkmLc/rEBKgZQCFUM2ocmJtOTRf062xHj2T9tMvASK397F5AWr+LohjGrqK7n1/nUMHns/4ZaYyVeVEkWVGi9AIjQZkUjV0l8auiwtRkrYfaCWU5F2VIy9Ik4u80fVeEhDF7QfRWp7VEAhXidjTbSt46RMTvK4AOrTWrwed9IcVbVKoVEApJR6mhvfhR5CeoQYPUVo1CWCU5E2Sj7aD8DFI4KcHfBj1lJ9vWrUZXvsSlCFkWMJz1UoP1DLnoPaT1qqm3GjL4hrIFrgCYTQpDdILH5gHXsO1rJ15xH+9Lt59El1k5bqoerLBrbsPMwN0wuQQhBpaWfrziouGJRNms+ttQqETkuy52ANZmoK7VMKwTlZGZwdSDftgoTjoTCzlxZzdsDPo3dN5+K8YFyplbYyq8kpkKoth6VNJ52dqvtCIkCFWKfSUryp4okup1RcADI5yeN0ObNVnYI0HGX2K2H+Ik3vWTibZCAhkJXB7OkFrHq1jHufKOGV383lSHWIlpY2miNtAOw+WKc1ct2zzZEYuw/UAZKLR+QauulaaKSn/vtIAH79ZAn3PlHClrXLSE1N0VuP1fNM4+hKPFM0k8dXf8C7myvYfaCWcZcN4aK8IAB7DtYxa/poUOGVd3YB0NLSxg3Lis0YGjIwwN2LfsaNS9fQE9w6u5DbbhxrBSSQneln+Z3TeGx1KTcuLWbza8s4OysdkFqwqkYjNGyp7zQcKLHwhqklpv0jrR0nVry588G/Hajb5W1zRF0AwtXpao0pJ1O9zjRUnbjQnCaMAm6fvmy+BAlqwkSmShbNKmTbziq+CZ3k69ApHltVyqcHa80lc2yGAjhS3cCcOzTcoc2PaImmGspYfCdPzOdIdQNrS8r51ZMlPPPQdahSH3QAKexGEYAgNdXNI3dOY/KEkXxaWccvHlxn8v3rziqGjr+f2dNH8+7m/aSluukXyIiTTaK1k0WzC+PwR6tDbNtVRWqqG1WFhALC5In5nJebzbZdVWRnpqNqAmqZbBK3T4vCKIcJesdXp45OpXX5Kzvu3XO4fmdaW9LXm9fObncBJKkOtf675oODPGf2l7ZAMUupwQTDmWiZqxqDgDQjRluvrV3x4EyyA36EFFw1fiSjhuewaUsF9Y1hbpldaMr3/Noy+mX5mTwx3zQCqvYp7OcWvcHNnDaatSXlbNtVxe4DdVw8IicuC7XCohnF/I5gVF4QieCivDr2VtYyZWI+2Zl+EPD6xnJaIjFWFM1k7OgLbLbTDKoiuGVWIVIYE6dk9doy3UkZ7LEF6Tehk/z6yRLqQ2EA9lbWsnptGXfeMknLfqPcJJZS0+5m5db0N7IRgRBQ8UXjpv1V35R30PnV5rUL2kBIFwCtxHZWHv9z7tlnXmU6RNdBVW2jsGlTvV/qVV/qWSsEqKq2WUhBVqYfVWoGvnJCPkLA3so66hvDLJxVaPYLzZEZLLx+LFJIFN1hWhEwKoIVlYe/qDeN9vzaMkYNn2sJrQqkkAh9+IlEYtx8dzHn52bz0B3TuDAvyKi8WvZW1nLl+JGMGpGLQHK0OkTZripeLynn9ZJy7LBs4SQuGBhg6cPrqW8M88aqRYCWkaC1hSUPWVle3xhm0+YKAPpl+c0yPjg3G9Vo/5K487UxhFmtQWL50MAKVBUqjn7zoXTEGvatXtRmUHABeNJa2t74YO8nky//UX2qN7lfnBZSmhFoRL3QI902j5uRC3DRFQ+Y2AXXF7JgVqFuZCsWFBVbxGh4w4EaOaFfJmgIoVr99L0tB0z6eyu14WfUiKBetjTVVJ2Gqsu8aUsFEihaOs0UW5sANZ5P3X8dr79bzo7yIybtY9UNtERjNEfaUKQgO9NP2a4qVr9axoJZYzla3UC/LD+DcwMsuF7Tcf27WmbvK31Yb0+SlmiMNJ8HgdQCXZ8rpCrNzLN6umVOQA9IPUl07399ouVYmqurFds1iwugdOXtHZfc9NKp5rb2Oq8nuZ+V4wZxo07bale3k5gVT6PygrRE2jhWE0IC34TC1DeGAUmLPuxo/dKq+y2RmNlD+2WdQXZWOhZY8jQ0hdleXkWaz82ShT/j4adLePH17awenmvrL7o8UuD1uln1xHwW3fWyHizWkoV3W8PL6sfmce3U0Vw7pQCA97dUsK+ylp8WDCF/eBBVSuZfX0hZeRUvvl5GIDOD+sYwPy0YwqBggEHBbBCSfZV17KusRZGAlByrCTFr8SqWLJjEdVNHW3aMc5ztlGi3uTCnG6u1IRkazEr9Zsf3XTYDaY4EIZ2uVzscDodDlRY1KzjsR1mDnLT9bjlRAs/9di77D9Vy6z1rkHo2vLyuzM6XRfesifv9WE2DibtpZiE3XV+ITRRT1fUbtbL3k4IhXH7pEFJ9bvZV1rK3soYLhwcT5NQ2+zwpPPfYfECiSC0TDT4NTWH+srUCqWeLBP5WXsXDKzZyXm6A+5ZMQ9ELh8/r5r4l07jtnjU8vKJEk+PSC8zn0mb3I9UhsrP83PmIVnIDmX79yGW3lmU1EXfjIE3du9sYzkj3nHFi6GHBBst+LuOLP83tSPW6z1cSEkyviFp9jhMhLo7icMYh18BOGpdP/vAcABbfqznrD7+da+5cfO8aBucG+OXNk3SlM7TSa5QXtAN1qDHMG3/WHDn3ukK83hSunlxA8foy/vj6dv7w2yDGDtB7jD65+TwpSCwnAsydWUjFoVr+srWC5kg7eyu1irDjE628XjEun6PVDaT6PAwOBkDAyGFBrplSwJu6HJdfMkSfWDXC+cNz2H+oluZIjBUvrqehMcw1Uwr48aVDTN6WCJY7hT7JmudE/V9VX2edrSHZmdTH890ZTsDMSs2RRUWO2ydfVuh0ODPsY7Q0Bh0zPPQjrRkctiiyTf2GM9E/szL9ZPX1EzoR1pUNMmJoME6pVJ+HvGFBMwKNFmrPsHuWa9E9Y0oBWX39KBJmTC7grU3lVByq5Y13y7l6SkHcRqMP/eJXa4hE23h2+TyO1YR02YQZcEerG1izPr5qPPvHUlPeZ5fPNeXNzQmYa47UNJA/LGhOnpmZfk3W36wjEo2RPzzI4psmxQWQBYacNkWlNQsYpzsppHXSk6ifHjv+ZSIlB8CYugHJgTP90xW0qyBVasOIiu0TbSJVVeuaSFG1qzrtmQ0vzckaqdNSgGK9vF52yQUo6P1KWuuMvYqxR1r7l/9+I1/UhAhk+plzTaHJy+N1c88vpgGw8qVSjlaHtP122SV8UdNAQ2MYj9dNSzTGoNwAqippjsYAGJgT4Jnlc3lm+VyuGKcdgxbPn8Tvl8/ltvmTTJlaWmJxDn/09xtpjsRMeQbmZAMQicYYFAzwm3uvQ1FhR3lVvG6qpaNqw6uqlkCq/ty4/jN0+rwm9M72j6vq2s78XunmyHan4k31pYxTEwgYd3pdugMNpl3Y1qjCeqbaHGkrI6qED7ZWUPrXClJ9biYU5sc5zQBDEVXV7jFVVbvjfOyZjXz4V22cf/jemXh8bjN4FCkZfekQfnzJEAD+49fFHKsOWYGlQn0oTCQaY+SwHFQJBw7VEuiboTtYy06vz83woUGGDw2S1VfLqtxggLyhQXJzAqY9Vr5USqgpzM+vKuDnkwsINYUpXl+GqsLRmhCPPVNi6nPr/El4vG5UJPc9up77lq+3Bby0JYQ9CaSZCIkOrvyi4f1HXihd4ehyndxe9GCcI10Akwp/dLZwODKMpm2C6YyEtx0ysT/GQzQa47mXtbL0znvljP63IWT19ZOV6efWeZPwelMw7nUBRgwLkhsM2MqPdbh/auVGPtqmOfHO26eRmxNAMUZ426R3x+3TaGg6SXVtiKX3FfO7R+aRGwwAkopDWu8bPjRoltXhQ3PiAi5vaNA2tGhIw+DGWLd5234+3FZBVqafWddotzx//6SKj7ZpR5uS97S+mZXpp7EpzEfbDpA3NMiBQ3VaYOQEbIEbb0HjTB5ve01PKaWya3/1q3/c8HGxoqo15ByP2I8eAC6Qouar9zu1gS3uFSZWDY9zr41TIl4Sica464E1VNeGyBuWQ+VndSy7v5gJhfnMunoMXq/bVMyAWVePAbRMAQg1hRkxLMhDj6+julYz/LLF0xhfmK850ZTH4u/xulm2eDp3PVBMJBpj4dJVLFs8lYlj8zn4ucZv+NAgJe9rxs7s6+fAoVqq6zT69srQEm3XtJGg6GN/dW0DT658l1SfmwfvmonX6wbgwbtn8vyaUkreKyfV52bWNYVMKMznxlue5qNtFQRzAlSa/HMSrvIS7ZeYHoIuRYmV7jj0zMYtBzaKTlHjGfDNye1FRV0JG7WM/LKuvvX75uhhf6pvKML+4lOPEmk5NO6Nv+0wr/Vr7dVSqCnMhMJ8lt42lfJPj/DCmlI2vl+eyLtXmHplAePH5OPzuvH53CycewXj9XJs3aHHTQcgBMGcAI89NI+nnyshGo1RcLE2KR78rBafz01m33Q2b6sgNxgg1BTmhTVa1TCqwZxFT9PYpA1kPp+b4ICA/moNcnKyyQ0GWHbbNHKCAf0GS5CTk8X9d13Li2s+5PoZhWRl+QHJksXTeOTx9TxfrPHIyvQzbGhOj0OclfPCzCUJtMU6wm+V7nl0x75jW53OjrrAybOaNxQVxZVUewgwZsELZ51/3rlj5kz/yVPpad4BMm6S0m9LjMQXxCeuNAhJHS3YWraf8YX5VkmW0HQiTGPTyW4Jb0qhayaA3AHZeH0pRFtjNDWdIhgM2CIGfYA21DcmOmGSa43GCH0bJjcnCyR88ukRGptOMuXKAraWVZDq85Cbk83WsgryhuaQmxPA53OzZXsFTU1hEIJxY/IJ9PXbdJaWrIbYevAatjIHeV3WphOn2Lp9P0jBuMJ8sjLTrYQwSMZlhGWQaGt700tv7/j150e/Ku9ye4/vPvPLCEVFKr2AAJh0+7Mp0TZPPzXZdf5VPx0xfnAwKz/V58lK9aRkeNwpZ7mcItl2Z2TrkYZD4z0ipLD9vY607hPNIJC2CmJ4xlhA3IWx+TrHmsVBWDzi/w4jscd0L1XmOwDdcEK/RjPOWXafmfLZ30gI9DNfXM3CLrgQ9r9awNaebN3LFrgSWyAgaI11fvf8uq13HP0qVO6LJH29ee3sVhJ6Yo+OBBgzZ40bL/72Lvo6nPiFqvhUHCkOJ95L8gYNvuzCQYXBczIvdzgcTstEcSli1T3jOinOALZ6IhOcZ9RrSxuQQifZAw/DaIl9Wtr323iZS7rVNJvxjQyxi2bjYX8tZJITcfa14jNBCDv/uOCy0TUHLLVj/fu779615/AHSqr/ePmKGbF/5EQ7Rw2Kihxj6gYkA25FyCSnRzg7hJKCQho4Mi/OG3jx1HGjFvn7eAZYu+0ONAxjV6I3B9px2K2nk7A1Y7v+cSW9W53Tv9t7p02/RHOYNk1YJKyblnhZE/d1l0fYXswnticT100eyy6fHTn+2uo3tj6eGk2uPZ1MtFP4ByDFpNtXJre1p6R1SpGVlJwSvHbq6GvzBp97ZUpKcjo9GDyxlBrv1IxoNfup1AuTLTOFbhDjTyF6dWaCk7SSGD/EWz0rMZOIz66E9idtDo4r7/RcSk1GNnpCGIOiUT+lhbPxtCvQ0aE0L1/5zpRw9OTBv69eFD5dJ4LtrrV3ELJ0Je0gO8bMeSXS7iT82oaPTwineHvEBeeeFzw3K9ftSfY5EM5kd5JbqCAdcfJZL6AdCR1L1XDmC1Zjn47vLQk6O7o6FFXtNPYJfV98N7RwAmhv74x1qbLHia836GjraO0SsvuAYWAS5ZXISGtblF5GEimEOOuMtMzc/ll5A87pe6nQKRh9ufHb8CfN4ch/us5panlr19cZ5/Zrf8qZ5LxKSjrbWjuWjVn3xJu9DTynkZHxMGPGW876tBYvXtJQSJNdDg+QJFxdTqk6hFR7PHT+j4FwSCkcqhSKUyqOnm8wu+1RnFI4VOmQotepLxG6dB5OV9fp71Fc0iE7VYfD1aNcilAdQgq3KsSZN069fOaFw3NvAMwI/LSy+r7X3vnb6ubmPpFVj09+252cdJU5nEkZO/zF8fy5hTlHe8rU08jIeNiw4WoFaAEZGbXgxRPJqRmulPYTzs6YWyi+lP9VJxrgirZLl7tNnrbwDkhuSZPfedpOu1QlezJk8smopPP0TeQEPGkx+VUo0COf/oGQUMJ+V5unrc+bfymP/ej8/pNTkpL8EklHZ9ep0u0HttCnT1tfJeoVDjFMYp/fhDs9vc/PxhQ99OX2Inq+EPjnQMh9L9IJPfzfix+gR/hc+2ifMeOt2DeZzclHq+vfGnZ+/5u7FKX1408PP3ni+1P1/U+ld5zI6PDtq6x9OW9I/9uTXa4+7Z2dzd+Howc2bdm9PfH1lQH/Jxn0A3SHy+a9nKYmy0ED+2eP/Pa78KmW5uhRX8xdt3ntDdGJs1/1Nae193cpYoAqhE8IOkFt6uqktv+p9G/1qhgH/0JG/gD/CvRrSWutyThZ80VN/Ylkh6r4Yp7mzQNr2gA2D6xpm1id+1XEx3cSmZQsVIVWRyyW3BHtyYnwQ0b+P4O0H6BOu3/3BP8FMdfnOnO7jEQAAAAASUVORK5CYII=",
            "e": 1
        },
        {
            "id": "image_1",
            "w": 33,
            "h": 32,
            "u": "",
            "p": "data:image/png;base64,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",
            "e": 1
        },
        {
            "id": "image_2",
            "w": 33,
            "h": 32,
            "u": "",
            "p": "data:image/png;base64,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",
            "e": 1
        },
        {
            "id": "image_3",
            "w": 100,
            "h": 100,
            "u": "",
            "p": "data:image/png;base64,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",
            "e": 1
        },
        {
            "id": "comp_0",
            "layers": [
                {
                    "ddd": 0,
                    "ind": 1,
                    "ty": 2,
                    "nm": "椭圆 7 拷贝",
                    "refId": "image_1",
                    "sr": 1,
                    "ks": {
                        "o": {
                            "a": 0,
                            "k": 100,
                            "ix": 11
                        },
                        "r": {
                            "a": 0,
                            "k": 0,
                            "ix": 10
                        },
                        "p": {
                            "a": 1,
                            "k": [
                                {
                                    "i": {
                                        "x": 0,
                                        "y": 0
                                    },
                                    "o": {
                                        "x": 0.167,
                                        "y": 0.167
                                    },
                                    "t": 0,
                                    "s": [
                                        12,
                                        90.5,
                                        0
                                    ],
                                    "to": [
                                        0,
                                        0,
                                        0
                                    ],
                                    "ti": [
                                        0,
                                        0,
                                        0
                                    ]
                                },
                                {
                                    "i": {
                                        "x": 0,
                                        "y": 1
                                    },
                                    "o": {
                                        "x": 0.167,
                                        "y": 0
                                    },
                                    "t": 3,
                                    "s": [
                                        12,
                                        90.5,
                                        0
                                    ],
                                    "to": [
                                        8.958,
                                        -6.667,
                                        0
                                    ],
                                    "ti": [
                                        -8.958,
                                        6.625,
                                        0
                                    ]
                                },
                                {
                                    "i": {
                                        "x": 0.833,
                                        "y": 0.833
                                    },
                                    "o": {
                                        "x": 0.333,
                                        "y": 0
                                    },
                                    "t": 12,
                                    "s": [
                                        65.75,
                                        50.5,
                                        0
                                    ],
                                    "to": [
                                        8.958,
                                        -6.625,
                                        0
                                    ],
                                    "ti": [
                                        1.125,
                                        -0.833,
                                        0
                                    ]
                                },
                                {
                                    "i": {
                                        "x": 0.833,
                                        "y": 0.833
                                    },
                                    "o": {
                                        "x": 0.167,
                                        "y": 0.167
                                    },
                                    "t": 13,
                                    "s": [
                                        65.75,
                                        50.75,
                                        0
                                    ],
                                    "to": [
                                        -1.125,
                                        0.833,
                                        0
                                    ],
                                    "ti": [
                                        1.125,
                                        -0.792,
                                        0
                                    ]
                                },
                                {
                                    "i": {
                                        "x": 0.48,
                                        "y": 0.48
                                    },
                                    "o": {
                                        "x": 0.167,
                                        "y": 0.167
                                    },
                                    "t": 18,
                                    "s": [
                                        59,
                                        55.5,
                                        0
                                    ],
                                    "to": [
                                        0,
                                        0,
                                        0
                                    ],
                                    "ti": [
                                        0,
                                        0,
                                        0
                                    ]
                                },
                                {
                                    "i": {
                                        "x": 0,
                                        "y": 1
                                    },
                                    "o": {
                                        "x": 0.33,
                                        "y": 0
                                    },
                                    "t": 38,
                                    "s": [
                                        59,
                                        55.5,
                                        0
                                    ],
                                    "to": [
                                        -7.833,
                                        5.833,
                                        0
                                    ],
                                    "ti": [
                                        7.833,
                                        -5.833,
                                        0
                                    ]
                                },
                                {
                                    "i": {
                                        "x": 0,
                                        "y": 0
                                    },
                                    "o": {
                                        "x": 0.167,
                                        "y": 0.167
                                    },
                                    "t": 45,
                                    "s": [
                                        12,
                                        90.5,
                                        0
                                    ],
                                    "to": [
                                        0,
                                        0,
                                        0
                                    ],
                                    "ti": [
                                        0,
                                        0,
                                        0
                                    ]
                                },
                                {
                                    "t": 48,
                                    "s": [
                                        12,
                                        90.5,
                                        0
                                    ]
                                }
                            ],
                            "ix": 2,
                            "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                        },
                        "a": {
                            "a": 0,
                            "k": [
                                16.5,
                                16,
                                0
                            ],
                            "ix": 1
                        },
                        "s": {
                            "a": 0,
                            "k": [
                                100,
                                100,
                                100
                            ],
                            "ix": 6
                        }
                    },
                    "ao": 0,
                    "ip": 0,
                    "op": 480,
                    "st": 0,
                    "bm": 0
                },
                {
                    "ddd": 0,
                    "ind": 2,
                    "ty": 2,
                    "nm": "椭圆 7",
                    "refId": "image_2",
                    "sr": 1,
                    "ks": {
                        "o": {
                            "a": 0,
                            "k": 100,
                            "ix": 11
                        },
                        "r": {
                            "a": 0,
                            "k": 0,
                            "ix": 10
                        },
                        "p": {
                            "a": 1,
                            "k": [
                                {
                                    "i": {
                                        "x": 0.833,
                                        "y": 0.833
                                    },
                                    "o": {
                                        "x": 0.33,
                                        "y": 0.33
                                    },
                                    "t": 0,
                                    "s": [
                                        70,
                                        46,
                                        0
                                    ],
                                    "to": [
                                        0,
                                        0,
                                        0
                                    ],
                                    "ti": [
                                        0,
                                        0,
                                        0
                                    ]
                                },
                                {
                                    "i": {
                                        "x": 0,
                                        "y": 1
                                    },
                                    "o": {
                                        "x": 0.33,
                                        "y": 0
                                    },
                                    "t": 7,
                                    "s": [
                                        70,
                                        46,
                                        0
                                    ],
                                    "to": [
                                        0,
                                        0,
                                        0
                                    ],
                                    "ti": [
                                        0,
                                        0,
                                        0
                                    ]
                                },
                                {
                                    "i": {
                                        "x": 0.833,
                                        "y": 0.833
                                    },
                                    "o": {
                                        "x": 0.33,
                                        "y": 0
                                    },
                                    "t": 12,
                                    "s": [
                                        115.25,
                                        4.75,
                                        0
                                    ],
                                    "to": [
                                        0,
                                        0,
                                        0
                                    ],
                                    "ti": [
                                        0.5,
                                        -51.5,
                                        0
                                    ]
                                },
                                {
                                    "i": {
                                        "x": 0.833,
                                        "y": 0.833
                                    },
                                    "o": {
                                        "x": 0.167,
                                        "y": 0.167
                                    },
                                    "t": 24,
                                    "s": [
                                        20,
                                        56,
                                        0
                                    ],
                                    "to": [
                                        -0.5,
                                        51.5,
                                        0
                                    ],
                                    "ti": [
                                        -19.625,
                                        17.625,
                                        0
                                    ]
                                },
                                {
                                    "i": {
                                        "x": 0.833,
                                        "y": 1
                                    },
                                    "o": {
                                        "x": 0.167,
                                        "y": 0.167
                                    },
                                    "t": 34,
                                    "s": [
                                        92.25,
                                        94.25,
                                        0
                                    ],
                                    "to": [
                                        19.625,
                                        -17.625,
                                        0
                                    ],
                                    "ti": [
                                        27.25,
                                        -16.5,
                                        0
                                    ]
                                },
                                {
                                    "i": {
                                        "x": 0.833,
                                        "y": 1
                                    },
                                    "o": {
                                        "x": 0.167,
                                        "y": 0
                                    },
                                    "t": 39,
                                    "s": [
                                        70,
                                        46,
                                        0
                                    ],
                                    "to": [
                                        -27.25,
                                        16.5,
                                        0
                                    ],
                                    "ti": [
                                        27.25,
                                        -16.5,
                                        0
                                    ]
                                },
                                {
                                    "t": 48,
                                    "s": [
                                        70,
                                        46,
                                        0
                                    ]
                                }
                            ],
                            "ix": 2,
                            "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                        },
                        "a": {
                            "a": 0,
                            "k": [
                                16.5,
                                16,
                                0
                            ],
                            "ix": 1
                        },
                        "s": {
                            "a": 0,
                            "k": [
                                100,
                                100,
                                100
                            ],
                            "ix": 6
                        }
                    },
                    "ao": 0,
                    "ip": 0,
                    "op": 480,
                    "st": 0,
                    "bm": 0
                }
            ]
        }
    ],
    "layers": [
        {
            "ind": 1,
            "ty": 2,
            "nm": "字",
            "refId": "image_0",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        59,
                        100,
                        0
                    ]
                },
                "a": {
                    "k": [
                        57,
                        16,
                        0
                    ]
                },
                "s": {
                    "k": [
                        {
                            "i": {
                                "x": [
                                    0.667,
                                    0.667,
                                    0.667
                                ],
                                "y": [
                                    1,
                                    1,
                                    1
                                ]
                            },
                            "o": {
                                "x": [
                                    0.333,
                                    0.333,
                                    0.333
                                ],
                                "y": [
                                    0,
                                    0,
                                    0
                                ]
                            },
                            "t": 0,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        },
                        {
                            "i": {
                                "x": [
                                    0.667,
                                    0.667,
                                    0.667
                                ],
                                "y": [
                                    1,
                                    1,
                                    1
                                ]
                            },
                            "o": {
                                "x": [
                                    0.333,
                                    0.333,
                                    0.333
                                ],
                                "y": [
                                    0,
                                    0,
                                    0
                                ]
                            },
                            "t": 24,
                            "s": [
                                105,
                                105,
                                100
                            ]
                        },
                        {
                            "t": 48,
                            "s": [
                                100,
                                100,
                                100
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                }
            },
            "ip": 0,
            "op": 480
        },
        {
            "ind": 2,
            "ty": 0,
            "nm": "预合成 1",
            "refId": "comp_0",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        59,
                        60,
                        0
                    ]
                },
                "a": {
                    "k": [
                        59,
                        60,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "hasMask": true,
            "masksProperties": [
                {
                    "inv": false,
                    "mode": "a",
                    "pt": {
                        "a": 0,
                        "k": {
                            "i": [
                                [
                                    23.777,
                                    0
                                ],
                                [
                                    0,
                                    -23.777
                                ],
                                [
                                    -23.777,
                                    0
                                ],
                                [
                                    0,
                                    23.777
                                ]
                            ],
                            "o": [
                                [
                                    -23.777,
                                    0
                                ],
                                [
                                    0,
                                    23.777
                                ],
                                [
                                    23.777,
                                    0
                                ],
                                [
                                    0,
                                    -23.777
                                ]
                            ],
                            "v": [
                                [
                                    58.5,
                                    11.948
                                ],
                                [
                                    15.448,
                                    55
                                ],
                                [
                                    58.5,
                                    98.052
                                ],
                                [
                                    101.552,
                                    55
                                ]
                            ],
                            "c": true
                        },
                        "ix": 1
                    },
                    "o": {
                        "a": 0,
                        "k": 100,
                        "ix": 3
                    },
                    "x": {
                        "a": 0,
                        "k": 0,
                        "ix": 4
                    },
                    "nm": "蒙版 1"
                }
            ],
            "w": 118,
            "h": 120,
            "ip": 0,
            "op": 480
        },
        {
            "ind": 3,
            "ty": 2,
            "nm": "组 10",
            "refId": "image_3",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        59,
                        56,
                        0
                    ]
                },
                "a": {
                    "k": [
                        50,
                        50,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 480
        }
    ],
    "markers": []
};


/***/ }),

/***/ "./src/lotties/invation.ts":
/*!*********************************!*\
  !*** ./src/lotties/invation.ts ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.invation = void 0;
exports.invation = {
    "fr": 24,
    "ip": 0,
    "op": 49,
    "w": 86,
    "h": 121,
    "nm": "invation",
    "layers": [
        {
            "ind": 1,
            "ty": 2,
            "nm": "组 31",
            "refId": "39b11020dae7b9a8f0635df5b457de4d",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        68.5,
                        59,
                        0
                    ]
                },
                "a": {
                    "k": [
                        17.5,
                        54,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 480
        },
        {
            "ind": 2,
            "ty": 2,
            "nm": "组 8",
            "refId": "78490eecdae83bb7bfc15b973c08cc05",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                51,
                                60.5,
                                0
                            ]
                        },
                        {
                            "t": 12,
                            "s": [
                                44.5,
                                60.5,
                                0
                            ]
                        },
                        {
                            "t": 20,
                            "s": [
                                53,
                                60.5,
                                0
                            ]
                        },
                        {
                            "t": 25,
                            "s": [
                                51,
                                60.5,
                                0
                            ]
                        },
                        {
                            "t": 48,
                            "s": [
                                51,
                                60.5,
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                },
                "a": {
                    "k": [
                        45,
                        58.5,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 480
        }
    ],
    "markers": []
};


/***/ }),

/***/ "./src/lotties/match.ts":
/*!******************************!*\
  !*** ./src/lotties/match.ts ***!
  \******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.match = void 0;
exports.match = {
    "fr": 24,
    "ip": 0,
    "op": 145,
    "w": 750,
    "h": 1624,
    "nm": "match",
    "layers": [
        {
            "ind": 4,
            "ty": 2,
            "nm": "白点 拷贝 6",
            "refId": "1764dbef451b8b4fb9ae3728a893be28",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        376.5,
                        859.5,
                        0
                    ]
                },
                "a": {
                    "k": [
                        2.5,
                        2.5,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 480
        },
        {
            "ind": 6,
            "ty": 2,
            "nm": "椭圆 832 拷贝 9",
            "refId": "a3151c6c673305582ba9657383c81039",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 46,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 72,
                            "s": [
                                0
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        376.5,
                        859,
                        0
                    ]
                },
                "a": {
                    "k": [
                        196.5,
                        196,
                        0
                    ]
                },
                "s": {
                    "k": [
                        {
                            "t": 0,
                            "s": [
                                0,
                                0,
                                100
                            ]
                        },
                        {
                            "t": 72,
                            "s": [
                                144,
                                144,
                                100
                            ]
                        }
                    ],
                    "x": "var $bm_rt;\n$bm_rt = loopOut('cycle', 0);"
                }
            },
            "ip": 0,
            "op": 480
        },
        {
            "ind": 8,
            "ty": 2,
            "nm": "白点 拷贝 5",
            "refId": "3c911e3ce7c16eb04b024651ac52b328",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 23,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 28,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 34,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 50,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        175.5,
                        751.5,
                        0
                    ]
                },
                "a": {
                    "k": [
                        3.5,
                        3.5,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 480
        },
        {
            "ind": 9,
            "ty": 2,
            "nm": "白点 拷贝 4",
            "refId": "3c911e3ce7c16eb04b024651ac52b328",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 5,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 10,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 16,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 32,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        285.5,
                        530.5,
                        0
                    ]
                },
                "a": {
                    "k": [
                        3.5,
                        3.5,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 480
        },
        {
            "ind": 10,
            "ty": 2,
            "nm": "白点 拷贝 3",
            "refId": "3c911e3ce7c16eb04b024651ac52b328",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 61,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 66,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 72,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 88,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        285.5,
                        1071.5,
                        0
                    ]
                },
                "a": {
                    "k": [
                        3.5,
                        3.5,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 480
        },
        {
            "ind": 11,
            "ty": 2,
            "nm": "白点 拷贝 2",
            "refId": "3c911e3ce7c16eb04b024651ac52b328",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 62,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 67,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 73,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 89,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        286.5,
                        1091.5,
                        0
                    ]
                },
                "a": {
                    "k": [
                        3.5,
                        3.5,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 480
        },
        {
            "ind": 12,
            "ty": 2,
            "nm": "白点 拷贝",
            "refId": "3c911e3ce7c16eb04b024651ac52b328",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 82,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 87,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 93,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 109,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        436.5,
                        970.5,
                        0
                    ]
                },
                "a": {
                    "k": [
                        3.5,
                        3.5,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 480
        },
        {
            "ind": 13,
            "ty": 2,
            "nm": "白点",
            "refId": "3c911e3ce7c16eb04b024651ac52b328",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 87,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 92,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 98,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 114,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        516.5,
                        1021.5,
                        0
                    ]
                },
                "a": {
                    "k": [
                        3.5,
                        3.5,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 480
        },
        {
            "ind": 14,
            "ty": 2,
            "nm": "红点",
            "refId": "6546f1f365d9c777b1c32aea164d869c",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 37,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 42,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 48,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 64,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        218.5,
                        873.5,
                        0
                    ]
                },
                "a": {
                    "k": [
                        6.5,
                        6.5,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 480
        },
        {
            "ind": 15,
            "ty": 2,
            "nm": "红底",
            "refId": "6546f1f365d9c777b1c32aea164d869c",
            "ks": {
                "o": {
                    "k": [
                        {
                            "t": 117,
                            "s": [
                                0
                            ]
                        },
                        {
                            "t": 122,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 128,
                            "s": [
                                100
                            ]
                        },
                        {
                            "t": 144,
                            "s": [
                                0
                            ]
                        }
                    ]
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        592.5,
                        748.5,
                        0
                    ]
                },
                "a": {
                    "k": [
                        6.5,
                        6.5,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 480
        },
        {
            "ind": 16,
            "ty": 2,
            "nm": "圈圈__m",
            "refId": "235a6cc3033ebfc1d9d9bd60d600e117",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        376.5,
                        859,
                        0
                    ]
                },
                "a": {
                    "k": [
                        418.5,
                        419,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 480
        }
    ],
    "markers": []
};


/***/ }),

/***/ "./src/lotties/snow.ts":
/*!*****************************!*\
  !*** ./src/lotties/snow.ts ***!
  \*****************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.snow = void 0;
exports.snow = {
    "fr": 24,
    "ip": 0,
    "op": 53,
    "w": 750,
    "h": 1624,
    "nm": "Comp 1",
    "layers": [
        {
            "ind": 1,
            "ty": 2,
            "nm": "snow_00000.png",
            "refId": "84474856504ef8b9e8c19ec77bcdbd65",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 0,
            "op": 2
        },
        {
            "ind": 2,
            "ty": 2,
            "nm": "snow_00002.png",
            "refId": "8a667db765f7eb4304ab03086cbcfe90",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 2,
            "op": 4
        },
        {
            "ind": 3,
            "ty": 2,
            "nm": "snow_00004.png",
            "refId": "df77466e5edfdf7696e3a00cdc821bb3",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 4,
            "op": 6
        },
        {
            "ind": 4,
            "ty": 2,
            "nm": "snow_00006.png",
            "refId": "052f3a5104d8c2d772b821e6eb716872",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 6,
            "op": 8
        },
        {
            "ind": 5,
            "ty": 2,
            "nm": "snow_00008.png",
            "refId": "c2a7347b80e9924e9360f15c86ab3b35",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 8,
            "op": 10
        },
        {
            "ind": 6,
            "ty": 2,
            "nm": "snow_00010.png",
            "refId": "a15b4c75da987fdac06857662dad28e0",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 10,
            "op": 12
        },
        {
            "ind": 7,
            "ty": 2,
            "nm": "snow_00011.png",
            "refId": "66ae34bb9f3c90590a85caa758ba3733",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 12,
            "op": 14
        },
        {
            "ind": 8,
            "ty": 2,
            "nm": "snow_00013.png",
            "refId": "dc6dbbc6484ea70eaf541c88dd192f5d",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 14,
            "op": 16
        },
        {
            "ind": 9,
            "ty": 2,
            "nm": "snow_00015.png",
            "refId": "208645e157f757946896b8cb4d181464",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 16,
            "op": 18
        },
        {
            "ind": 10,
            "ty": 2,
            "nm": "snow_00017.png",
            "refId": "a5be43e52e4eff7bf6505ee18468bdc7",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 18,
            "op": 20
        },
        {
            "ind": 11,
            "ty": 2,
            "nm": "snow_00019.png",
            "refId": "4c484b252217ecf249439245271742d4",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 20,
            "op": 22
        },
        {
            "ind": 12,
            "ty": 2,
            "nm": "snow_00021.png",
            "refId": "ebf60357fb6c8051026ce17c22ac239a",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 22,
            "op": 24
        },
        {
            "ind": 13,
            "ty": 2,
            "nm": "snow_00022.png",
            "refId": "793a6898a3f4a7bd50c23ee0ae08d43a",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 24,
            "op": 26
        },
        {
            "ind": 14,
            "ty": 2,
            "nm": "snow_00024.png",
            "refId": "65ec5b1c3d96dc171dec7e04d0a4fd2a",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 26,
            "op": 28
        },
        {
            "ind": 15,
            "ty": 2,
            "nm": "snow_00026.png",
            "refId": "48cf05c2d8c9d789b6d57e86833f593a",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 28,
            "op": 30
        },
        {
            "ind": 16,
            "ty": 2,
            "nm": "snow_00028.png",
            "refId": "e10b8855440fab51f658075c94bc2419",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 30,
            "op": 32
        },
        {
            "ind": 17,
            "ty": 2,
            "nm": "snow_00030.png",
            "refId": "845fcf6c9a22cdf4fad0ea8a9bfba230",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 32,
            "op": 34
        },
        {
            "ind": 18,
            "ty": 2,
            "nm": "snow_00032.png",
            "refId": "ac69d7230079802e223fc9cc1355945c",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 34,
            "op": 36
        },
        {
            "ind": 19,
            "ty": 2,
            "nm": "snow_00033.png",
            "refId": "085fe94b8f8a9b1eb32c3931bb4ff0ec",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 36,
            "op": 38
        },
        {
            "ind": 20,
            "ty": 2,
            "nm": "snow_00035.png",
            "refId": "cf7a396caaff8d70d63ef52392c04436",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 38,
            "op": 40
        },
        {
            "ind": 21,
            "ty": 2,
            "nm": "snow_00037.png",
            "refId": "8c8a04951c4c1c3a3196c07f1d5bcd9c",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 40,
            "op": 42
        },
        {
            "ind": 22,
            "ty": 2,
            "nm": "snow_00039.png",
            "refId": "6022f3ad3b734f9dee43285d67a03438",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 42,
            "op": 44
        },
        {
            "ind": 23,
            "ty": 2,
            "nm": "snow_00041.png",
            "refId": "62dd234c6ed46a272d65e66791040aef",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 44,
            "op": 46
        },
        {
            "ind": 24,
            "ty": 2,
            "nm": "snow_00043.png",
            "refId": "25f973924e5a61cf6cf03bc766f99347",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 46,
            "op": 48
        },
        {
            "ind": 25,
            "ty": 2,
            "nm": "snow_00044.png",
            "refId": "6b035aaf773a0db0a603b792554cc173",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 48,
            "op": 50
        },
        {
            "ind": 26,
            "ty": 2,
            "nm": "snow_00046.png",
            "refId": "177e173b59be1daff16e34f483cc089d",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 50,
            "op": 52
        },
        {
            "ind": 27,
            "ty": 2,
            "nm": "snow_00048.png",
            "refId": "eb0c4428630226b4acf1beac273792d9",
            "ks": {
                "o": {
                    "k": 100
                },
                "r": {
                    "k": 0
                },
                "p": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "a": {
                    "k": [
                        375,
                        812,
                        0
                    ]
                },
                "s": {
                    "k": [
                        100,
                        100,
                        100
                    ]
                }
            },
            "ip": 52,
            "op": 54
        }
    ],
    "markers": []
};


/***/ }),

/***/ "./src/panels/AssistPanel.ts":
/*!***********************************!*\
  !*** ./src/panels/AssistPanel.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssistPanel = void 0;
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var UI_1 = __importDefault(__webpack_require__(/*! ../UI */ "./src/UI.ts"));
var Tween = FYGE.Tween;
var AssistPanel = (function (_super) {
    __extends(AssistPanel, _super);
    function AssistPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(AssistPanel.prototype, "groupNames", {
        get: function () {
            return ["assist"];
        },
        enumerable: false,
        configurable: true
    });
    ;
    AssistPanel.prototype.initUi = function () {
        var bg = UI_1.default.Sp(this, "活动邀请.png", (750 - 616) / 2, (1624 - 766) / 2);
        this.assistBtn = UI_1.default.Btn(bg, "按钮-接受邀请.png", this.onClickBtn, this, (616 - 530) / 2, 450);
    };
    AssistPanel.prototype.onClickBtn = function () {
        var _a = this.data.cb, cb = _a === void 0 ? null : _a;
        cb && cb();
        this.hidePanel();
    };
    AssistPanel.prototype.showAni = function () {
        var _this = this;
        if (this.isShowing)
            return;
        this.isShowing = true;
        this.alpha = 0;
        Tween.get(this)
            .set({ alpha: 1, scaleX: 0, scaleY: 0, anchorX: 0.5 * 750, anchorY: 0.5 * 1624 })
            .to({ alpha: 1, scaleX: 1, scaleY: 1 }, 500, FYGE.Ease.quartOut)
            .call(function () {
            _this.isShowing = false;
        });
    };
    AssistPanel.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    return AssistPanel;
}(Panel_1.Panel));
exports.AssistPanel = AssistPanel;


/***/ }),

/***/ "./src/panels/ChooseTeam.ts":
/*!**********************************!*\
  !*** ./src/panels/ChooseTeam.ts ***!
  \**********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChooseTeam = void 0;
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../TaoBaoNet */ "./src/TaoBaoNet.ts");
var UI_1 = __importDefault(__webpack_require__(/*! ../UI */ "./src/UI.ts"));
var MouseEvent = FYGE.MouseEvent;
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var ChooseTeam = (function (_super) {
    __extends(ChooseTeam, _super);
    function ChooseTeam() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.choose = null;
        return _this;
    }
    Object.defineProperty(ChooseTeam.prototype, "groupNames", {
        get: function () {
            return ["ct"];
        },
        enumerable: false,
        configurable: true
    });
    ;
    ChooseTeam.prototype.showAni = function () {
        var _this = this;
        if (this.isShowing)
            return;
        this.isShowing = true;
        this.alpha = 0;
        Tween.get(this)
            .to({ alpha: 1 }, 500, FYGE.Ease.quartOut)
            .call(function () {
            _this.isShowing = false;
        });
    };
    ChooseTeam.prototype.initUi = function () {
        this.blueEn = RES_1.RES.getRes("ct_蓝色en.png");
        this.blueDis = RES_1.RES.getRes("ct_蓝色dis.png");
        this.redEn = RES_1.RES.getRes("ct_红色en.png");
        this.redDis = RES_1.RES.getRes("ct_红色dis.png");
        var title = UI_1.default.Sp(this, "ct文案.png", 129, 377);
        title.alpha = 0;
        title.y = 277;
        var blue = this.blue = UI_1.default.Ctn(this, -1624);
        UI_1.default.Sp(blue, "ct蓝.png", 0, 547);
        var red = this.red = UI_1.default.Ctn(this, 1624);
        UI_1.default.Sp(red, "ct红.png", 264, 547);
        this.blueTeam = UI_1.default.Sp(blue, "ct_蓝色dis.png", 119, 938);
        this.redTeam = UI_1.default.Sp(red, "ct_红色dis.png", 535, 938);
        this.blueTeam.addEventListener(MouseEvent.CLICK, this.chooseTeam, this);
        this.redTeam.addEventListener(MouseEvent.CLICK, this.chooseTeam, this);
        var okBtn = this.okBtn = UI_1.default.Btn(this, "ct按钮.png", this.clickOk, this, 111, 1300);
        okBtn.visible = false;
        okBtn.alpha = 0;
        var light = this.light = UI_1.default.Sp(this, "ct光.png", 0, 526);
        light.mouseChildren = light.mouseEnable = false;
        light.visible = false;
        Tween.get(this)
            .wait(100)
            .call(function () {
            Tween.get(blue)
                .to({ x: 0 }, 500, Ease.quadOut);
            Tween.get(red)
                .to({ x: 0 }, 500, Ease.quadOut)
                .call(function () {
                light.visible = true;
                light.alpha = 0;
                Tween.get(light, { loop: true })
                    .to({ alpha: 1 }, 1000, Ease.quadInOut)
                    .to({ alpha: 0 }, 1000, Ease.quadInOut);
                Tween.get(title)
                    .to({ alpha: 1, y: 377 }, 600, Ease.quadInOut);
            });
        });
    };
    ChooseTeam.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        Tween.removeTweens(this);
        Tween.removeTweens(this.okBtn);
        Tween.removeTweens(this.red);
        Tween.removeTweens(this.blue);
        Tween.removeTweens(this.light);
    };
    ChooseTeam.prototype.chooseTeam = function (e) {
        if (!this.choose) {
            Tween.get(this.okBtn)
                .set({ visible: true })
                .to({ alpha: 1 }, 500);
        }
        this.choose = (e.target == this.blueTeam) ? 1 : 2;
        this.blueTeam.texture = this.choose == 1 ? this.blueEn : this.blueDis;
        this.redTeam.texture = this.choose == 2 ? this.redEn : this.redDis;
    };
    ChooseTeam.prototype.clickOk = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.btnDelay(this.okBtn);
                        if (!this.choose)
                            return [2, ctrls_1.showToast("请先选择队伍")];
                        return [4, TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.chooseTeam, { type: this.choose })];
                    case 1:
                        _a.sent();
                        this.data.updateIndex && this.data.updateIndex();
                        this.hidePanel();
                        return [2];
                }
            });
        });
    };
    return ChooseTeam;
}(Panel_1.Panel));
exports.ChooseTeam = ChooseTeam;


/***/ }),

/***/ "./src/panels/GameGuide.ts":
/*!*********************************!*\
  !*** ./src/panels/GameGuide.ts ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GameGuide = void 0;
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var UI_1 = __importDefault(__webpack_require__(/*! ../UI */ "./src/UI.ts"));
var MouseEvent = FYGE.MouseEvent;
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var GameGuide = (function (_super) {
    __extends(GameGuide, _super);
    function GameGuide() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.itemIndex = 0;
        _this.downX = 0;
        _this.active = false;
        _this.mouseDown = function (e) {
            _this.downX = e.localX;
            _this.active = false;
        };
        _this.mouseMove = function (e) {
            var localX = e.localX;
            var dx = localX - _this.downX;
            if (Math.abs(dx) > 50 && !_this.active) {
                if (dx < 0) {
                    _this.changeItem(_this.itemIndex + 1);
                }
                else {
                    _this.changeItem(_this.itemIndex - 1);
                }
                _this.active = true;
            }
        };
        return _this;
    }
    Object.defineProperty(GameGuide.prototype, "groupNames", {
        get: function () {
            return ["GuidePanel"];
        },
        enumerable: false,
        configurable: true
    });
    ;
    GameGuide.prototype.showAni = function () {
        var _this = this;
        if (this.isShowing)
            return;
        this.isShowing = true;
        this.alpha = 0;
        Tween.get(this)
            .to({ alpha: 1 }, 500, FYGE.Ease.quartOut)
            .call(function () {
            _this.isShowing = false;
        });
    };
    GameGuide.prototype.initUi = function () {
        for (var i = 0; i < 5; i++) {
            this["guide" + i] = UI_1.default.Sp(this, "guide" + i + ".png", 143 + 1624 * i, 355);
            this["point" + i] = UI_1.default.Sp(this, "guidePoint.png", 246 + 60 * i, 1263);
        }
        this.point1.alpha = this.point2.alpha = this.point3.alpha = this.point4.alpha = 0.4;
        UI_1.default.Btn(this, "guideBtn.png", this.hidePanel, this, 103, 1296);
        this.stage.addEventListener(MouseEvent.MOUSE_DOWN, this.mouseDown);
        this.stage.addEventListener(MouseEvent.MOUSE_MOVE, this.mouseMove);
    };
    GameGuide.prototype.changeItem = function (index, ani) {
        if (ani === void 0) { ani = true; }
        if (index < 0 || index > 4)
            return;
        this.itemIndex = index;
        var duration = ani ? 600 : 0;
        for (var i = 0; i < 5; i++) {
            Tween.get(this["guide" + i], {}, null, true)
                .to({ x: 143 + 1624 * (i - index) }, duration, Ease.quadInOut);
            this["point" + i].alpha = (index == i) ? 1 : 0.4;
        }
    };
    GameGuide.prototype.destroy = function () {
        this.stage.removeEventListener(MouseEvent.MOUSE_DOWN, this.mouseDown);
        this.stage.removeEventListener(MouseEvent.MOUSE_MOVE, this.mouseMove);
        _super.prototype.destroy.call(this);
    };
    return GameGuide;
}(Panel_1.Panel));
exports.GameGuide = GameGuide;


/***/ }),

/***/ "./src/panels/Invitepanel.ts":
/*!***********************************!*\
  !*** ./src/panels/Invitepanel.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvitePanel = void 0;
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var UI_1 = __importDefault(__webpack_require__(/*! ../UI */ "./src/UI.ts"));
var RichText_1 = __webpack_require__(/*! ./RichText */ "./src/panels/RichText.ts");
var Tween = FYGE.Tween;
var InvitePanel = (function (_super) {
    __extends(InvitePanel, _super);
    function InvitePanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(InvitePanel.prototype, "groupNames", {
        get: function () {
            return ["invite"];
        },
        enumerable: false,
        configurable: true
    });
    ;
    InvitePanel.prototype.initUi = function () {
        var _a = this.data, _b = _a.inviteCount, inviteCount = _b === void 0 ? 0 : _b, _c = _a.pkCount, pkCount = _c === void 0 ? 0 : _c;
        var bg = UI_1.default.Sp(this, "次数不足.png", (750 - 616) / 2, (1624 - 766) / 2);
        var desc = bg.addChild(new RichText_1.RichText());
        desc.text = [
            { text: "成功邀请", style: { color: "#34455d", size: 36 } },
            { text: inviteCount + "\n", style: { color: "#d92d36", size: 40 } },
            { text: "位好友", style: { color: "#34455d", size: 36 } },
        ];
        desc.textAlign = FYGE.TEXT_ALIGN.CENTER;
        desc.position.set(580 / 2, 238);
        var title = bg.addChild(new RichText_1.RichText());
        title.text = [
            { text: "获得", style: { color: "#34455d", size: 38 } },
            { text: pkCount + "\n", style: { color: "#d92d36", size: 44 } },
            { text: "次PK次数", style: { color: "#34455d", size: 38 } },
        ];
        title.textAlign = FYGE.TEXT_ALIGN.CENTER;
        title.position.set(575 / 2, 330);
        this.assistBtn = UI_1.default.Btn(bg, "我知道了.png", this.onClickBtn, this, (616 - 540) / 2, 450);
    };
    InvitePanel.prototype.onClickBtn = function () {
        var _a = this.data.cb, cb = _a === void 0 ? null : _a;
        cb && cb();
        this.hidePanel();
    };
    InvitePanel.prototype.showAni = function () {
        var _this = this;
        if (this.isShowing)
            return;
        this.isShowing = true;
        this.alpha = 0;
        Tween.get(this)
            .set({ alpha: 1, scaleX: 0, scaleY: 0, anchorX: 0.5 * 750, anchorY: 0.5 * 1624 })
            .to({ alpha: 1, scaleX: 1, scaleY: 1 }, 500, FYGE.Ease.quartOut)
            .call(function () {
            _this.isShowing = false;
        });
    };
    InvitePanel.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
    };
    return InvitePanel;
}(Panel_1.Panel));
exports.InvitePanel = InvitePanel;


/***/ }),

/***/ "./src/panels/LoserPanel.ts":
/*!**********************************!*\
  !*** ./src/panels/LoserPanel.ts ***!
  \**********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoserPanel = void 0;
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var UI_1 = __importDefault(__webpack_require__(/*! ../UI */ "./src/UI.ts"));
var LoserPanel = (function (_super) {
    __extends(LoserPanel, _super);
    function LoserPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(LoserPanel.prototype, "groupNames", {
        get: function () {
            return ["LoserPanel"];
        },
        enumerable: false,
        configurable: true
    });
    ;
    LoserPanel.prototype.initUi = function () {
        UI_1.default.Sp(this, "loserBg.png", 74, 422);
        UI_1.default.Btn(this, "loserBtn.png", this.hidePanel, this, 103, 876);
    };
    return LoserPanel;
}(Panel_1.Panel));
exports.LoserPanel = LoserPanel;


/***/ }),

/***/ "./src/panels/NoTime.ts":
/*!******************************!*\
  !*** ./src/panels/NoTime.ts ***!
  \******************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NoTime = void 0;
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var TbFunc_1 = __importDefault(__webpack_require__(/*! ../TbFunc */ "./src/TbFunc.ts"));
var UI_1 = __importDefault(__webpack_require__(/*! ../UI */ "./src/UI.ts"));
var NoTime = (function (_super) {
    __extends(NoTime, _super);
    function NoTime() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(NoTime.prototype, "groupNames", {
        get: function () {
            return ["NoTime"];
        },
        enumerable: false,
        configurable: true
    });
    ;
    NoTime.prototype.initUi = function () {
        UI_1.default.Sp(this, "noTimeBg.png", 74, 422);
        this.okBtn = UI_1.default.Btn(this, "noTimeBtn.png", this.clickBtn, this, 103, 876);
    };
    NoTime.prototype.clickBtn = function () {
        TbFunc_1.default.showTask();
        this.hidePanel();
    };
    return NoTime;
}(Panel_1.Panel));
exports.NoTime = NoTime;


/***/ }),

/***/ "./src/panels/RichText.ts":
/*!********************************!*\
  !*** ./src/panels/RichText.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.RichText = void 0;
var RichText = (function (_super) {
    __extends(RichText, _super);
    function RichText(text) {
        var _this = _super.call(this) || this;
        _this._textAlign = FYGE.TEXT_ALIGN.CENTER;
        _this._verticalAlign = FYGE.VERTICAL_ALIGN.MIDDLE;
        _this._gap = 0;
        if (text)
            _this.text = text;
        return _this;
    }
    Object.defineProperty(RichText.prototype, "textAlign", {
        get: function () {
            return this._textAlign;
        },
        set: function (value) {
            if (this._textAlign !== value) {
                this._textAlign = value;
                this.adaptate();
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(RichText.prototype, "verticalAlign", {
        get: function () {
            return this._verticalAlign;
        },
        set: function (value) {
            if (this._verticalAlign !== value) {
                this._verticalAlign = value;
                this.adaptate();
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(RichText.prototype, "gap", {
        get: function () {
            return this._gap;
        },
        set: function (value) {
            if (this._gap != value) {
                this._gap = value;
                this.adaptate();
            }
        },
        enumerable: false,
        configurable: true
    });
    ;
    ;
    Object.defineProperty(RichText.prototype, "text", {
        get: function () {
            return this._text;
        },
        set: function (value) {
            this._text = value;
            var arr = value || [];
            for (var i = 0; i < arr.length; i++) {
                var a = arr[i];
                var c = this.children[i] || this.addChild(RichText.cache.shift() || new FYGE.TextField());
                c.text = a.text;
                c.fillColor = a.style.color;
                c.size = a.style.size;
            }
            if (this.children.length > arr.length) {
                for (var i = this.children.length - 1; i >= arr.length; i--) {
                    var c = this.children[i];
                    this.removeChild(c);
                    RichText.cache.push(c);
                }
            }
            this.adaptate();
        },
        enumerable: false,
        configurable: true
    });
    RichText.prototype.adaptate = function () {
        if (!this.children.length)
            return;
        var len = this.children.length;
        var sum = 0;
        for (var m = 0; m < len; m++) {
            sum += this.children[m].textWidth;
        }
        sum += (len - 1) * this._gap;
        var left;
        if (this._textAlign == FYGE.TEXT_ALIGN.LEFT) {
            left = 0;
        }
        else if (this._textAlign == FYGE.TEXT_ALIGN.RIGHT) {
            left = -sum;
        }
        else {
            left = -sum / 2;
        }
        var temSum = 0;
        for (var i = 0; i < this.children.length; i++) {
            this.children[i].x = left + temSum;
            temSum += this.children[i].textWidth + this._gap;
        }
        var up;
        if (this._verticalAlign == FYGE.VERTICAL_ALIGN.UP) {
            up = 0;
        }
        else if (this._verticalAlign == FYGE.VERTICAL_ALIGN.DOWN) {
            up = -1;
        }
        else {
            up = -1 / 2;
        }
        for (var i = 0; i < this.children.length; i++) {
            this.children[i].y = this.children[i].textHeight * up;
        }
    };
    RichText.cache = [];
    return RichText;
}(FYGE.Container));
exports.RichText = RichText;


/***/ }),

/***/ "./src/panels/WinnerPanel.ts":
/*!***********************************!*\
  !*** ./src/panels/WinnerPanel.ts ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WinnerPanel = void 0;
var Panel_1 = __webpack_require__(/*! ../../module/views/Panel */ "./module/views/Panel.ts");
var UI_1 = __importDefault(__webpack_require__(/*! ../UI */ "./src/UI.ts"));
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var WinnerPanel = (function (_super) {
    __extends(WinnerPanel, _super);
    function WinnerPanel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(WinnerPanel.prototype, "groupNames", {
        get: function () {
            return ["WinnerPanel"];
        },
        enumerable: false,
        configurable: true
    });
    ;
    WinnerPanel.prototype.initUi = function () {
        var _a = this.data, team = _a.team, value = _a.value;
        team == 1 ? UI_1.default.Sp(this, "winner蓝.png", 0, 11) :
            UI_1.default.Sp(this, "winner红.png", 17, 11);
        UI_1.default.Btn(this, "winnerBtn.png", this.hidePanel, this, 103, 876);
        var txt1 = UI_1.default.Txt(this, "获得\t", 40, "#000000", TEXT_ALIGN.CENTER);
        var txt3 = UI_1.default.Txt(this, "\t优雅值", 40, "#000000", TEXT_ALIGN.CENTER);
        var txt2 = UI_1.default.Txt(this, value + "", 40, team == 1 ? "#063d8d" : "#dd1039", TEXT_ALIGN.CENTER);
        var twHalf = txt2.textWidth / 2;
        txt2.position.set(375 - twHalf, 791);
        txt1.position.set(txt2.x - txt1.textWidth, 791);
        txt3.position.set(txt2.x + txt2.textWidth, 791);
    };
    return WinnerPanel;
}(Panel_1.Panel));
exports.WinnerPanel = WinnerPanel;


/***/ }),

/***/ "./src/scenes/GameScene/AI.ts":
/*!************************************!*\
  !*** ./src/scenes/GameScene/AI.ts ***!
  \************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AI = void 0;
var Container = FYGE.Container;
var matter_js_1 = __webpack_require__(/*! matter-js */ "./node_modules/matter-js/build/matter.js");
var Tools_1 = __webpack_require__(/*! ../../Tools */ "./src/Tools.ts");
var UI_1 = __importDefault(__webpack_require__(/*! ../../UI */ "./src/UI.ts"));
var GameConfig_1 = __webpack_require__(/*! ./GameConfig */ "./src/scenes/GameScene/GameConfig.ts");
var AI = (function (_super) {
    __extends(AI, _super);
    function AI(ball) {
        var _this = _super.call(this) || this;
        _this.ball = ball;
        _this._isRunning = true;
        _this.init();
        return _this;
    }
    AI.prototype.setBodyPos = function (x, y) {
        matter_js_1.Body.setPosition(this.body, { x: x, y: y });
        return this;
    };
    Object.defineProperty(AI.prototype, "isRunning", {
        get: function () {
            return this._isRunning;
        },
        set: function (isRunning) {
            this._isRunning = isRunning;
        },
        enumerable: false,
        configurable: true
    });
    AI.prototype.init = function () {
        var sp = UI_1.default.Sp(this, "推手.png");
        sp.anchorTexture.set(0.485, 0.465);
        this.body = matter_js_1.Bodies.circle(this.x, this.y, (sp.width / 2) - 8, {
            label: GameConfig_1.BodyLabel.AI,
            restitution: 0.5,
            friction: 0,
            frictionStatic: 0,
            collisionFilter: { category: 5, mask: 5 },
        });
        this.body.target = this;
    };
    AI.prototype.update = function () {
        _super.prototype.update.call(this);
        var _a = this.body.position, x = _a.x, y = _a.y;
        this.position.set(x, y);
        this.rotation = this.body.angle;
        if (this.isRunning) {
            if (this.ball.y < 812) {
                this.body.frictionAir = 0.01;
                var dx = this.ball.x - this.x;
                var dy = this.ball.y - this.y;
                dx = Tools_1.numLimit(dx, -GameConfig_1.aiVelocityLimit, GameConfig_1.aiVelocityLimit);
                dy = Tools_1.numLimit(dy, -GameConfig_1.aiVelocityLimit, GameConfig_1.aiVelocityLimit);
                var dir = matter_js_1.Vector.create(dx, dy);
                var dirNormal = matter_js_1.Vector.normalise(dir);
                matter_js_1.Body.setVelocity(this.body, dir);
            }
            else {
                this.body.frictionAir = 0.05;
            }
        }
    };
    return AI;
}(Container));
exports.AI = AI;


/***/ }),

/***/ "./src/scenes/GameScene/Ball.ts":
/*!**************************************!*\
  !*** ./src/scenes/GameScene/Ball.ts ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ball = void 0;
var Container = FYGE.Container;
var matter_js_1 = __webpack_require__(/*! matter-js */ "./node_modules/matter-js/build/matter.js");
var UI_1 = __importDefault(__webpack_require__(/*! ../../UI */ "./src/UI.ts"));
var GameConfig_1 = __webpack_require__(/*! ./GameConfig */ "./src/scenes/GameScene/GameConfig.ts");
var RAD_TO_DEG = FYGE.RAD_TO_DEG;
var Ball = (function (_super) {
    __extends(Ball, _super);
    function Ball() {
        var _this = _super.call(this) || this;
        _this._right = null;
        _this.init();
        return _this;
    }
    Object.defineProperty(Ball.prototype, "right", {
        get: function () {
            return this._right;
        },
        set: function (right) {
            this._right = right;
        },
        enumerable: false,
        configurable: true
    });
    Ball.prototype.setBodyPos = function (x, y) {
        matter_js_1.Body.setPosition(this.body, { x: x, y: y });
        return this;
    };
    Ball.prototype.init = function () {
        var sp = UI_1.default.Sp(this, "红球.png");
        sp.anchorTexture.set(0.5, 0.5);
        this.body = matter_js_1.Bodies.circle(this.x, this.y, (sp.width / 2) - 5, {
            label: GameConfig_1.BodyLabel.Ball,
            restitution: 0.5,
            friction: 0,
            frictionStatic: 0,
            collisionFilter: { category: 1, mask: 1 },
        });
        this.body.target = this;
    };
    Ball.prototype.onMouseMove = function (e) {
        this.setBodyPos(e.localX, e.localY);
    };
    Ball.prototype.update = function () {
        _super.prototype.update.call(this);
        var _a = this.body.position, x = _a.x, y = _a.y;
        this.position.set(x, y);
        this.rotation = this.body.angle * RAD_TO_DEG;
    };
    return Ball;
}(Container));
exports.Ball = Ball;


/***/ }),

/***/ "./src/scenes/GameScene/CountDown.ts":
/*!*******************************************!*\
  !*** ./src/scenes/GameScene/CountDown.ts ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CountDown = void 0;
var Container = FYGE.Container;
var RES_1 = __webpack_require__(/*! ../../../module/RES */ "./module/RES.ts");
var Tools_1 = __webpack_require__(/*! ../../Tools */ "./src/Tools.ts");
var UI_1 = __importDefault(__webpack_require__(/*! ../../UI */ "./src/UI.ts"));
var BitmapText = FYGE.BitmapText;
var Tween = FYGE.Tween;
var CountDown = (function (_super) {
    __extends(CountDown, _super);
    function CountDown() {
        var _this = _super.call(this) || this;
        _this.time = 2000;
        _this.init();
        return _this;
    }
    CountDown.prototype.init = function () {
        var bg = UI_1.default.Sp(this, "timeBg.png");
        bg.anchorTexture.set(0.5, 0.5);
        var texture = Tools_1.Tools.getNumTextures("time_");
        texture[":"] = RES_1.RES.getRes("time_f.png");
        this.label = this.addChild(new BitmapText(texture));
        this.label.text = "02:00";
        this.label.position.set(12, -8);
        this.label.gap = 3;
    };
    CountDown.prototype.start = function (time, call) {
        var _this = this;
        time += 500;
        this.timer && Tween.removeTweens(this.timer);
        this.timer = Tween.get(this, {
            onChange: function () {
                var min = _this.time / 60000 >> 0;
                var sec = (_this.time - min * 60000) / 1000 >> 0;
                _this.label.text = Tools_1.prefixInteger(min, 2) + ":" + Tools_1.prefixInteger(sec, 2);
            }
        })
            .set({ time: time })
            .to({ time: 500 }, time)
            .call(function () { return call(); });
    };
    CountDown.prototype.stop = function () {
        this.timer && Tween.pauseTweens(this.timer);
    };
    return CountDown;
}(Container));
exports.CountDown = CountDown;


/***/ }),

/***/ "./src/scenes/GameScene/GameConfig.ts":
/*!********************************************!*\
  !*** ./src/scenes/GameScene/GameConfig.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.aiVelocityLimit = exports.playerVelocityLimit = exports.ballDy = exports.initDy = exports.BodyLabel = exports.edgeOption = void 0;
exports.edgeOption = {
    isStatic: true,
    isSleeping: true,
    restitution: 0.5,
    friction: 0,
    frictionStatic: 0,
};
var BodyLabel;
(function (BodyLabel) {
    BodyLabel["Player"] = "Player";
    BodyLabel["Goal"] = "Goal";
    BodyLabel["Ball"] = "Ball";
    BodyLabel["AI"] = "AI";
})(BodyLabel = exports.BodyLabel || (exports.BodyLabel = {}));
exports.initDy = 200;
exports.ballDy = 200;
exports.playerVelocityLimit = 250;
exports.aiVelocityLimit = 20;


/***/ }),

/***/ "./src/scenes/GameScene/GameScene.ts":
/*!*******************************************!*\
  !*** ./src/scenes/GameScene/GameScene.ts ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var matter_js_1 = __webpack_require__(/*! matter-js */ "./node_modules/matter-js/build/matter.js");
var ctrls_1 = __webpack_require__(/*! ../../../module/ctrls */ "./module/ctrls/index.ts");
var layers_1 = __webpack_require__(/*! ../../../module/views/layers */ "./module/views/layers.ts");
var Scene_1 = __webpack_require__(/*! ../../../module/views/Scene */ "./module/views/Scene.ts");
var Clock_1 = __importDefault(__webpack_require__(/*! ../../Clock */ "./src/Clock.ts"));
var TaoBaoNet_1 = __webpack_require__(/*! ../../TaoBaoNet */ "./src/TaoBaoNet.ts");
var Tools_1 = __webpack_require__(/*! ../../Tools */ "./src/Tools.ts");
var UI_1 = __importDefault(__webpack_require__(/*! ../../UI */ "./src/UI.ts"));
var IndexScene_1 = __importDefault(__webpack_require__(/*! ../IndexScene */ "./src/scenes/IndexScene.ts"));
var OverScene_1 = __importDefault(__webpack_require__(/*! ../OverScene */ "./src/scenes/OverScene.ts"));
var AI_1 = __webpack_require__(/*! ./AI */ "./src/scenes/GameScene/AI.ts");
var Ball_1 = __webpack_require__(/*! ./Ball */ "./src/scenes/GameScene/Ball.ts");
var CountDown_1 = __webpack_require__(/*! ./CountDown */ "./src/scenes/GameScene/CountDown.ts");
var GameConfig_1 = __webpack_require__(/*! ./GameConfig */ "./src/scenes/GameScene/GameConfig.ts");
var Goal_1 = __webpack_require__(/*! ./Goal */ "./src/scenes/GameScene/Goal.ts");
var Player_1 = __webpack_require__(/*! ./Player */ "./src/scenes/GameScene/Player.ts");
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var Tween = FYGE.Tween;
var GameScene = (function (_super) {
    __extends(GameScene, _super);
    function GameScene() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.clock = new Clock_1.default();
        _this._playerScore = 0;
        _this._aiScore = 0;
        _this.over = function () { return __awaiter(_this, void 0, void 0, function () {
            var _a, success, data;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        console.log("倒计时结束", this.data.id, this.playerScore, this.aiScore);
                        matter_js_1.Events.off(this.engine, "collisionStart", this.onCollisionStart);
                        this.isResending = true;
                        this.ai.isRunning = false;
                        return [4, Tools_1.sleep(1000)];
                    case 1:
                        _b.sent();
                        return [4, TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.submitGame, {
                                id: this.data.id,
                                score: this.playerScore,
                                robotScore: this.aiScore,
                            })];
                    case 2:
                        _a = _b.sent(), success = _a.success, data = _a.data;
                        if (success) {
                            Tools_1.Tools.myActivityInfo.gameTimes = data.gameTimes;
                            ctrls_1.changeScene(OverScene_1.default, {
                                robotScore: this.aiScore,
                                score: this.playerScore,
                                robotNick: this.data.robot.userNick,
                                robotAvatar: this.data.robot.avatar,
                            });
                            return [2];
                        }
                        ctrls_1.changeScene(IndexScene_1.default);
                        return [2];
                }
            });
        }); };
        _this.isResending = false;
        _this.onCollisionStart = function (e) {
            var _a, _b;
            var pairs = e.pairs;
            for (var i = 0; i < pairs.length; i++) {
                var pair = pairs[i];
                var _c = pair.bodyA, targetA = _c.target, labelA = _c.label;
                var _d = pair.bodyB, targetB = _d.target, labelB = _d.label;
                if (labelB === GameConfig_1.BodyLabel.Ball) {
                    _a = [labelA, labelB], labelB = _a[0], labelA = _a[1];
                    _b = [targetA, targetB], targetB = _b[0], targetA = _b[1];
                }
                if (labelA === GameConfig_1.BodyLabel.Ball) {
                    switch (labelB) {
                        case GameConfig_1.BodyLabel.Player:
                            _this.ball.right = GameConfig_1.BodyLabel.Player;
                            break;
                        case GameConfig_1.BodyLabel.AI:
                            _this.ball.right = GameConfig_1.BodyLabel.AI;
                            break;
                        case GameConfig_1.BodyLabel.Goal:
                            if (targetB.goalType === GameConfig_1.BodyLabel.AI
                                && _this.ball.right === GameConfig_1.BodyLabel.Player) {
                                console.log("玩家进球");
                                _this.playerScore++;
                                _this.beforeResend(GameConfig_1.BodyLabel.AI);
                            }
                            else if (targetB.goalType === GameConfig_1.BodyLabel.Player
                                && _this.ball.right === GameConfig_1.BodyLabel.AI) {
                                console.log("AI进球");
                                _this.aiScore++;
                                _this.beforeResend(GameConfig_1.BodyLabel.Player);
                            }
                            break;
                    }
                }
            }
        };
        return _this;
    }
    Object.defineProperty(GameScene.prototype, "groupNames", {
        get: function () {
            return ["GameScene"];
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(GameScene.prototype, "playerScore", {
        get: function () {
            return this._playerScore;
        },
        set: function (playerScore) {
            this._playerScore = playerScore;
            this.scorePlayer.text = playerScore + "";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(GameScene.prototype, "aiScore", {
        get: function () {
            return this._aiScore;
        },
        set: function (aiScore) {
            this._aiScore = aiScore;
            this.scoreAI.text = aiScore + "";
        },
        enumerable: false,
        configurable: true
    });
    GameScene.prototype.initUi = function () {
        return __awaiter(this, void 0, void 0, function () {
            var texture;
            return __generator(this, function (_a) {
                UI_1.default.Sp(this, "gameBg.jpg");
                this.world = this.createPhyWorld();
                this.initPhyScene();
                texture = Tools_1.Tools.getNumTextures("score_");
                this.scorePlayer = UI_1.default.BitTxt(this, texture);
                this.scorePlayer.text = "0";
                this.scorePlayer.rotation = 90;
                this.scorePlayer.position.set(695, 835);
                this.scorePlayer.textAlign = TEXT_ALIGN.LEFT;
                this.scoreAI = UI_1.default.BitTxt(this, texture);
                this.scoreAI.text = "0";
                this.scoreAI.rotation = 90;
                this.scoreAI.position.set(695, 790);
                this.scoreAI.textAlign = TEXT_ALIGN.RIGHT;
                this.countDown = this.addChild(new CountDown_1.CountDown());
                this.countDown.position.set(375, layers_1.layers.stageOffsetY + 100);
                this.countDown.start(1000 * 120, this.over);
                matter_js_1.Events.on(this.engine, "collisionStart", this.onCollisionStart);
                return [2];
            });
        });
    };
    GameScene.prototype.start = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                _super.prototype.start.call(this);
                return [2];
            });
        });
    };
    GameScene.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        matter_js_1.Events.off(this.engine, "collisionStart", this.onCollisionStart);
    };
    GameScene.prototype.reset = function () {
    };
    GameScene.prototype.resend = function (right) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.player.setBodyPos(375, 1624 - layers_1.layers.stageOffsetY - GameConfig_1.initDy);
                        this.ai.setBodyPos(375, layers_1.layers.stageOffsetY + GameConfig_1.initDy);
                        if (right === GameConfig_1.BodyLabel.Player) {
                            this.ball.setBodyPos(375, 1624 - layers_1.layers.stageOffsetY - GameConfig_1.initDy - GameConfig_1.ballDy);
                        }
                        else {
                            this.ball.setBodyPos(375, layers_1.layers.stageOffsetY + GameConfig_1.initDy + GameConfig_1.ballDy);
                        }
                        matter_js_1.Body.setVelocity(this.player.body, matter_js_1.Vector.create());
                        matter_js_1.Body.setVelocity(this.ai.body, matter_js_1.Vector.create());
                        matter_js_1.Body.setVelocity(this.ball.body, matter_js_1.Vector.create());
                        matter_js_1.Body.setAngularVelocity(this.player.body, 0);
                        matter_js_1.Body.setAngularVelocity(this.ai.body, 0);
                        matter_js_1.Body.setAngularVelocity(this.ball.body, 0);
                        return [4, Tools_1.sleep(500)];
                    case 1:
                        _a.sent();
                        this.isResending = false;
                        this.ai.isRunning = true;
                        return [2];
                }
            });
        });
    };
    GameScene.prototype.beforeResend = function (right) {
        var _this = this;
        this.isResending = true;
        this.ai.isRunning = false;
        var tw = Tween.get(this.ball);
        for (var i = 0; i < 5; i++) {
            tw.to({ alpha: 0.4 }, 250)
                .to({ alpha: 1 }, 250);
        }
        tw.call(function () { return _this.resend(right); });
    };
    GameScene.prototype.update = function () {
        var dt = this.clock.getDelta();
        if (!this.isResending) {
            matter_js_1.Runner.tick(this.runner, this.engine, dt);
        }
        _super.prototype.update.call(this);
    };
    GameScene.prototype.createPhyWorld = function () {
        this.engine = matter_js_1.Engine.create();
        var world = this.engine.world;
        this.engine.gravity.y = 0.0;
        this.runner = matter_js_1.Runner.create();
        return world;
    };
    GameScene.prototype.initPhyScene = function () {
        this.goalTop = this.addChild(new Goal_1.Goal(GameConfig_1.BodyLabel.AI))
            .setBodyPos(375, layers_1.layers.stageOffsetY - 130);
        this.goalBottom = this.addChild(new Goal_1.Goal(GameConfig_1.BodyLabel.Player))
            .setBodyPos(375, 1624 - layers_1.layers.stageOffsetY + 130);
        this.ball = this.addChild(new Ball_1.Ball());
        this.ball.position.set(375, 1624 - layers_1.layers.stageOffsetY - GameConfig_1.initDy);
        this.player = this.addChild(new Player_1.Player());
        this.ai = this.addChild(new AI_1.AI(this.ball));
        this.resend(GameConfig_1.BodyLabel.Player);
        var edge = this.setPhyWorldEdge();
        matter_js_1.World.add(this.world, __spreadArrays([
            this.player.body,
            this.ai.body,
            this.ball.body,
            this.goalTop.body,
            this.goalBottom.body
        ], edge));
    };
    GameScene.prototype.setPhyWorldEdge = function () {
        var edgeWeight = 1000;
        var halfEdgeWeight = edgeWeight / 2;
        var edgeW = 750 + edgeWeight;
        var edgeH = 1624 + edgeWeight;
        var playEdge = matter_js_1.Bodies.rectangle(375, 812 - halfEdgeWeight, edgeW, edgeWeight, __assign(__assign({}, GameConfig_1.edgeOption), { collisionFilter: { category: 2, mask: 2 } }));
        var AiEdge = matter_js_1.Bodies.rectangle(375, 812 + halfEdgeWeight, edgeW, edgeWeight, __assign(__assign({}, GameConfig_1.edgeOption), { collisionFilter: { category: 4, mask: 4 } }));
        var edges = [
            [375, layers_1.layers.stageOffsetY - halfEdgeWeight, edgeW, edgeWeight],
            [375, 1624 - layers_1.layers.stageOffsetY + halfEdgeWeight, edgeW, edgeWeight],
            [-halfEdgeWeight, 812, edgeWeight, edgeH],
            [750 + halfEdgeWeight, 812, edgeWeight, edgeH],
        ].map(function (v) {
            return matter_js_1.Bodies.rectangle(v[0], v[1], v[2], v[3], __assign(__assign({}, GameConfig_1.edgeOption), { collisionFilter: { group: -1 } }));
        });
        return __spreadArrays([playEdge, AiEdge], edges);
    };
    GameScene.prototype.setPhyDebug = function () {
        var canvas = document.createElement("canvas");
        canvas.style.width = "100%";
        canvas.style.height = "100%";
        var div = document.createElement("div");
        div.style.position = "absolute";
        div.style.top = "50%";
        div.style.pointerEvents = "none";
        div.style.transform = "translateY(-50%)";
        div.style.lineHeight = "0";
        div.style.fontStyle = "0";
        document.body.append(div);
        var render = matter_js_1.Render.create({
            canvas: canvas,
            element: div,
            engine: this.engine,
            options: {
                wireframes: true,
                width: 750,
                height: 1624,
                background: 'transparent',
                wireframeBackground: 'transparent',
                showSleeping: true,
            },
        });
        matter_js_1.Render.run(render);
    };
    return GameScene;
}(Scene_1.Scene));
exports.default = GameScene;


/***/ }),

/***/ "./src/scenes/GameScene/Goal.ts":
/*!**************************************!*\
  !*** ./src/scenes/GameScene/Goal.ts ***!
  \**************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Goal = void 0;
var Container = FYGE.Container;
var matter_js_1 = __webpack_require__(/*! matter-js */ "./node_modules/matter-js/build/matter.js");
var UI_1 = __importDefault(__webpack_require__(/*! ../../UI */ "./src/UI.ts"));
var GameConfig_1 = __webpack_require__(/*! ./GameConfig */ "./src/scenes/GameScene/GameConfig.ts");
var Goal = (function (_super) {
    __extends(Goal, _super);
    function Goal(_goalType) {
        var _this = _super.call(this) || this;
        _this._goalType = _goalType;
        _this.init();
        return _this;
    }
    Object.defineProperty(Goal.prototype, "goalType", {
        get: function () {
            return this._goalType;
        },
        enumerable: false,
        configurable: true
    });
    Goal.prototype.setBodyPos = function (x, y) {
        matter_js_1.Body.setPosition(this.body, { x: x, y: y });
        return this;
    };
    Goal.prototype.init = function () {
        var sp = UI_1.default.Sp(this, "goal_" + this.goalType + ".png");
        if (this.goalType === GameConfig_1.BodyLabel.AI) {
            sp.anchorTexture.set(0.5, 0);
            sp.y = 130;
        }
        else {
            sp.anchorTexture.set(0.5, 1);
            sp.y = -130;
        }
        this.body = matter_js_1.Bodies.circle(this.x, this.y, 230, {
            label: GameConfig_1.BodyLabel.Goal,
            isStatic: true,
            isSensor: true,
        });
        this.body.target = this;
    };
    Goal.prototype.update = function () {
        _super.prototype.update.call(this);
        var _a = this.body.position, x = _a.x, y = _a.y;
        this.position.set(x, y);
        this.rotation = this.body.angle;
    };
    return Goal;
}(Container));
exports.Goal = Goal;


/***/ }),

/***/ "./src/scenes/GameScene/Player.ts":
/*!****************************************!*\
  !*** ./src/scenes/GameScene/Player.ts ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Player = void 0;
var Container = FYGE.Container;
var matter_js_1 = __webpack_require__(/*! matter-js */ "./node_modules/matter-js/build/matter.js");
var Tools_1 = __webpack_require__(/*! ../../Tools */ "./src/Tools.ts");
var UI_1 = __importDefault(__webpack_require__(/*! ../../UI */ "./src/UI.ts"));
var GameConfig_1 = __webpack_require__(/*! ./GameConfig */ "./src/scenes/GameScene/GameConfig.ts");
var MouseEvent = FYGE.MouseEvent;
var Event = FYGE.Event;
var Player = (function (_super) {
    __extends(Player, _super);
    function Player() {
        var _this = _super.call(this) || this;
        _this.lp = matter_js_1.Vector.create();
        _this.init();
        return _this;
    }
    Player.prototype.setBodyPos = function (x, y) {
        matter_js_1.Body.setPosition(this.body, { x: x, y: y });
        return this;
    };
    Player.prototype.init = function () {
        var _this = this;
        var sp = UI_1.default.Sp(this, "推手.png");
        sp.anchorTexture.set(0.485, 0.465);
        this.body = matter_js_1.Bodies.circle(this.x, this.y, (sp.width / 2) - 8, {
            label: GameConfig_1.BodyLabel.Player,
            restitution: 0.5,
            friction: 0,
            frictionStatic: 0,
            collisionFilter: { category: 3, mask: 3 },
        });
        this.body.target = this;
        this.once(Event.ADDED_TO_STAGE, function () {
            _this.stage.addEventListener(MouseEvent.MOUSE_DOWN, _this.onMouseDown, _this);
        });
    };
    Player.prototype.destroy = function () {
        this.stage.removeEventListener(MouseEvent.MOUSE_DOWN, this.onMouseDown, this);
        _super.prototype.destroy.call(this);
    };
    Player.prototype.update = function () {
        _super.prototype.update.call(this);
        var _a = this.body.position, x = _a.x, y = _a.y;
        this.position.set(x, y);
        this.rotation = this.body.angle;
    };
    Player.prototype.onMouseDown = function (e) {
        var _this = this;
        this.lp.x = e.localX;
        this.lp.y = e.localY;
        this.stage.addEventListener(MouseEvent.MOUSE_MOVE, this.onMouseMove, this);
        this.stage.once(MouseEvent.MOUSE_UP, function () {
            _this.stage.removeEventListener(MouseEvent.MOUSE_MOVE, _this.onMouseMove, _this);
        });
    };
    Player.prototype.onMouseMove = function (e) {
        var localX = e.localX, localY = e.localY;
        var lp = this.lp;
        var dx = localX - lp.x, dy = localY - lp.y;
        dx = Tools_1.numLimit(dx, -GameConfig_1.playerVelocityLimit, GameConfig_1.playerVelocityLimit);
        dy = Tools_1.numLimit(dy, -GameConfig_1.playerVelocityLimit, GameConfig_1.playerVelocityLimit);
        var velocity = matter_js_1.Vector.create(dx, dy);
        matter_js_1.Body.setVelocity(this.body, velocity);
        lp.x = localX;
        lp.y = localY;
    };
    return Player;
}(Container));
exports.Player = Player;


/***/ }),

/***/ "./src/scenes/HomeScene/GoodsList.ts":
/*!*******************************************!*\
  !*** ./src/scenes/HomeScene/GoodsList.ts ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.GOODS = void 0;
exports.GOODS = {
    goods_1: {
        active: "产品.png",
        no: "神秘尖货.png",
        x: 46,
        y: 784,
        btnType: "goods1",
        tip: "限量.png",
        time: "08.04"
    },
    goods_2: {
        active: "产品.png",
        no: "神秘尖货.png",
        x: 380,
        y: 1180,
        btnType: "goods2",
        tip: "限量.png",
        time: "08.09"
    },
    goods_3: {
        active: "产品.png",
        no: "神秘尖货.png",
        x: 46,
        y: 1520,
        btnType: "goods3",
        tip: "限量.png",
        time: "08.10"
    },
    goods_4: {
        active: "产品.png",
        no: "神秘尖货.png",
        x: 380,
        y: 1830,
        btnType: "goods4",
        tip: "限量.png",
        time: "08.11"
    }
};


/***/ }),

/***/ "./src/scenes/HomeScene/HomeScene.ts":
/*!*******************************************!*\
  !*** ./src/scenes/HomeScene/HomeScene.ts ***!
  \*******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var ctrls_1 = __webpack_require__(/*! ../../../module/ctrls */ "./module/ctrls/index.ts");
var Scene_1 = __webpack_require__(/*! ../../../module/views/Scene */ "./module/views/Scene.ts");
var icon2_1 = __webpack_require__(/*! ../../lotties/icon2 */ "./src/lotties/icon2.ts");
var invation_1 = __webpack_require__(/*! ../../lotties/invation */ "./src/lotties/invation.ts");
var snow_1 = __webpack_require__(/*! ../../lotties/snow */ "./src/lotties/snow.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../../TaoBaoNet */ "./src/TaoBaoNet.ts");
var TbFunc_1 = __importDefault(__webpack_require__(/*! ../../TbFunc */ "./src/TbFunc.ts"));
var Tools_1 = __webpack_require__(/*! ../../Tools */ "./src/Tools.ts");
var UI_1 = __importDefault(__webpack_require__(/*! ../../UI */ "./src/UI.ts"));
var IndexScene_1 = __importDefault(__webpack_require__(/*! ../IndexScene */ "./src/scenes/IndexScene.ts"));
var GoodsList_1 = __webpack_require__(/*! ./GoodsList */ "./src/scenes/HomeScene/GoodsList.ts");
var home_types_1 = __webpack_require__(/*! ./home.types */ "./src/scenes/HomeScene/home.types.ts");
var InvationScene_1 = __importDefault(__webpack_require__(/*! ./InvationScene */ "./src/scenes/HomeScene/InvationScene.ts"));
var ShowPage_1 = __webpack_require__(/*! ./ShowPage */ "./src/scenes/HomeScene/ShowPage.ts");
var Utils_1 = __webpack_require__(/*! ./Utils */ "./src/scenes/HomeScene/Utils.ts");
var layers_1 = __webpack_require__(/*! ../../../module/views/layers */ "./module/views/layers.ts");
var TaoBaoNet_2 = __webpack_require__(/*! ../../TaoBaoNet */ "./src/TaoBaoNet.ts");
var Container = FYGE.Container;
var ScrollPage = FYGE.ScrollPage;
var Tween = FYGE.Tween;
var MouseEvent = FYGE.MouseEvent;
var Texture = FYGE.Texture;
var AssistPanel_1 = __webpack_require__(/*! ../../panels/AssistPanel */ "./src/panels/AssistPanel.ts");
var Invitepanel_1 = __webpack_require__(/*! ../../panels/Invitepanel */ "./src/panels/Invitepanel.ts");
var LoserPanel_1 = __webpack_require__(/*! ../../panels/LoserPanel */ "./src/panels/LoserPanel.ts");
var WinnerPanel_1 = __webpack_require__(/*! ../../panels/WinnerPanel */ "./src/panels/WinnerPanel.ts");
var HomeScene = (function (_super) {
    __extends(HomeScene, _super);
    function HomeScene() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.curPage = home_types_1.HOME_PAGE.index;
        _this.startX = 0;
        _this.startY = 0;
        return _this;
    }
    Object.defineProperty(HomeScene.prototype, "groupNames", {
        get: function () {
            return ["HomeScene", "icon2", "invation", "snow", "snow1", "snow2"];
        },
        enumerable: false,
        configurable: true
    });
    HomeScene.prototype.initUi = function () {
        var globalData = Tools_1.Tools.globalData;
        console.log("shijian ====", Utils_1.dealTimerToString(1626328406000));
        this.y += layers_1.layers.stageOffsetY / 2;
        this.homeCon = this.addChild(new Container());
        this.homeScrollCon = this.homeCon.addChild(new ScrollPage(750, 1624, 0, true));
        var _view = this.homeScrollCon.view;
        var scrollBg = _view.addChild(UI_1.default.Sp(this, "首页.png"));
        this.homeContent = _view.addChild(new Container());
        this.homeScrollCon.maxDistance = 2436;
        this.homeScrollCon.isSpringBack = false;
        var homeTitle = UI_1.default.Sp(this.homeContent, "title.png", (750 - 499) / 2, 303);
        var homeDesc = UI_1.default.Sp(this.homeContent, "desc.png", (750 - 441) / 2, 553);
        var ruleBtn = UI_1.default.Btn(this.homeCon, "活动规则.png", this.onClickBtn.bind(this, home_types_1.BTN_TYPE.rule), this, 0, 188);
        ruleBtn.anchorX = 0;
        var prizeBtn = UI_1.default.Btn(this.homeCon, "兑换奖品.png", this.onClickBtn.bind(this, home_types_1.BTN_TYPE.prize), this, 750 - 135, 188);
        prizeBtn.anchorX = 135;
        var gameIcon = UI_1.default.Lottie(this.homeCon, icon2_1.icon2);
        gameIcon.x = 5;
        gameIcon.y = 284;
        gameIcon.play();
        gameIcon.addEventListener(MouseEvent.CLICK, this.onClickBtn.bind(this, home_types_1.BTN_TYPE.startGame), this);
        this.invationBtn = UI_1.default.Lottie(this.homeCon, invation_1.invation);
        this.invationBtn.x = 750 - 87;
        this.invationBtn.y = 284;
        this.invationBtn.anchorX = 87;
        this.invationBtn.addEventListener(MouseEvent.CLICK, this.onClickBtn.bind(this, home_types_1.BTN_TYPE.invation), this);
        this.invationBtn.visible = true;
        this.ticketBtn = UI_1.default.Btn(this.homeCon, "门票.png", this.onClickBtn.bind(this, home_types_1.BTN_TYPE.ticket), this, 750 - 148, 284);
        this.ticketBtn.anchorX = 148;
        this.ticketBtn.visible = false;
        this.leftMoveBtn = UI_1.default.Btn(this.homeCon, "左滑.png", this.onClickBtn.bind(this, home_types_1.BTN_TYPE.leftMove), this, 0, 495);
        this.leftMoveBtn.anchorX = 0;
        this.leftMoveBtn.visible = false;
        this.rightMoveBtn = UI_1.default.Btn(this.homeCon, "右滑.png", this.onClickBtn.bind(this, home_types_1.BTN_TYPE.rightMove), this, 750 - 88, 495);
        this.rightMoveBtn.anchorX = 88;
        this.rightMoveBtn.visible = true;
        this.goodsContainer = this.homeContent.addChild(new Container());
        this.updateIndex();
        this.showContent = _view.addChild(new ShowPage_1.ShowPage());
        this.showContent.x = 750;
        this.showContent.alpha = 0;
        this.showContent.updateTexture = "title.png";
        var _snow = UI_1.default.Lottie(this, snow_1.snow);
        _snow.x = _snow.y = 0;
        _snow.play();
        _snow.mouseChildren = false;
        _snow.mouseEnable = false;
        this.curPage = home_types_1.HOME_PAGE.index;
        this.addEvent();
    };
    HomeScene.prototype.updateIndex = function () {
        var _a = Tools_1.Tools.globalData.getActivityBaseInfo.goods, goods = _a === void 0 ? [] : _a;
        this.goodsContainer.removeAllChildren();
        var snowBg = UI_1.default.Sp(this.goodsContainer, "雪花页1.png", 0, 1306);
        var flag = false, count = 0, timeStr = Utils_1.dealTimerToString(+TaoBaoNet_2.getTbServerTime());
        for (var item in GoodsList_1.GOODS) {
            var good = GoodsList_1.GOODS[item];
            var img = "", offsetX = 0, isShow = false;
            if (good["btnType"] === home_types_1.BTN_TYPE.goods1 || !flag) {
                img = good.active;
                offsetX = good.x;
                isShow = true;
            }
            else {
                img = good.no;
                offsetX = good.x - 60;
                isShow = false;
            }
            var _goodSp = UI_1.default.Btn(this.goodsContainer, img, this.onClickBtn.bind(this, [home_types_1.BTN_TYPE[good["btnType"]], goods["link" + (count + 1)] || ""]), this, offsetX, good.y);
            _goodSp.anchorX = _goodSp.width / 2;
            if (img === good.no) {
                _goodSp.mouseChildren = false;
                _goodSp.mouseEnable = false;
            }
            var _tip = UI_1.default.Sp(this.goodsContainer, good["tip"], good.x + 225, good.y - 20);
            _tip.anchorX = 60;
            _tip.anchorY = 54;
            if (isShow) {
                _tip.visible = true;
            }
            else {
                _tip.visible = false;
            }
            Tween.get(_tip, { loop: true })
                .to({ scaleX: 0.8, scaleY: 0.8 }, 500)
                .to({ scaleX: 1, scaleY: 1 }, 500);
            if (timeStr == good.time) {
                flag = true;
                snowBg.texture = Texture.fromUrl(home_types_1.SNOW_PNG[count]);
            }
            count++;
        }
        this.checkModal();
    };
    HomeScene.prototype.addEvent = function () {
        this.addEventListener(MouseEvent.MOUSE_DOWN, this.onMouseDown, this);
        this.addEventListener(MouseEvent.MOUSE_MOVE, this.onMouseMove, this);
        this.addEventListener(MouseEvent.MOUSE_UP, this.onMouseUp, this);
    };
    HomeScene.prototype.removeEvent = function () {
        this.removeEventListener(MouseEvent.MOUSE_DOWN, this.onMouseDown, this);
        this.removeEventListener(MouseEvent.MOUSE_MOVE, this.onMouseMove, this);
        this.removeEventListener(MouseEvent.MOUSE_UP, this.onMouseUp, this);
    };
    HomeScene.prototype.onMouseDown = function (evt) {
        try {
            this.startX = Number(evt.localX);
            this.startY = Number(evt.localY);
        }
        catch (e) {
        }
    };
    HomeScene.prototype.onMouseMove = function (evt) {
        try {
            var _x = Number(evt.localX);
            if (Math.abs(_x - this.startX) < 50)
                return;
            var dir = _x - this.startX > 0 ? 1 : -1;
        }
        catch (e) {
        }
    };
    HomeScene.prototype.onMouseUp = function (evt) {
        try {
            var _x = Number(evt.localX);
            if (Math.abs(_x - this.startX) < 50)
                return;
            var dir = _x - this.startX > 0 ? 1 : -1;
            if (this.startY > 300 && this.startY < 1200) {
                if (this.startX > 550 && dir == -1) {
                    this.onChangePage(home_types_1.HOME_PAGE.show);
                }
                else if (this.startX < 200 && dir == 1) {
                    this.onChangePage(home_types_1.HOME_PAGE.index);
                }
            }
        }
        catch (e) {
        }
    };
    HomeScene.prototype.onClickBtn = function (args) {
        console.log("args--->>>>", args);
        var type = null;
        if (typeof args == "string") {
            type = args;
        }
        else if (Object.prototype.toString.call(args) === '[object Array]') {
            type = args[0];
        }
        if (type == home_types_1.BTN_TYPE.rule || type == home_types_1.BTN_TYPE.prize) {
            ;
        }
        else {
            if (!this.checkActiveStatus()) {
                return;
            }
        }
        switch (type) {
            case home_types_1.BTN_TYPE.rule:
                Utils_1.showPanelTb(type);
                break;
            case home_types_1.BTN_TYPE.prize:
                TbFunc_1.default.goExchangeGoods();
                break;
            case home_types_1.BTN_TYPE.startGame:
                ctrls_1.changeScene(IndexScene_1.default);
                break;
            case home_types_1.BTN_TYPE.invation:
                ctrls_1.changeScene(InvationScene_1.default, { first: false });
                break;
            case home_types_1.BTN_TYPE.ticket:
                var getActivityBaseInfo = Tools_1.Tools.globalData.getActivityBaseInfo;
                var _a = getActivityBaseInfo.applyLink, applyLink = _a === void 0 ? "" : _a;
                TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.navigateToOutside, { url: applyLink });
                break;
            case home_types_1.BTN_TYPE.leftMove:
                this.onChangePage(home_types_1.HOME_PAGE.index);
                break;
            case home_types_1.BTN_TYPE.rightMove:
                this.onChangePage(home_types_1.HOME_PAGE.show);
                break;
            case home_types_1.BTN_TYPE.goods1:
            case home_types_1.BTN_TYPE.goods2:
            case home_types_1.BTN_TYPE.goods3:
            case home_types_1.BTN_TYPE.goods4:
                var link = args[1] || "";
                TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.navigateToOutside, { url: link });
                break;
        }
    };
    HomeScene.prototype.onChangePage = function (type) {
        var _this = this;
        if (!this.checkActiveStatus())
            return;
        if (type === this.curPage)
            return;
        this.homeScrollCon.scrollTo(0);
        this.homeScrollCon.mouseEnable = false;
        this.invationBtn.visible = this.ticketBtn.visible = false;
        this.rightMoveBtn.visible = this.leftMoveBtn.visible = false;
        if (type === home_types_1.HOME_PAGE.index) {
            Tween.get(this.homeContent)
                .to({ x: 0, alpha: 1 }, 400)
                .call(function () {
                _this.invationBtn.visible = _this.homeScrollCon.mouseEnable = _this.rightMoveBtn.visible = true;
                _this.ticketBtn.visible = false;
                _this.homeScrollCon.maxDistance = 2436;
                _this.curPage = type;
            });
            Tween.get(this.showContent)
                .to({ x: 750, alpha: 0 }, 400);
        }
        else if (type === home_types_1.HOME_PAGE.show) {
            Tween.get(this.homeContent)
                .to({ x: -750, alpha: 0 }, 400)
                .call(function () {
                _this.ticketBtn.visible = _this.homeScrollCon.mouseEnable = _this.leftMoveBtn.visible = true;
                _this.invationBtn.visible = false;
                _this.homeScrollCon.maxDistance = 1824;
                _this.curPage = type;
            });
            Tween.get(this.showContent)
                .to({ x: 0, alpha: 1 }, 400);
        }
    };
    HomeScene.prototype.checkModal = function () {
        var _a = Tools_1.Tools.globalData, getLoginInfo = _a.getLoginInfo, getMyActivityInfo = _a.getMyActivityInfo, isVip = _a.isVip;
        var _b = Tools_1.Tools.globalData, _c = _b.inviteId, inviteId = _c === void 0 ? "" : _c, _d = _b.remainTimes, remainTimes = _d === void 0 ? {} : _d;
        var yesterdaySelectTeam = getMyActivityInfo.yesterdaySelectTeam, showPkModal = getMyActivityInfo.showPkModal, yesterdayWinCoin = getMyActivityInfo.yesterdayWinCoin;
        var checkSuccessOrFail = function () {
            if (!!yesterdaySelectTeam && !showPkModal) {
                if (!!yesterdayWinCoin) {
                    ctrls_1.showPanel(WinnerPanel_1.WinnerPanel, {
                        team: yesterdaySelectTeam,
                        value: yesterdayWinCoin,
                    });
                }
                else {
                    ctrls_1.showPanel(LoserPanel_1.LoserPanel);
                }
            }
        };
        if (inviteId) {
            ctrls_1.showPanel(AssistPanel_1.AssistPanel, {
                cb: function () {
                    if (!isVip) {
                        TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getAssistCb);
                    }
                }
            });
        }
        else if (remainTimes === null || remainTimes === void 0 ? void 0 : remainTimes.invites) {
            ctrls_1.showPanel(Invitepanel_1.InvitePanel, {
                cb: function () {
                    checkSuccessOrFail();
                },
                inviteCount: (remainTimes === null || remainTimes === void 0 ? void 0 : remainTimes.invites) / 2,
                pkCount: remainTimes === null || remainTimes === void 0 ? void 0 : remainTimes.invites
            });
        }
        else {
            checkSuccessOrFail();
        }
    };
    HomeScene.prototype.checkActiveStatus = function () {
        var nowTime = +TaoBaoNet_2.getTbServerTime();
        var _a = Tools_1.Tools.globalData.getActivityBaseInfo, getActivityBaseInfo = _a === void 0 ? {} : _a;
        var _b = getActivityBaseInfo.startTime, startTime = _b === void 0 ? 0 : _b, _c = getActivityBaseInfo.endTime, endTime = _c === void 0 ? 0 : _c;
        if (nowTime < startTime) {
            ctrls_1.showToast("活动未开始");
            return false;
        }
        if (nowTime > endTime) {
            ctrls_1.showToast("活动已结束");
            return false;
        }
        return true;
    };
    HomeScene.prototype.destroy = function () {
    };
    return HomeScene;
}(Scene_1.Scene));
exports.default = HomeScene;


/***/ }),

/***/ "./src/scenes/HomeScene/InvationScene.ts":
/*!***********************************************!*\
  !*** ./src/scenes/HomeScene/InvationScene.ts ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var UI_1 = __importDefault(__webpack_require__(/*! ../../UI */ "./src/UI.ts"));
var Scene_1 = __webpack_require__(/*! ../../../module/views/Scene */ "./module/views/Scene.ts");
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var Graphics = FYGE.Graphics;
var Tween = FYGE.Tween;
var Texture = FYGE.Texture;
var MouseEvent = FYGE.MouseEvent;
var snow_1 = __webpack_require__(/*! ../../lotties/snow */ "./src/lotties/snow.ts");
var ctrls_1 = __webpack_require__(/*! ../../../module/ctrls */ "./module/ctrls/index.ts");
var HomeScene_1 = __importDefault(__webpack_require__(/*! ./HomeScene */ "./src/scenes/HomeScene/HomeScene.ts"));
var layers_1 = __webpack_require__(/*! ../../../module/views/layers */ "./module/views/layers.ts");
var Main_1 = __webpack_require__(/*! ../../Main */ "./src/Main.ts");
var Tools_1 = __webpack_require__(/*! ../../Tools */ "./src/Tools.ts");
var TbFunc_1 = __importDefault(__webpack_require__(/*! ../../TbFunc */ "./src/TbFunc.ts"));
var TaoBaoNet_1 = __webpack_require__(/*! ../../TaoBaoNet */ "./src/TaoBaoNet.ts");
var InvationScene = (function (_super) {
    __extends(InvationScene, _super);
    function InvationScene() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.lastTime = 0;
        return _this;
    }
    Object.defineProperty(InvationScene.prototype, "groupNames", {
        get: function () {
            return ["InvationScene", "snow"];
        },
        enumerable: false,
        configurable: true
    });
    InvationScene.prototype.initUi = function () {
        var _a = Tools_1.Tools.globalData, _b = _a.avatar, avatar = _b === void 0 ? "" : _b, _c = _a.nickName, nickName = _c === void 0 ? "" : _c;
        var _d = this.data, params = _d.params, first = _d.first;
        this.y += layers_1.layers.stageOffsetY / 2;
        UI_1.default.Sp(this, "首页.png");
        this.invationPageCover = UI_1.default.Sp(this, "弹窗-邀请函__m.png", (750 - 614) / 2, 345 - layers_1.layers.stageOffsetY / 2);
        this.invationPageBack = UI_1.default.Sp(this, "弹窗-接受邀请.png", 0, 345 - layers_1.layers.stageOffsetY / 2);
        this.invationPageBack.anchorX = 375;
        this.invationPageBack.scaleX = 1;
        var avatorBorder = this.invationPageBack.addChild(new Graphics());
        avatorBorder.beginFill(0x959fb0, 1);
        avatorBorder.drawCircle(375, 65 + 82, 82);
        avatorBorder.endFill();
        this.avatorSp = UI_1.default.Sp(this.invationPageBack, "首页.png", 304, 76);
        this.avatorSp.width = this.avatorSp.height = 145;
        this.avatorSp.texture = Texture.fromUrl(avatar);
        var _rect = this.invationPageBack.addChild(new Graphics());
        _rect.beginFill(0x959fb0, 1);
        _rect.drawCircle(308 + 68, 80 + 68, 72);
        _rect.endFill();
        this.avatorSp.mask = _rect;
        this.userName = UI_1.default.Txt(this.invationPageBack, "" + nickName, 22, "#000000", TEXT_ALIGN.CENTER, 750, 0, 248);
        this.userName.bold = true;
        this.userName.text = nickName;
        this.codeImg = UI_1.default.Sp(this.invationPageBack, "首页.png", 290, 454);
        this.codeImg.width = this.codeImg.height = 185;
        this.backBtn = UI_1.default.Btn(this, "back.png", this.onBackHome, this, (750 - 404) / 2, 1280 - layers_1.layers.stageOffsetY / 2);
        this.snowPage = UI_1.default.Sp(this, "雪花页.png", 0, 0);
        this.tip = UI_1.default.Sp(this, "toast1.png", (750 - 492) / 2, 640);
        Tween.get(this.tip, { loop: true })
            .to({ alpha: 0.5 }, 800)
            .to({ alpha: 1 }, 800);
        var _snow = UI_1.default.Lottie(this, snow_1.snow);
        _snow.x = _snow.y = 0;
        _snow.play();
        _snow.mouseChildren = false;
        _snow.mouseEnable = false;
        if (first) {
            this.invationPageCover.visible = true;
            this.invationPageBack.scaleX = -1;
            this.invationPageBack.visible = this.backBtn.visible = false;
            this.tip.visible = this.snowPage.visible = true;
        }
        else {
            this.invationPageCover.visible = false;
            this.invationPageBack.scaleX = 1;
            this.invationPageBack.visible = this.backBtn.visible = true;
            this.tip.visible = this.snowPage.visible = false;
        }
        this.onAddEvents();
    };
    InvationScene.prototype.onAddEvents = function () {
        var _a = this.data, params = _a.params, first = _a.first;
        if (first) {
            Main_1.GDispatcher.addEventListener(TaoBaoNet_1.TbNetName.getHuhuSnow, this.onHuhuCheck);
        }
        this.mouseChildren = true;
        this.mouseEnable = true;
        this.addEventListener(MouseEvent.MOUSE_DOWN, this.onMouseDown, this);
        this.addEventListener(MouseEvent.MOUSE_UP, this.onMouseUp, this);
    };
    InvationScene.prototype.onRemoveEvents = function () {
        this.addEventListener(MouseEvent.MOUSE_DOWN, this.onMouseDown, this);
        this.addEventListener(MouseEvent.MOUSE_UP, this.onMouseUp, this);
    };
    InvationScene.prototype.onMouseDown = function () {
        this.lastTime = +new Date();
    };
    InvationScene.prototype.onMouseUp = function () {
        var now = +new Date(), delatTime = 0;
        if (this.lastTime) {
            delatTime = now - this.lastTime;
        }
        if (delatTime > 500) {
            console.log("长按");
            this.saveImg();
        }
    };
    InvationScene.prototype.onHuhuCheck = function () {
        var _this = this;
        Tween.removeTweens(this.tip);
        this.tip.visible = false;
        this.snowPage.visible = false;
        this.invationPageBack.scaleX = -1;
        this.invationPageBack.visible = true;
        this.onRotatecard(function () {
            _this.backBtn.visible = true;
        });
    };
    InvationScene.prototype.onRotatecard = function (cb) {
        Tween.get(this.invationPageCover)
            .set({ anchorX: 307 })
            .to({ scaleX: -1, alpha: 0 }, 1000)
            .call(function () { cb && cb(); });
        Tween.get(this.invationPageBack)
            .set({ anchorX: 375 })
            .to({ scaleX: 1, alpha: 1 }, 1000);
    };
    InvationScene.prototype.onBackHome = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, Tools_1.Tools.getGlobalData()];
                    case 1:
                        _a.sent();
                        return [4, Tools_1.Tools.getActivityInfo()];
                    case 2:
                        _a.sent();
                        ctrls_1.changeScene(HomeScene_1.default);
                        return [2];
                }
            });
        });
    };
    InvationScene.prototype.saveImg = function () {
        var rect = new FYGE.Rectangle(71, 0, 608, 890);
        var imgUrl = FYGE.toDisplayDataURL(this.invationPageBack, rect);
        TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getUploadImg, {
            file: imgUrl.split("data:image/png;base64,")[1]
        }, function (s, result) {
            var data = result.data;
            if (data === null || data === void 0 ? void 0 : data.url) {
                TbFunc_1.default.saveImg(data === null || data === void 0 ? void 0 : data.url);
            }
            else {
                TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getUploadImg, {}, function (s, res) {
                    var _a, _b;
                    if ((_a = res === null || res === void 0 ? void 0 : res.data) === null || _a === void 0 ? void 0 : _a.url) {
                        TbFunc_1.default.saveImg((_b = res === null || res === void 0 ? void 0 : res.data) === null || _b === void 0 ? void 0 : _b.url);
                    }
                });
            }
        });
    };
    InvationScene.prototype.destroy = function () {
        this.onRemoveEvents();
    };
    return InvationScene;
}(Scene_1.Scene));
exports.default = InvationScene;


/***/ }),

/***/ "./src/scenes/HomeScene/ShowPage.ts":
/*!******************************************!*\
  !*** ./src/scenes/HomeScene/ShowPage.ts ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShowPage = void 0;
var TaoBaoNet_1 = __webpack_require__(/*! ../../TaoBaoNet */ "./src/TaoBaoNet.ts");
var UI_1 = __importDefault(__webpack_require__(/*! ../../UI */ "./src/UI.ts"));
var Tools_1 = __webpack_require__(/*! ./../../Tools */ "./src/Tools.ts");
var Utils_1 = __webpack_require__(/*! ./Utils */ "./src/scenes/HomeScene/Utils.ts");
var Container = FYGE.Container;
var Graphics = FYGE.Graphics;
var Texture = FYGE.Texture;
var LIVE = [
    {
        type: 1,
        time: "06.18"
    },
    {
        type: 0,
        time: "06.21"
    },
    {
        type: 2,
        time: "07.07"
    },
    {
        type: 0,
        time: "07.13"
    },
    {
        type: 1,
        time: "07.21"
    }
];
var LIVE_TYPE;
(function (LIVE_TYPE) {
    LIVE_TYPE[LIVE_TYPE["end"] = 1] = "end";
    LIVE_TYPE[LIVE_TYPE["live"] = 2] = "live";
    LIVE_TYPE[LIVE_TYPE["no"] = 0] = "no";
})(LIVE_TYPE || (LIVE_TYPE = {}));
var ShowPage = (function (_super) {
    __extends(ShowPage, _super);
    function ShowPage() {
        var _this = _super.call(this) || this;
        _this.initUI();
        return _this;
    }
    Object.defineProperty(ShowPage.prototype, "updateTexture", {
        get: function () {
            return this._textureStr;
        },
        set: function (v) {
            this._textureStr = v;
            var _texture = Texture.fromUrl(v);
            this._splive.texture = _texture;
        },
        enumerable: false,
        configurable: true
    });
    ShowPage.prototype.initUI = function () {
        var title = UI_1.default.Sp(this, "大秀标题.png", (750 - 345) / 2, 282);
        var border = UI_1.default.Sp(this, "框.png", (750 - 642) / 2, 475);
        var _rect = this.addChild(new Graphics());
        _rect.beginFill("#adbdca", 1);
        _rect.drawRoundedRect(border.x + 52, border.y + 44, 530, 770, 50);
        _rect.endFill();
        this._splive = UI_1.default.Sp(this, "首页.png", border.x + 52, border.y + 44);
        this._splive.width = 530;
        this._splive.height = 770;
        this._splive.mask = _rect;
        var _line = UI_1.default.Sp(this, "line.png", (750 - 642) / 2, 1224);
        this.liveContainer = this.addChild(new Container());
        this.updateData();
        UI_1.default.Btn(this, "按钮-订阅直播间__m.png", this.observerLive, this, (750 - 566) / 2, 1350);
    };
    ShowPage.prototype.updateData = function () {
        return __awaiter(this, void 0, void 0, function () {
            var live, _a, getActivityBaseInfo, _b, liveConfig, _x;
            var _this = this;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0: return [4, Tools_1.Tools.getGlobalData()];
                    case 1:
                        _c.sent();
                        live = [];
                        _a = Tools_1.Tools.globalData.getActivityBaseInfo, getActivityBaseInfo = _a === void 0 ? {} : _a;
                        _b = getActivityBaseInfo.liveConfig, liveConfig = _b === void 0 ? [] : _b;
                        liveConfig.forEach(function (item, index) {
                            var timeStr = Utils_1.dealTimerToString(+TaoBaoNet_1.getTbServerTime());
                            timeStr = Utils_1.dealTimerToString(1624254806000);
                            var nowTime = +new Date(timeStr);
                            var thisTime = +new Date(item.day);
                            var type = 0;
                            if (nowTime < thisTime) {
                                type = 0;
                            }
                            else if (nowTime == thisTime) {
                                type = 2;
                            }
                            else {
                                type = 1;
                            }
                            var op = {
                                type: type,
                                img: item === null || item === void 0 ? void 0 : item.image,
                                link: item === null || item === void 0 ? void 0 : item.link,
                                time: item === null || item === void 0 ? void 0 : item.day
                            };
                            live.push(op);
                        });
                        _x = 50;
                        live.forEach(function (item, index) {
                            if (item.type == LIVE_TYPE.end) {
                                var _endBtn = UI_1.default.Sp(_this.liveContainer, "已结束.png", _x, 1182);
                                var _txt = UI_1.default.Txt(_endBtn, item.time, 22, "#ffffff", FYGE.TEXT_ALIGN.CENTER, 95, 0, 54);
                                _txt.bold = true;
                                _x += 38 + 95;
                            }
                            else if (item.type == LIVE_TYPE.no) {
                                var _noBtn = UI_1.default.Sp(_this.liveContainer, "未开播.png", _x, 1182);
                                var _txt = UI_1.default.Txt(_noBtn, item.time, 22, "#ffffff", FYGE.TEXT_ALIGN.CENTER, 95, 0, 54);
                                _txt.bold = true;
                                _x += 38 + 95;
                            }
                            else if (item.type == LIVE_TYPE.live) {
                                var _liveBtn = UI_1.default.Sp(_this.liveContainer, "直播中.png", _x, 1172);
                                var _txt = UI_1.default.Txt(_liveBtn, item.time, 26, "#ffffff", FYGE.TEXT_ALIGN.CENTER, 116, 0, 64);
                                _txt.bold = true;
                                _x += 38 + 116;
                            }
                        });
                        return [2];
                }
            });
        });
    };
    ShowPage.prototype.observerLive = function () {
        var getActivityBaseInfo = Tools_1.Tools.globalData.getActivityBaseInfo;
        var _a = getActivityBaseInfo.liveLink, liveLink = _a === void 0 ? "" : _a;
        TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.navigateToOutside, { url: liveLink });
    };
    return ShowPage;
}(Container));
exports.ShowPage = ShowPage;


/***/ }),

/***/ "./src/scenes/HomeScene/Utils.ts":
/*!***************************************!*\
  !*** ./src/scenes/HomeScene/Utils.ts ***!
  \***************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.dealTimerToString = exports.showPanelTb = void 0;
var TaoBaoNet_1 = __webpack_require__(/*! ../../TaoBaoNet */ "./src/TaoBaoNet.ts");
function showPanelTb(name, args) {
    if (args === void 0) { args = null; }
    var parm = {
        methodName: name,
    };
    if (args) {
        parm["args"] = args;
    }
    TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.openPanel, parm, function (s, res) { });
}
exports.showPanelTb = showPanelTb;
function dealTimerToString(time) {
    var str = "";
    var _time = new Date(time);
    var _mon = _time.getMonth() + 1 > 9 ? _time.getMonth() + 1 : "0" + (_time.getMonth() + 1);
    var _day = _time.getDate() > 9 ? _time.getDate() : "0" + _time.getDate();
    str += _mon + "." + _day;
    return str;
}
exports.dealTimerToString = dealTimerToString;


/***/ }),

/***/ "./src/scenes/HomeScene/home.types.ts":
/*!********************************************!*\
  !*** ./src/scenes/HomeScene/home.types.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.SNOW_PNG = exports.HOME_PAGE = exports.BTN_TYPE = void 0;
var BTN_TYPE;
(function (BTN_TYPE) {
    BTN_TYPE["rule"] = "rule";
    BTN_TYPE["prize"] = "prize";
    BTN_TYPE["startGame"] = "startGame";
    BTN_TYPE["invation"] = "invation";
    BTN_TYPE["leftMove"] = "leftMove";
    BTN_TYPE["rightMove"] = "rightMove";
    BTN_TYPE["ticket"] = "ticket";
    BTN_TYPE["goods1"] = "goods1";
    BTN_TYPE["goods2"] = "goods2";
    BTN_TYPE["goods3"] = "goods3";
    BTN_TYPE["goods4"] = "goods4";
})(BTN_TYPE = exports.BTN_TYPE || (exports.BTN_TYPE = {}));
var HOME_PAGE;
(function (HOME_PAGE) {
    HOME_PAGE["index"] = "index";
    HOME_PAGE["show"] = "show";
})(HOME_PAGE = exports.HOME_PAGE || (exports.HOME_PAGE = {}));
exports.SNOW_PNG = [
    "雪花页_01.png",
    "雪花页1.png",
    "雪花页2.png",
];


/***/ }),

/***/ "./src/scenes/IndexScene.ts":
/*!**********************************!*\
  !*** ./src/scenes/IndexScene.ts ***!
  \**********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var Scene_1 = __webpack_require__(/*! ../../module/views/Scene */ "./module/views/Scene.ts");
var G_EVENT_1 = __webpack_require__(/*! ../common/G_EVENT */ "./src/common/G_EVENT.ts");
var snow_1 = __webpack_require__(/*! ../lotties/snow */ "./src/lotties/snow.ts");
var Main_1 = __webpack_require__(/*! ../Main */ "./src/Main.ts");
var ChooseTeam_1 = __webpack_require__(/*! ../panels/ChooseTeam */ "./src/panels/ChooseTeam.ts");
var GameGuide_1 = __webpack_require__(/*! ../panels/GameGuide */ "./src/panels/GameGuide.ts");
var NoTime_1 = __webpack_require__(/*! ../panels/NoTime */ "./src/panels/NoTime.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../TaoBaoNet */ "./src/TaoBaoNet.ts");
var TbFunc_1 = __importDefault(__webpack_require__(/*! ../TbFunc */ "./src/TbFunc.ts"));
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var UI_1 = __importDefault(__webpack_require__(/*! ../UI */ "./src/UI.ts"));
var HomeScene_1 = __importDefault(__webpack_require__(/*! ./HomeScene/HomeScene */ "./src/scenes/HomeScene/HomeScene.ts"));
var MatchScene_1 = __importDefault(__webpack_require__(/*! ./MatchScene */ "./src/scenes/MatchScene.ts"));
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var IndexScene = (function (_super) {
    __extends(IndexScene, _super);
    function IndexScene() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.guideY = 188;
        _this.updateIndex = function () { return __awaiter(_this, void 0, void 0, function () {
            var suc, todaySelectTeam;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, Tools_1.Tools.getMyActivityInfo()];
                    case 1:
                        suc = _a.sent();
                        if (!suc)
                            ctrls_1.showToast("获取活动信息失败");
                        return [4, Tools_1.Tools.getTeamInfo()];
                    case 2:
                        _a.sent();
                        todaySelectTeam = Tools_1.Tools.myActivityInfo.todaySelectTeam;
                        if (!todaySelectTeam) {
                            this.blueTipText.text = this.redTipText.text = "当前选择人数";
                            this.blueText.text = Tools_1.Tools.teamInfo["1"].people + "\u4EBA";
                            this.redText.text = Tools_1.Tools.teamInfo["2"].people + "\u4EBA";
                            ctrls_1.showPanel(ChooseTeam_1.ChooseTeam, {
                                updateIndex: this.updateIndex
                            });
                        }
                        else {
                            this.blueTipText.text = this.redTipText.text = "当前分数";
                            this.blueText.text = "" + Tools_1.Tools.teamInfo["1"].score;
                            this.redText.text = "" + Tools_1.Tools.teamInfo["2"].score;
                            this.blueTeamTip.visible = (todaySelectTeam == 1);
                            this.redTeamTip.visible = !(todaySelectTeam == 1);
                        }
                        this.gameTime.text = "PK\u6B21\u6570\uFF1A" + Tools_1.Tools.myActivityInfo.gameTimes;
                        return [2];
                }
            });
        }); };
        return _this;
    }
    Object.defineProperty(IndexScene.prototype, "groupNames", {
        get: function () {
            return ["IndexScene", "snow", "snow1", "snow2"];
        },
        enumerable: false,
        configurable: true
    });
    IndexScene.prototype.initUi = function () {
        UI_1.default.Sp(this, "indexBg.jpg");
        var blue = this.blue = UI_1.default.Ctn(this, -1624);
        UI_1.default.Sp(blue, "index蓝.png", 0, 547);
        var red = this.red = UI_1.default.Ctn(this, 1624);
        UI_1.default.Sp(red, "index红.png", 264, 547);
        var texture = Tools_1.Tools.getNumTextures("index_");
        ["人", "分", "前", "当", "择", "数", "选"].forEach(function (v) {
            texture[v] = RES_1.RES.getRes("index_" + v + ".png");
        });
        this.blueTipText = UI_1.default.BitTxt(blue, texture, "当前选择人数", 165, 940);
        this.blueTipText.gap = -10;
        this.redTipText = UI_1.default.BitTxt(red, texture, "当前选择人数", 575, 940);
        this.redTipText.gap = -10;
        this.blueText = UI_1.default.BitTxt(blue, texture, "0人", 165, 1000);
        this.blueText.gap = -10;
        this.redText = UI_1.default.BitTxt(red, texture, "0人", 575, 1000);
        this.redText.gap = -10;
        this.blueTeamTip = UI_1.default.Sp(blue, "blueTeamTip.png", 40, 1050);
        this.redTeamTip = UI_1.default.Sp(red, "redTeamTip.png", 550, 1050);
        this.blueTeamTip.visible = false;
        this.redTeamTip.visible = false;
        var light = this.light = UI_1.default.Sp(this, "index光.png", 0, 526);
        light.mouseChildren = light.mouseEnable = false;
        light.visible = false;
        this.guideBtn = UI_1.default.Btn(this, "indexGuide.png", this.clickBtn, this, 0, 188);
        this.guideBtn.anchorX = 0;
        this.myPrize = UI_1.default.Btn(this, "indexMyPrize.png", this.clickBtn, this, 615, 186);
        this.myPrize.anchorX = 135;
        this.backBtn = UI_1.default.Btn(this, "backBtn.png", this.clickBtn, this, 12, 250);
        this.taskBtn = UI_1.default.Btn(this, "indexTask.png", this.clickBtn, this, 709, 368);
        this.taskBtn.anchorX = 41;
        this.startCtn = UI_1.default.Ctn(this, 375, 1389);
        this.startBtn = UI_1.default.Btn(this.startCtn, "indexStart.png", this.clickStart, this, -264, -89);
        this.sweepLight = UI_1.default.Sp(this.startCtn, "index扫光.png", -150, -120);
        this.sweepLight.scaleX = -1;
        this.sweepLight.mask = UI_1.default.Rect(this.startCtn, 341, 93, 0, 5, -167, -48);
        UI_1.default.Sp(this, "indexGameTimeBg.png", 441, 1261).mouseEnable = false;
        this.gameTime = UI_1.default.Txt(this, "PK次数：1", 24, "#ffffff", TEXT_ALIGN.CENTER, 151, 441, 1286);
        this.gameTime.mouseEnable = false;
        this.effect();
    };
    IndexScene.prototype.effect = function () {
        var _this = this;
        var snowEffect = UI_1.default.Lottie(this, snow_1.snow);
        snowEffect.play();
        snowEffect.mouseEnable = snowEffect.mouseChildren = false;
        Tween.get(this, {
            loop: true,
            onChange: function () {
                _this.guideBtn.y = _this.guideY;
                _this.myPrize.y = _this.guideY;
            }
        }).to({ guideY: 183 }, 1000, Ease.quadInOut)
            .to({ guideY: 188 }, 1000, Ease.quadInOut);
        Tween.get(this)
            .wait(100)
            .call(function () {
            Tween.get(_this.blue)
                .to({ x: 0, y: 0 }, 600, Ease.quadOut)
                .call(function () {
                Tween.get(_this.light)
                    .set({ alpha: 0, visible: true })
                    .to({ alpha: 0.4 }, 400)
                    .call(function () {
                    Tween.get(_this.light, { loop: true })
                        .to({ alpha: 1 }, 1200, Ease.quadInOut)
                        .to({ alpha: 0.4 }, 1200, Ease.quadInOut);
                });
            });
            Tween.get(_this.red)
                .to({ x: 0, y: 0 }, 600, Ease.quadOut)
                .wait(2000);
        });
        Tween.get(this.sweepLight, { loop: true })
            .set({ x: -150 })
            .to({ x: 380 }, 1500, Ease.quadInOut)
            .wait(1500);
        Tween.get(this.startCtn, { loop: true })
            .to({ scaleX: 1.05, scaleY: 1.05 }, 1000, Ease.getPowInOut(1.2))
            .to({ scaleX: 1, scaleY: 1 }, 1000, Ease.getPowInOut(1.2));
    };
    IndexScene.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        Main_1.GDispatcher.removeEventListener(G_EVENT_1.G_EVENT.UPDATE_TASK, this.updateIndex);
        Tween.removeTweens(this);
        Tween.removeTweens(this.blue);
        Tween.removeTweens(this.red);
        Tween.removeTweens(this.light);
        Tween.removeTweens(this.sweepLight);
        Tween.removeTweens(this.startCtn);
    };
    IndexScene.prototype.start = function (data) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.updateIndex()];
                    case 1:
                        _a.sent();
                        Main_1.GDispatcher.addEventListener(G_EVENT_1.G_EVENT.UPDATE_TASK, this.updateIndex);
                        return [2];
                }
            });
        });
    };
    IndexScene.prototype.clickStart = function () {
        return __awaiter(this, void 0, void 0, function () {
            var isVip;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        TaoBaoNet_1.addStat("JOIN_GAME");
                        if (Tools_1.Tools.myActivityInfo.gameTimes <= 0) {
                            return [2, ctrls_1.showPanel(NoTime_1.NoTime)];
                        }
                        return [4, TbFunc_1.default.checkMember()];
                    case 1:
                        isVip = _a.sent();
                        if (!isVip) return [3, 2];
                        ctrls_1.changeScene(MatchScene_1.default);
                        return [3, 4];
                    case 2: return [4, TbFunc_1.default.openMember()];
                    case 3:
                        _a.sent();
                        _a.label = 4;
                    case 4: return [2];
                }
            });
        });
    };
    IndexScene.prototype.clickBtn = function (e) {
        return __awaiter(this, void 0, void 0, function () {
            var target, _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        target = e.target;
                        _a = target;
                        switch (_a) {
                            case this.guideBtn: return [3, 1];
                            case this.myPrize: return [3, 2];
                            case this.backBtn: return [3, 3];
                            case this.taskBtn: return [3, 4];
                        }
                        return [3, 6];
                    case 1:
                        ctrls_1.showPanel(GameGuide_1.GameGuide);
                        return [3, 6];
                    case 2:
                        TbFunc_1.default.goExchangeGoods();
                        return [3, 6];
                    case 3:
                        ctrls_1.changeScene(HomeScene_1.default);
                        return [3, 6];
                    case 4: return [4, TbFunc_1.default.showTask()];
                    case 5:
                        _b.sent();
                        return [3, 6];
                    case 6: return [2];
                }
            });
        });
    };
    return IndexScene;
}(Scene_1.Scene));
exports.default = IndexScene;


/***/ }),

/***/ "./src/scenes/MatchScene.ts":
/*!**********************************!*\
  !*** ./src/scenes/MatchScene.ts ***!
  \**********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var Scene_1 = __webpack_require__(/*! ../../module/views/Scene */ "./module/views/Scene.ts");
var match_1 = __webpack_require__(/*! ../lotties/match */ "./src/lotties/match.ts");
var TaoBaoNet_1 = __webpack_require__(/*! ../TaoBaoNet */ "./src/TaoBaoNet.ts");
var TbFunc_1 = __importDefault(__webpack_require__(/*! ../TbFunc */ "./src/TbFunc.ts"));
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var UI_1 = __importDefault(__webpack_require__(/*! ../UI */ "./src/UI.ts"));
var IndexScene_1 = __importDefault(__webpack_require__(/*! ./IndexScene */ "./src/scenes/IndexScene.ts"));
var PreScene_1 = __importDefault(__webpack_require__(/*! ./PreScene */ "./src/scenes/PreScene.ts"));
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var Texture = FYGE.Texture;
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var MatchScene = (function (_super) {
    __extends(MatchScene, _super);
    function MatchScene() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(MatchScene.prototype, "groupNames", {
        get: function () {
            return ["MatchScene", "match"];
        },
        enumerable: false,
        configurable: true
    });
    MatchScene.prototype.initUi = function () {
        var _this = this;
        UI_1.default.Sp(this, "blueBg.jpg");
        this.backBtn = UI_1.default.Btn(this, "backBtn.png", this.clickBtn, this, 12, 180);
        this.cancel = UI_1.default.Btn(this, "matchCancel.png", this.clickBtn, this, 111, 1350);
        UI_1.default.Sp(this, "matchTimeBg.png", 161, 313);
        var preTime = Math.random() * 4 + 4 >> 0;
        UI_1.default.Txt(this, "\u9884\u8BA1\u5339\u914D\u65F6\u95F4 00:0" + preTime, 26, "#203e7b", TEXT_ALIGN.CENTER, 750, 2, 373);
        var ctTxt = UI_1.default.Txt(this, "00:00", 30, "#203e7b", TEXT_ALIGN.CENTER, 750, 3, 331);
        ctTxt.bold = true;
        var count = 0;
        Tween.get(this, { loop: true })
            .wait(1000)
            .call(function () {
            ++count;
            var min = Tools_1.prefixInteger(count / 60 >> 0, 2);
            var sec = Tools_1.prefixInteger(count - (count / 60 >> 0) * 60, 2);
            ctTxt.text = min + ":" + sec;
            if (count === preTime / 2 >> 0)
                _this.gameStart();
        });
        var pointer = UI_1.default.Sp(this, "matchPointer.png", 375, 860);
        pointer.anchorTexture.set(0, 0.98);
        Tween.get(pointer, { loop: true })
            .to({ rotation: -360 }, 10000);
        var matchEffect = UI_1.default.Lottie(this, match_1.match);
        matchEffect.play();
        matchEffect.mouseEnable = matchEffect.mouseChildren = false;
        var avatar = this.avatar = UI_1.default.Ctn(this, 375, 860);
        var avatarBg = UI_1.default.Sp(avatar, "matchAvatarBg.png");
        avatarBg.anchorTexture.set(0.5, 0.5);
        var img = UI_1.default.Sp(avatar, "");
        console.log(Tools_1.Tools.globalData);
        img.texture = Texture.fromUrl(Tools_1.Tools.globalData.avatar);
        img.width = img.height = 165;
        img.anchorTexture.set(0.5, 0.5);
        img.mask = UI_1.default.Circle(avatar, 0, 0, 83);
        Tween.get(avatar, { loop: true })
            .to({ scaleX: 1.15, scaleY: 1.15 }, 1000, Ease.getPowInOut(1.2))
            .to({ scaleX: 1, scaleY: 1 }, 1000, Ease.getPowInOut(1.2));
    };
    MatchScene.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        Tween.removeTweens(this);
        Tween.removeTweens(this.avatar);
    };
    MatchScene.prototype.gameStart = function () {
        return __awaiter(this, void 0, void 0, function () {
            var isVip, _a, success, data, id, _b, rbSuc, robot;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        isVip = TbFunc_1.default.checkMember();
                        return [4, TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.startGame, { isVip: isVip })];
                    case 1:
                        _a = _c.sent(), success = _a.success, data = _a.data;
                        if (!success) return [3, 3];
                        id = data.id;
                        return [4, TaoBaoNet_1.sendTbNet(TaoBaoNet_1.TbNetName.getRobot)];
                    case 2:
                        _b = _c.sent(), rbSuc = _b.success, robot = _b.data;
                        ctrls_1.changeScene(PreScene_1.default, { id: id, robot: robot });
                        return [3, 4];
                    case 3:
                        ctrls_1.changeScene(IndexScene_1.default);
                        _c.label = 4;
                    case 4: return [2];
                }
            });
        });
    };
    MatchScene.prototype.clickBtn = function (e) {
        var target = e.target;
        switch (target) {
            case this.cancel:
            case this.backBtn:
                ctrls_1.changeScene(IndexScene_1.default);
                break;
        }
    };
    return MatchScene;
}(Scene_1.Scene));
exports.default = MatchScene;


/***/ }),

/***/ "./src/scenes/OverScene.ts":
/*!*********************************!*\
  !*** ./src/scenes/OverScene.ts ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Avatar = void 0;
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var RES_1 = __webpack_require__(/*! ../../module/RES */ "./module/RES.ts");
var Scene_1 = __webpack_require__(/*! ../../module/views/Scene */ "./module/views/Scene.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var UI_1 = __importDefault(__webpack_require__(/*! ../UI */ "./src/UI.ts"));
var IndexScene_1 = __importDefault(__webpack_require__(/*! ./IndexScene */ "./src/scenes/IndexScene.ts"));
var Texture = FYGE.Texture;
var Container = FYGE.Container;
var TEXT_ALIGN = FYGE.TEXT_ALIGN;
var Event = FYGE.Event;
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var OverScene = (function (_super) {
    __extends(OverScene, _super);
    function OverScene() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.score = 0;
        _this.robotScore = 0;
        return _this;
    }
    Object.defineProperty(OverScene.prototype, "groupNames", {
        get: function () {
            return ["OverScene"];
        },
        enumerable: false,
        configurable: true
    });
    OverScene.prototype.initUi = function () {
        UI_1.default.Sp(this, "blueBg.jpg");
        var _a = this.data, robotScore = _a.robotScore, robotNick = _a.robotNick, robotAvatar = _a.robotAvatar, score = _a.score;
        var _b = Tools_1.Tools.globalData, avatar = _b.avatar, nickName = _b.nickName;
        var _c = Tools_1.Tools.myActivityInfo.todaySelectTeam, todaySelectTeam = _c === void 0 ? 2 : _c;
        var texture = Tools_1.Tools.getNumTextures("overScore_");
        var ctn = this.ctn = UI_1.default.Ctn(this, 0, 1624);
        var bg = UI_1.default.Sp(ctn, "over平.png", 0, 107);
        var myCtn = ctn.addChild(new Avatar(avatar, nickName));
        var robotCtn = ctn.addChild(new Avatar(robotAvatar, robotNick));
        var myTxt = this.myTxt = UI_1.default.BitTxt(ctn, texture, "0");
        myTxt.score = 0;
        var robotTxt = this.robotTxt = UI_1.default.BitTxt(ctn, texture, "0");
        robotTxt.score = 0;
        {
            if (robotScore == score) {
                this.myTip = UI_1.default.Sp(ctn, "over平局.png", 404.5, 683.5);
                this.myTip.scale.set(0, 0);
                this.myTip.anchorTexture.set(0.5, 0.5);
                this.robotTip = UI_1.default.Sp(ctn, "over平局.png", 368.5, 1083.5);
                this.robotTip.scale.set(0, 0);
                this.robotTip.anchorTexture.set(0.5, 0.5);
                bg.texture = RES_1.RES.getRes("over平.png");
                myCtn.scale.set(1.08, 1.08);
                robotCtn.scale.set(1.08, 1.08);
                myTxt.position.set(365, 970);
                robotTxt.position.set(405, 570);
                if (todaySelectTeam == 1) {
                    myCtn.position.set(138.5, 985);
                    robotCtn.position.set(625.5, 586.2);
                    UI_1.default.Sp(ctn, "blueTeamTip.png", 290, 1125);
                }
                else {
                    myCtn.position.set(625.5, 586.2);
                    robotCtn.position.set(138.5, 985);
                    UI_1.default.Sp(ctn, "redTeamTip.png", 327, 725);
                }
            }
            else if (robotScore > score) {
                this.myTip = UI_1.default.Sp(ctn, "over胜利.png", 380, 683.5);
                this.myTip.scale.set(0, 0);
                this.myTip.anchorTexture.set(0.5, 0.5);
                this.robotTip = UI_1.default.Sp(ctn, "over失败.png", 305, 1013);
                this.robotTip.scale.set(0, 0);
                this.robotTip.anchorTexture.set(0.5, 0.5);
                myTxt.position.set(300, 925);
                myTxt.scale.set(0.85, 0.85);
                robotTxt.position.set(390, 570);
                robotTxt.scale.set(1.15, 1.15);
                if (todaySelectTeam == 1) {
                    bg.texture = RES_1.RES.getRes("over红.png");
                    UI_1.default.Sp(ctn, "blueTeamTip.png", 220, 1060);
                    myCtn.scale.set(0.89, 0.89);
                    myCtn.position.set(113.8, 934);
                    robotCtn.scale.set(1.077, 1.077);
                    robotCtn.position.set(608.5, 586);
                }
                else {
                    bg.texture = RES_1.RES.getRes("over蓝.png");
                    UI_1.default.Sp(ctn, "redTeamTip.png", 220, 1060);
                    myCtn.scale.set(0.88, 0.88);
                    myCtn.position.set(122, 935);
                    robotCtn.scale.set(1.077, 1.077);
                    robotCtn.position.set(610, 585);
                }
            }
            else if (score > robotScore) {
                this.myTip = UI_1.default.Sp(ctn, "over胜利.png", 389.5, 683.5);
                this.myTip.scale.set(0, 0);
                this.myTip.anchorTexture.set(0.5, 0.5);
                this.robotTip = UI_1.default.Sp(ctn, "over失败.png", 304.5, 1013);
                this.robotTip.scale.set(0, 0);
                this.robotTip.anchorTexture.set(0.5, 0.5);
                robotTxt.position.set(310, 925);
                robotTxt.scale.set(0.85, 0.85);
                myTxt.position.set(383, 570);
                myTxt.scale.set(1.15, 1.15);
                if (todaySelectTeam == 1) {
                    bg.texture = RES_1.RES.getRes("over蓝.png");
                    UI_1.default.Sp(ctn, "blueTeamTip.png", 300, 725);
                    robotCtn.position.set(122, 935);
                    robotCtn.scale.set(0.88, 0.88);
                    myCtn.position.set(610, 585);
                    myCtn.scale.set(1.077, 1.077);
                }
                else {
                    bg.texture = RES_1.RES.getRes("over红.png");
                    UI_1.default.Sp(ctn, "redTeamTip.png", 310, 725);
                    robotCtn.scale.set(0.89, 0.89);
                    robotCtn.position.set(113.8, 934);
                    myCtn.scale.set(1.077, 1.077);
                    myCtn.position.set(608.5, 586);
                }
            }
        }
        this.btn = UI_1.default.Btn(this, "overBtn.png", function () {
            ctrls_1.changeScene(IndexScene_1.default);
        }, this, 111, 1300);
        this.btn.alpha = 0;
        UI_1.default.Btn(this, "backBtn.png", function () {
            ctrls_1.changeScene(IndexScene_1.default);
        }, this, 12, 180);
        this.effect();
    };
    OverScene.prototype.effect = function () {
        var _this = this;
        var _a = this.data, robotScore = _a.robotScore, robotNick = _a.robotNick, robotAvatar = _a.robotAvatar, score = _a.score;
        Tween.get(this.ctn)
            .to({ y: 0 }, 1000, Ease.quadInOut)
            .call(function () {
            var mt = score / 20 * 1000, rt = score / 20 * 1000;
            Tween.get(_this, {
                onChange: function () { return _this.myTxt.text = (_this.score >> 0) + ""; }
            }).to({ score: +score }, mt);
            Tween.get(_this, {
                onChange: function () { return _this.robotTxt.text = (_this.robotScore >> 0) + ""; }
            }).to({ robotScore: +robotScore }, rt);
            Tween.get(_this.myTip)
                .wait((mt > rt ? mt : rt) + 100)
                .to({ scaleX: 1, scaleY: 1 }, 300, Ease.quadInOut);
            Tween.get(_this.robotTip)
                .wait((mt > rt ? mt : rt) + 100)
                .to({ scaleX: 1, scaleY: 1 }, 300, Ease.quadInOut)
                .call(function () {
                Tween.get(_this.btn)
                    .to({ alpha: 1 }, 300)
                    .call(function () {
                    Tween.get(_this.btn, { loop: true })
                        .to({ scaleX: 1.12, scaleY: 1.12 }, 1000, Ease.getPowInOut(1.2))
                        .to({ scaleX: 1, scaleY: 1 }, 1000, Ease.getPowInOut(1.2));
                });
            });
        });
    };
    OverScene.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        Tween.removeTweens(this);
        Tween.removeTweens(this.ctn);
        Tween.removeTweens(this.myTip);
        Tween.removeTweens(this.robotTip);
        Tween.removeTweens(this.btn);
    };
    return OverScene;
}(Scene_1.Scene));
exports.default = OverScene;
var Avatar = (function (_super) {
    __extends(Avatar, _super);
    function Avatar(avatar, userNick) {
        var _this = _super.call(this) || this;
        var robotImg = UI_1.default.Sp(_this, "");
        robotImg.texture = (avatar instanceof Texture)
            ? avatar
            : Texture.fromUrl(avatar);
        robotImg.width = robotImg.height = 165;
        robotImg.anchorTexture.set(0.5, 0.5);
        _this.once(Event.ADDED_TO_STAGE, function () {
            robotImg.mask = UI_1.default.Circle(_this, 0, 0, 82);
            robotImg.addEventListener(Event.ENTER_FRAME, function () {
                robotImg.mask._boundsID++;
            });
        });
        UI_1.default.Txt(_this, userNick, 34, "#ffffff", TEXT_ALIGN.CENTER, 500, -253, 120);
        return _this;
    }
    return Avatar;
}(Container));
exports.Avatar = Avatar;


/***/ }),

/***/ "./src/scenes/PreScene.ts":
/*!********************************!*\
  !*** ./src/scenes/PreScene.ts ***!
  \********************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var ctrls_1 = __webpack_require__(/*! ../../module/ctrls */ "./module/ctrls/index.ts");
var Scene_1 = __webpack_require__(/*! ../../module/views/Scene */ "./module/views/Scene.ts");
var Tools_1 = __webpack_require__(/*! ../Tools */ "./src/Tools.ts");
var UI_1 = __importDefault(__webpack_require__(/*! ../UI */ "./src/UI.ts"));
var GameScene_1 = __importDefault(__webpack_require__(/*! ./GameScene/GameScene */ "./src/scenes/GameScene/GameScene.ts"));
var OverScene_1 = __webpack_require__(/*! ./OverScene */ "./src/scenes/OverScene.ts");
var Tween = FYGE.Tween;
var Ease = FYGE.Ease;
var PreScene = (function (_super) {
    __extends(PreScene, _super);
    function PreScene() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(PreScene.prototype, "groupNames", {
        get: function () {
            return ["PreScene"];
        },
        enumerable: false,
        configurable: true
    });
    PreScene.prototype.initUi = function () {
        var _this = this;
        UI_1.default.Sp(this, "preBg.jpg");
        var _a = Tools_1.Tools.globalData, avatar = _a.avatar, nickName = _a.nickName;
        var blue = this.blue = UI_1.default.Ctn(this, -1624, 973);
        UI_1.default.Sp(blue, "pre蓝.png", 0, 467);
        var red = this.red = UI_1.default.Ctn(this, 1624, -973);
        UI_1.default.Sp(red, "pre红.png", 253, 298);
        var myCtn = new OverScene_1.Avatar(avatar, nickName);
        var robotCtn = new OverScene_1.Avatar(this.data.robot.avatar, this.data.robot.userNick);
        if (Tools_1.Tools.myActivityInfo.todaySelectTeam == 1) {
            blue.addChild(myCtn).position.set(138, 830);
            red.addChild(robotCtn).position.set(616, 830);
        }
        else {
            red.addChild(myCtn).position.set(616, 830);
            blue.addChild(robotCtn).position.set(138, 830);
        }
        var light = this.light = UI_1.default.Sp(this, "pre光.png", 0, 446);
        light.mouseChildren = light.mouseEnable = false;
        light.visible = false;
        Tween.get(this)
            .wait(100)
            .call(function () {
            Tween.get(blue)
                .to({ x: 0, y: 0 }, 600, Ease.quadOut)
                .call(function () {
                light.visible = true;
                light.alpha = 0;
                Tween.get(light, { loop: true })
                    .to({ alpha: 1 }, 1000, Ease.quadInOut)
                    .to({ alpha: 0 }, 1000, Ease.quadInOut);
            });
            Tween.get(red)
                .to({ x: 0, y: 0 }, 600, Ease.quadOut)
                .wait(2000)
                .call(function () {
                ctrls_1.changeScene(GameScene_1.default, _this.data);
            });
        });
    };
    PreScene.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        Tween.removeTweens(this);
        Tween.removeTweens(this.blue);
        Tween.removeTweens(this.red);
    };
    return PreScene;
}(Scene_1.Scene));
exports.default = PreScene;


/***/ })

/******/ });
});
//# sourceMappingURL=output.js.map