import React, { useState, useEffect, useRef } from 'react'
import { View } from '@tarojs/components'
import ContainerFit from '@/components/_base/ContainerFit/ContainerFit'
import TitleImg from '@/components/_tb_comps/TitleImg/TitleImg'
import GoodsList from '@/components/_tb_comps/GoodsList/GoodsList'
import { useRouter } from '@tarojs/taro'
import tbccTs from 'tbcc-sdk-ts'
import API from '@/api'
import { useThrottle } from '@/hooks/useThrottle'
import styles from './cartGoods.module.less'
import { CART_CONFIG, CART_TYPE } from '@/config/cart.config'

const { commonToast, showSkuModal } = tbccTs.tb

function CartGoodsPage() {
  const router = useRouter()
  const [goodsList, setGoodsList] = useState([])
  const { itemIds } = router?.params
  // 收藏状态
  const collectflag = useRef(false)

  useEffect(() => {
    getGoodsList()
  }, [])

  const getGoodsList = async () => {
    const { data } = await API.getCollectGoods({ key: CART_CONFIG.taskType, itemIds })
    setGoodsList(data?.list || [])
  }
  // 加入购物车 // 对应itemId为 574141925233 skuId为4018047819826 数量为4
  const onCompleteTask = useThrottle(async (itemId, collected) => {
    console.log(itemId)
    if (collected && CART_CONFIG.type === CART_TYPE.ONE) {
      commonToast('您已加购过该商品了')
      return;
    }
    if(collectflag.current && CART_CONFIG.type === CART_TYPE.ONE) {
      commonToast('该任务今天已完成，明天再来吧~')
    }
    const { status, quantity } = await showSkuModal(String(itemId))
    if (status == "addCartSuccess") {
      const { success } = await API.completeTask({ key: CART_CONFIG.taskType, itemId, count: quantity })
      if (success) {
        collectflag.current = true
        getGoodsList()
        commonToast('加购成功')
      }
    }
  }, 2000);

  return (
    <ContainerFit bg={CART_CONFIG.bg}>
      <View className={styles['page-content__title']}>
        <TitleImg config={CART_CONFIG.head}/>
      </View>
      <View className={styles['page-content__list']}>
        <GoodsList goodsList={goodsList} task={CART_CONFIG} onOpenDetail={(itemId,collected) => onCompleteTask(itemId,collected)} />
      </View>
    </ContainerFit>
  )
}

export default CartGoodsPage
