/** @format */
import { UserService, TaskService } from '../service';
export default class Task {
    /**
     * 任务列表
     */
    getTaskList(context: Context, { userInfo, vipInfo, activityInfo, session }: IControllerInfos, [taskService]: [TaskService]): Promise<Result>;
    /**
     *  完成关注店铺任务
     */
    doFollowTask(context: Context, { userInfo, activityInfo }: IControllerInfos, [TaskService]: [TaskService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result>;
    /**
     *  积分兑换次数
     */
    doExchangeCreditsTask(context: Context, { userInfo, activityInfo, session }: IControllerInfos, [userService, taskService]: [UserService, TaskService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result>;
    /**
     * 浏览商品
     */
    doBrowseGoodsTask(context: Context, { userInfo, activityInfo }: IControllerInfos, [taskService]: [TaskService]): Promise<import("taobao-mini-sdk/lib/utils/resultmodel").Result>;
}
