"use strict";
/** @format */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var db_1 = require("../db");
var sdk_1 = require("../sdk");
var constants_1 = require("../constants");
var xlsx = require("node-xlsx");
/** @format */
var StatController = /** @class */ (function () {
    function StatController() {
    }
    /**
     *  统计数据
     */
    StatController.prototype.getStats = function (context) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, activityId, startDay, endDay, userDao, accessDao, recordDao, awardsDao, oneDay, xlsxData, day, PV, UV, newUV, vipPV, noVipPV, vipUV, noVipUV, newVipUV, followPV, followUV, inviteSuccessUV, receiveShareUV, receiveShareVipUV, receiveShareNoVipUV, keyValueMapper, tommorrow, buffer, result, e_1;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = context.data, activityId = _a.activityId, startDay = _a.startDay, endDay = _a.endDay;
                        userDao = new sdk_1.BaseDao(context, db_1.USER_DB_NAME);
                        accessDao = new sdk_1.BaseDao(context, db_1.ACCESS_DB_NAME);
                        recordDao = new sdk_1.BaseDao(context, db_1.RECORD_DB_NAME);
                        awardsDao = new sdk_1.BaseDao(context, db_1.AWARDS_DB_NAME);
                        oneDay = 24 * 3600 * 1000;
                        xlsxData = [];
                        _b.label = 1;
                    case 1:
                        _b.trys.push([1, 19, , 20]);
                        day = startDay;
                        _b.label = 2;
                    case 2:
                        if (!(new Date(day).getTime() <= new Date(endDay).getTime())) return [3 /*break*/, 17];
                        return [4 /*yield*/, accessDao.count({ activityId: activityId, createDay: day })
                            // 访问UV
                        ];
                    case 3:
                        PV = _b.sent();
                        return [4 /*yield*/, accessDao.aggregate([
                                { $match: { activityId: activityId, createDay: day } },
                                { $group: { _id: '$openId', count: { $sum: 1 } } }
                            ])];
                    case 4:
                        UV = (_b.sent()).length;
                        return [4 /*yield*/, userDao.count({
                                activityId: activityId,
                                createDay: day
                            })
                            // 已入会PV
                        ];
                    case 5:
                        newUV = _b.sent();
                        return [4 /*yield*/, accessDao.count({ activityId: activityId, createDay: day, isVip: true })
                            // 未入会PV
                        ];
                    case 6:
                        vipPV = _b.sent();
                        return [4 /*yield*/, accessDao.count({ activityId: activityId, createDay: day, isVip: false })
                            // 已入会UV
                        ];
                    case 7:
                        noVipPV = _b.sent();
                        return [4 /*yield*/, accessDao.aggregate([
                                { $match: { activityId: activityId, createDay: day, isVip: true } },
                                { $group: { _id: '$openId', count: { $sum: 1 } } }
                            ])];
                    case 8:
                        vipUV = (_b.sent()).length;
                        return [4 /*yield*/, accessDao.aggregate([
                                { $match: { activityId: activityId, createDay: day, isVip: false } },
                                { $group: { _id: '$openId', count: { $sum: 1 } } }
                            ])];
                    case 9:
                        noVipUV = (_b.sent()).length;
                        return [4 /*yield*/, userDao.count({
                                activityId: activityId,
                                'member.newMember': true,
                                'member.bememberDay': day
                            })];
                    case 10:
                        newVipUV = _b.sent();
                        return [4 /*yield*/, recordDao.count({
                                activityId: activityId,
                                createDay: day,
                                recordType: constants_1.RECORD_TYPE.FOLLOW_TASK.type
                            })];
                    case 11:
                        followPV = _b.sent();
                        return [4 /*yield*/, recordDao.aggregate([
                                { $match: { activityId: activityId, createDay: day, recordType: constants_1.RECORD_TYPE.FOLLOW_TASK.type } },
                                { $group: { _id: '$openId', count: { $sum: 1 } } }
                            ])];
                    case 12:
                        followUV = (_b.sent()).length;
                        return [4 /*yield*/, recordDao.aggregate([
                                { $match: { activityId: activityId, createDay: day, recordType: constants_1.RECORD_TYPE.INVITE_SUCCESS.type } },
                                { $group: { _id: '$inviteId', count: { $sum: 1 } } }
                            ])];
                    case 13:
                        inviteSuccessUV = (_b.sent()).length;
                        return [4 /*yield*/, recordDao.aggregate([
                                { $match: { activityId: activityId, createDay: day, recordType: constants_1.RECORD_TYPE.RECEIVE_INVITE.type } },
                                { $group: { _id: '$openId', count: { $sum: 1 } } }
                            ])];
                    case 14:
                        receiveShareUV = (_b.sent()).length;
                        return [4 /*yield*/, accessDao.aggregate([
                                { $match: { activityId: activityId, createDay: day, isReceiveShare: true, isVip: true } },
                                { $group: { _id: '$openId', count: { $sum: 1 } } }
                            ])];
                    case 15:
                        receiveShareVipUV = (_b.sent()).length;
                        return [4 /*yield*/, accessDao.aggregate([
                                { $match: { activityId: activityId, createDay: day, isReceiveShare: true, isVip: false } },
                                { $group: { _id: '$openId', count: { $sum: 1 } } }
                            ])];
                    case 16:
                        receiveShareNoVipUV = (_b.sent()).length;
                        keyValueMapper = {
                            时间: day,
                            访问PV: PV,
                            访问UV: UV,
                            新增UV: newUV,
                            已入会PV: vipPV,
                            已入会UV: vipUV,
                            未入会PV: noVipPV,
                            未入会UV: noVipUV,
                            新入会UV: newVipUV,
                            关注店铺完成PV: followPV,
                            关注店铺完成UV: followUV,
                            // 签到PV: signTaskPV,
                            // 签到UV: signTaskUV,
                            邀请好友完成UV: inviteSuccessUV,
                            带来好友UV: receiveShareUV,
                            带来好友已入会UV: receiveShareVipUV,
                            带来好友未入会UV: receiveShareNoVipUV
                        };
                        if (day === startDay) {
                            xlsxData.push(Object.keys(keyValueMapper));
                        }
                        // @ts-ignore
                        xlsxData.push(Object.values(keyValueMapper));
                        tommorrow = new Date(day).getTime() + oneDay;
                        day = sdk_1.dateFormatter(sdk_1.transformBeijingDate(tommorrow), 'yyyy/MM/dd');
                        return [3 /*break*/, 2];
                    case 17:
                        buffer = xlsx.build([
                            {
                                name: "\u6570\u636E\u7EDF\u8BA1" + startDay.replace(/\//g, '-') + "-" + endDay.replace(/\//g, '-'),
                                data: xlsxData
                            }
                        ]);
                        return [4 /*yield*/, context.cloud.file.uploadFile({
                                fileContent: buffer,
                                fileName: "\u6570\u636E\u7EDF\u8BA1" + startDay.replace(/\//g, '-') + "-" + endDay.replace(/\//g, '-') + ".xlsx"
                            })];
                    case 18:
                        result = _b.sent();
                        console.log(xlsxData, 'xlsxData');
                        if (result.url) {
                            result.url = result.url.replace('http', 'https').replace('-internal', '');
                        }
                        return [2 /*return*/, sdk_1.resultsModel.success(result.url)];
                    case 19:
                        e_1 = _b.sent();
                        console.log('上传文件出错', e_1);
                        // 打印日志
                        return [2 /*return*/, sdk_1.resultsModel.error(constants_1.CODE_TYPES.SYSTEM_ERROR, "\u4E0A\u4F20\u6587\u4EF6\u9519\u8BEF")];
                    case 20: return [2 /*return*/];
                }
            });
        });
    };
    return StatController;
}());
exports.default = StatController;
//# sourceMappingURL=stat.controller.js.map