const { Utils } = require('taobao-mini-sdk/lib/index').default;
const { dateFormatter,transformBeijingDate } = Utils.default;
const xlsx = require("node-xlsx");

//埋点数据类型
const STAT_TYPE = {
  newAddUv:'newAddUv',//首次进入uv 1
  accesssPv:'accesssPv',//访问pv 1
  accesssUv:'accesssUv',//访问uv
  joinGamePv:'joinGamePv',//参与pv 1
  joinGameUv:'joinGameUv',//参与uv
  countFollow:'countFollow',//关注店铺完成pv 1
  dayLogin:'dayLogin',//每日登录任务完成 1
  completeInvited:'completeInvited',//邀请好友任务完成Pv 1
  invitedMember: 'invitedMember',//带来好友已入会(未入会isvip) 1
  beBrowse:'beBrowse',//每日浏览完成uv 1
  exchanageCredit:'exchanageCredit',//积分兑换砖石pv(前端)
  inviteFriend:'inviteFriend',//邀请好友发起Pv(前端)
  useNormal:'useNormal',//款鞋一使用pv
  usePrimary:'usePrimary',//款鞋二使用pv 
  useMedium:'useMedium',//款鞋三使用pv 
  consumption:'consumption',//每日消费uv(点击去下单) (前端)
  exchanagePrize:'exchanagePrize',//每日兑换uv(兑换商场)(前端)
  addShoesUv:'addShoesUv',//获得碎片Uv 1
  reduceShoesUv:'reduceShoesUv',//使用碎片Uv
  addCardUv:'addCardUv',//获得复活卡Uv 1
  reduceCardUv:'reduceCardUv',//使用复活卡Uv 1
  reduceDiamondUv:'reduceDiamondUv',//消耗砖石Uv
  reduceCreditUv:'reduceCreditUv',//消耗积分Uv
  countDiamond:'countDiamond',//当日累计消耗砖石
  countCredit:'countCredit',//当日累计消耗积分
  countMember:'countMember',//入会人数
  countShoes:'countShoes',//碎片获取总量
  useCountShoes:'useCountShoes',//碎片使用总量
  countCards:'countCards',//复活卡获取总量
  useCountCards:'useCountCards',//复活卡使用总量
  assistRecord:'assistRecord',//助力记录
  orderPrice:'orderPrice',//订单价格
}

function getAggSql(
  matchInfo,
  day,
  isUv = false,
  isTotal = false,
  isPrice = false
) {
  let groupObj = isUv
    ? {
        _id: {
          day: "$createDay",
          openId: "$openId",
        },
        number: { $sum: 1 },
      }
    : {
        _id: "$createDay",
        number: { $sum: 1 },
      };
  groupObj = isTotal
    ? { ...groupObj, totalValue: { $push: isPrice ? "$price" : "$value" } }
    : groupObj;
  return [
    {
      $match: { ...matchInfo, createDay: day },
    },
    {
      $group: groupObj,
    },
  ];
}

exports.getStat = async (context) => {
  let { startDay, endDay, activityId } = context.data;
  const { cloud } = context;
  if (!startDay) return false;
  if(!endDay) {
    endDay = startDay
  }
  let statDb = cloud.db.collection("c_stat_info");
  let accessDb = cloud.db.collection("c_user_access");
  let joinDb = cloud.db.collection("c_user_join");
  let userDb = cloud.db.collection("c_user");
  let awardsDb = cloud.db.collection("c_awards_info");
  let oneDay = 24 * 3600 * 1000;
  let day = startDay;
  let xlsxList = [
    [
      "日期",
      "新增uv",
      "访问pv(已入会)",
      "访问pv(未入会)",
      "访问uv(已入会)",
      "访问uv(未入会)",
      "总访问uv",
      "参与pv(已入会)",
      "参与pv(未入会)",
      "参与uv(已入会)",
      "参与uv(未入会)",
      "总参与uv",
      "入会人数",
      "累计消耗钻石",
      "累计消耗积分",
      "鞋款1使用uv",
      "鞋款2使用uv",
      "鞋款3使用uv",
      // "下单金额",
      "关注店铺完成uv",
      "每日登录完成uv",
      "积分兑换砖石pv",
      "积分兑换砖石uv",
      "邀请好友任务发起pv",
      "邀请好友任务发起uv",
      "邀请好友任务完成pv",
      "邀请好友任务完成uv",
      // "带来好友已入会",
      // "带来好友未入会",
      "每日浏览完成uv",
      "每日消费uv",
      "每日兑换uv",
      "碎片获取总量",
      "碎片使用总量",
      "复活卡获取总量",
      "复活卡使用总量",
    ],
  ];
  while (new Date(day).getTime() <= new Date(endDay).getTime()) {
    let newAddUv = await statDb.aggregate(
      getAggSql({ activityId, type: STAT_TYPE.newAddUv }, day, true)
    );
    let vipAccessPv = await accessDb.aggregate(
      getAggSql({ activityId, isVip: true }, day, false)
    );
    let notVipAccessPv = await accessDb.aggregate(
      getAggSql({ activityId, isVip: false }, day, false)
    );
    let vipAccessUv = await accessDb.aggregate(
      getAggSql({ activityId, isVip: true }, day, true)
    );
    let notVipAccessUv = await accessDb.aggregate(
      getAggSql({ activityId, isVip: false }, day, true)
    );

    //总访问uv
    let accessCountUv = await accessDb.aggregate(
      getAggSql({ activityId }, day, true)
    );

    let vipJoinGamePv = await joinDb.aggregate(
      getAggSql({ activityId, isVip: true }, day, false)
    );
    let noVipJoinGamePv = await joinDb.aggregate(
      getAggSql({ activityId, isVip: false }, day, false)
    );
    let vipJoinGameUv = await joinDb.aggregate(
      getAggSql({ activityId, isVip: true }, day, true)
    );
    let noVipJoinGameUv = await joinDb.aggregate(
      getAggSql({ activityId, isVip: false }, day, true)
    );

    //总参与uv
    let joinCountUv = await joinDb.aggregate(
      getAggSql({ activityId }, day, true)
    );

    let countMember = await statDb.aggregate(
      getAggSql({ activityId, type: STAT_TYPE.countMember }, day, true)
    );

    //当日累计消耗砖石
    let countDiamond = await statDb.aggregate(
      getAggSql({ activityId, type: STAT_TYPE.reduceDiamondUv }, day, true, true)
    );

    //当日累计消耗积分
    let countCredit = await statDb.aggregate(
      getAggSql({ activityId, type: STAT_TYPE.reduceCreditUv }, day, true, true)
    );
    //款鞋使用
    let shoeUse1 = await statDb.aggregate(
      getAggSql({ activityId, type: STAT_TYPE.useNormal },day, true )
    );
    let shoeUse2 = await statDb.aggregate(
      getAggSql({ activityId, type: STAT_TYPE.usePrimary },day, true )
    );
    let shoeUse3 = await statDb.aggregate(
      getAggSql({ activityId, type: STAT_TYPE.useMedium },day, true )
    );

    //下单金额 
    let orderPrice = await statDb.aggregate(
      getAggSql({ activityId, type: STAT_TYPE.orderPrice }, day, false, true )
    );
    //关注店铺 
    let countFollow = await statDb.aggregate(
      getAggSql({ activityId, type: STAT_TYPE.countFollow }, day, true )
    );
    //每日登录完成 
    let dayLogin = await userDb.aggregate(
      [
        {
          $match: { activityId, [`taskInfo.${day}.sign.status`]: 2},
        },
        {
          $group: { _id: "$openId", number: { $sum: 1 } },
        }
      ]
    );
    //每日兑换pv
    let exchanageCreditPv = await statDb.aggregate(
      getAggSql({ activityId, type: STAT_TYPE.exchanageCredit }, day, false )
    );
    //每日兑换uv
    let exchanageCreditUv = await statDb.aggregate(
      getAggSql({ activityId, type: STAT_TYPE.exchanageCredit }, day, true )
    );
    //邀请好友发起pv
    let inviteFriendPv = await statDb.aggregate(
      getAggSql({ activityId, type: STAT_TYPE.inviteFriend }, day, false )
    );
    //邀请好友发起uv
    let inviteFriendUv = await statDb.aggregate(
      getAggSql({ activityId, type: STAT_TYPE.inviteFriend }, day, true )
    );
    //邀请好友完成pv
    let completeInvitedPv = await statDb.aggregate(
      getAggSql({ activityId, type: STAT_TYPE.completeInvited }, day, false )
    );
    //邀请好友完成uv
    let completeInvitedUv = await statDb.aggregate(
      getAggSql({ activityId, type: STAT_TYPE.completeInvited }, day, true )
    );
    //带来好友已入会
    let isVipInvitedMember = await statDb.aggregate(
      getAggSql({ activityId, type: STAT_TYPE.invitedMember, isvip: true }, day, true )
    );
    //带来好友未入会
    let noIsVipInvitedMember = await statDb.aggregate(
      getAggSql({ activityId, type: STAT_TYPE.invitedMember, isvip: false }, day, true )
    );
    //每日浏览完成
    let beBrowse = await statDb.aggregate(
      getAggSql({ activityId, type: STAT_TYPE.beBrowse }, day, true )
    );
    //每日消费
    let consumption = await statDb.aggregate(
      getAggSql({ activityId, type: STAT_TYPE.consumption }, day, true )
    );

    //碎片获取总量
    let countShoes = await statDb.aggregate(
      getAggSql({ activityId, type: STAT_TYPE.addShoesUv }, day, false, true )
    );
    //碎片使用总量
    let timeRangePre = (new Date(day)).getTime()
    let timeRangeNext = (new Date(day)).getTime() + 24 * 3600 * 1000 - 1

    //每日兑换
    let exchanagePrize = await awardsDb.aggregate(
      [
        {
          $match: { activityId, prizeType: 2, createTime: { $gt : timeRangePre, $lte : timeRangeNext } },
        },
        {
          $group: { _id: "$openId", number: { $sum: 1 } },
        }
      ]
    );

    let countReduceShoes = await awardsDb.aggregate(
      [
        {
          $match: { activityId, prizeType: 2, createTime: { $gt : timeRangePre, $lte : timeRangeNext } },
        },
        {
          $group: { _id: "$createTime", number: { $sum: 1 }, totalValue: { $push: "$exchangeValue" } },
        },
      ]
    );
    //复活卡获取总量
    let countCards = await statDb.aggregate(
      getAggSql({ activityId, type: STAT_TYPE.addCardUv }, day, false, true )
    );
    //复活卡使用总量
    let countReduceCards = await statDb.aggregate(
      getAggSql({ activityId, type: STAT_TYPE.reduceCardUv }, day, false, true )
    );

    xlsxList.push([
      day,
      newAddUv.length || 0,
      (vipAccessPv[0] && vipAccessPv[0].number) || 0,
      (notVipAccessPv[0] && notVipAccessPv[0].number) || 0,
      vipAccessUv.length || 0,
      notVipAccessUv.length || 0,
      accessCountUv.length || 0,
      (vipJoinGamePv[0] && vipJoinGamePv[0].number) || 0,
      (noVipJoinGamePv[0] && noVipJoinGamePv[0].number) || 0,
      vipJoinGameUv.length || 0,
      noVipJoinGameUv.length || 0,
      joinCountUv.length || 0,
      countMember.length || 0,
      (countDiamond.length &&
        countDiamond.reduce((s, v) => {
          return (s = v.totalValue.reduce((m, i) => {
            return (m += i);
          }, s));
        }, 0)) || 0,
      (countCredit.length &&
        countCredit.reduce((s, v) => {
          return (s = v.totalValue.reduce((m, i) => {
            return (m += i);
          }, s));
        }, 0)) || 0,
      shoeUse1.length || 0,
      shoeUse2.length || 0,
      shoeUse3.length || 0,
      // (orderPrice.length &&
      //   orderPrice.reduce((s, v) => {
      //     return (s = v.totalValue.reduce((m, i) => {
      //       return (m += i);
      //     }, s));
      //   }, 0)) || 0,
      countFollow.length || 0,
      dayLogin.length || 0,
      (exchanageCreditPv[0] && exchanageCreditPv[0].number) || 0,
      exchanageCreditUv.length || 0,
      (inviteFriendPv[0] && inviteFriendPv[0].number) || 0,
      inviteFriendUv.length || 0,
      (completeInvitedPv[0] && completeInvitedPv[0].number) || 0,
      completeInvitedUv.length || 0,
      // isVipInvitedMember.length || 0,
      // noIsVipInvitedMember.length || 0,
      beBrowse.length || 0,
      consumption.length || 0,
      exchanagePrize.length || 0,
      (countShoes.length &&
        countShoes.reduce((s, v) => {
          return (s = v.totalValue.reduce((m, i) => {
            return (m += i);
          }, s));
        }, 0)) || 0,
        (countReduceShoes.length &&
        countReduceShoes.reduce((s, v) => {
          return (s = v.totalValue.reduce((m, i) => {
            return (m += i);
          }, s));
        }, 0)) || 0,
        (countCards.length &&
        countCards.reduce((s, v) => {
          return (s = v.totalValue.reduce((m, i) => {
            return (m += i);
          }, s));
        }, 0)) || 0,
        (countReduceCards.length &&
        countReduceCards.reduce((s, v) => {
          return (s = v.totalValue.reduce((m, i) => {
            return (m += i);
          }, s));
        }, 0)) || 0,
    ]);

    //时间+1
    let tommorrow = new Date(day).getTime() + oneDay;
    day = dateFormatter(transformBeijingDate(tommorrow), 'yyyy/MM/dd');
  }
  let buffer = xlsx.build([
    {
      name: "斯凯奇奔跑吧数据",
      data: xlsxList,
    },
  ]);
  // console.log(`xlsxData: ${JSON.stringify(xlsxData)}`);
  try {
    let result = await cloud.file.uploadFile({
      fileContent: buffer,
      fileName: "斯凯奇奔跑吧数据" + Date.now() + ".xlsx",
    });
    // result.url 需进行处理
    return result.url;
  } catch (e) {
    console.log("上传文件出错", e);
    // 打印日志
    return false;
  }
};

exports.getTopUser = async (context) => {
  const { activityId } = context.data;
  const { cloud } = context;
  let userDb = cloud.db.collection("c_user");
  let res = await userDb.find(
    {
      activityId,
    },
    {
      sort: {
        totalScore: -1,
      },
      limit: 100,
    }
  );
  return res;
};

exports.inset100User = async (context) => {
  const { cloud } = context;
  let userDb = cloud.db.collection("c_user");
  for(let i = 0;i < 90; i++) {
    let recod = {
      "remainTimes": {
        "newMember": 0,
        "browseGoods": 0,
        "sign": 0,
        "member": 1,
        "invites": 0,
        "orders": 0,
        "follow": 0
      },
      "totalShoes": 20,
      "openId": "AAGvCTXPAL-pl8nrX7woalGD",
      "rankPrizePop": 0,
      "guideComplete": true,
      "activityId": "5f3b3b6e9da6714ab709b859",
      "userNick": "duiba2",
      "member": {
        "newMember": false,
        "flag": true
      },
      "taskInfo": {},
      "info": {
        "2020/08/26": {
          "login": 1
        }
      },
      "initialCredits": 0,
      "inviteId": "",
      "resurgenceCards": 0,
      "createDay": "2020/08/26",
      "updateTime": 1598433994730,
      "avatar": "http://wwc.alicdn.com/avatar/getAvatar.do?userIdStr=MHx4MCMHP8xSPGx0PCxGPHxWPGxYPCxWXFv4P8xWPkQT&width=80&height=80&type=sns",
      "maxScore": 355,
      "follow": {
        "flag": false,
        "newFollow": false
      },
      "totalScore": 1392,
      "diamond": 0,
      "maxScoreTime": 1598433994730,
      "createTime": 1598431915312,
      "recordTask": {
        "followStatus": 0,
        "invites": [],
        "memberStatus": 1,
        "orders": []
      },
      "toolInfo": {
        "normal": 1,
        "medium": 0,
        "primary": 0
      }
    }
    console.log('oneUser:'+JSON.stringify(recod))
    await userDb.insertOne(recod)
  }
};

//测试方法 5f35eded0cb7330c94e04eda  5f3b3b6e9da6714ab709b859
// {
//   "handler": "getStat",
//   "data": {
//     "activityId":"5f50641e3075d9e976e28d72",
//     "startDay":"2020/09/03",
//     "endDay":"2020/09/03"
//   }
// }
