
/**
 * 增加埋点数据PV
 * @param {
 * "openId":"",
 * "activityId":"",
 * "type":"",
 * "value":"自定义"} data 
 */
const statInsertPV = async (context, data) => {
    let {
        openId,
        activityId,
        type
    } = data;
    const dbName = 'c_stat_info';
    const db = context.cloud.db;

    if (!openId || !activityId || !type) {
        console.log('埋点数据参数为空');
        return null;
    }
    data['dayTime'] = getToday();
    data['createTime'] = Date.now();
    data['updateTime'] = Date.now();
    try {
        return await db.collection(dbName).insertOne(data);
    } catch (e) {
        console.log(`添加记录失败-${dbName}：`, e);
        return false;
    }
}

/**
 * 增加埋点数据UV
 * @param {
 * "openId":"",
 * "activityId":"",
 * "type":"",
 * "value":"自定义"} data 
 */
const statInsertUV = async (context, data) => {
    let {
        openId,
        activityId,
        type
    } = data;
    if (!openId || !activityId || !type) {
        console.log('埋点数据参数为空');
        return null;
    }
    const dbName = 'c_stat_info';
    const db = context.cloud.db;

    let record = await db.collection(dbName).findOne({
        openId,
        activityId,
        type,
        dayTime: getToday()
    });
    if (null == record) {
        data['dayTime'] = getToday();
        data['createTime'] = Date.now();
        data['updateTime'] = Date.now();
        return await db.collection(dbName).insertOne(data);
    }
    return true;
}

module.exports = {
  statInsertPV,
  statInsertUV
}