const logger = (methodName, params) => {
  console.log(`调用方法: ${methodName}`, params);
}

// 发送错误日志
const addErrorLog = async (context, data = {}) => {
  if (!context) return false;
  const {
    openId,
    data: { activityId }
  } = context;
  const dbName = 'error_log';
  const db = context.cloud.db;
  const { functionName, errorMessage, catchType = 1 } = data;
  const record = {
    openId,
    activityId,
    functionName,
    errorMessage,
    catchType,
    createTime: Date.now()
  };
  try {
    return await db.collection(dbName).insertOne(record);
  } catch (e) {
    console.log(`添加记录失败-${dbName}：`, e);
    return false;
  }
};

module.exports = {
  logger,
  addErrorLog
}