/**
 * 访问明细
 */
const { BaseDao } = require("../sdk");
const { getToday } = require("../utils");
const { USER_JOIN_DB_NAME } = require("../db");

class UserJoinService {
  constructor(context) {
    this.context = context;
    this.userJoinDao = new BaseDao(context, USER_JOIN_DB_NAME);
  }

  // 用户开始游戏
  async insertGameInfo(userInfo) {
    const { openId, data } = this.context;
    const { activityId } = data;
    return this.userJoinDao.insertOne({
      openId,
      activityId,
      ...userInfo,
      createTime: Date.now(),
      updateTime: Date.now(),
      createDay: getToday(),
    });
  }

  // 更新用户游戏数据
  async updateGameInfo(_id, activityId, info) {
    return this.userJoinDao.update(
      {
        _id,
        activityId,
      },
      {
        $set: {
          ...info,
          updateTime: Date.now(),
        },
      }
    );
  }

  async getGameInfo(_id, activityId) {
    return this.userJoinDao.findOne({
      _id,
      activityId,
    });
  }

  async getGameInfoListByToolType(activityId, toolType) {
    const { openId } = this.context;
    return this.userJoinDao.find({
      activityId,
      openId,
      toolType,
    });
  }

  async getUserJoinTotalScore(activityId) {
    const { openId } = this.context;
    return this.context.cloud.db.collection(USER_JOIN).aggregate([
      {
        $match: { activityId, openId },
      },
      {
        $group: {
          _id: "$toolType",
          score: { $sum: "$score" },
        },
      },
    ]);
  }

  async getJoinCount(activityId, openId) {
    return this.userJoinDao.count({
      activityId,
      openId,
    });
  }
}

module.exports = UserJoinService;
