/**
 * 任务
 */
const UserService = require('./user.service');
const GameService = require('./game.service')
const StatService = require("./stat.service");
const { TBAPIS, transformBeijingDate } = require('../sdk');
const {
  CODE_TYPES, TASK_TYPE, TASK_TYPE_WIN, BUY_GOODS_LIMIT, DRAW_STATUS, DATA_TYPE, FIRST_DIAMOND
} = require('../constants');
const { getToday, getSellerSession, getUserOrderlist, statInsertPV, statInsertUV } = require('../utils')

class TaskService extends UserService {

  async getGoodsList(ids) {
    let { session } = await getSellerSession(this.context);

    let result = await TBAPIS.getItemListByItemIds(this.context, session, ids, {});

    console.log('result', result);
    let items = (result.items && result.items.item) || [];
    let list = items.map(v => {
      return {
        url: v.detail_url,
        id: v.num_iid,
        name: v.title,
        image: v.pic_url,
        desc: v.desc,
        price: v.price
      }
    });

    return list;
  }

  //完成任务
  async doCompleteTask(userInfo, taskType, isNewVip = 1) {
    if (taskType === TASK_TYPE.INVITES) {
      return await this.doInvitesTask(userInfo, isNewVip);
    } else if (taskType === TASK_TYPE.FOLLOW) {
      return await this.doFollowTask(userInfo);
    }else if (taskType === TASK_TYPE.BROWSE) {
      return await this.doBrowseTask(userInfo);
    }
    return CODE_TYPES.PARAMS_ERROR;
  }

  // 领取任务奖励
  async receiveTaskRewards(activityInfo, userInfo, taskType) {
    if (taskType === TASK_TYPE.INVITES) {
      return await this.getInvitesTaskRewards(userInfo);
    } else if (taskType === TASK_TYPE.BUY_GOODS) {
      return await this.getBuyGoodsTaskRewards(userInfo);
    }
    else if (taskType === TASK_TYPE.FREE_MASONRYS) {
      return await this.getFreeRewards(userInfo);
    }
    else if (taskType === TASK_TYPE.FOLLOW) {
      return await this.getFollowRewards(userInfo);
    }
    else if (taskType === TASK_TYPE.BROWSE) {
      return await this.getBrowseRewards(userInfo);
    }
    else if (taskType === TASK_TYPE.EXCHANAGE) {
      return await this.getExchangeRewards(userInfo);
    }
    return CODE_TYPES.PARAMS_ERROR;
  }

  //邀请任务完成
  async doInvitesTask(userInfo) {
    const { isNewVip, inviteId, activityId } = this.context.data
    const { openId } = context;

    if (!inviteId) {
        return CODE_TYPES.PARAMS_ERROR;
    }
    if(inviteId === openId) {
        return CODE_TYPES.PARAMS_ERROR;
    }

    const { session } = await getSellerSession(this.context);
    let { isvip, url } = await this.userdao.getShopVip(session);
    if (!isvip) {
        return CODE_TYPES.ERROR_NOT_VIP
    }

    //判断是否玩过游戏
    const gameService = new GameService(this.context)
    const joinInfo = await gameService.getJoinInfo()
    if(joinInfo) {
      return CODE_TYPES.ERROR_NOT_NEW_VIP
    }

    //邀请人信息
    const inviteUserInfo = await this.userdao.getUserInfo(inviteId);

    if (!inviteUserInfo) return CODE_TYPES.ERROR_INVALID_INVITE_USER;
    const invitedInfo = await dataService.getRecordByCondition({
        activityId,
        openId,
        type: DATA_TYPE.assistRecord
    });
    //已经助力过 不能助力
    if(invitedInfo) {
      return CODE_TYPES.ERROR_ASSIST_ALREADY
    }

    //邀请者信息
    let { _id, taskInfo, remainTimes, recordTask } = inviteUserInfo
    let today = getToday()
    let todayTask = taskInfo[today]
    let oldRemain = remainTimes.invites ? remainTimes.invites : 0
    let oldMemberNum = remainTimes.newMember ? remainTimes.newMember : 0
    let oldRecord = recordTask.invites ? recordTask.invites : []
    let todayRecord = todayTask.invites ? todayTask.invites : []
    //非店铺会员
    oldMemberNum = (isNewVip - 0) == 1 ? oldMemberNum + TASK_TYPE_WIN.NEN_INVITES : oldMemberNum
    oldRemain = oldRemain + 1
    oldRecord.push({ openId, newMember: isNewVip })
    todayRecord.push({ openId, newMember: isNewVip })
    let record = {
      recordTask: {
        ...recordTask,
        invites: oldRecord
      },
      remainTimes: {
        ...remainTimes,
        invites: oldRemain,
        newMember: oldMemberNum
      },
      taskInfo: {
        ...taskInfo,
          [today]: {
            ...todayTask,
            invites: todayRecord
          }
      }
    }
    //助力成功添加记录
    await dataService.addAssistRecord(userInfo,{
        value: 4
    })
    // 更新邀请者信息
    await this.userdao.update({ _id },{ $set: record });

    // 更新被邀请者信息
    let userRecord = {
      diamond: userInfo.diamond + FIRST_DIAMOND
    }
    let result = await this.userdao.update({ _id:userInfo._id }, { $set: userRecord });
    return {
      diamond: FIRST_DIAMOND
    };
  }
  //浏览任务完成
  async doBrowseTask(userInfo) {
    let today = getToday()
    const { _id, taskInfo, remainTimes } = userInfo
    const todayTask = taskInfo[today]
    let { browserGoods: { value, status } } = todayTask
    if(status == 2) {
        return CODE_TYPES.ERROR_TASK_ALREADYRECEIVE;
    }
    let record = {
      remainTimes: {
        ...remainTimes,
        browserGoods: remainTimes.browserGoods + 1
      },
      taskInfo: {
        ...taskInfo,
        [today]: {
          ...todayTask,
          browserGoods: { value, status: 1 }
        }
      }
    }
    // 更新用户信息
    let result = await this.userdao.update({ _id }, { $set: record });

    return result;
  }
  //关注店铺任务完成
  async doFollowTask(userInfo) {
    let today = getToday()
    const { _id, remainTimes, recordTask, follow } = userInfo
    let { followStatus } = recordTask
    if(followStatus == 2 || follow.flag) {
        return CODE_TYPES.ERROR_TASK_ALREADYRECEIVE;
    }
    let record = {
      follow: {
        flag: true,
        newFollow: true,
        befollowTime: Date.now()
      },
      recordTask: {
        ...recordTask,
        followStatus: 1
      },
      remainTimes: {
        ...remainTimes,
        follow: 1
      },
    }
    // 更新用户信息
    let result = await this.userdao.update({ _id }, { $set: record });

    return result;
  }

  //领取关注店铺任务奖励
  async getFollowRewards(userInfo) {
      const { _id, diamond, remainTimes, recordTask } = userInfo
      const { follow } = remainTimes
      const { followStatus } = recordTask
      if(follow == 0 || followStatus == 2) {
        return CODE_TYPES.ERROR_TASK_NORECEIVE;
      }
      let oldDiamond = diamond ? diamond : 0

      let record = {
        diamond: oldDiamond + TASK_TYPE_WIN.FOLLOW,
        recordTask: {
          ...recordTask,
          followStatus: 2
        }
      }
      // 更新用户信息
      let result = await this.userdao.update({ _id }, { $set: record });

      return result;
  }
  //领取每日登录任务奖励
  async getFreeRewards(userInfo) {
      let today = getToday()
      const { _id, diamond, activityId } = userInfo
      const todayTask = taskInfo[today]
      let { freeDiamond: { value, status} } = todayTask
      
      if(status == 2) {
        return CODE_TYPES.ERROR_TASK_NORECEIVE;
      }
      let oldDiamond = diamond ? diamond : 0
      let record = {
          diamond: oldDiamond + value,
          taskInfo: {
            ...taskInfo,
            [today]: {
              ...todayTask,
              freeDiamond: { value, status: 2 }
            }
          }
      }
      //每日登录任务完成打点
      let statService = new StatService(this.context)
      await statService.addStat({ activityId, type: DATA_TYPE.dayLoginUv })

      // 更新用户信息
      let result = await this.userdao.update({ _id }, { $set: record });

      return result;
  }
  //领取每浏览商品任务奖励
  async getBrowseRewards(userInfo) {
      let today = getToday()
      let { _id, resurgenceCards, taskInfo, remainTimes } = userInfo
      const todayTask = taskInfo[today]
      let { browserGoods: { value, status} } = todayTask

      if(remainTimes.browserGoods == 0 || status == 2) {
        return CODE_TYPES.ERROR_TASK_NORECEIVE;
      }
      //增加复活卡次数
      let oldResurCard = resurgenceCards ? resurgenceCards : 0
      let record = {
          resurgenceCards: oldResurCard + TASK_TYPE_WIN.BROWSE,
          taskInfo: {
            ...taskInfo,
            [today]: {
              ...todayTask,
              browserGoods: { value, status: 2 }
            }
          }
      }
      //获得复活卡打点
      let statService = new StatService(this.context)
      await statService.addStatNumberUv({ activityId, type: DATA_TYPE.addCardUv, value:TASK_TYPE_WIN.BROWSE })
      // 更新用户信息
      let result = await this.userdao.update({ _id }, { $set: record });

      return result;
  }
  //领取每日兑换任务奖励
  async getExchangeRewards(userInfo) {
      let today = getToday()
      const { _id, diamond, activityId, taskInfo } = userInfo
      const todayTask = taskInfo[today]
      let { exchangeCredits } = todayTask
      let exchangeTimes = exchangeCredits ? exchangeCredits.length : []
      //无兑换任务
      if(exchangeTimes >= 2) {
        return CODE_TYPES.ERROR_TASK_NORECEIVE;
      }
      const { session } = await getSellerSession(this.context);
      let currentCredits = await this.userdao.queryUserCredits(session)
      //积分不足
      if(currentCredits < TASK_TYPE_WIN.EXCHANAGE_CREDITS) {
          return CODE_TYPES.ERROR_CREDIT_NUM;
      }

      //扣减积分
      let reduceResult = this.userdao.updateUserCredits(TASK_TYPE_WIN.EXCHANAGE_CREDITS,session)
      if(reduceResult) {
        let oldDiamond = diamond ? diamond : 0
        let oldRredit = exchangeCredits ? exchangeCredits : []
        let newRredit = oldRredit.push({
          createTime: Date.now(),
          diamond: ASK_TYPE_WIN.EXCHANAGE_CREDIT,
          value: ASK_TYPE_WIN.EXCHANAGE_CREDIT
        })
        console.log(newRredit)
        let record = {
            diamond: oldDiamond + TASK_TYPE_WIN.EXCHANAGE_CREDIT,
            initialCredits: currentCredits - TASK_TYPE_WIN.EXCHANAGE_CREDIT,
            taskInfo: {
              ...taskInfo,
              [today]: {
                ...todayTask,
                exchangeCredits: newRredit
              }
            }
        }
        //消耗积分打点
        let statService = new StatService(this.context)
        await statService.addStatNumberUv({ activityId, type: DATA_TYPE.reduceCreditUv, value:TASK_TYPE_WIN.EXCHANAGE_CREDIT })
        // 更新用户信息
        let result = await this.userdao.update({ _id }, { $set: record });

        return result;
      }
      return false;
  }
  //领取邀请任务奖励
  async getInvitesTaskRewards(userInfo) {
      let { _id, diamond, resurgenceCards, recordTask, taskInfo, remainTimes, openId, activityId } = userInfo
      let { invites, newMember } = remainTimes
      let today = getToday()
      //领取次数
      diamond += invites * TASK_TYPE_WIN.INVITES
      resurgenceCards += newMember
      let newRecord = taskInfo[today].invites ? taskInfo[today].invites : []
      let oldRecord = recordTask.invites ? recordTask.invites : []
      newRecord.forEach(el => {
        el.times = Date.now()
        oldRecord.push (el)
      })
      let record = {
          diamond,
          resurgenceCards,
          recordTask: {
            ...recordTask,
            invites: oldRecord
          },
          remainTimes: {
            ...remainTimes,
              invites: 0,
              newMember: 0
          }
      }
      //获得复活卡打点
      if(newMember > 0) {
        let statService = new StatService(this.context)
        await statService.addStatNumberUv({ activityId, type: DATA_TYPE.addCardUv, value:newMember })
      }
      //邀请好友完成Pv Uv
      await statInsertPV({ openId, activityId, type: DATA_TYPE.completeInvitedPv })
      await statInsertUV({ openId, activityId, type: DATA_TYPE.completeInvitedUv })
      // 更新用户信息
      let result = await this.userdao.update({ _id }, { $set: record });

      return result;
  }
  async getBuyGoodsTaskRewards(userInfo) {
    let { _id, resurgenceCards, remainTimes, activityId } = userInfo
    let { orders } = remainTimes

    // 领取次数
    resurgenceCards += orders * TASK_TYPE_WIN.BUY_GOODS;

    let record = {
      resurgenceCards,
      remainTimes: {
        ...remainTimes,
        orders: 0
      },
      updateTime: Date.now()
    }
    //获得复活卡打点
    let statService = new StatService(this.context)
    await statService.addStatNumberUv({ activityId, type: DATA_TYPE.addCardUv, value:TASK_TYPE_WIN.BUY_GOODS })
    // 更新用户信息
    let result = await this.userdao.update({ _id }, { $set: record });

    return result;
  }

  //获取未生效的成功购买商品订单
  async getNewBuyGoodsOrders(activityInfo, userInfo) {
    let lastBuyTime = userInfo.createTime;
    if (!lastBuyTime) {
      return [];
    }
    //获取商品列表 
    if (!(activityInfo.tasks && activityInfo.tasks.orderGoods && activityInfo.tasks.orderGoods.itemIds)) {
      return [];
    }
    let itemIds = activityInfo.tasks.orderGoods.itemIds.split(',');

    //调用淘宝API查询用户订单
    let orders = await getUserOrderlist(this.context, lastBuyTime, Date.now());
    console.log('orders', orders);

    //已使用的订单ID
    let orderRecord = userInfo.orderRecord ? userInfo.orderRecord : [];
    let orderNums = orderRecord.map(o => o.orderId);

    //购买指定商品的新订单
    orders = orders.filter(o => {
      let flag = itemIds.indexOf(o.itemId + '') >= 0 && orderNums.indexOf(o.orderId) < 0; //&& orderNums.length < BUY_GOODS_LIMIT;
      orderNums.push(o.orderId);
      return flag;
    });

    return orders;
  }

  
  /**
   * 添加助力记录
   * @param {*} param0 
   */
  async addAssistRecord(userInfo, { value }) {
    // value  1 助力成功 2老会员不能助力  3不是会员 4 已经助力过了
    const { inviteId } = this.context.data;
    const record = await this.initRecordData(userInfo, {
      type: DATA_TYPE.assistRecord
    }, {
      inviteId,
      value
    });
    return await this.dataDao.insertOne(record);
  }

  /**
   * 查询记录
   * @param {*} conditions 
   */
  async getRecordByCondition(conditions) {
    return await this.dataDao.findOne(conditions);
  }

  /**
   * 初始化记录
   * @param {*} param0 
   * @param {*} customData 
   */
  async initRecordData(userInfo, { type }, customData = {}) {
    const { openId, data } = this.context;
    let { activityId, userNick } = data;
    if (!userNick) {
      if (userInfo) {
        userNick = userInfo.userNick;
      }
    }
    let record = {
      openId,
      activityId,
      userNick,
      type,
      createTime: Date.now(),
      createDay: getToday(),
      ...customData
    }
    return record;
  }
}

module.exports = TaskService;