/**
 * 访问明细
 */
const { BaseDao } = require("../sdk");
const { getToday } = require("../utils");
const { DATA_DB_NAME } = require("../db");

class StatService {
  constructor(context) {
    this.context = context;
    this.statService = new BaseDao(context, DATA_DB_NAME);
  }
  /**
   * 增加访问记录
   * @param {数据信息} info
   */
  async addStat(info) {
    let { openId } = this.context;
    return await this.statService.insertOne({
      ...info,
      openId,
      createTime: Date.now(),
      updateTime: Date.now(),
      createDay: getToday(),
    });
  }

  /**
   * 增加积分 砖石 复活卡 消耗  砖石 复活卡 获得 记录
   * @param {数据信息} info
   */
  async addStatNumberUv(info) {
    let { openId } = this.context;
    let { activityId, type, value } = info
    let record = await this.statService.findOne({
        openId,
        activityId,
        type,
        createDay: getToday()
    });
    if (null == record) {
        return await this.statService.insertOne({
          ...info,
          openId,
          createTime: Date.now(),
          updateTime: Date.now(),
          createDay: getToday(),
        });
    }

    //已经有数据
    let oldValue = record.value ? record.value : 0

    return await this.statService.update({
      ...record,
      value: oldValue + value,
      openId,
      updateTime: Date.now(),
    });
  }
}

module.exports = StatService;
