const {
  BaseDao
} = require('../sdk');
const { getToday } = require('../utils');
const { JOIN_DB_NAME }  = require('../db');
const {JOIN_INFO_STATUS} = require('../constants');

class GameService {
  constructor(context) {
    this.context = context;
    this.joindao = new BaseDao(context, JOIN_DB_NAME);
  }

  async addJoin(userNick, maxScore = 0) {
    const { activityId } = this.context.data;
    const { openId } = this.context;
    const record = {
      activityId,
      userNick,
      openId,
      createDay: getToday(),
      createTime: Date.now(),
      updateTime: Date.now(),
      score: 0,
      maxScore,
      shoes: 0,
      status: JOIN_INFO_STATUS.START
    }

    return await this.joindao.insertOne(record);
  }

  async getJoinInfo() {
    const { openId } = this.context;
    const { activityId } = this.context.data;
    return await this.joindao.findOne({ openId, activityId })
  }
  
  async updateJoin(_id, document) {
    return await this.joindao.update({
      _id
    }, {
      $set: document
    })
  }
} 

module.exports = GameService;
