const UserService = require('../service/user.service');
const BaseService = require('../service/base.service');
const { pipeActivityInfo } = require('./base.controller');
const { login } = require('./user.controller');
const TaskService = require('../service/task.service');
const StatService = require("../service/stat.service");
const { CODE_TYPES, TASK_TYPE, TASK_LIST, TASK_TYPE_WIN } = require('../constants');
const { ResultsModel, dateFormatter, TBAPIS, transformBeijingDate } = require('../sdk');
const { getToday, logger, getSellerSession, getUserOrderlist, statInsertPV, statInsertUV } = require('../utils')
let resultModel = new ResultsModel();

//购买浏览商品列表
const getBrowseGoodsList = async (context) => {
  // 判断活动
  let pipeRes = await pipeActivityInfo(context);
  // 活动结束
  if (pipeRes.code) {
    return pipeRes;
  }
  let ids = "";
  if (pipeRes.tasks && pipeRes.tasks.orderGoods) {
    ids = pipeRes.tasks.orderGoods.itemIds;
  }

  let list = [];
  if (ids) {
    let taskSer = new TaskService(context);
    list = await taskSer.getGoodsList(ids);
  }
  console.log('list ', list);

  return resultModel.success(list);
}
//购买下单商品列表
const getOrderList = async (context) => {
  // 判断活动
  let pipeRes = await pipeActivityInfo(context);
  // 活动结束
  if (pipeRes.code) {
    return pipeRes;
  }
  let ids = "";
  if (pipeRes.tasks && pipeRes.tasks.orderGoods) {
    ids = pipeRes.tasks.orderGoods.itemIds;
  }

  let list = [];
  if (ids) {
    let taskSer = new TaskService(context);
    list = await taskSer.getGoodsList(ids);
  }
  console.log('list ', list);

  return resultModel.success(list);
}

//获取任务列表
const getTaskList = async (context) => {
  logger('getTaskList', context.data);
  const pipeRes = await pipeActivityInfo(context);
  console.log('---------------'+pipeRes)
  if (pipeRes.code) {
    return pipeRes;
  }

  try {
    let userSer = new UserService(context);
    let statSer = new StatService(context);
    let taskService = new TaskService(context)
    let today = getToday();

    let userInfo = await userSer.getUserInfo()
     // 用户不存在
    if (!userInfo) {
      return resultModel.error(CODE_TYPES.ERROR_NO_USER);
    }
    let { remainTimes, recordTask, taskInfo, _id } = userInfo
    let todayTask = taskInfo[today]
    let { followStatus, orders:oldOrderRecord } = recordTask
    if(!todayTask) {
      todayTask = {
        browserGoods: { value: TASK_TYPE_WIN.BROWSE, status: 0},
        invites: [],
        orders: [],
        exchangeCredits: [],
        sign: { value: TASK_TYPE_WIN.DAY, status: 1}
      }
    }
    //是否有未生效的新订单
    let newOrders = await taskService.getNewBuyGoodsOrders(pipeRes, userInfo);
    let goodsTaskWaitReceive = newOrders.length;
    let oldRecord = todayTask.orders ? todayTask.orders : []
    oldOrderRecord = oldOrderRecord || []
    //订单支付成功uv
    if (goodsTaskWaitReceive > 0) {
      newOrders.forEach(el => {
        let orderDetail = {
          "itemId": o.itemId,
          "orderId": o.orderId,
          "price": o.price,
        };
        oldRecord.push({
          "createTime": transformBeijingDate(Date.now()),
          "orderId": o.orderId
        })
        oldOrderRecord.push({
          "createTime": transformBeijingDate(Date.now()),
          "orderId": o.orderId
        })
        //下单打点
        statSer.addStat({activityId, type: DATA_TYPE.orderPrice, orderInfo:orderDetail})
      })
      let { activityId, openId } = userInfo;
      statInsertUV({ activityId, openId, type: DATA_TYPE.consumptionUv });
    }

    //更新用户信息
    let param  = {
        remainTimes: {
          ...remainTimes,
          orders: goodsTaskWaitReceive + remainTimes.orders
        },
        recordTask: {
          ...recordTask,
          orders: oldOrderRecord
        },
        taskInfo: {
          ...taskInfo,
          [today]: {
            ...todayTask,
            orders: oldRecord
          }
        }
    }
    await userSer.update(_id,param)

    //获取更新后打用户信息
    let updateUserInfo = await userSer.getUserInfo()

    let { browserGoods, invites, exchangeCredits, freeDiamond } = updateUserInfo.taskInfo[today]
    let { invites:remainInvites, orders:oldOrders } = updateUserInfo.remainTimes
    let taskList = TASK_LIST.map(el => {
      if(el.taskType == TASK_TYPE.BROWSE) {
        el.status = browserGoods.status
      }
      if(el.taskType == TASK_TYPE.FOLLOW) {
        el.status = followStatus
      }
      if(el.taskType == TASK_TYPE.FREE_MASONRYS) {
        el.status = freeDiamond.status
      }
      if(el.taskType == TASK_TYPE.INVITES) {
        el.status = remainInvites == 0 ? 0 : 1
      }
      if(el.taskType == TASK_TYPE.BUY_GOODS) {
        el.status = orders == 0 ? 0 : 1
      }
      if(el.taskType == TASK_TYPE.EXCHANAGE) {
        el.status = goodsTaskWaitReceive > 0 ? 1 : oldOrders > 0 ? 1 : 0
        el.times = exchangeCredits.length || 0
      }
    })

    return resultModel.success({ taskList })
  }
  catch(err) {
    console.log('获取新订单失败')
  }
}

// 领取任务次数
const completeTask = async (context) => {

  // 判断活动
  let pipeRes = await pipeActivityInfo(context);
  if (pipeRes.code) {
    return pipeRes;
  }

  let { taskType } = context.data;
  if (!taskType) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `taskType必填`);
  }
  if (![TASK_TYPE.INVITES, TASK_TYPE.BUY_GOODS, TASK_TYPE.FREE_MASONRYS, TASK_TYPE.FOLLOW,TASK_TYPE.BROWSE,TASK_TYPE.EXCHANAGE].includes(taskType)) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `taskType非法`);
  }

  let userSer = new UserService(context);
  let userInfo = await userSer.getUserInfo();
  // 用户不存在
  if (!userInfo) {
    return resultModel.error(CODE_TYPES.ERROR_NO_USER);
    // await login(context)
    // userInfo = await userSer.getUserInfo();
  }

  let taskSer = new TaskService(context);
  let result = await taskSer.receiveTaskRewards(pipeRes, userInfo, taskType);

  if (result.code) {
    return resultModel.error(result);
  }
  return resultModel.success(result);
}

//完成任务
const doCompleteTask = async (context) => {
  // 判断活动
  let pipeRes = await pipeActivityInfo(context);
  if (pipeRes.code) {
    return pipeRes;
  }

  let { taskType, isNewVip, inviteId } = context.data;
  if (!taskType) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `taskType必填`);
  }

  if (![TASK_TYPE.INVITES, TASK_TYPE.FOLLOW, TASK_TYPE.BROWSE].includes(taskType)) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `taskType非法`);
  }

  let userSer = new UserService(context);
  let userInfo = await userSer.getUserInfo();
  // 用户不存在
  if (!userInfo) {
    return resultModel.error(CODE_TYPES.ERROR_NO_USER);
  }

  let taskSer = new TaskService(context);
  let result = await taskSer.doCompleteTask(userInfo, taskType, isNewVip);

  if (result.code) {
    return resultModel.error(result);
  }
  return resultModel.success(result);
}
module.exports = {
  getBrowseGoodsList,
  getOrderList,
  getTaskList,
  completeTask,
  doCompleteTask
}