const { pipeActivityInfo } = require('./base.controller');
const UserJoinService = require("../service/userJoin.service");
const UserService = require('../service/user.service');
const AwardsService = require('../service/awards.service');
const GameService = require('../service/game.service');
const { CODE_TYPES, DRAW_STATUS, SHIP_STATUS, SAMPLE_STATUS, B_PRIZE_TYPE, PRIZE_TYPE, JOIN_INFO_STATUS, DATA_TYPE } = require('../constants');
const { getToday, getSellerSession, statInsertPV, statInsertUV } = require('../utils');
const { ResultsModel } = require('../sdk');
let resultModel = new ResultsModel();

const getGameInfo = async context => {
  const pipeRes = await pipeActivityInfo(context);
  if (pipeRes.code) {
    return pipeRes;
  }

  let { activityId } = context.data;
  let { openId } = context;

  const userService = new UserService(context);
  const userInfo = await userService.getUserInfo();
  if (!userInfo) return resultModel.error(CODE_TYPES.ERROR_NO_USER);

  const UserJoinSer = new UserJoinService(context);
  let joinCount = await UserJoinSer.getJoinCount(activityId, openId);

  let { diamond, resurgenceCards, initialCredits, member } = userInfo;

  //初始积分
  let { session } = await getSellerSession(context, activityId);
  let initialCredits = await userService.queryUserCredits(session) || 0

  let result = {
    guideComplete: joinCount > 0 ? 1 : 0,
    diamond,
    resurgenceCards,
    initialCredits: member.flag ? initialCredits : 0,
    isVip: isvip,
    vipLink: url,
  }
  return resultModel.success(result);
}

// 开始游戏
const startGame = async context => {
  let pipeRes = await pipeActivityInfo(context);
  if (pipeRes.code) {
    return pipeRes;
  }

  const userService = new UserService(context);
  const userInfo = await userService.getUserInfo();
  if (!userInfo) return resultModel.error(CODE_TYPES.ERROR_NO_USER);

  let { activityId } = context.data;

  const { diamond } = userInfo;

  if (diamond < 10) {
    return resultModel.error(CODE_TYPES.ERROR_NO_GAME_COUNT);
  }

  const gameService = new GameService(context);
  const joinId = await gameService.addJoin(userInfo.userNick);
  //埋点数据
  statInsertPV({ activityId, openId, type: DATA_TYPE.joinPv });
  statInsertUV({ activityId, openId, type: DATA_TYPE.joinUv });

  await userService.updateUser(userInfo._id, {
    diamond: userInfo.diamond - 10,
    newUserGuide: 1
  });

  //首次参与活动老会员UV
  if (gameTime == 0 && userInfo.member && userInfo.member.flag) {
    const dataService = new DataService(context);
    dataService.insertUV({ activityId, openId, type: DATA_TYPE.joinOldMemberUv });
  }

  return resultModel.success({
    id: joinId,
    isvip,
    url
  });
}

const submitGame = async context => {
  const { activityId, id, score } = context.data;

  if (!activityId) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `activityId必填`);
  }
  if (!id) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `id必填`);
  }
  if (!score && score !== 0) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `score必填`);
  }

  let pipeRes = await pipeActivityInfo(context);
  if (pipeRes.code) {
    return pipeRes;
  }

  const userService = new UserService(context);
  const userInfo = await userService.getUserInfo();
  if (!userInfo) return resultModel.error(CODE_TYPES.ERROR_NO_USER);

  const gameService = new GameService(context);
  const joinInfo = await gameService.getJoinInfo(id);

  if (!joinInfo) return resultModel.error(CODE_TYPES.ERROR_NO_JOIN_INFO);

  if (!(joinInfo.status && joinInfo.status == JOIN_INFO_STATUS.START)) {
    resultModel.error(CODE_TYPES.ERROR_JOIN_STATUS_ERROR);
  }

  await gameService.updateJoin(id, {
    submitGame: Date.now(),
    submitDay: getToday(),
    score,
    duration: Date.now() - joinInfo.createTime,
    prizeId: prizeResult._id,
    awardId: prizeResult.awardId,
    prizeType,
    status: JOIN_INFO_STATUS.FINISH
  });

  const totalScore = userInfo.totalScore + score;

  await userService.updateUser(userInfo._id, {
    totalScore,
    // info: userInfo['info'],
    updateScoreTime: Date.now()
  });

  const { rank } = await userService.getUserRank(totalScore);

  let { _id, ename, type, image, name, awardId } = prizeResult;

  let prize = { _id, ename, type, image, name, awardId };

  return resultModel.success({
    score,
    rank,
    totalScore,
    redPacketReminder,
    prize
  });

}

module.exports = {
  getGameInfo,
  startGame,
  submitGame
}