const BaseService = require('../service/base.service');
const { CODE_TYPES, ACTIVITY_STATUS, OPEN_PRIZE_STATUS } = require('../constants');
const { ResultsModel } = require('../sdk');

let resultModel = new ResultsModel();

// 活动判断
const pipeActivityInfo = async (context) => {
  let activitySer = new BaseService(context);
  let { activityId } = context.data;
  // 参数校验
  if (!activityId) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `activityId必填`);
  }
  // 活动基本情况
  let activityInfo = await activitySer.getBaseInfo(activityId);
  // 活动不存在
  if (!activityInfo && activityInfo.deleteStatus === ACTIVITY_STATUS.DELETE) {
    return resultModel.error(CODE_TYPES.ERROR_NO_ACTIVITY);
  }
  let { startTime, endTime } = activityInfo;
  let currentTime = Date.now();
  if (currentTime < startTime) {
    return resultModel.error(CODE_TYPES.ERROR_ACTIVITY_NOSTART, `活动未开始`);
  }
  if (currentTime > endTime) {
    return resultModel.error(CODE_TYPES.ERROR_ACTIVITY_OVER, `活动已结束`);
  }
  return activityInfo;
}

// 活动基本信息
const getActivityBaseInfoById = async(context) => {
  let activitySer = new BaseService(context);
  let { activityId } = context.data;
  // 参数校验
  if (!activityId) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `activityId必填`);
  }
  // 活动基本情况
  let activityInfo = await activitySer.getBaseInfo(activityId);
  activityInfo.rankLimit = 1000;
  activityInfo.openPrizeTime = activityInfo.endTime + 48 * 60 * 60 * 1000;
  activityInfo.openPrize = (activityInfo.openPrizeStatus && activityInfo.openPrizeStatus === OPEN_PRIZE_STATUS.SUCCESS);
  return resultModel.success(activityInfo);
}

module.exports = {
  pipeActivityInfo,
  getActivityBaseInfoById
}