const {
  DEFAULT_CODE_TYPES
} = require('./sdk');

let BusinessError = {
  // 更新重试失败(用于并发更新)
  ERROR_UPDATE_RETRY: {
    code: `210001`,
    defaultMsg: `系统错误`
  },
  // 活动不存在
  ERROR_NO_ACTIVITY: {
    code: `220001`,
    defaultMsg: `活动不存在`
  },
  // 活动未开始
  ERROR_ACTIVITY_NOSTART: {
    code: `220002`,
    defaultMsg: `活动未开始`
  },
  // 活动已结束
  ERROR_ACTIVITY_OVER: {
    code: `220003`,
    defaultMsg: `活动已结束`
  },
  // 排行榜未开奖
  ERROR_NO_RANKOEPN: {
    code: `220004`,
    defaultMsg: `排行榜未开奖`
  },
  // 用户不存在
  ERROR_NO_USER: {
    code: `310002`,
    defaultMsg: `用户不存在`
  },
  // 需要成为会员才能助力哦
  ERROR_NEEDMEMBER_DOHELP: {
    code: `310004`,
    defaultMsg: '需要成为会员才能助力哦'
  },
  // 任务奖励已领取
  ERROR_TASK_ALREADYRECEIVE: {
    code: `430002`,
    defaultMsg: `任务奖励已领取`
  },
  // 任务已完成
  ERROR_TASK_COMPLETE: {
    code: `430003`,
    defaultMsg: `任务已完成`
  },
  // 暂无次数可领取
  ERROR_TASK_NORECEIVE: {
    code: `430003`,
    defaultMsg: `暂无次数可领取`
  },
  ERROR_FORBIDDEN_OPE: {
    code: `530001`,
    defaultMsg: `非法操作`
  },
  ERROR_RECEIVE_PRIZE: {
    code: `630002`,
    defaultMsg: `奖励已领取`
  },
  ERROR_SEND_PRIZE: {
    code: `730001`,
    defaultMsg: `发奖失败`
  },
  ERROR_NO_PRIZE: {
    code: `730002`,
    defaultMsg: `奖品不存在`
  },
  ERROR_NO_STOCK: {
    code: `730003`,
    defaultMsg: `库存不足`
  },
  ERROR_PRIZE_EXPIRED: {
    code: `740001`,
    defaultMsg: `奖品已超过领取时间`
  },
  ERROR_TASK_NORECEIVE: {
    code: `930002`,
    defaultMsg: `该任务不可领取`
  },
  ERROR_NOT_NEW_VIP: {
    code: `930003`,
    defaultMsg: `新玩家才可以助力哦`
  },
  ERROR_NOT_VIP: {
    code: `930004`,
    defaultMsg: `成为会员才能为TA助力哦！`
  },
  ERROR_INVALID_INVITE_USER: {
    code: `930005`,
    defaultMsg: `inviteId无效`
  },
  ERROR_ASSIST_ALREADY: {
    code: `930006`,
    defaultMsg: `已为好友成功助力过了`
  },
  ERROR_CREDIT_NUM: {
    code: `100001`,
    defaultMsg: `积分不足`
  },
  ERROR_SYSTEM: {
    code: `100002`,
    defaultMsg: `系统错误`
  },
  ERROR_NO_SHOES: {
    code: `100003`,
    defaultMsg: `鞋子数量不足`
  },
  ERROR_EXCHANGE: {
    code: `100004`,
    defaultMsg: `兑换失败`
  }
}

const TASK_LIST = [{
    taskType: 'follow',
    rewards: 10, //砖石
    status: 0
  },
  {
    taskType: 'orderGoods',
    rewards: 5, //复活卡
    status: 0
  },
  {
    taskType: 'inviteFriends',
    status: 0,
    rewards: 20, //砖石
    value: 0,
  },
  {
    taskType: 'browseGoods',
    rewards: 1, //复活卡
    status: 0
  },
  {
    taskType: 'exchangeCredits',
    limitTimes: 2,
    rewards: 50, //砖石
    times: 0
  },
  {
    taskType: 'sign',
    rewards: 10, //砖石
    status: 0
  }
]

const CODE_TYPES = Object.assign({}, DEFAULT_CODE_TYPES, BusinessError);

//tb 接口返回部分错误
const TBERROR = {
  'USER_PERMISSION_EXCEED_MAX_RIGHT_COUNT_IN_DAY': '今日领取达到上限，明日再来领取哦',
  'COUPON_INVALID_OR_DELETED': '权益无效或者被删除，请联系商家',
  'APPLY_OWNSELF_COUPON': '不能领取自己家店铺权益',
  'APPLY_SINGLE_COUPON_COUNT_EXCEED_LIMIT': '请至卡券包删除无用权益再领取',
  'NO_RIGHT_QUANTITY': '权益库存不足，请联系商家',
  'ERRORA_3_567': '领取失败，为风险用户',
  'Invalid session': '订购应用已过期，请联系商家处理',
  'NO_RIGHT_QUANTITY': '权益库存不足，请联系商家'
}

// 领取奖品状态
const DRAW_STATUS = {
  // 待领取
  WAITAWARD: 1,
  // 处理中
  PROCESSING: 2,
  // 领取成功
  SUCCESS: 3,
  // 领取失败
  FAIL: 4,
  // 已过期
  EXPIRED: 5,
  // 重新领取
  RETRY: 6
}

// 物流状态
const SHIP_STATUS = {
  //未填写收货地址
  NO_ADDRESS: 0,
  //未发货
  UNSHIPPED: 1,
  //已发货
  SHIPPED: 2
}

// 奖品类型
const PRIZE_TYPE = {
  ENAME: 1,
  CREDITS: 2,
  OBJECT: 3,
  THANKS: 5
};
// C端的APP NAME
const C_APP_NAME = 'promotioncenter-3000000026263524';

// 订单状态
const TAOBAO_SUCCESS_ORDER_STATUS = [
  "WAIT_SELLER_SEND_GOODS",
  "SELLER_CONSIGNED_PART",
  "WAIT_BUYER_CONFIRM_GOODS",
  "TRADE_BUYER_SIGNED",
  "TRADE_FINISHED",
  "PAID_FORBID_CONSIGN",
];
// 活动状态
const ACTIVITY_STATUS = {
  NORMAL: 1,
  DELETE: 2
};

//鞋子类型map
const SHOE_TYPE_MAP = {
  1: "normal", //新用户赠送1次免伤
  2: "primary",
  3: "medium"
};
const NORMAL_TOOL_TYPE = 1;

//每局游戏消耗10砖石
const ONCE_DIAMOND_RE = 10;

const SHOE_TYPE_REWARDS = {
  1: 0,
  2: 20, //20砖石兑换
  3: 30 //30砖石兑换
}

// 任务类型
const TASK_TYPE = {
  //每日免费
  FREE_MASONRYS: 'sign',
  // 邀请好友
  INVITES: 'inviteFriends',
  // 购买商品
  BUY_GOODS: 'orderGoods',
  // 关注店铺
  FOLLOW: 'follow',
  // 浏览商品
  BROWSE: 'browseGoods',
  //积分兑换
  EXCHANAGE: 'exchangeCredits',
}
//任务奖励
const TASK_TYPE_WIN = {
  //每日登录
  DAY: 10,
  // 邀请好友得20砖石
  INVITES: 20,
  //邀请好友非店铺会员得复活卡
  NEN_INVITES: 1,
  // 购买商品得复活卡
  BUY_GOODS: 5,
  // 关注店铺
  FOLLOW: 10,
  // 浏览商品得复活卡
  BROWSE: 1,
  //积分兑换
  EXCHANAGE_CREDITS: 50,
}

//任务频率类型常量
const TASK_RATE_TYPE = {
  FOREVER: 1,
  EVERYDAY: 2,
  NOLIMIT: 3,
};

// 积分兑换限制
const EXCHANGE_CREDITS_LIMIT = {
  value: 2,
  type: TASK_RATE_TYPE.EVERYDAY
};

// 浏览商品限制
const BROSER_LIMIT = {
  value: 1,
  type: TASK_RATE_TYPE.EVERYDAY
};

// 邀请好友限制
const INVITE_FRIENDS_LIMIT = {
  value: 5,
  type: TASK_RATE_TYPE.EVERYDAY
};

//游戏记录状态
const JOIN_INFO_STATUS = {
  START: 0,
  FINISH: 1
}
//助力成功
const ASSIST_SUCCESS = 1

//助力成功 新入会获得30砖石
const FIRST_DIAMOND = 30

// 排行榜开奖状态
const OPEN_PRIZE_STATUS = {
  WAITOPEN: 1,
  OPENING: 2,
  SUCCESS: 3,
  FAIL: 4
};

//埋点数据类型
const DATA_TYPE = {
  newAddUv: 'newAddUv', //首次进入uv
  accesssPv: 'accesssPv', //访问pv
  accesssUv: 'accesssUv', //访问uv
  joinGamePv: 'joinGamePv', //参与pv
  joinGameUv: 'joinGameUv', //参与uv
  useNormalUv: 'useNormalUv', //款鞋一使用uv
  usePrimaryUv: 'usePrimaryUv', //款鞋二使用uv
  useMediumUv: 'useMediumUv', //款鞋三使用uv
  countFollowUv: 'countFollowUv', //关注店铺完成uv
  dayLoginUv: 'dayLoginUv', //每日登录任务完成
  exchanageCreditPv: 'exchanageCreditPv', //积分兑换砖石pv(前端)
  exchanageCreditUv: 'exchanageCreditUv', //积分兑换砖石uv
  inviteFriendPv: 'inviteFriendPv', //邀请好友发起Pv(前端)
  inviteFriendUv: 'inviteFriendUv', //邀请好友发起Uv
  completeInvitedPv: 'completeInvitedPv', //邀请好友任务完成Pv 1
  completeInvitedUv: 'completeInvitedUv', //邀请好友任务完成Uv 1
  beInvitedMember: 'beInvitedMember', //带来好友已入会
  noInvitedMember: 'noInvitedMember', //带来好友未入会
  beBrowseUv: 'beBrowseUv', //每日浏览完成uv
  consumptionUv: 'consumptionUv', //每日消费uv(去下单) 1
  exchanagePrize: 'exchanagePrize', //每日兑换uv(兑换商场)(前端)
  addShoesUv: 'addShoesUv', //获得碎片Uv
  reduceShoesUv: 'reduceShoesUv', //使用碎片Uv
  addCardUv: 'addCardUv', //获得复活卡Uv
  reduceCardUv: 'reduceCardUv', //使用复活卡Uv
  reduceDiamondUv: 'reduceDiamondUv', //消耗砖石Uv
  reduceCreditUv: 'reduceCreditUv', //消耗积分Uv
  countDiamond: 'countDiamond', //当日累计消耗砖石
  countCredit: 'countCredit', //当日累计消耗积分
  countMember: 'countMember', //入会人数
  countShoes: 'countShoes', //碎片获取总量
  useCountShoes: 'useCountShoes', //碎片使用总量
  countCards: 'countCards', //复活卡获取总量
  useCountCards: 'useCountCards', //复活卡使用总量
  assistRecord: 'assistRecord', //助力记录
  orderPrice: 'orderPrice', //订单价格
}

let rand = (function () {
  let seed = (new Date()).getTime()

  function r() {
    seed = (seed * 9301 + 49297) % 233280
    return seed / (233280.0)
  }
  return function (number) {
    return Math.ceil(r() * number)
  }
})()


const SHIP_TYPE = {
  INIT: 1,
  ADD_ADDRESS: 2,
  SEND_GOODS: 3
}

const PRIZE_DATA_TYPE = {
  RANK: 1,
  EXCHANGE: 2
}

const HAS_EXCHANGE = {
  EXCHANGE: 2,
  NO_EXCHANGE: 1
}

module.exports = {
  CODE_TYPES,
  C_APP_NAME,
  TBERROR,
  DRAW_STATUS,
  PRIZE_TYPE,
  TAOBAO_SUCCESS_ORDER_STATUS,
  ACTIVITY_STATUS,
  TASK_TYPE,
  SHIP_STATUS,
  OPEN_PRIZE_STATUS,
  TASK_TYPE_WIN,
  JOIN_INFO_STATUS,
  DATA_TYPE,
  ASSIST_SUCCESS,
  SHOE_TYPE_MAP,
  NORMAL_TOOL_TYPE,
  INVITE_FRIENDS_LIMIT,
  BROSER_LIMIT,
  EXCHANGE_CREDITS_LIMIT,
  FIRST_DIAMOND,
  TASK_LIST,
  SHOE_TYPE_REWARDS,
  rand,
  PRIZE_DATA_TYPE,
  SHIP_TYPE,
  HAS_EXCHANGE
}