const {CODE_TYPES} = require('../../constants');
/**
 * 并发更新
 * @param {接收数组或对象} daoqueryArr : [{dao: userdao, query:{_id:_id}}, {dao: activityprizedao, query: {userNick, status ...}}]
 * @param {*} fn 
 * @param {*} times 
 */
const lockUpdate = async(daoqueryArr, fn, times=5) => {
  if (typeof daoqueryArr !=='object') {
    console.log(`lockUpdate 参数错误`);
    return false;
  }
  if (!daoqueryArr instanceof Array) {
    daoqueryArr = [daoqueryArr];
  }
  let time = 0;
  console.log(`进入update并发处理次数`, times);
  let success = false;
  try{
    while (time++ < times && !success) {
      // 依次锁住表
      let updateRes = [];
      let error = false
      for(let i = 0; i < daoqueryArr.length; i++) {
        let daoquery = daoqueryArr[i];
        if (!daoquery.dao || !daoquery.query) {
          success = true;
          error = true
          console.log(`daoquery`, daoquery)
          break
        }else {
          console.log(`daoquery`, daoquery)
          let canupdate = await daoquery.dao.update(daoquery.query, {$set: {lockStatus: 2}});
          updateRes.push(canupdate);
        }
      }
      if (error) {
        return `调用lockUpdate方法参数不符合规范`
      }
      console.log(`updateRes`, updateRes)
      // 若都锁定成功了，执行内部调用
      if (updateRes.every((v) => v === 1)) {
        const ret = await fn();
        console.log(`完成调用，解锁操作执行--------------`);
        daoqueryArr.forEach(async daoquery => {
          console.log(daoquery)
          let ures = await daoquery.dao.update(daoquery.query, {$set: {lockStatus: 1}});
          console.log(`更新lockStatus为1`, ures);
        });
        success = true;
        return ret;
      } else {
        console.log(`进入waitFor了，需等待30ms`)
        await waitFor(30);
        success = false;
      }
    }
  }catch(e) {
    console.log(e);
    daoqueryArr.forEach(async daoquery => {
      let ures = await daoquery.dao.update(daoquery.query, {$set: {lockStatus: 1}});
      console.log(`更新lockStatus为1`, ures);
    });
    success = false;
  }
  console.log(`daoqueryArr`, daoqueryArr)
  // 稍后重试
  if (!success) {
    daoqueryArr.forEach(async daoquery => {
      console.log(daoquery)
      let ures = await daoquery.dao.update(daoquery.query, {$set: {lockStatus: 1}});
      console.log(`操作${times}次后更新lockStatus为1`, ures);
    });
    return CODE_TYPES.ERROR_UPDATE_RETRY;
  }
  function waitFor(ms) {
    return new Promise(resolve => {
      setTimeout(resolve, ms)
    });
  }
}

module.exports = lockUpdate;
