/**
 * 获取商家session
 */

const { SELLER_INFO_DB_NAME, ACTIVITY_CONFIG_DB_NAME } = require('../../db');

const { BaseDao } = require('../../sdk')

const getSellerSession = async (context, activityId) => {
  if (!activityId) {
    activityId = context.data.activityId;
  }
  let activitydao = new BaseDao(context, ACTIVITY_CONFIG_DB_NAME)
  let sellerdao = new BaseDao(context, SELLER_INFO_DB_NAME)
  let activityConfigResult = await activitydao.find({ _id: activityId });
  if (!activityConfigResult || !activityConfigResult[0]) return {};

  let result = await sellerdao.find({
    openId: activityConfigResult[0].openId
  });
  console.log(`getSellerSession`, result);
  if (!result || !result[0]) return {};
  return {
    session: result[0].accessToken
  };
}

module.exports = getSellerSession;