/**
 * 访问明细
 */
const { BaseDao } = require("../sdk");
const { getToday } = require("../utils");
const { USER_JOIN_DB_NAME } = require("../db");
const {JOIN_INFO_STATUS} = require('../constants');

class UserJoinService {
  constructor(context) {
    this.context = context;
    this.userJoinDao = new BaseDao(context, USER_JOIN_DB_NAME);
  }

  // 用户开始游戏
  async insertGameInfo(userInfo) {
    const { openId, data } = this.context;
    const { activityId } = data;
    return this.userJoinDao.insertOne({
      openId,
      activityId,
      ...userInfo,
      status: JOIN_INFO_STATUS.START,
      createTime: Date.now(),
      updateTime: Date.now(),
      createDay: getToday(),
    });
  }

  // 更新用户游戏数据
  async updateGameInfo(_id, activityId, info) {
    return this.userJoinDao.update(
      {
        _id,
        activityId,
      },
      {
        $set: {
          ...info,
          updateTime: Date.now(),
        },
      }
    );
  }

  async getGameInfo(_id, activityId) {
    return this.userJoinDao.findOne({
      _id,
      activityId,
    });
  }

  //上一次游戏信息
  async getLastGameInfo() {
    const { openId, data: { activityId } } = this.context;
    const lastList = await this.userJoinDao.find({ openId, activityId, toolType: { $in: [1,2,3] } }, {
      limit: 1,
      sort: {
        updateTime: -1
      }
    });
    console.log('lastList'+lastList)
    return lastList[0]
  }

  async getGameInfoListByToolType(activityId, toolType) {
    const { openId } = this.context;
    return this.userJoinDao.find({
      activityId,
      openId,
      toolType,
    });
  }

  async getUserJoinTotalScore(activityId) {
    const { openId } = this.context;
    return this.context.cloud.db.collection(USER_JOIN_DB_NAME).aggregate([
      {
        $match: { activityId, openId },
      },
      {
        $group: {
          _id: "$toolType",
          score: { $sum: "$score" },
        },
      },
    ]);
  }

  async getJoinCount(info) {
    return this.userJoinDao.count({
      ...info
    });
  }
}

module.exports = UserJoinService;
