/**
 * 基本信息
 */
const { BaseDao, transformBeijingDate, dateFormatter } = require('../sdk');
const { ACTIVITY_CONFIG_DB_NAME } = require('../db');

class BaseService {
  constructor(context) {
    this.context = context;
    this.activitydao = new BaseDao(context, ACTIVITY_CONFIG_DB_NAME);
  }
  /**
   * @desc 活动基本信息
   * @param {活动id} activityId 
   * @returns 返回活动详情，若不存在活动，返回为null
   */
  async getBaseInfo(activityId) {
    if (!activityId) {
      activityId = this.context.data.activityId
    }
    return await this.activitydao.findOne({_id: activityId});
  }
}
module.exports = BaseService;