/**
 * 访问明细
 */
const {
  BaseDao
} = require('../sdk');
const { getToday } = require('../utils');
const { ACCESS_DB_NAME }  = require('../db');
 
class UserAccessService {
  constructor(context) {
    this.context = context;
    this.accessdao = new BaseDao(context, ACCESS_DB_NAME);
  }
  /**
   * 增加访问记录
   * @param {是否关注店铺} newFollow 
   */
  async addAccess(isVip = false, type, newFollow = false) {
    let {
      openId,
      data
    } = this.context;
    let {
      activityId,
      userNick,
      avatar,
      inviteId
    } = data;

    return await this.accessdao.insertOne({
      openId,
      activityId,
      userNick,
      avatar,
      isReceiveShare: !!inviteId,
      inviteId,
      isVip,
      newFollow,
      accessTime: Date.now(),
      createTime: Date.now(),
      updateTime: Date.now(),
      createDay: getToday(),
      type
    });
  }

  async addComeAccess(type) {
    let { openId, data } = this.context;
    let { activityId, userNick = "" } = data;

    return await this.accessdao.insertOne({
      openId,
      activityId,
      userNick,
      accessTime: Date.now(),
      createTime: Date.now(),
      updateTime: Date.now(),
      createDay: getToday(),
      type,
    });
  }
}

module.exports = UserAccessService;
