const UserService = require('../service/user.service');
const ActivityService = require('../service/base.service');
const UserJoinService = require("../service/userJoin.service");
const AccessService = require("../service/access.service");
const StatService = require("../service/stat.service");
const { CODE_TYPES, DATA_TYPE, TASK_TYPE, NEW_USER_DIAMAND } = require('../constants');
const { logger, addErrorLog, getToday, getSellerSession } = require('../utils')
const { ResultsModel } = require('../sdk');
let resultModel = new ResultsModel();

/**
 * 登陆
 */
const login = async (context) => {
 logger('login', context.data);
  const {
    userNick,
    activityId,
    avatar,
    inviteId = "",
    isFollow = false
  } = context.data;
  const { openId } = context;
  if (!activityId) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `activityId必填`);
  }
  if (!userNick || !avatar) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `userNick, avatar 必填`);
  }
  try {
    const activityService = new ActivityService(context);
    const userService = new UserService(context);
    const accessService = new AccessService(context);
    const statService = new StatService(context);
    const UserJoinSer = new UserJoinService(context);
    let activityInfo = await activityService.getBaseInfo(activityId);
    // 活动不存在
    if (!activityInfo) {
        return resultModel.error(CODE_TYPES.ERROR_NO_ACTIVITY);
    }
    let { session } = await getSellerSession(context, activityId);
    // 是否是会员
    let { isvip, url } = await userService.getShopVip(session);

    let joinCount = await UserJoinSer.getJoinCount({activityId, openId});
    // let isvip = false;
    let today = getToday();
    let userInfo = await userService.getUserInfo();
    //访问pv
    await accessService.addAccess(isvip, DATA_TYPE.accesssPv);
    //每日登录任务完成打点
    await statService.addStat({ activityId, type: DATA_TYPE.dayLogin })

    //初始积分
    let initialCredits = await userService.queryUserCredits(session) || 0
    
    if (userInfo) {
      let { _id, member, diamond, resurgenceCards, info, remainTimes, recordTask } = userInfo;
      let todyInfo = info[today]
      let loginTimes = todyInfo && todyInfo.login ? todyInfo.login + 1 : 1
      if (!member.newMember && !member.flag && isvip) {
        let { member: remainMember } = remainTimes
        let { memberStatus } = recordTask
        await userService.updateUser(_id, {
          inviteId,
          member: {
            flag: isvip,
            newMember: isvip,
            bememberTime: Date.now()
          },
          remainTimes: {
            ...remainTimes,
            member: remainMember == 0 ? 1 : remainMember
          },
          recordTask: {
            ...recordTask,
            memberStatus: memberStatus == 0 ? 1 : memberStatus
          },
          info: {
            ...info,
            [today]:{
              login: loginTimes
            }
          }
        });
        await statService.addStat({ activityId, type: DATA_TYPE.countMember })
      }
      else {
        await userService.updateUser(_id, {
          inviteId,
          info: {
            ...info,
            [today]:{
              login: loginTimes
            }
          }
        });
      }
      return resultModel.success({
        inviteId: openId,
        diamond,
        resurgenceCards,
        initialCredits: isvip? initialCredits : 0,
        guideComplete: joinCount > 0
      });
    }
    //首次进入uv
    await statService.addStat({ activityId, type:DATA_TYPE.newAddUv });
    // if(isvip) {
    //   await statService.addStat({ activityId, type: DATA_TYPE.countMember })
    // }

    let result = await userService.insertInitUser({
      userNick,
      activityId,
      avatar,
      openId,
      inviteId,
      diamond: NEW_USER_DIAMAND,
      totalScore: 0,
      maxScore: 0,
      rankPrizePop: 0,
      initialCredits,
      resurgenceCards: 0,
      totalShoes: 0,
      guideComplete: false,
      member: {
        flag: isvip,
        newMember: false,
      },
      follow: {
        flag: isFollow,
        newFollow: false,
      },
      toolInfo: {
        normal:1,
        primary:0,
        medium:0
      },
      remainTimes: {
        [TASK_TYPE.BROWSE]: 0,
        orders: 0,
        invites: 0,
        [TASK_TYPE.FOLLOW]: isFollow ? 1 : 0,
        [TASK_TYPE.FREE_MASONRYS]: 0,
        newMember: 0,
        member: isvip ? 1 : 0
      },
      recordTask: {
          invites: [],
          orders: [],
          followStatus: isFollow ? 1 : 0,
          memberStatus: isvip ? 1 : 0
      },
      taskInfo: {},
      info: {
        [today]: {
          login: 1
        }
      },
    });
    if (result) {
      return resultModel.success({
        inviteId: openId,
        diamond: 0,
        resurgenceCards: 0,
        initialCredits: isvip? initialCredits : 0,
        guideComplete: joinCount > 0
      });
    }
    return resultModel.error(CODE_TYPES.ERROR_LOGIN_INSERT);
  } catch (e) {
    console.log(e, "login接口出错了");
    return resultModel.error(CODE_TYPES.SYSTEM_ERROR, "用户登录失败");
  }
};

/**
 * 判断是否VIP
 */
const getVipInfo = async context => {
    logger('getVipInfo', context.data);

    let { activityId } = context.data
    if(!activityId) {
        return resultModel.error(CODE_TYPES.PARAMS_ERROR,`activityId必填`)
    }
    const { session } = await getSellerSession(context, activityId);
    if(!session) {
        await addErrorLog(context, { functionName: 'getVipInfo', errorMessage: '获取卖家session失败'});
        return resultModel.error(CODE_TYPES.SYSTEM_ERROR, '获取卖家session失败');
    }
    const userService = new UserService(context);
    const statService = new StatService(context);
    let userInfo = await userService.getUserInfo();
    let { _id, member } = userInfo
    try {
        let vipInfo = await userService.getShopVip(session);
        let realVip = vipInfo.isVip
        if(!member.flag && vipInfo.isvip) {
            //初始积分
            let initialCredits = await userService.queryUserCredits(session) || 0
             await userService.updateUser(_id, {
                initialCredits: vipInfo.isVip ? initialCredits : 0,
                member: {
                    flag: vipInfo.isvip,
                    newMember: true,
                    bememberTime: Date.now()
                }
            });
            await statService.addStat({ activityId, type: DATA_TYPE.countMember })
        }
        //如果已入会 再退出会员，则判定为会员
        if(member.flag && member.newMember && !vipInfo.isvip) {
          vipInfo.isvip = true
        }
        return resultModel.success({
          ...vipInfo,
          realVip,
        })
    } catch (error) {
        console.log('判断是否vip失败'+error)
    }
}

/**
 * 加入会员(joinType:1 游戏复活，2任务列表)
 */
const doJoin = async context => {
    logger('doJoin', context.data);

    let { activityId, joinType } = context.data
    if(!activityId) {
        return resultModel.error(CODE_TYPES.PARAMS_ERROR,`activityId必填`)
    }
    if(!joinType) {
        return resultModel.error(CODE_TYPES.PARAMS_ERROR,`joinType必填`)
    }

    const { session } = await getSellerSession(context, activityId);
    if(!session) {
        await addErrorLog(context, { functionName: 'getVipInfo', errorMessage: '获取卖家session失败'});
        return resultModel.error(CODE_TYPES.SYSTEM_ERROR, '获取卖家session失败');
    }
    const userService = new UserService(context);
    const statService = new StatService(context);
    let userInfo = await userService.getUserInfo();
    let { _id, member, resurgenceCards, recordTask, remainTimes } = userInfo
    const { isvip, url } = await userService.getShopVip(session);
    if(!isvip) {
      return resultModel.error(CODE_TYPES.ERROR_NO_VIP, `请先加入会员`)
    }
    try {
      let { memberStatus } = recordTask || {}
      if(memberStatus != 2 && isvip) {
          //初始积分
          await userService.updateUser(_id, {
            member: {
                flag: isvip,
                newMember: true,
                bememberTime: Date.now()
            },
            recordTask: {
              ...recordTask,
              memberStatus: joinType == 2 ? 1 : 2
            },
            remainTimes: {
              ...remainTimes,
              member: joinType == 2 ? 1 : 0
            }
          });

          //获得复活卡
          await statService.addStatNumberUv({ activityId, type: DATA_TYPE.addCardUv, value:1 })
          await statService.addStat({ activityId, type: DATA_TYPE.countMember })
          await statService.addStatNumberUv({ activityId, type: DATA_TYPE.reduceCardUv, value: 1 })
          
          return resultModel.success(joinType == 1 ? {
            resurgenceCards,
            rewards: 1
          }: true)
      }
      return resultModel.success(true)
    } catch (error) {
        console.log('加入会员失败'+error)
    }
}

/**
 * 埋点数据
 */
const addData = async context => {
  logger('doJoin', context.data);

  let { activityId, type } = context.data
  if(!activityId) {
      return resultModel.error(CODE_TYPES.PARAMS_ERROR,`activityId必填`)
  }
  if(!DATA_TYPE[type]) return resultModel.error(CODE_TYPES.PARAMS_ERROR,`type类型非法`)
  console.log('DATA_TYPE:'+DATA_TYPE[type])

  const statService = new StatService(context);
  await statService.addStat({ activityId, type })

  return resultModel.success(true)
}

/**
 * 获取用户积分
 * @param {*} context 
 */
const getUserCredits = async context => {
  logger('getUserCredits', context.data);

    let { activityId } = context.data
    if(!activityId) {
        return resultModel.error(CODE_TYPES.PARAMS_ERROR,`activityId必填`)
    }
    const { session } = await getSellerSession(context, activityId);
    if(!session) {
        return resultModel.error(CODE_TYPES.SYSTEM_ERROR, '获取卖家session失败');
    }
    const userService = new UserService(context);
    let { isvip, url } = await userService.getShopVip(session);

    if(!isvip) {
      return resultModel.success({
        isvip,
        url,
        quantity: 0
      })
    }
    try {
      let quantity = await userService.queryUserCredits(session) || 0
      return resultModel.success({
        isvip,
        url,
        quantity
      })
    } catch (error) {
      console.log('获取用户积分失败'+error)
    }
}

/**
 * 加积分(测试使用)
 */
const addUserCredits = async context => {
  const { activityId, quantity } = context.data;

  const userService = new UserService(context);
  let { session } = await getSellerSession(context, activityId);
  await userService.updateUserCredits(quantity, session, optType = 'add')
  let initialCredits = await userService.queryUserCredits(session) || 0
  console.log('initialCredits'+JSON.stringify(initialCredits))
}

module.exports = {
    login,
    getVipInfo,
    doJoin,
    addData,
    getUserCredits,
    addUserCredits
}