const UserService = require('../service/user.service');
const BaseService = require('../service/base.service');
const { pipeActivityInfo } = require('./base.controller');
const UserJoinService = require("../service/userJoin.service");
const { login } = require('./user.controller');
const TaskService = require('../service/task.service');
const StatService = require("../service/stat.service");
const { CODE_TYPES, TASK_TYPE, TASK_LIST, TASK_TYPE_WIN, DATA_TYPE, SHOP_URL } = require('../constants');
const { ResultsModel, dateFormatter, TBAPIS, transformBeijingDate } = require('../sdk');
const { getToday, logger, getSellerSession, getUserOrderlist } = require('../utils')
let resultModel = new ResultsModel();

//是否可助力
const isHelp = async (context) => {
  // 判断活动
  let pipeRes = await pipeActivityInfo(context);
  if (pipeRes.code) {
    return pipeRes;
  }

  const { inviteId, activityId } = context.data;
  const { openId } = context

  if (!inviteId) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `inviteId必填`);
  }
  if(inviteId === openId) {
    return resultModel.error(CODE_TYPES.ERROR_NO_MySELF, `自己不能给自己助力哦`);
  }

  const userJoinSer = new UserJoinService(context);
  const statService = new StatService(context)
  const userService = new UserService(context);
  const userInfo = await userService.getUserInfo();
  if (!userInfo) {
    //用户首次进入
    await login()
  }

  let { session } = await getSellerSession(context, activityId);
  // 是否是会员
  let { isvip, url } = await userService.getShopVip(session);

  console.log('isvip'+isvip)
  //带来好友未入会pv 已经入会
  await statService.addStat({ activityId, type: DATA_TYPE.invitedMember, isvip })
  //增加用户助力记录 value:1 未助力  2已助力
  let helpCount = await statService.getStatCount({ activityId, type: DATA_TYPE.assistRecord })
  if(helpCount == 0) {
    await statService.addStat({ activityId, type: DATA_TYPE.assistRecord, isNewVip: !isvip, value: 1, inviteId })
  }
  if(!isvip) {
    return resultModel.success({
      isvip,
      url
    })
  }
  let joinCount = await userJoinSer.getJoinCount({activityId, openId});
  if(joinCount > 0) {
    return resultModel.error(CODE_TYPES.ERROR_NOT_NEW_USER, `新玩家才可以助力哦`)
  }

  return resultModel.success({
    isvip,
    url
  })
}

//购买浏览商品列表
const getBrowseGoodsList = async (context) => {
  // 判断活动
  let pipeRes = await pipeActivityInfo(context);
  // 活动结束
  if (pipeRes.code) {
    return pipeRes;
  }
  let ids = "";
  if (pipeRes.tasks && pipeRes.tasks.browseGoods) {
    ids = pipeRes.tasks.browseGoods.itemIds;
  }

  let list = [];
  if (ids) {
    let taskSer = new TaskService(context);
    list = await taskSer.getGoodsList(ids);
  }
  console.log('list ', list);

  return resultModel.success({
    goodsList: list,
    shopUrl: SHOP_URL
  });
}
//购买下单商品列表
const getOrderList = async (context) => {
  // 判断活动
  let pipeRes = await pipeActivityInfo(context);
  // 活动结束
  if (pipeRes.code) {
    return pipeRes;
  }
  let ids = "";
  if (pipeRes.tasks && pipeRes.tasks.orderGoods) {
    ids = pipeRes.tasks.orderGoods.itemIds;
  }

  let list = [];
  if (ids) {
    let taskSer = new TaskService(context);
    list = await taskSer.getGoodsList(ids);
  }
  console.log('list ', list);

  return resultModel.success({
    goodsList: list,
    shopUrl: SHOP_URL
  });
}

//获取任务列表
const getTaskList = async (context) => {
  logger('getTaskList', context.data);
  const { activityId } = context.data;
  const pipeRes = await pipeActivityInfo(context);
  console.log('---------------'+pipeRes)
  if (pipeRes.code) {
    return pipeRes;
  }

  try {
    let userSer = new UserService(context);
    let statSer = new StatService(context);
    let taskService = new TaskService(context)
    let today = getToday();

    let userInfo = await userSer.getUserInfo()
     // 用户不存在
    if (!userInfo) {
      return resultModel.error(CODE_TYPES.ERROR_NO_USER);
    }
    let { remainTimes, recordTask, taskInfo, _id } = userInfo
    let todayTask = taskInfo[today]
    let { followStatus, orders:oldOrderRecord, memberStatus } = recordTask
    if(!todayTask) {
      todayTask = {
        browseGoods: { value: TASK_TYPE_WIN.BROWSE, status: 0},
        invites: [],
        orders: [],
        exchangeCredits: [],
        sign: { value: TASK_TYPE_WIN.DAY, status: 1}
      }
      remainTimes = {
        ...remainTimes,
        sign: 1
      }
    }
    //是否有未生效的新订单
    let newOrders = await taskService.getNewBuyGoodsOrders(pipeRes, userInfo) || []
    console.log('newOrders:'+JSON.stringify(newOrders))
    let goodsTaskWaitReceive = newOrders ? newOrders.length : 0;
    let oldRecord = todayTask.orders ? todayTask.orders : []
    oldOrderRecord = oldOrderRecord || []
    //订单支付成功uv
    if (goodsTaskWaitReceive > 0) {
      for(let i = 0; i < newOrders.length; i++) {
        let o = newOrders[i]
         let orderDetail = {
          "itemId": o.itemId,
          "orderId": o.orderId,
          "price": o.price,
        };
        oldRecord.push({
          "createTime": transformBeijingDate(Date.now()),
          "orderId": o.orderId
        })
        oldOrderRecord.push({
          "createTime": transformBeijingDate(Date.now()),
          "orderId": o.orderId
        })
        //下单打点
        await statSer.addStat({activityId, type: DATA_TYPE.orderPrice, orderInfo:orderDetail, price: o.price })
      }
      //完成下单uv
      await statSer.addStat({ activityId, type: DATA_TYPE.consumptionUv });
    }

    //更新用户信息
    let param  = {
        remainTimes: {
          ...remainTimes,
          orders: goodsTaskWaitReceive + remainTimes.orders
        },
        recordTask: {
          ...recordTask,
          orders: oldOrderRecord
        },
        taskInfo: {
          ...taskInfo,
          [today]: {
            ...todayTask,
            orders: oldRecord
          }
        }
    }
    await userSer.updateUser(_id,param)

    //获取更新后打用户信息
    let updateUserInfo = await userSer.getUserInfo()
    let memberRecord = updateUserInfo.member
    let { browseGoods, exchangeCredits, sign } = updateUserInfo.taskInfo[today]
    let { invites:remainInvites, orders:oldOrders, member: oldMember, browseGoods:oldBrowseGoods } = updateUserInfo.remainTimes
    let taskList = TASK_LIST.map(el => {
      if(el.taskType == TASK_TYPE.BROWSE) {
        el.status = browseGoods && browseGoods.status ? browseGoods.status : oldBrowseGoods ? 1 : 0
      }
      if(el.taskType == TASK_TYPE.FOLLOW) {
        el.status = followStatus ? followStatus : 0
      }
      if(el.taskType == TASK_TYPE.FREE_MASONRYS) {
        el.status = sign && sign.status ? sign.status : 0
      }
      if(el.taskType == TASK_TYPE.INVITES) {
        el.status = remainInvites == 0 ? 0 : 1
      }
      if(el.taskType == TASK_TYPE.BUY_GOODS) {
        el.status = oldOrders == 0 ? 0 : 1
      }
      if(el.taskType == TASK_TYPE.EXCHANAGE) {
        el.status = (exchangeCredits.length == 2) ? 2 : 0
        el.times = exchangeCredits.length || 0
      }
      if(el.taskType == TASK_TYPE.FOLLOW && followStatus == 2) {
        return;
      }
      return el
    })

    if(!memberRecord.flag || (memberRecord.flag && memberStatus == 1 && oldMember == 1)) {
      let { session } = await getSellerSession(context, activityId);
      let { isvip, url } = await userSer.getShopVip(session);
      taskList.unshift({
        taskType: 'member',
        rewards:1,//复活卡
        status: memberStatus,
        isvip,
        url
      })
    }

    return resultModel.success(taskList.filter(el => el))
  }
  catch(err) {
    console.log('获取新订单失败:'+err)
    return resultModel.error(err)
  }
}

// 领取任务次数
const completeTask = async (context) => {
  // 判断活动
  let pipeRes = await pipeActivityInfo(context);
  if (pipeRes.code) {
    return pipeRes;
  }

  let { taskType, activityId, quantity } = context.data;
  if (!taskType) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `taskType必填`);
  }
  if (![TASK_TYPE.INVITES, TASK_TYPE.BUY_GOODS, TASK_TYPE.FREE_MASONRYS, TASK_TYPE.FOLLOW,TASK_TYPE.BROWSE,TASK_TYPE.EXCHANAGE,TASK_TYPE.MEMBER].includes(taskType)) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `taskType非法`);
  }

  let userSer = new UserService(context);
  let userInfo = await userSer.getUserInfo();
  // 用户不存在
  if (!userInfo) {
    return resultModel.error(CODE_TYPES.ERROR_NO_USER);
  }
  //积分兑换验证是否会员
  if(TASK_TYPE.EXCHANAGE == taskType) {
    let { session } = await getSellerSession(context, activityId);
    let { isvip, url } = await userSer.getShopVip(session);
    if(!isvip) {
      return resultModel.error(CODE_TYPES.ERROR_NO_VIP, `请先加入会员`)
    }
  }

  let taskSer = new TaskService(context);
  let result = await taskSer.receiveTaskRewards(pipeRes, userInfo, taskType, quantity);
  console.log('result'+JSON.stringify(result))
  if (result.code) {
    return resultModel.error(result);
  }
  return resultModel.success(result);
}

//完成任务
const doCompleteTask = async (context) => {
  // 判断活动
  let pipeRes = await pipeActivityInfo(context);
  if (pipeRes.code) {
    return pipeRes;
  }

  let { taskType, inviteId } = context.data;
  if (!taskType) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `taskType必填`);
  }

  if (![TASK_TYPE.INVITES, TASK_TYPE.FOLLOW, TASK_TYPE.BROWSE].includes(taskType)) {
    return resultModel.error(CODE_TYPES.PARAMS_ERROR, `taskType非法`);
  }

  let userSer = new UserService(context);
  let userInfo = await userSer.getUserInfo();
  // 用户不存在
  if (!userInfo) {
    return resultModel.error(CODE_TYPES.ERROR_NO_USER);
  }

  let taskSer = new TaskService(context);
  let result = await taskSer.doCompleteTask(userInfo, taskType);

  if (result.code) {
    return resultModel.error(result);
  }
  console.log('result'+result)
  return resultModel.success(result);
}
module.exports = {
  getBrowseGoodsList,
  getOrderList,
  getTaskList,
  completeTask,
  doCompleteTask,
  isHelp
}